#ifndef _IPMI_LAN_SESSION_UTIL_H
#define	_IPMI_LAN_SESSION_UTIL_H	1

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <freeipmi/fiid.h>
#include <freeipmi/udm/ipmi-udm.h>

#define IPMI_LAN_INTERNAL_WORKAROUND_FLAGS_GET_SESSION_CHALLENGE     0x00000001
#define IPMI_LAN_INTERNAL_WORKAROUND_FLAGS_CHECK_UNEXPECTED_AUTHCODE 0x00000002

int8_t ipmi_lan_cmd_wrapper (ipmi_device_t dev,
                             uint32_t internal_workaround_flags,
                             uint8_t lun,
                             uint8_t net_fn,
                             uint8_t authentication_type,
                             uint32_t *session_sequence_number,
                             uint32_t session_id,
                             uint8_t *rq_seq,
                             char *password,
                             uint32_t password_len,
                             fiid_obj_t obj_cmd_rq,
                             fiid_obj_t obj_cmd_rs);

int8_t ipmi_lan_open_session (ipmi_device_t dev);

int8_t ipmi_lan_close_session (ipmi_device_t dev);

int8_t ipmi_lan_2_0_cmd_wrapper (ipmi_device_t dev,
                                 uint8_t lun,
                                 uint8_t net_fn,
                                 uint8_t payload_type,
                                 uint8_t payload_authenticated,
                                 uint8_t payload_encrypted,
                                 uint8_t *message_tag,
                                 uint32_t *session_sequence_number,
                                 uint32_t session_id,
                                 uint8_t *rq_seq,
                                 uint8_t authentication_algorithm,
                                 uint8_t integrity_algorithm,
                                 uint8_t confidentiality_algorithm,
                                 uint8_t *integrity_key,
                                 uint32_t integrity_key_len,
                                 uint8_t *confidentiality_key,
                                 uint32_t confidentiality_key_len,
                                 char *password,
                                 uint32_t password_len,
                                 fiid_obj_t obj_cmd_rq,
                                 fiid_obj_t obj_cmd_rs);

int8_t ipmi_lan_2_0_open_session (ipmi_device_t dev);

int8_t ipmi_lan_2_0_close_session (ipmi_device_t dev);

#ifdef __cplusplus
}
#endif

#endif /* ipmi-lan-interface.h */


