# ipmi_if.sh
# detect IPMI Interface type, usually KCS or SSIF 
#
# Future: also include preferred Driver type on another line
#
ifdir=/usr/share/ipmiutil
ifout=$ifdir/ipmi_if.txt
mkdir -p $ifdir
which dmidecode  >/dev/null 2>&1
if [ $? -ne 0 ]
then
   # if no dmidecode, old, so assume KCS 
   echo "Interface type: KCS" >$ifout
   exit 0
fi
dmidecode |grep IPMI >/dev/null 2>&1
if [ $? -ne 0 ]
then
   echo "Interface type: None" >$ifout
   exit 0
fi
iftype=`dmidecode |grep "Interface Type:" |cut -f2 -d':'`
echo $iftype |grep KCS >/dev/null 2>&1
if [ $? -eq 0 ]
then
   echo "Interface type: KCS" >$ifout
else
   echo $iftype |grep "OUT OF SPEC" >/dev/null 2>&1
   if [ $? -eq 0 ]
   then
      echo "Interface type: SSIF" >$ifout
   else 
      echo "Interface type: $iftype" >$ifout
   fi
fi
# echo "IPMI `cat $ifout` interface found"

sa=`dmidecode |grep "I2C Slave Address:" |cut -f2 -d':'`
echo "I2C Slave Address: $sa" >>$ifout
base=`dmidecode |grep "Base Address:" |tail -n1 |cut -f2 -d':'`
echo "Base Address: $base" >>$ifout

biosver=`dmidecode |grep "Version: " |head -n1 |cut -f2 -d':'`
echo "BIOS Version: $biosver" >>$ifout
exit 0
