#! /bin/bash
#
# ipmi_port         
#
# chkconfig: 2345 91 07
# description: ipmi_port to reserve the IPMI RMCP port 623 from portmap
#
### BEGIN INIT INFO
# Provides: ipmi_port
# Required-Start: $network
# Default-Start:  3 4 5
# Default-Stop:   0 1 2 6
# Description: ipmi_port is used to reserve the RMCP port from portmap
### END INIT INFO
#
# Source function library.
# . /etc/init.d/functions

name=ipmi_port
prog="/usr/share/ipmiutil/$name"
portmap=/etc/init.d/portmap
thresh="/usr/share/ipmiutil/thresholds.sh"

ps -ef |grep -v grep | grep dpcproxy  >/dev/null
if [ $? -eq 0 ]
then
    echo "$name: dpcproxy is already running on port 623,"
    echo "so ipmi_port is not needed."
    exit 1
fi

case "$1" in
  start)
	echo -n $"Starting $name: "
	echo
	if [ -f $thresh ]
	then
	   # apply saved sensor thresholds, if any
	   sh $thresh
	fi
	if [ -x $portmap ]
	then
	   $prog -b
	fi
	RETVAL=$?
	;;
  stop)
	echo -n $"Stopping $name: "
	echo
	RETVAL=1
        rpid=`ps -ef |grep $name |grep -v grep |awk '{print $2}'`
        if [ "${rpid}" != "" ]
        then
           kill $rpid
	   RETVAL=$?
        fi
	;;
  *)
	echo $"Usage: $0 {start|stop}"
	exit 1
esac
