Name: ipmiutil
Version: 2.1.2
Release: 1
Summary: A package that includes various IPMI server management utilities
License: BSD
Group: System Environment/Kernel
Source: http://prdownloads.sf.net/ipmiutil/ipmiutil-%{version}.tar.gz
URL: http://ipmiutil.sf.net
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
%ifarch x86_pentium3 x86_pentium4
AutoReqProv: No
%endif
%ifarch x86_64
%define LibDir  /usr/lib64
%else
%define LibDir  %{_libdir}
%endif

%description
The ipmiutil component package provides utilities to view the SEL (showsel), 
perform a hardware reset (hwreset), set up the BMC LAN and Platform 
Event Filter entry to allow SNMP alerts (pefconfig), and other IPMI tasks.  
These can be invoked with the metacommand, ipmiutil, as well.  Man pages
are provided.
An IPMI driver can be provided by either the Intel IPMI driver (/dev/imb) 
or the OpenIPMI driver (/dev/ipmi0).  If used locally and no driver is
detected, ipmiutil will use user-space register I/Os instead.


%prep
%setup -q

%build
sh configure
make

%install
# Use %{buildroot} macro instead of $RPM_BUILD_ROOT now.
if [ "%{buildroot}" != "/" ]
then
   rm -rf %{buildroot}
fi
make install DESTDIR=%{buildroot}
( cd %{buildroot}/usr/share/man/man8; gzip -f *.8 ) 
rm -f %{buildroot}/usr/sbin/xmlconfig 2>/dev/null

%files
%defattr(0755,root,root)
/usr/sbin/ipmiutil
/usr/sbin/alarms
/usr/sbin/bmchealth
/usr/sbin/fruconfig
/usr/sbin/getevent
/usr/sbin/hwreset
/usr/sbin/icmd
/usr/sbin/pefconfig
/usr/sbin/showsel
/usr/sbin/sensor
/usr/sbin/tmconfig
/usr/sbin/wdt
/usr/sbin/isolconsole
/usr/sbin/idiscover
/usr/share/ipmiutil/ipmi_if.sh
/usr/share/ipmiutil/checksel
/usr/share/ipmiutil/wdt.sh
/usr/share/ipmiutil/events
/usr/share/ipmiutil/ipmi_port
/usr/share/ipmiutil/ipmi_port.sh
%LibDir/libipmi_lanplus.*
%defattr(0664,root,root)
/usr/share/ipmiutil/README
/usr/share/ipmiutil/COPYING
/usr/share/ipmiutil/UserGuide
/usr/share/ipmiutil/bmclanpet.mib
/usr/share/ipmiutil/bmclanaol.mib
/usr/share/man/man8/showsel.8.gz
/usr/share/man/man8/sensor.8.gz
/usr/share/man/man8/hwreset.8.gz
/usr/share/man/man8/getevent.8.gz
/usr/share/man/man8/bmchealth.8.gz
/usr/share/man/man8/alarms.8.gz
/usr/share/man/man8/wdt.8.gz
/usr/share/man/man8/pefconfig.8.gz
/usr/share/man/man8/tmconfig.8.gz
/usr/share/man/man8/fruconfig.8.gz
/usr/share/man/man8/icmd.8.gz
/usr/share/man/man8/ipmiutil.8.gz
/usr/share/man/man8/isolconsole.8.gz
/usr/share/man/man8/idiscover.8.gz
/usr/share/man/man8/events.8.gz
# %defattr(-,root,root)
# %doc README TODO COPYING ChangeLog

%clean
if [ "%{buildroot}" != "/" ]
then
   rm -rf %{buildroot}
fi

%pre
# before install
datadir=/usr/share/ipmiutil
echo "Installing IPMI Management Utilities %{version} ..."
mkdir -p $datadir

dev1=/dev/imb
dev2=/dev/ipmi0
dev3=/dev/ipmi/0
dev4=/dev/ipmikcs
if [ ! -c $dev1 ]
then
  if [ ! -c $dev2 ]
  then
     if [ ! -c $dev3 ]
     then
        echo "Warning: No IPMI devices found ($dev1, $dev2, or $dev3)."
        # echo "IPMI Management Utilities depend on an IPMI driver, aborting."
        # exit 1
     fi
  fi
fi

if [ ! -d /usr/share/man ]
then
    if [ -d /usr/man ]
    then
       ln -s /usr/man /usr/share/man 
    fi
fi

%post
# after install
pdir=/usr/sbin
tmped=/tmp/edmk.tmp
tmpsel=/tmp/pefcfg.tmp
datadir=/usr/share/ipmiutil
mibdir=/usr/share/snmp/mibs

echo "ipmiutil install started `date`" 
# Assumes that the kernel patches are already in place.

# Make sure that the panic timeout is set to some reasonable value
pnew=5
pfil=/proc/sys/kernel/panic
lilofil=/etc/lilo.conf
pval=`cat $pfil`

if [ ! -f $lilofil ]
then
   # They must have grub instead of lilo, so skip this change. 
   pval="1"
fi
# Always skip this change for ipmiutil
pval="1"

# assume that if $pval is set, that someone has already configured lilo.conf
if [ $pval = "0" ]
then
   # Panic timeout is not set, set timeout to $pnew
   echo "$pnew" >$pfil
   cp -f $lilofil /tmp/lilo.conf-orig
   grep append $lilofil >/dev/null 2>&1
   if [ $? -eq 0 ]
   then
        # modify the append line to add panic timeout
        # can't use $pnew within sed, so set literal 5
        sed -e 's/append=\"/append="panic=5 /' $lilofil >$tmped 
        cp -f $tmped $lilofil
        # use this method in case something else (console) is also in append
   else
        # not found, so add the append line
        cat - <<%%% >$tmped 
1
/timeout
a
append="panic=$pnew"
.
w
q
%%%
        ed $lilofil <$tmped >/dev/null
   fi
fi

# Check location of snmpd.conf for pefconfig
if [ -f /etc/SuSE-release ]
then
   if [ ! -f /etc/snmp/snmpd.conf ]
   then
     if [ -f /etc/ucdsnmpd.conf ]
     then
        mkdir -p /etc/snmp
        cd /etc/snmp
        ln -s /etc/ucdsnmpd.conf  snmpd.conf
     fi
     if [ -f /etc/snmpd.conf ]
     then
        mkdir -p /etc/snmp
        cd /etc/snmp
        ln -s /etc/snmpd.conf  snmpd.conf
     fi
   fi
fi
if [ -d $mibdir ]
then
   cp -f $datadir/bmclanpet.mib $mibdir/BMCLAN-PET-MIB.txt
   # cp -f $datadir/bmclanaol.mib $mibdir/BMCLAN-AOL-MIB.txt 
fi

newcrypto=%LibDir/libcrypto.so.4
uname -r |grep mvl >/dev/null 2>&1
if [ $? -eq 0 ]
then
   # link libcrypto.4 on MontaVista, for safety
   if [ ! -f $newcrypto ] 
   then
      cp -f %LibDir/libcrypto.so.0 $newcrypto
   fi
fi

# check if chroot, if so, will not have /proc instances
if [ -f /proc/devices ]
then
   isroot=1
else
   isroot=0
fi

# If using FreeIPMI, add /usr/share/ipmiutil/libfreeipmi.so
# to the %files section, and uncomment these lines below.
## Check for any version of FreeIPMI out there.
#ls /usr/lib/libfreeipmi.so.%lfver >/dev/null 2>&1
#if [ $? -eq 0 ]
#then
#   # there is one, use it.
#   freelib=`ls /usr/lib/libfreeipmi.so* |tail -1`
#   if [ ! -f /usr/lib/libfreeipmi.so.%lfver ]
#   then
#      cd /usr/lib
#      ln -s $freelib libfreeipmi.so.%lfver
#   fi
#else
#   # there isn't one, use our copy.
#   cd /usr/lib
#   ln -s $datadir/libfreeipmi.so libfreeipmi.so.%lfver
#   if [ -d /usr/lib64 ]
#   then 
#      cd /usr/lib64
#      ln -s $datadir/libfreeipmi.so libfreeipmi.so.%lfver
#   fi
#fi
## Set up the key file for FreeIPMI
#keydir=/var/lib/freeipmi
#keyfil=$keydir/ipckey
#if [ ! -f $keyfil ]
#then
#   mkdir -p $keydir
#   touch $keyfil
#   chmod 664 $keyfil
#fi

# There can be any one of several IPMI driver modules installed.
# Dont need to load a kernel module here. 
  
# We installed some libraries, so do ldconfig
ldconfig

# detects IPMI interface type, output to $datadir/ipmi_if.txt
if [ $isroot -eq 1 ]
then
   $datadir/ipmi_if.sh 
fi

# arg1 = 1 if rpm -i (first time), arg1 = 2 if rpm -U
if [ "$1" = "1" ]
then
  # doing rpm -i, first time

  # link to new command names
  if [ 1 -eq 1 ] 
  then
     cd $pdir
     ln -s alarms      i_alarms
     ln -s bmchealth   i_health
     ln -s fruconfig   i_fru
     ln -s getevent    i_getevt
     ln -s hwreset     i_reset
     ln -s pefconfig   i_lan
     ln -s showsel     i_sel
     ln -s sensor      i_sensor
     ln -s tmconfig    i_serial
     ln -s wdt         i_wdt
     ln -s isolconsole i_sol
  fi

  # For any system, set up the checksel cron job for showsel
  # This is inert if IPMI is not supported.
  cp $datadir/checksel /etc/cron.daily

  if [ $isroot -eq 1 ]
  then
     if [ -x $pdir/ipmiutil ]
     then 
        $pdir/ipmiutil wdt >/dev/null 2>&1
        fIPMI=$?
     else
        fIPMI=1
     fi
  else
     fIPMI=1
  fi

  # If fIPMI==0, IPMI is supported, and not chroot.
  if [ $fIPMI -eq 0 ] 
  then
     # Reserve the IPMI RMCP port from the portmap service
     cp $datadir/ipmi_port.sh /etc/init.d/ipmi_port
     which chkconfig  >/dev/null 2>&1
     if [ $? -eq 0 ]
     then
        chkconfig --add ipmi_port
     fi

     # Set up first-time IPMI sensor and LAN functions
     sensorout=$datadir/sensor_out.txt
     if [ ! -f $sensorout ] 
     then
        # Now take a snapshot of the sensors on this system
        echo "Saving a sensor snapshot to $sensorout ..."
        $pdir/ipmiutil sensor >$sensorout
     fi

     # Check if the BMC LAN is already configured.
     $pdir/ipmiutil lan -t >/dev/null
     if [ $? -ne 0 ] 
     then
        # not already configured
        # Read the BMC LAN configuration (saving BMC MAC, if any)
        $pdir/ipmiutil lan -r >$tmpsel 2>&1
        # Some users may not want to auto-enable BMC LAN, and some
        # systems will require -I to be specified, so don't always
        # do this, just display a message.
        #
        # $pdir/pefconfig -e >$tmpsel 2>&1
        # if [ $? -eq 0 ]
        # then
        #   echo "pefconfig successful, details in $tmpsel"
        # else
        #   echo "pefconfig error, details in $tmpsel"
        # fi
        echo "The BMC LAN is not yet configured."
        echo "Use 'ipmiutil lan -e' or 'ipmiutil lan -e -I <ip>' to do this."
     fi
  fi
fi

echo "done `date`" 

%preun
# before uninstall
echo "Uninstalling ipmiutil %{version} feature ..."

%postun
# after uninstall
pdir=/usr/sbin
datadir=/usr/share/ipmiutil
mibdir=/usr/share/snmp/mibs
tmped=/tmp/edmk.tmp

# arg1 = 1 if rpm -U, arg1 = 0 if rpm -e
if [ "$1" = "0" ]
then
  # doing rpm -e postun, so clean up anything left over
  rm -rf $datadir  2>/dev/null

  if [ -f /etc/cron.daily/checksel ]
  then
     rm -f /etc/cron.daily/checksel 2>/dev/null
  fi

  if [ -x /etc/init.d/ipmi_port ]
  then
     which chkconfig  >/dev/null 2>&1
     if [ $? -eq 0 ]
     then
        chkconfig --del ipmi_port
     fi
     rm -f /etc/init.d/ipmi_port
  fi

  if [ -L $pdir/i_sel ]
  then
     cd $pdir
     rm -f  i_alarms i_health i_fru i_getevt i_reset
     rm -f  i_lan i_sel i_sensor i_serial i_wdt i_sol
  fi

  if [ -d $mibdir ]
  then
     rm -f $mibdir/BMCLAN-AOL-MIB.txt 2>/dev/null
     rm -f $mibdir/BMCLAN-PET-MIB.txt 2>/dev/null
  fi

#  ls -l /usr/lib/libfreeipmi.so.%lfver |grep ipmiutil >/dev/null 2>&1
#  if [ $? -eq 0 ]
#  then
#     # ipmiutil installed the freeipmi, so remove it
#     rm -f /usr/lib/libfreeipmi.so.%lfver 
#     if [ -d /usr/lib64 ]
#     then
#        rm -f /usr/lib64/libfreeipmi.so.%lfver 
#     fi
#     rm -rf /var/lib/freeipmi
#  fi
fi

%changelog
* Fri Jun 08 2007 Andrew Cress <arcress@users.sourceforge.net>
  rpmlint tweaks for ipmiutil-1.9.8
* Mon May 21 2007 Andrew Cress <arcress@users.sourceforge.net>
  added isroot flag for chroot cases
* Mon May 18 2007 Andrew Cress <arcress@users.sourceforge.net>
  added ipmi_port init handling
* Mon Jul 10 2006 Andrew Cress <arcress@users.sourceforge.net>
  changed to libfreeipmi.so.2, include & run ipmi_if.sh
* Tue Aug 02 2005 Andrew Cress <arcress@users.sourceforge.net> 
  changed not to run pefconfig if already configured
* Wed Feb 03 2005 Andrew Cress <arcress@users.sourceforge.net> 
  changed /usr/man to /usr/share/man,
  fixed postun to recognize rpm -U via $1 
* Mon Nov 1 2004 Andrew Cress <arcress@users.sourceforge.net> 
  added freeipmi install files and logic
* Tue Aug 23 2004 Andrew Cress <arcress@users.sourceforge.net> 
- added MIB links to /usr/share/snmp/mibs
* Tue Aug 10 2004 Andrew Cress <arcress@users.sourceforge.net> 
- added icmd utility to the rpm
* Thu Aug 05 2004 Andrew Cress <arcress@users.sourceforge.net> 
- added special logic for SuSE snmpd.conf
* Fri Apr 02 2004 Andrew Cress <arcress@users.sourceforge.net> 
- added checksel cron job
* Tue Jan 28 2003 Andrew Cress <arcress@users.sourceforge.net> 
- added sensor & fruconfig for ipmiutil 1.2.8
* Tue Aug  2 2002 Andrew Cress <arcress@users.sourceforge.net> 
- fixed bug 793 (dont need Require:ipmidrvr) for ipmiutil 1.2.2
* Tue Jul  2 2002 Andrew Cress <arcress@users.sourceforge.net> 
- fixed bug 555 in showsel for ipmiutil 1.2.1
* Fri May 10 2002 Andrew Cress <arcress@users.sourceforge.net> 
- fixed bug 504 in pefconfig for ipmiutil 1.1.5
* Thu Apr 11 2002 Andrew Cress <arcress@users.sourceforge.net> 
- updated pathnames for ipmiutil 1.1.4, some cleanup
* Mon Mar 18 2002 Andrew Cress <arcress@users.sourceforge.net> 
- updated for 1.1.3-2, added checking for grub vs. lilo to .spec
* Tue Mar 12 2002 Andrew Cress <arcress@users.sourceforge.net> 
- updated for 1.1.3, added source rpm, changed license, etc.
* Thu Jan 31 2002 Andrew Cress <arcress@users.sourceforge.net> 
- updated for 1.1.0-2, changed selpef to pefconfig
* Thu Jan 25 2002 Andrew Cress <arcress@users.sourceforge.net> 
- updated for 1.1.0, changed to ipmidrvr rather than isc dependency
* Thu Jan 16 2002 Andrew Cress <arcress@users.sourceforge.net> 
- updated for 1.1.0, added hwreset utility
* Thu Dec 14 2001 Andrew Cress <arcress@users.sourceforge.net> 
- updated for 1.0.0, man page updates
* Thu Nov 19 2001 Andrew Cress <arcress@users.sourceforge.net> 
- updated for 0.9.0, uses new OSS bmc_panic, so don't install module.
* Thu Nov 13 2001 Andrew Cress <arcress@users.sourceforge.net> 
- updated for 0.8.5, add "Requires: isc" (#32), hide selpef output (#38)
* Thu Nov  8 2001 Andrew Cress <arcress@users.sourceforge.net> 
- updated for 0.8.4, eliminate "file exists" messages by fixing removal
* Thu Oct 25 2001 Andrew Cress <arcress@users.sourceforge.net> 
- updated for 0.8.2, run selpef (objdump:applypatch gives bogus warning)
* Thu Oct 25 2001 Andrew Cress <arcress@users.sourceforge.net> 
- updated for 0.8.2, run selpef (objdump:applypatch gives bogus warning)
* Wed Oct 24 2001 Andrew Cress <arcress@users.sourceforge.net> 
- created ipmiutil package 0.8.1 without kbuild
* Tue Oct 23 2001 Andrew Cress <arcress@users.sourceforge.net> 
- created ipmiutil package 0.8.0
