#! /bin/bash
#
# wdt          Enable & reset the IPMI watchdog timer via cron
#
# chkconfig: 2345 91 59
# description: wdt is a utility from ipmiutil.sf.net to configure the \
#              IPMI watchdog timer.
#
# It enables watchdog for 90 second timeout, reset every 1 min (60 sec).
# It uses the cron daemon which reads files from /etc/cron.d
# Note that the $crond_sh variable is different for RedHat & SuSE.
#
# Source function library.
# . /etc/init.d/functions

prog="/usr/sbin/ipmiutil wdt"
wdtcron=/etc/cron.d/wdt
#tmpcron=/tmp/wdtcron.$$
# tmpcron2=/tmp/wdtcron2.$$

start() {
	echo -n $"Starting $prog: "
	echo
        # configure the watchdog for a 90 second timeout
	$prog -e -t 90
	RETVAL=$?
        if [ $RETVAL -eq 0 ]
	then
           # restart the watchdog every 60 seconds via crontab (skip)
           # cat - <<%%% >$tmpcron
#* * * * * $prog -r 
#%%%
           # crontab $tmpcron
	   # RETVAL=$?
           # restart the watchdog every 60 seconds via /etc/cron.d
           cat - <<%%% >$wdtcron
* * * * *  root  $prog -r 
%%%
	   # make crond re-read the /etc/cron.d
	   $crond_sh restart
        fi
	echo
	return $RETVAL
}

stop() {
	echo -n $"Stopping $prog: "
	echo
	# first disable the watchdog 
	$prog -d
	RETVAL=$?
	# now remove the wdt cron job
        # crontab -l >$tmpcron
        # grep -v $prog $tmpcron |grep -v "^#" >$tmpcron2
        # crontab $tmpcron2
        rm -f $wdtcron
	# make crond re-read the /etc/cron.d
	$crond_sh restart
	echo
	return $RETVAL
}	

restart() {
  	stop
	start
}	

# Begin mainline script here
if [ -f /etc/redhat-release ]
then
   crond_sh=/etc/init.d/crond
else
   # SuSE, MontaVista, etc.
   crond_sh=/etc/init.d/cron
fi

case "$1" in
  start)
  	start
	;;
  stop)
  	stop
	;;
  status)
  	$prog
	;;
  restart)
  	restart
	;;
  *)
	echo $"Usage: $0 {start|stop|status|restart}"
	exit 1
esac
