#!/bin/bash
#
# hpi init script to start/stop the Intel hpi library daemon
# process name: SpiLibd
#
# For RedHat and MontaVista
# chkconfig: 345 50 35
#
### BEGIN SuSE INIT INFO
# Provides: tam
# Required-Start: $network
# Default-Start:  3 5
# Default-Stop:   0 1 2 6
# Description:    tam is used to start/stop Telco Alarm Manager
### END INIT INFO

case "$1" in 
"start")
	# Is it already started?
	ps -ef | grep -v grep | grep SpiLibd
	if [ $? -eq 0 ]
	then
	    echo "SpiLibd is already started"
	    exit 1
        fi
	export SAHPI_HOME=/etc/hpi
	export LD_LIBRARY_PATH=/usr/lib
	#export LD_LIBRARY_PATH=$SAHPI_HOME/lib
	# Use default config locations (/etc/hpi/*.conf)
	#export SPI_LIB_CFG_LOCATION=$SAHPI_HOME/spi-lib.conf
	#export SPI_DAEMON_CFG_LOCATION=$SAHPI_HOME/spi-daemon.conf
	export SPI_LIB_LOG_LOCATION=/var/log/spilib
	export SPI_DAEMON_LOG_LOCATION=/var/log/spidaemon
	export SPI_DAEMON_LOG_LEVEL=-l5
	export SPI_LIB_LOG_LEVEL=-l5
#        export LD_ASSUME_KERNEL=2.4.1
	# flush the logs before starting daemon
	rm -f ${SPI_DAEMON_LOG_LOCATION}.1 $SPI_LIB_LOG_LOCATION 2>/dev/null
	mv $SPI_DAEMON_LOG_LOCATION ${SPI_DAEMON_LOG_LOCATION}.1 2>/dev/null
	# see /usr/bin/SpiLibd
	SpiLibd
	touch /var/lock/subsys/hpi
	;;
"stop")
	spid=`ps -ef | grep -v grep | grep SpiLibd |awk '{ print $2 }'`
	if [ "$spid" != "" ]
	then
	   kill $spid    
	   sleep 5
	   kill -9 $spid  2>/dev/null
	fi
	rm -f /var/lock/subsys/hpi
	;;
*)
        echo "Usage: $0 start|stop"
	exit 1
	;;
esac

exit 0
