# ipmilib.mak
# This makefile will build the ipmiutil lib directory
#
# Make sure to download and build openssl for Windows
#
# buildwin.cmd sets VCDIR, the directory containing VisualStudio 6.0 VC.
LIBC=/LIBPATH:%VCDIR%\lib 
INCL=%VCDIR%\include

# The ipmiutil lib directory
SRC_D=.
INSTALLTOP=\
OUT_D=.
PLUS_DIR=lanplus
PLUS_LIB=lanplus.lib
SSL_LIBS=libeay32.lib ssleay32.lib

# Set your compiler options
CC=cl
MKDIR=-mkdir
MKLIB=lib
RM=del
CP=copy


all: banner $(PLUS_LIB)

banner:
	@echo Building ipmi libs

$(PLUS_LIB):    
    cd $(PLUS_DIR)
    nmake /nologo -f ipmiplus.mak all
    cd ..
    $(CP) $(PLUS_DIR)\$(PLUS_LIB) .

clean:
    $(RM) $(PLUS_LIB)
    cd $(PLUS_DIR)
    nmake /nologo -f ipmiplus.mak clean
    cd ..

distclean:
    $(RM) $(PLUS_LIB)
    cd $(PLUS_DIR)
    nmake /nologo -f ipmiplus.mak distclean
    cd ..

