# ipmiplus.mak
# This makefile will build the ipmiutil lib\lanplus directory
#
# Make sure to download and build openssl for Windows first
#
# buildwin.cmd sets VCDIR, the directory containing VisualStudio 6.0 VC.
LIBC=/LIBPATH:%VCDIR%\lib 
INCL=%VCDIR%\include

# The ipmiutil lanplus directory
SRC_D=.
INC=-I$(INCL) -I$(SRC_D) -I$(SRC_D)\inc
O_LIB=lanplus.lib
SSL_LIBS=libeay32.lib ssleay32.lib
SSL_DLLS=libeay32.dll ssleay32.dll

# Set your compiler options
CC=cl
CF_EX=/DWIN32 $(INC)
# CFLAGS= /MD /W3 /WX /Ox /O2 /Ob2 /Gs0 /GF /Gy /nologo $(CF_EX)
CFLAGS= /W3 /Ox /O2 /Ob2 /Gs0 /GF /Gy /nologo $(CF_EX)
LINK=link
LFLAGS=/nologo /subsystem:console /machine:IX86 /opt:ref $(LIBC)
MKDIR=-mkdir
MKLIB=lib
MLFLAGS= /nologo /subsystem:console /machine:I386 /opt:ref /dll
RM=del

LIB_OBJ = lanplus.obj lanplus_crypt.obj lanplus_crypt_impl.obj \
          lanplus_dump.obj lanplus_strings.obj helper.obj ipmi_strings.obj

HEADERS = 

all: banner $(O_LIB)

banner:
	@echo Building ipmi lanplus library

install:

clean:
    $(RM) *.obj
    $(RM) $(O_LIB)

distclean:
    $(RM) *.obj
    $(RM) $(O_LIB)
    $(RM) *.lib

lanplus.obj:    lanplus.c
    $(CC) /c $(CFLAGS) lanplus.c

lanplus_crypt.obj:    lanplus_crypt.c
    $(CC) /c $(CFLAGS) lanplus_crypt.c

lanplus_crypt_impl.obj:    lanplus_crypt_impl.c
    $(CC) /c $(CFLAGS) lanplus_crypt_impl.c

lanplus_dump.obj:    lanplus_dump.c
    $(CC) /c $(CFLAGS) lanplus_dump.c

lanplus_strings.obj:    lanplus_strings.c
    $(CC) /c $(CFLAGS) lanplus_strings.c

ipmi_strings.obj:    ipmi_strings.c
    $(CC) /c $(CFLAGS) ipmi_strings.c

helper.obj:    helper.c
    $(CC) /c $(CFLAGS) helper.c

$(O_LIB):    $(LIB_OBJ)
    $(MKLIB) /OUT:$(O_LIB) /nologo $(LIB_OBJ)

