#!/bin/sh
#    ipmievt.sh - generate an IPMI temperature event
#
# Baseboard Temp is usually index 0d, 0e or 15, & sensor num 0x30
# Note that values displayed/used are in hex.
#
# sensor |grep -i "Baseboard Temp" 
# 000d SDR Full 01 39 20 a 01 snum 30 Baseboard Temp   = 2f OK   47.00 degrees C
#   ^^=ibasetemp                   ^^=nbasetemp                  ^^+4=lotemp
#
sensorfil=/usr/share/ipmiutil/sensor_out.txt
pattn="Baseboard Temp"
#ibasetemp=0d
#nbasetemp=30   # usually snum 30 on Intel
#lotemp=33
ibasetemp=`grep -i "$pattn" $sensorfil  |awk '{print $1}'`
nbasetemp=`grep -i "$pattn" $sensorfil  |awk '{print $10}'`
curtemp=`grep -i "$pattn" $sensorfil  |awk '{print $16}' |cut -f1 -d'.'`
lotemp=`expr $curtemp + 4`  

echo "Setting $pattn lower threshold to $lotemp - current temp = $curtemp"
# cause a crit-lo for Baseboard Temp
sensor -i $ibasetemp -t -n $nbasetemp -l $lotemp

# give it 2 secs before clearing to OK
sleep 2
# put Baseboard Temp back to OK
sensor -i $ibasetemp -t -n $nbasetemp -l 5 

sleep 1
# show the SEL events
showsel -l4 

