#!/bin/sh
linux_type="redhat"
basic_test()
{
	showsel > /dev/null 2>&1
	if [ "$?" -eq 0 ];then
		echo "BASIC_PASS: The tool can run correctly"
		return 0
	else
		echo "BASIC_PASS: The tool can not run correctly"
		return 1
	fi
}
showsel_ov()
{
	showsel -v|grep version|grep -v BMC > /dev/null
	if [ "$?" -eq "0" ];then 
		showsel -v|grep "free space" > /dev/null 2>&1
		if [ "$?" -eq 0 ];then
			echo "PASS:Showsel option -v testing"
			return 0
		else
			echo "FAIL: Showsel testing -v fail"
		fi
	else
		echo "FAIL: Showsel testing -v fail"
		return 1
	fi
}

showsel_oc()
{
	message_original=`showsel|wc -l`
	showsel -c > /dev/null 2>&1
	message_now=`showsel|wc -l`
	if [ "$message_original" -ge "$message_now" ];then
		echo "PASS:Showsel option -c testing"
		return 0
	else
		echo "FAIL:Showsel option -c testing"
		return 1
	fi
}

check_os()
{
	if [ -d "/usr/src/redhat" ];then
		linux_type="redhat"
	fi 
	if [ -d "/usr/src/hardhat" ];then
		linux_type="hardhat"
	fi
}

check_driver()
{
	lsmod|grep "ipmi_comb" > /dev/null 2>&1
	if [ $? -eq 0 ];then
		echo "The ipmi_comb driver has been inserted already"
       		Major=`cat /proc/devices|grep imb|awk '{print $1}'`
		if [ ! -c /dev/imb ];then
                    		mknod /dev/imb c $Major 0
       		fi
		return 1
	fi
	modprobe "ipmi_comb" > /dev/null 2>&1
	if [ $? -eq  0 ];then
		echo "The ipmi_comb driver be inserted corretly"
	else
		echo "There are no ipmi driver or ipmi driver can not be inserted correctly"
		exit 1
	fi
		
	lsmod|grep "ipmi_comb" > /dev/null 2>&1
       	if [ $? -eq 0 ];then
       		Major=`cat /proc/devices|grep imb|awk '{print $1}'`
		if [ ! -c /dev/imb ];then
                    		mknod /dev/imb c $Major 0
       		fi
	fi

}
showsel_ow()
{
	cp -f  /var/log/messages /tmp/tempbackup
	if [  ! -d /usr/share/panicsel ];then
		mkdir /usr/share/panicsel
	fi
	if [ -f /usr/share/panicsel/sel.idx ];then
		rm -f sel.idx	
	fi
	showsel -w > /dev/null 2>&1
	idx=`cat /usr/share/panicsel/sel.idx`
	diff /var/log/messages /tmp/tempbackup > /tmp/diff_log
	log=`cat /tmp/diff_log|grep $idx`
	if [ -n "$idx"  -a  -n "$log" ];then
		echo "PASS: showsel option w"	
		
	else
		echo "PASS: Showsel option w"
	fi
		
}
###########################################
#test show OS critical message correctly###
###########################################
showsel_os()
{
	rm -f showseloutputs
	showsel -s >> showseloutputs
	osnumber=`grep "OS Critical Stop" showseloutputs|wc -l`
	showsel -s > /dev/null  2>&1
	if [ $? -eq 0 -a  $osnumber -gt 0 ];then
		echo " PASS: Showsel option s "
		return 0
	else
		if [ $osnumber -eq 0 ];then
			echo "WARN:You should crash the machine and creat a OS critical message"
			return 1
		fi
		echo "FAIL: Showsel option s"
		return 1 
	fi

}
showsel_test()
{
	check_os
	check_driver
	basic_test
	if [ "$?" -eq 0 ];then
		showsel_ov
		showsel_oc
		showsel_ow
		showsel_os	
	fi
}
#####################################################################
#test pefconfig can read PEF entry                                   ###
#####################################################################
pefconfig_basic()
{
	if [ -f pefconfigoutput ];then
		rm -rf pefconfigoutput	
	fi;
	pefconfig -r > pefconfigoutput 2>&1
	pefnumber=`grep PEFilter pefconfigoutput|wc -l`
	lannumber=`grep Lan pefconfigoutput|wc -l`
	if [ $pefnumber -eq 12 ];then
		echo  " PASS: pefconfig basic requirement "
		return 0
	else
		echo "FAIL: pefconfig basic requirement"
		return 1
	fi;
	if [ -f pefconfigoutput ];then
		rm -rf pefconfigoutput	
	fi;
}

#####################################################################
#test pefconfig can enable or disable the new PEF 0x20 events        ###
#####################################################################
pefconfig_od()
{
	if [ -f /tmp/pefconfigoutputd ];then
		rm /tmp/pefconfigoutputd
	fi
	pefconfig -d > /tmp/pefconfigoutputd 2>&1
	disable=`cat /tmp/pefconfigoutputd|grep "Access = Disabled"`
	if [ -n "$disable" ];then
		echo "PASS:  pefconfig disable OS critical Event "
		return 0
	else
		echo "FAIL:  pefconfig disable OS critical Event "
		return 1
	fi
}

#####################################################################
#test pefconfig can write new entry at different offset than 12      ###
#####################################################################
ts_pefconfign()
{
total=`pefconfig -r | grep PEFilter | wc -l`
total=`echo $((total))`
PASS="PASS"
tmp_num=$1
num=`echo $((tmp_num))`
if [ "$num" -le "$total" ];then
        pefconfig -n $num|grep PEFilter|tail -n $num > pefconfig_$num
        pefconfig -r |grep PEFilter|head -n $num > pefconfig_r$num
        dif=`diff pefconfig_$num pefconfig_r$num`
        if [ -n "$dif" ];then
                PASS="FAIL"
        fi
        rm -f pefconfig_$num
        rm -f pefconfig_r$num
else
        succnum=`pefconfig  -x -n $num |grep SetPefEntry|awk '{print $2}'|grep "successful"|wc -l`
        succnum=`echo $((succnum))`
        eqnum=`expr $num \* 2 - 1`
        if [ "$succnum" -eq  "$eqnum" ];then
                lastrecord=`pefconfig -n 15 |grep PEFilter|tail -n 1|awk '{print $3}'`
                if [ $lastrecord -ne "80" ];then
                        PASS="FAIL"
                fi
        fi
fi
        if [ $PASS == "$FAIL" ];then
                echo "FAIL : pefconfig -n" $1
        else
                echo "PASS : pefconfig -n" $1
        fi
}
#####################################################################
#test pefconfig can output more debug information                    ###
#####################################################################
ts_pefconfigx()
{
	if [ -f pefconfigoutput ];then
		rm -rf pefconfigoutput
	fi
	if [ -f pefconfigoutputx ];then
		rm -rf pefconfigoutputx
	fi
	pefconfig -x >> pefconfigoutputx
	test=`grep "PEF record" pefconfigoutputx`
	if [ ! -z test ];then
		echo  "PASS: pefconfig parameter x "
		return 0
	else
		echo "FAIL: pefconfig parameter x"
		return 1
	fi
	if [ -f pefconfigoutputx ];then
		rm -rf pefconfigoutputx
	fi
		
}
##############################################################
#Basic function for testing pefconfig configuration 
################################################################
get_host_ip_address()
{
	 ifconfig|grep "inet addr"|grep -v "127.0.0.1"|awk '{print $2}'|cut -d: -f2 
}
get_host_mac_address()
{
	 ifconfig|grep eth0|awk '{print $5}'
}
get_route_ip_address()
{
	 netstat -rn|grep eth0|grep UG|awk '{print $2}'
	#cat /proc/net/arp|grep -v "HW"|awk '{print $1}'
}
get_route_mac_address()
{
	 routeip=`get_route_ip_address`
	 cat /proc/net/arp|grep -v "HW"|grep $routeip|awk '{print $4}'
}
get_subnet_mask_address()
{
        ifconfig|grep Mask|grep -v "127.0.0.1"|awk '{print $4}'|cut -d: -f2
}
get_alert_ip_address()
{
        cat /etc/snmp/snmpd.conf|grep trapsink|cut -f2 -d' '
}
get_alert_mac_address()
{
        routip=get_route_ip_address
        arping -c 1 $routeip > /dev/null 2>&1
        arping -c 2 $1|grep reply|tail -1|awk '{print $5}'|cut -c2-18
}

get_pef_ip_address()
{
	cat $1|grep $2|grep -v "Param"|awk '{print $2}'|cut -d= -f2
}
get_pef_mac_address()
{
	cat $1|grep $2|grep -v "Param"|awk '{print $3}'|cut -d= -f2
}
check_pef()
{
	cat $1|grep "SetLanEntry"|grep "($2"|awk '{print $4}'
}
upper()
{
	echo $1|tr 'a-z' 'A-Z'
}
####################################################
#Test pefconfig set host ip and mac addresses
###################################################

ts_pefconfig_sethost()
{
	rm /tmp/pefconfig_host	
	ip=`get_host_ip_address`
	mac=`get_host_mac_address`
	pefconfig -I $ip -M $mac > /tmp/pefconfig_host 2>&1
	setip=`get_pef_ip_address /tmp/pefconfig_host eth0`
	setmac=`get_pef_mac_address /tmp/pefconfig_host eth0`
	setmac=`upper $setmac`
	isip=`check_pef /tmp/pefconfig_host 3` 
	ismac=`check_pef /tmp/pefconfig_host 4`
	if [ $ip == $setip ] && [ $mac == $setmac ] \
	 	 && [ $isip -eq 0 ] && [ $ismac -eq 0 ];then
		echo "PASS:Pefconfig Set host ip and Mac address"
		return 0
	else
		echo "FAIL:Pefconfig Set host ip and Mac address"
		return 1
	fi 
}
###############################################################
##Test pefconfig set route ip and mac addresses
###############################################################
ts_pefconfig_setroute()
{
	ip=`get_route_ip_address`
	count=`get_route_ip_address`
	mac=`get_route_mac_address`
	pefconfig -G $ip -H $mac > /tmp/pefconfig_route 2>&1
	setip=`get_pef_ip_address /tmp/pefconfig_route gateway`
        setmac=`get_pef_mac_address /tmp/pefconfig_route gateway`
	setmac=`upper $setmac`
        isip=`check_pef /tmp/pefconfig_route 12`
        ismac=`check_pef /tmp/pefconfig_route 13`
	if [ $ip == $setip ] && [ $mac == $setmac ] \
                 && [ $isip -eq 0 ] && [ $ismac -eq 0 ];then
                echo "PASS:Pefconfig Set route ip and mac address"
		return 0
        else
                echo "FAIL:Pefconfig Set route ip and mac address"
        	return 1
	fi
}
get_alert_setip_address()
{
	cat $1|grep $2|awk '{print $3}'|cut -d= -f2
}
get_alert_setmac_address()
{
	 cat $1|grep $2|awk '{print $4}'|cut -d= -f2
}
ps_pefconfig_setalert()
{
	rm -f /tmp/pefconfig_alert > /dev/null 2>&1
	ip=`get_host_ip_address`
	mac=`get_host_mac_address`
 	pefconfig -A $ip -B $mac > /tmp/pefconfig_alert 2>&1
 	setip=`get_alert_setip_address /tmp/pefconfig_alert alert`
 	setmac=`get_alert_setmac_address /tmp/pefconfig_alert alert`
	setmac=`upper $setmac`
	isip=`check_pef /tmp/pefconfig_alert 18` 
	ismac=`check_pef /tmp/pefconfig_alert 19`
	if [ $ip == $setip ] && [ $mac == $setmac ] \
	 && [ $isip -eq 0 ] && [ $ismac -eq 0 ];then
		 echo "PASS:Pefconfig Set alert" 
		 return 0
 	else
		echo "FAIL:Pefconfig Set Alert"
		return 1
	fi
}
###########################################################
#Test pefconfig set community 
###########################################################
ts_pefconfig_setcommunity()
{
	rm -f  /tmp/pefconfig_comm
	pefconfig -A 127.0.0.1 -C private > /tmp/pefconfig_comm 2>&1
	pef_comm=`cat /tmp/pefconfig_comm|grep Community|awk '{print $5}'`
	if [ $pef_comm == "private" ];then
		echo "PASS:Pefconfig set community"
		return 0		
	else
		echo "FAIL:Pefconfig set community"
		return 1		
	fi
}
get_pef_subnet()
{
	a=`cat $1|grep Subnet|awk '{print $5}'`
	b=`cat $1|grep Subnet|awk '{print $6}'`
	c=`cat $1|grep Subnet|awk '{print $7}'`
	d=`cat $1|grep Subnet|awk '{print $8}'`
	echo $a.$b.$c.$d
}
##############################################################
#Test pefconfig set subnet mask
###############################################################
ts_pefconfig_setsubnet()
{

	subnet=`get_subnet_mask_address`;
	pefconfig -S $subnet > /tmp/pefconfig_subnet 2>&1
	pef_subnet=`get_pef_subnet /tmp/pefconfig_subnet`
	if [ $subnet == $pef_subnet ];then
		echo "PASS:Pefconfig get sub net mask address"
		return 0		
	else
		echo "FAIL: Pefconfig get sub net mask address"
		return 1
	fi
}

pefconfig_test()
{
	pefconfig_basic
	if [ "$?" -eq 0 ];then 
		ts_pefconfign 9
		ts_pefconfign 12
		ts_pefconfign 16
		ts_pefconfigx
		ts_pefconfig_sethost
		ts_pefconfig_setroute
		ts_pefconfig_setsubnet
	else
		"System does not support pefconfig function"
	fi
}
#*****************************************************/
#Test the tmconfig util******************************/
#*****************************************************/
EntryTest()
{
	which tmconfig > /dev/null 2>&1
	if [ $? -ne 0 ];then
		if [ -f /usr/share/panicsel/tmconfig ];then
			cp -f /usr/share/panicsel/tmconfig /usr/sbin
		else
			echo "Tmconfig:there are no tmconfig util"
			exit 1
		fi
	fi
}
TestPara()
{
	result=`cat $1|grep $2|awk '{print $4}'|cut -d , -f 1`
	if [ $result -eq 0 ];then
		echo "PASS:Tmconfig" $2
		return 0
	else
		echo "FAIL:Tmconfig" $2
		return 1
	fi 	

}
ts_tmconfigr()
{
	infoline="Test tmconfig parameter r"
	EntryTest
	tmconfig -r > /dev/null 2>&1
	if [ $? -eq 0 ];then
		echo  "PASS:" $infoline
		return 0
	else
		echo "FAIL:" $infoline
		return 1
	fi
}

ts_tmconfigs()
{
	infoline="Test tmconfig parameter n"
	EntryTest
	tmconfig -s > /tmp/tmconfigs 2>&1
	TestPara /tmp/tmconfigs "SetChanAcc(ser)" $infoline
}
ts_tmconfigup()
{
        infoline="Test tmconfig parameter u and p"
        EntryTest
        tmconfig -u root -p password >/dev/null 2>&1
        if [ $? -eq 0 ];then
                echo PASS $infoline
        else
                echo FAIL $infoline
        fi
}
LanTest()
{
        infoline="Test tmconfig parameter l"
        tmconfig -l > /tmp/tmconfigl
        line=`cat /tmp/tmconfigl|grep "Lan Param"|wc -l`
        if [ $line -eq 22 ];then
                echo  "PASS" $infoline
        else
                echo "FAIL"  $infoline
        fi
}
ts_tmconfigl()
{
        EntryTest
        LanTest
}

ts_tmconfign()
{
        infoline="Test tmconfig parameter n"
        EntryTest
        tmconfig -n>/tmp/tmconfign 2>&1
        TestPara /tmp/tmconfign "SetSerialMux(Basebd)" $infoline
}
ts_tmconfigt()
{
        infoline="Test tmconfig parameter t"
        EntryTest
        tmconfig -t>/tmp/tmconfigt 2>&1
        TestPara /tmp/tmconfigt "SetSerialMux(TMode)" $infoline
}

tmconfig_test()
{
	ts_tmconfigr
	if [ $? -eq 0 ];then
		ts_tmconfigs
		ts_tmconfigl
		ts_tmconfign
		ts_tmconfigup
		ts_tmconfigt
	else
		echo "FAIL:Basic tmconfig testing"
	fi
}
showsel_test
pefconfig_test
tmconfig_test
