#
# Makefile to generate ipmiutil utilities (on SCO UnixWare 7.1.1)
# $Modtime:   Aug  2 2002 16:15:24  $
# $Revision:   1.5  $
#
# Issues:  SCO has getopt in stdio.h, and getopt.h is missing.
#          SCO cannot handle macro args (NO_MACRO_ARGS) in imbapi.c
# Define SCO_UW compile flag to handle these.
# It now compiles, but we still get other errors though.
#
CC=cc
CCC=g++

COPTS = -DSCO_UW -DUNIX -D_REENTRANT -DUWSVR4 

OBJS = showsel.o pefconfig.o hwreset.o tmconfig.o sensor.o fruconfig.o alarms.o wdt.o
IOBJS = ipmicmd.o imbapi.o ipmimv.o
TARGS = showsel sensor hwreset fruconfig alarms wdt pefconfig tmconfig

ALL : $(TARGS)

#%.o:    %.c
#        $(CC) $(COPTS) -c  $(*F).c

imbapi.o:	imbapi.c imb_api.h
	$(CC) $(COPTS) -c imbapi.c 

ipmimv.o:	ipmimv.c
	$(CC) $(COPTS) -c ipmimv.c

ipmicmd.o:	ipmicmd.c ipmicmd.h
	$(CC) $(COPTS) -c ipmicmd.c 

showsel.o:	showsel.c 
	$(CC) $(COPTS) -c showsel.c

sensor.o:	sensor.c 
	$(CC) $(COPTS) -c sensor.c
showsel:	showsel.o $(IOBJS)
	$(CC) $(COPTS) -o showsel showsel.o $(IOBJS)

sensor: 	sensor.o  $(IOBJS)
	$(CC) $(COPTS) -o sensor sensor.o  $(IOBJS)

hwreset:	hwreset.o  $(IOBJS)
	$(CC) $(COPTS) -o hwreset hwreset.o  $(IOBJS)

fruconfig:	fruconfig.o  $(IOBJS)
	$(CC) $(COPTS) -o fruconfig fruconfig.o  $(IOBJS)

alarms: 	alarms.o $(IOBJS)
	$(CC) $(COPTS) -o alarms alarms.o $(IOBJS)

pefconfig:	     pefconfig.o $(IOBJS)
	$(CC) $(COPTS) -o pefconfig pefconfig.o $(IOBJS) 

tmconfig:	     tmconfig.o  $(IOBJS)
	$(CC) $(COPTS) -o tmconfig tmconfig.o $(IOBJS)

wdt: 	wdt.o $(IOBJS)
	$(CC) $(COPTS) -o wdt wdt.o $(IOBJS)

clean: 
	rm -f $(OBJS) $(IOBJS) $(TARGS)
