/*M*
//  PVCS:
//      $Workfile:   ipmiia.c  $
//      $Revision:   1.02  $
//      $Modtime:   06 Jul 2006 11:24:14  $
//      $Author:   arcress@users.sourceforge.net  $  
//
//  Define the ipmi_cmd routines for the Intel IMB IPMI driver.
//     /dev/imb  = Intel IMB IPMI driver 
// 
//  07/06/06 ARC - created from ipmicmd.c
//  04/30/07 ARC - moved relevant sutroutine to imbapi.c
 *M*/
/*----------------------------------------------------------------------*
The BSD License 

Copyright (c) 2002-2006, Intel Corporation
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met:

  a.. Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer. 
  b.. Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution. 
  c.. Neither the name of Intel Corporation nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *----------------------------------------------------------------------*/
#ifdef WIN32
#include <windows.h>
#else
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <unistd.h>
#endif
#include <stdio.h>

#include "ipmicmd.h"  

/* 
 * See imbapi.c for SendTimedImbpRequest, etc.   
 *
 * Special stuff for ipmi_cmd_ia() IMB functions 
 * has now been moved to imbapi.c also.
 */
#ifdef MOVED
/* begin MOVED code */

// Request structure provided to SendTimedImbpRequest()
#pragma pack(1)
typedef struct {
        uchar   cmdType;        // IMB command
        uchar   rsSa;           // command destination address
        uchar   busType;        // not used
        uchar   netFn;          // IMB command class (network function)
        uchar   rsLun;          // subsystem on destination
        uchar * data;           // command body
        int     dataLength;     // body size
} IMBPREQUESTDATA;
#pragma pack() 

#ifdef LINK_LANDESK
#define SendTimedImbpRequest ia_SendTimedImbpRequest /* defined in imbapi.c */
#endif
extern uint SendTimedImbpRequest (   /* defined in imbapi.c */
        IMBPREQUESTDATA *reqPtr,         // request info and data
        int              timeOut,        // how long to wait, in mSec units
        uchar           *respDataPtr,    // where to put response data
        int             *respDataLen,    // how much response data there is
        uchar           *completionCode  // request status from dest controller
        );
extern int ipmi_open_ia(char fdebug);
extern int ipmi_close_ia(void);

/* Global Data */
// extern int fDriverTyp;
extern FILE *fperr;
extern FILE *fpdbg;
extern ipmi_cmd_t ipmi_cmds[NCMDS];

// special IMB defines
#define MAX_NO_OF_RETRIES       3
#define DEFAULT_TIMEOUT       (1000)  /*timeout for SendTimedImb in sec*/

int ipmi_timeout_ia = DEFAULT_TIMEOUT;  /* in sec */

int ipmi_cmdraw_ia(uchar cmd, uchar netfn, uchar lun, uchar sa, uchar bus, 
                   uchar *pdata, uchar sdata, uchar *presp, int *sresp, 
                   uchar *pcc, char fdebugcmd)
{
   IMBPREQUESTDATA requestData;
   int status = 0;
   char *imbDev;
   uchar * pc;
   int sz, i;
#ifndef WIN32
   struct stat     stbuf;
#endif

   requestData.cmdType	= cmd;
   requestData.rsSa	= sa;
   requestData.busType	= bus;
   requestData.netFn	= netfn;
   requestData.rsLun	= lun;
   requestData.dataLength = sdata;
   requestData.data       = pdata; 

   if (fdebugcmd) {
          sz = sizeof(IMBPREQUESTDATA);
          pc = (uchar *)&requestData.cmdType;
          fprintf(fpdbg,"ipmi_cmdraw_ia: request (len=%d): ",sz);
          for (i = 0; i < sz; i++) fprintf(fpdbg,"%02x ",pc[i]);
          fprintf(fpdbg,"\n");
          pc = requestData.data;
          sz = requestData.dataLength;
          fprintf(fpdbg,"  req.data=%p, dlen=%d: ", pc, sz);
          for (i = 0; i < sz; i++) fprintf(fpdbg,"%02x ",pc[i]);
          fprintf(fpdbg,"\n");
        }

#ifdef WIN32
   imbDev = "[imbdrv]";
   if (1) 
#else
   imbDev = "/dev/imb";
   if (stat(imbDev, &stbuf) == -1)  {
	   fprintf(fperr,"ipmi_cmdraw_ia: No IMB driver found (%s)\n",imbDev);
	   return(ERR_NO_DRV);
   } else    /* imb device node is there */
#endif
   {
	   sz = *sresp;  /* note that sresp must be pre-set */
	   memset(presp, 0, sz);
           for ( i =0 ; i < MAX_NO_OF_RETRIES; i++) 
	   {
		*sresp = sz;   /* retries may need to re-init *sresp */
		if((status = SendTimedImbpRequest(&requestData, ipmi_timeout_ia, presp, sresp, pcc)) == ACCESS_OK ) {
			break;
			}
		if (fdebugcmd)   // only gets here if error
	          fprintf(fpdbg,"ipmi_cmdraw_ia: sendImbRequest error status=%x, ccode=%x\n",
                            (uint)status, *pcc);
	   } 
   }

    if (fdebugcmd) {  /* if debug, show both good and bad statuses */
	    fprintf(fpdbg,"ipmi_cmdraw_ia: sendImbRequest status=%x, ccode=%x\n", 
                      (uint)status, *pcc);
            if (status == ACCESS_OK) {  
               uchar * pc; int sz;
               sz = *sresp;
               pc = (uchar *)presp;
               fprintf(fpdbg,"ipmi_cmdraw_ia: response (len=%d): ",sz);
               for (i = 0; i < sz; i++) fprintf(fpdbg,"%02x ",pc[i]);
               fprintf(fpdbg,"\n");
            }
        }

    return(status);
} /* end ipmi_cmdraw_ia() */

int ipmi_cmd_ia(ushort cmd, uchar *pdata, uchar sdata, uchar *presp, 
		int *sresp, uchar *pcc, char fdebugcmd)
{
   IMBPREQUESTDATA requestData;
   int status = 0;
   char *imbDev;
   uchar * pc;
   int sz, i;
#ifndef WIN32
   struct stat     stbuf;
#endif

   for (i = 0; i < NCMDS; i++) {
      if (ipmi_cmds[i].cmdtyp == cmd) break;
   }
   if (i >= NCMDS) {
	fprintf(fperr,"ipmi_cmd_ia: Unknown command %x\n",cmd);
	return(-1); 
	}
   if (cmd >= CMDMASK) cmd = cmd & CMDMASK;  /* unmask it */

   requestData.cmdType	= (uchar)(cmd & 0x00ff);
   requestData.rsSa	= ipmi_cmds[i].sa;
   requestData.busType	= ipmi_cmds[i].bus;
   requestData.netFn	= ipmi_cmds[i].netfn;
   requestData.rsLun	= ipmi_cmds[i].lun;
   requestData.dataLength = sdata;
   requestData.data       = pdata; 

   if (fdebugcmd) {
          sz = sizeof(IMBPREQUESTDATA);
          pc = (uchar *)&requestData.cmdType;
          fprintf(fpdbg,"ipmi_cmd_ia: request (len=%d): ",sz);
          for (i = 0; i < sz; i++) fprintf(fpdbg,"%02x ",pc[i]);
          fprintf(fpdbg,"\n");
          pc = requestData.data;
          sz = requestData.dataLength;
          fprintf(fpdbg,"  req.data=%p, dlen=%d: ", pc, sz);
          for (i = 0; i < sz; i++) fprintf(fpdbg,"%02x ",pc[i]);
          fprintf(fpdbg,"\n");
        }

#ifdef WIN32
   imbDev = "[imbdrv]";
   if (1) 
#else
   imbDev = "/dev/imb";
   if (stat(imbDev, &stbuf) == -1)  {
	   fprintf(fperr,"ipmi_cmd_ia: No IMB driver found (%s)\n",imbDev);
	   return(ERR_NO_DRV);
   } else    /* imb device node is there */
#endif
   {
	   sz = *sresp;  /* note that sresp must be pre-set */
	   memset(presp, 0, sz);
           for ( i =0 ; i < MAX_NO_OF_RETRIES; i++) 
	   {
		*sresp = sz;   /* retries may need to re-init *sresp */
		if((status = SendTimedImbpRequest(&requestData, ipmi_timeout_ia, presp, sresp, pcc)) == ACCESS_OK ) {
			break;
			}
		if (fdebugcmd)   // only gets here if error
	          fprintf(fpdbg,"ipmi_cmd_ia: sendImbRequest error status=%x, ccode=%x\n",
                            (uint)status, *pcc);
	   } 
   }

    if (fdebugcmd) {  /* if debug, show both good and bad statuses */
	    fprintf(fpdbg,"ipmi_cmd_ia: sendImbRequest status=%x, ccode=%x\n", 
                      (uint)status, *pcc);
            if (status == ACCESS_OK) {  
               uchar * pc; int sz;
               sz = *sresp;
               pc = (uchar *)presp;
               fprintf(fpdbg,"ipmi_cmd_ia: response (len=%d): ",sz);
               for (i = 0; i < sz; i++) fprintf(fpdbg,"%02x ",pc[i]);
               fprintf(fpdbg,"\n");
            }
        }

    return(status);
} /* end ipmi_cmd_ia() */

/* end MOVED code */
#endif

/* end ipmiia.c */
