/*
 * ipmilanplus.h:  (a copy of ipmitool/ipmi_intf.h)
 *
 * Copyright (c) 2003 Sun Microsystems, Inc.  All Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * Redistribution of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * Redistribution in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any kind.
 * ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES,
 * INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.
 * SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.  IN NO EVENT WILL
 * SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA,
 * OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
 * PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
 * LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE,
 * EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */

#ifndef IPMI_INTF_H
#define IPMI_INTF_H

/*
#include <ipmitool/ipmi.h>
#include <ipmitool/ipmi_oem.h>
#include <ipmitool/ipmi_constants.h>

#include <sys/types.h>
*/
#ifdef WIN32
#include <windows.h>
#include <winsock.h>
typedef unsigned char           uint8_t;
typedef unsigned short int      uint16_t;
typedef unsigned int            uint32_t;
typedef int              	int32_t;
typedef uint32_t    socklen_t;

#else
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif

/**************************************/
 
#define IPMI_BMC_SLAVE_ADDR   0x20
#define IPMI_BUF_SIZE  1024
struct ipmi_rq {
        struct {
                uint8_t netfn:6;
                uint8_t lun:2;
                uint8_t cmd;
                uint8_t target_cmd;
                uint16_t data_len;
                uint8_t *data;
        } msg;
};

struct ipmi_rs {
        uint8_t ccode;
        uint8_t data[IPMI_BUF_SIZE];
 
        /*
         * Looks like this is the length of the entire packet, including the RMCP
         * stuff, then modified to be the length of the extra IPMI message data
         */
        int data_len;
 
        struct {
                uint8_t netfn;
                uint8_t cmd;
                uint8_t seq;
                uint8_t lun;
        } msg;
 
        struct {
                uint8_t authtype;
                uint32_t seq;
                uint32_t id;
                uint8_t bEncrypted;     /* IPMI v2 only */
                uint8_t bAuthenticated; /* IPMI v2 only */
                uint8_t payloadtype;    /* IPMI v2 only */
                /* This is the total length of the payload or
                   IPMI message.  IPMI v2.0 requires this to
                   be 2 bytes.  Not really used for much. */
                uint16_t msglen;
        } session;
 
        /*
         * A union of the different possible payload meta-data
         */
        union {
                struct {
                        uint8_t rq_addr;
                        uint8_t netfn;
                        uint8_t rq_lun;
                        uint8_t rs_addr;
                        uint8_t rq_seq;
                        uint8_t rs_lun;
                        uint8_t cmd;
                } ipmi_response;
                struct {
                        uint8_t message_tag;
                        uint8_t rakp_return_code;
                        uint8_t max_priv_level;
                        uint32_t console_id;
                        uint32_t bmc_id;
                        uint8_t auth_alg;
                        uint8_t integrity_alg;
                        uint8_t crypt_alg;
                } open_session_response;
                struct {
                        uint8_t message_tag;
                        uint8_t rakp_return_code;
                        uint32_t console_id;
                        uint8_t bmc_rand[16];   /* Random number generated by the BMC */
                        uint8_t bmc_guid[16];
                        uint8_t key_exchange_auth_code[20];
                } rakp2_message;
                struct {
                        uint8_t message_tag;
                        uint8_t rakp_return_code;
                        uint32_t console_id;
                        uint8_t integrity_check_value[20];
                } rakp4_message;
                struct {
                        uint8_t packet_sequence_number;
                        uint8_t acked_packet_number;
                        uint8_t accepted_character_count;
                        uint8_t is_nack;        /* bool */
                        uint8_t transfer_unavailable;   /* bool */
                        uint8_t sol_inactive;   /* bool */
                        uint8_t transmit_overrun;       /* bool */
                        uint8_t break_detected; /* bool */
                } sol_packet;
 
        } payload;
};

struct ipmi_v2_payload {
	uint16_t payload_length;
	uint8_t payload_type;

	union {

		struct {
			uint8_t rq_seq;
			struct ipmi_rq *request;
		} ipmi_request;

		struct {
			uint8_t rs_seq;
			struct ipmi_rs *response;
		} ipmi_response;

		/* Only used internally by the lanplus interface */
		struct {
			uint8_t *request;
		} open_session_request;

		/* Only used internally by the lanplus interface */
		struct {
			uint8_t *message;
		} rakp_1_message;

		/* Only used internally by the lanplus interface */
		struct {
			uint8_t *message;
		} rakp_2_message;

		/* Only used internally by the lanplus interface */
		struct {
			uint8_t *message;
		} rakp_3_message;

		/* Only used internally by the lanplus interface */
		struct {
			uint8_t *message;
		} rakp_4_message;

		struct {
			uint8_t data[IPMI_BUF_SIZE];
			uint16_t character_count;
			uint8_t packet_sequence_number;
			uint8_t acked_packet_number;
			uint8_t accepted_character_count;
			uint8_t is_nack;	/* bool */
			uint8_t assert_ring_wor;	/* bool */
			uint8_t generate_break;	/* bool */
			uint8_t deassert_cts;	/* bool */
			uint8_t deassert_dcd_dsr;	/* bool */
			uint8_t flush_inbound;	/* bool */
			uint8_t flush_outbound;	/* bool */
		} sol_packet;

	} payload;
};
/**************************************/

/*
 * An enumeration that describes every possible session state for
 * an IPMIv2 / RMCP+ session.
 */
enum LANPLUS_SESSION_STATE {
	LANPLUS_STATE_PRESESSION = 0,
	LANPLUS_STATE_OPEN_SESSION_SENT,
	LANPLUS_STATE_OPEN_SESSION_RECEIEVED,
	LANPLUS_STATE_RAKP_1_SENT,
	LANPLUS_STATE_RAKP_2_RECEIVED,
	LANPLUS_STATE_RAKP_3_SENT,
	LANPLUS_STATE_ACTIVE,
	LANPLUS_STATE_CLOSE_SENT,
};


#define IPMI_AUTHCODE_BUFFER_SIZE 20
#define IPMI_SIK_BUFFER_SIZE      20
#define IPMI_KG_BUFFER_SIZE       21 /* key plus null byte */

struct ipmi_session {
	uint8_t hostname[64];
	uint8_t username[17];
	uint8_t authcode[IPMI_AUTHCODE_BUFFER_SIZE + 1];
	uint8_t challenge[16];
	uint8_t authtype;
	uint8_t authtype_set;
#define IPMI_AUTHSTATUS_PER_MSG_DISABLED	0x10
#define IPMI_AUTHSTATUS_PER_USER_DISABLED	0x08
#define IPMI_AUTHSTATUS_NONNULL_USERS_ENABLED	0x04
#define IPMI_AUTHSTATUS_NULL_USERS_ENABLED	0x02
#define IPMI_AUTHSTATUS_ANONYMOUS_USERS_ENABLED	0x01
	uint8_t authstatus;
	uint8_t authextra;
	uint8_t privlvl;
	uint8_t cipher_suite_id;
	char sol_escape_char;
	int password;
	int port;
	int active;
	int retry;

	uint32_t session_id;
	uint32_t in_seq;
	uint32_t out_seq;
	uint32_t timeout;

	struct sockaddr_in addr;
	socklen_t addrlen;

	/*
	 * This struct holds state data specific to IMPI v2 / RMCP+ sessions
	 */
	struct {
		enum LANPLUS_SESSION_STATE session_state;

		/* These are the algorithms agreed upon for the session */
		uint8_t requested_auth_alg;
		uint8_t requested_integrity_alg;
		uint8_t requested_crypt_alg;
		uint8_t auth_alg;
		uint8_t integrity_alg;
		uint8_t crypt_alg;
		uint8_t max_priv_level;

		uint32_t console_id;
		uint32_t bmc_id;

		/*
		 * Values required for RAKP mesages
		 */

		/* Random number generated byt the console */
		uint8_t console_rand[16]; 
		/* Random number generated by the BMC */
		uint8_t bmc_rand[16];

		uint8_t bmc_guid[16];
		uint8_t requested_role;   /* As sent in the RAKP 1 message */
		uint8_t rakp2_return_code;

		uint8_t sik[IPMI_SIK_BUFFER_SIZE]; /* Session integrity key */
		uint8_t kg[IPMI_KG_BUFFER_SIZE];   /* BMC key */
		uint8_t k1[20];   /* Used for Integrity checking? */
		uint8_t k2[20];   /* First 16 bytes used for AES  */
	} v2_data;


	/*
	 * This data is specific to the Serial Over Lan session
	 */
	struct {
		uint16_t max_inbound_payload_size;
		uint16_t max_outbound_payload_size;
		uint16_t port;
		uint8_t sequence_number;

		/*  This data describes the last SOL packet */
		uint8_t last_received_sequence_number;
		uint8_t last_received_byte_count;
		void (*sol_input_handler)(struct ipmi_rs * rsp);
	} sol_data;
};

struct ipmi_intf_support {
	const char * name;
	int supported;
};

struct ipmi_intf {
	char name[16];
	char desc[128];
	int fd;
	int opened;
	int abort;
	int noanswer;

	struct ipmi_session * session;
	struct ipmi_oem_handle * oem;
	struct ipmi_cmd * cmdlist;
	uint32_t my_addr;
	uint32_t target_addr;
	uint8_t target_lun;
	uint8_t target_channel;
        uint32_t transit_addr;
        uint8_t transit_channel;
        uint8_t devnum;

	int (*setup)(struct ipmi_intf * intf);
	int (*open)(struct ipmi_intf * intf);
	void (*close)(struct ipmi_intf * intf);
	struct ipmi_rs *(*sendrecv)(struct ipmi_intf * intf, struct ipmi_rq * req);
	int (*sendrsp)(struct ipmi_intf * intf, struct ipmi_rs * rsp);
	struct ipmi_rs *(*recv_sol)(struct ipmi_intf * intf);
	struct ipmi_rs *(*send_sol)(struct ipmi_intf * intf, void *payload);
                                 /*struct ipmi_v2_payload * payload);*/
	int (*keepalive)(struct ipmi_intf * intf);
};

struct ipmi_cmd {
	int (*func)(struct ipmi_intf * intf, int argc, char ** argv);
	const char * name;
	const char * desc;
};

struct ipmi_intf * ipmi_intf_load(char * name);
void ipmi_intf_print(struct ipmi_intf_support * intflist);

void lanplus_set_sol_data(int insize, int outsize, int port);

#ifdef NEEDED
struct ipmi_rs * ipmi_lan_send_cmd(struct ipmi_intf * intf, struct ipmi_rq * req);
int  ipmi_lanplus_open(struct ipmi_intf * intf);
void ipmi_lanplus_close(struct ipmi_intf * intf);
int ipmiv2_lan_ping(struct ipmi_intf * intf);
int ipmi_lanplus_setup(struct ipmi_intf * intf);
int ipmi_lanplus_keepalive(struct ipmi_intf * intf);
struct ipmi_rs * ipmi_lanplus_send_ipmi_cmd(struct ipmi_intf * intf, struct ipmi_rq * req);
struct ipmi_rs * ipmi_lanplus_recv_sol(struct ipmi_intf * intf);
struct ipmi_rs * ipmi_lanplus_send_sol( struct ipmi_intf * intf, void *payload);

void ipmi_intf_session_set_hostname(struct ipmi_intf * intf, char * hostname);
void ipmi_intf_session_set_username(struct ipmi_intf * intf, char * username);
void ipmi_intf_session_set_password(struct ipmi_intf * intf, char * password);
void ipmi_intf_session_set_privlvl(struct ipmi_intf * intf, uint8_t privlvl);
void ipmi_intf_session_set_cipher_suite_id(struct ipmi_intf * intf, uint8_t cipher_suite_id);
void ipmi_intf_session_set_sol_escape_char(struct ipmi_intf * intf, char sol_escape_char);
void ipmi_intf_session_set_kgkey(struct ipmi_intf * intf, char * kgkey);
void ipmi_intf_session_set_port(struct ipmi_intf * intf, int port);
void ipmi_intf_session_set_authtype(struct ipmi_intf * intf, uint8_t authtype);
void ipmi_intf_session_set_timeout(struct ipmi_intf * intf, uint32_t timeout);
void ipmi_intf_session_set_retry(struct ipmi_intf * intf, int retry);
void ipmi_cleanup(struct ipmi_intf * intf);
#endif

#endif /* IPMI_INTF_H */
