/***********************************************
 * ipmiutil.c 
 *
 * This is a meta-command utility to invoke each of the
 * other sub-commands in a consolidated interface.
 * To build this, compile with -DMETACOMMAND.
 *
 * Author:  Andy Cress  arcress@users.sourceforge.net
 * Copyright (c) 2006-2007 Intel Corporation.
 *
 * 01/03/07 ARCress - created
 * 01/05/07 ARCress - version 1.0
 * 01/10/07 ARCress - version 1.1
 * 02/07/07 ARCress - version 1.3 adding isolconsole
 * 02/26/07 ARCress - updated sub-command names
 * 08/31/07 ARCress - added "leds" subcommand
 *
 ***********************************************/
/*----------------------------------------------------------------------*
The BSD License 

Copyright (c) 2007, Intel Corporation
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met:

  a.. Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer. 
  b.. Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution. 
  c.. Neither the name of Intel Corporation nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *----------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>

#include "ipmicmd.h"
#include "ipmiutil.h"

static char *progname  = "ipmiutil";
static char *progver   = "2.12";
static char fdebug = 0;
/*int ipmiutil(int argc, char **argv); */

#define NSUBCMDS  14
static struct {
  int idx;
  char tag[16];
  int (*rtn)(int argc, char **argv);
  char desc[50];
  } subcmds[NSUBCMDS] = {
 {  0, "alarms", i_alarms,  "show/set the front panel alarm LEDs and relays" },
 {  1, "leds",   i_alarms,  "show/set the front panel alarm LEDs and relays" },
 {  2, "discover", i_discover, "discover all IPMI servers on this LAN" },
 {  3, "health", i_health,  "check and show the basic health of the IPMI BMC"},
 {  4, "fru",    i_fru,     "show decoded FRU inventory data, write asset tag"},
 {  5, "getevt", i_getevt,  "receive any IPMI events and display them" },
 {  6, "reset",  i_reset,   "cause the BMC to reset or power down the system"},
 {  7, "cmd",    i_cmd ,    "send a specified raw IPMI command to the BMC" },
 {  8, "lan",    i_lan,     "show/set IPMI LAN parameters and PEF table"},
 {  9, "serial", i_serial,  "show/set IPMI Serial & Terminal Mode parameters"},
 { 10, "sensor", i_sensor,  "show Sensor Data Records, readings, thresholds" },
 { 11, "sel",    i_sel,     "show/clear firmware System Event Log records" },
 { 12, "sol",    i_sol,     "start/stop an SOL console session" },
 { 13, "wdt",    i_wdt,     "show/set/reset the watchdog timer" } };

static char usagemsg[] = "Usage: ipmiutil <command> [other options]\n"
                         "   where <command> is one of the following:\n";
static char helpmsg[]  = "For help on each command (e.g. 'sel'), enter:\n"
			 "   ipmiutil sel -?\n";

static void show_usage()
{
    int i;
    printf(usagemsg);
    for (i=0; i<NSUBCMDS; i++)
       printf("\t%s\t%s\n",subcmds[i].tag,subcmds[i].desc);
    printf("   common IPMI LAN options:\n");
    print_lan_opt_usage();
    printf(helpmsg);
}

#ifdef WIN32
int __cdecl
#else
int
#endif
main(int argc, char **argv)
{
   int ret = 1;
   int i;
   
   printf("%s ver %s\n", progname,progver); 
   if (argc < 2) {
      show_usage();
      exit(1);
   }
   for (i = 0; i < NSUBCMDS; i++)
   {
       if (strcmp(argv[1],subcmds[i].tag) == 0) {
          argc--;
          argv++;
          ret = subcmds[i].rtn(argc,argv);
       }
   }
   if (i >= NSUBCMDS) {
      show_usage();
      ret = 1;
   }
   else show_outcome(progname,ret); 
   return(ret);
}

/*end ipmiutil.c*/
