# ipmiutil.mak
# This makefile will build the ipmiutil util directory
#
# First download getopt.c getopt.h
# Then download and build openssl for Windows 
#
# buildwin.cmd sets VCDIR, the directory containing VisualStudio 6.0 VC
LIBC=/LIBPATH:%VCDIR%\lib 
INCL=%VCDIR%\include

# The ipmiutil directory
SRC_D=.
LIB_D=..\lib
INSTALLTOP=install
OUT_D=obj
TMP_D=tmp
INC=-I$(INCL) -I$(SRC_D)
O_LIB=lanplus.lib
# To remove lanplus support use the empty LANPLUS variables
# LF_LANPLUS=
# CF_LANPLUS=
LF_LANPLUS=/LIBPATH:$(LIB_D) $(O_LIB) ssleay32.lib libeay32.lib 
CF_LANPLUS=/D HAVE_LANPLUS

# Set your compiler options
# To remove any GPL dependencies, use the CF_EX line with NON_GPL
CF_EX=/DWIN32 $(CF_LANPLUS) $(INC)
# CF_EX=/DWIN32 $(CF_LANPLUS) $(INC) /DNON_GPL
# old CFLAGS= /MD /W3 /WX /Ox /O2 /Ob2 /Gs0 /GF /Gy /nologo $(CF_EX)
CFLAGS=/Zel /Zp8 /W3 /Gm- /GF /Gy /Oy /nologo $(CF_EX)
CFLAGS_M=/Zel /Zp8 /W3 /Gm- /GF /Gy /Oy /nologo $(CF_EX) /D METACOMMAND
LFLAGS=/nologo /subsystem:console /machine:IX86 /opt:ref $(LIBC)
LFLAGS_D=/nologo /subsystem:console /machine:I386 /opt:ref /dll
CC=cl
LINK=link
MKDIR=-mkdir
MKLIB=lib
RM=del
CP=copy

CMD_OBJ  = getopt.obj ipmicmd.obj imbapi.obj md5.obj md2.obj  \
           ipmilan.obj ipmilanplus.obj 
LIBS_EX  = advapi32.lib kernel32.lib wsock32.lib libc.lib
LIBS_PEF = /LIBPATH:$(LIB_D) iphlpapi.lib
# LIBS_EX+=wsock32.lib user32.lib gdi32.lib 


HEADER=ipmicmd.h imb_api.h ipmilan.h ipmidir.h ipmi_ioctls.h ipmilanplus.h \
       ipmiutil.h

SHOWSEL = showsel
TARG_EXE=alarms.exe bmchealth.exe $(SHOWSEL).exe $(SHOWSEL)msg.dll \
         hwreset.exe fruconfig.exe pefconfig.exe tmconfig.exe wdt.exe \
         getevent.exe sensor.exe icmd.exe isolconsole.exe idiscover.exe \
         events.exe
E_EXE=ipmiutil.exe
E_OBJ=$(TMP_D)\ipmiutil.obj \
      $(TMP_D)\alarms.obj $(TMP_D)\bmchealth.obj $(TMP_D)\wdt.obj   \
      $(TMP_D)\hwreset.obj $(TMP_D)\fruconfig.obj $(TMP_D)\pefconfig.obj \
      $(TMP_D)\tmconfig.obj $(TMP_D)\icmd.obj $(TMP_D)\isolconsole.obj \
      $(TMP_D)\isolwin.obj $(TMP_D)\idiscover.obj \
      $(TMP_D)\getevent.obj $(TMP_D)\sensor.obj $(TMP_D)\showsel.obj \
      events.obj getopt.obj ipmicmd.obj imbapi.obj ipmilanplus.obj \
      md5.obj md2.obj ipmilan.obj 

###################################################################
all: banner $(TMP_D) exe 

banner:
	@echo Building ipmiutil

$(TMP_D):
	$(MKDIR) $(TMP_D)
	@echo created $(TMP_D)

lib:    $(LIB_D)\$(O_LIB)
    cd $(LIB_D)
    nmake /nologo -f ipmilib.mak
    cd ../util

exe: $(TARG_EXE) $(E_EXE)

install:
	$(MKDIR) $(INSTALLTOP)
	$(MKDIR) $(INSTALLTOP)\bin
	$(CP) $(E_EXE)    $(INSTALLTOP)\bin
	xcopy $(TARG_EXE) $(INSTALLTOP)\bin
	xcopy *.dll       $(INSTALLTOP)\bin

clean:
	$(RM) *.obj
	$(RM) *.exe
	$(RM) $(TMP_D)\*.obj

distclean:
	$(RM) *.obj
	$(RM) *.exe
	$(RM) $(TMP_D)\*.*
	rmdir $(TMP_D)
	$(RM) *.dll
	$(RM) getopt.*

getopt.obj:    getopt.c
    $(CC) /c $(CFLAGS) getopt.c

imbapi.obj:    imbapi.c
    $(CC) /c $(CFLAGS) imbapi.c

ipmicmd.obj:    ipmicmd.c
    $(CC) /c $(CFLAGS) ipmicmd.c

ipmilan.obj:    ipmilan.c
    $(CC) /c $(CFLAGS) ipmilan.c

ipmilanplus.obj:    ipmilanplus.c
    $(CC) /c $(CFLAGS) ipmilanplus.c

md5.obj:    md5.c
    $(CC) /c $(CFLAGS) md5.c

md2.obj:    md2.c
    $(CC) /c $(CFLAGS) md2.c

events.obj:    events.c
    $(CC) /c $(CFLAGS) events.c

alarms.obj:    alarms.c
    $(CC) /c $(CFLAGS) alarms.c

bmchealth.obj:    bmchealth.c
    $(CC) /c $(CFLAGS) bmchealth.c

getevent.obj:    getevent.c
    $(CC) /c $(CFLAGS) getevent.c

$(SHOWSEL).obj:    $(SHOWSEL).c
    $(CC) /c $(CFLAGS) $(SHOWSEL).c

hwreset.obj:    hwreset.c
    $(CC) /c $(CFLAGS) hwreset.c

hwreset.exe:     hwreset.obj $(CMD_OBJ)
    $(LINK) $(LFLAGS) /OUT:hwreset.exe hwreset.obj $(CMD_OBJ) \
            $(LF_LANPLUS) $(LIBS_EX)

fruconfig.obj:    fruconfig.c
    $(CC) /c $(CFLAGS) fruconfig.c

fruconfig.exe:     fruconfig.obj $(CMD_OBJ)
    $(LINK) $(LFLAGS) /OUT:fruconfig.exe fruconfig.obj $(CMD_OBJ) \
            $(LF_LANPLUS) $(LIBS_EX)

pefconfig.obj:    pefconfig.c
    $(CC) /c $(CFLAGS) pefconfig.c

pefconfig.exe:     pefconfig.obj $(CMD_OBJ)
    $(LINK) $(LFLAGS) /OUT:pefconfig.exe pefconfig.obj $(CMD_OBJ) \
            $(LF_LANPLUS) $(LIBS_PEF) $(LIBS_EX) 

tmconfig.obj:    tmconfig.c
    $(CC) /c $(CFLAGS) tmconfig.c

tmconfig.exe:     tmconfig.obj $(CMD_OBJ)
    $(LINK) $(LFLAGS) /OUT:tmconfig.exe tmconfig.obj $(CMD_OBJ) \
            $(LF_LANPLUS) $(LIBS_EX)

sensor.obj:    sensor.c
    $(CC) /c $(CFLAGS) sensor.c

sensor.exe:     sensor.obj $(CMD_OBJ)
    $(LINK) $(LFLAGS) /OUT:sensor.exe sensor.obj $(CMD_OBJ) \
            $(LF_LANPLUS) $(LIBS_EX)

wdt.obj:    wdt.c
    $(CC) /c $(CFLAGS) wdt.c

wdt.exe:     wdt.obj $(CMD_OBJ)
    $(LINK) $(LFLAGS) /OUT:wdt.exe wdt.obj $(CMD_OBJ) \
            $(LF_LANPLUS) $(LIBS_EX)

isolconsole.obj:    isolconsole.c
    $(CC) /c $(CFLAGS) isolconsole.c

isolwin.obj:    isolwin.c
    $(CC) /c $(CFLAGS) isolwin.c

isolconsole.exe:     isolconsole.obj isolwin.obj $(CMD_OBJ)
    $(LINK) $(LFLAGS) /OUT:isolconsole.exe isolconsole.obj isolwin.obj \
		$(CMD_OBJ) $(LF_LANPLUS) $(LIBS_EX)

icmd.obj:    icmd.c
    $(CC) /c $(CFLAGS) icmd.c

icmd.exe:     icmd.obj $(CMD_OBJ)
    $(LINK) $(LFLAGS) /OUT:icmd.exe icmd.obj $(CMD_OBJ) \
            $(LF_LANPLUS) $(LIBS_EX)

idiscover.obj:    idiscover.c
    $(CC) /c $(CFLAGS) idiscover.c

idiscover.exe:     idiscover.obj getopt.obj
    $(LINK) $(LFLAGS) /OUT:idiscover.exe idiscover.obj getopt.obj \
            $(LF_LANPLUS) $(LIBS_EX)

alarms.exe:     alarms.obj $(CMD_OBJ)
    $(LINK) $(LFLAGS) /OUT:alarms.exe alarms.obj $(CMD_OBJ) \
            $(LF_LANPLUS) $(LIBS_EX)

bmchealth.exe:     bmchealth.obj $(CMD_OBJ)
    $(LINK) $(LFLAGS) /OUT:bmchealth.exe bmchealth.obj $(CMD_OBJ) \
            $(LF_LANPLUS) $(LIBS_EX)

getevent.exe:     getevent.obj events.obj $(CMD_OBJ)
    $(LINK) $(LFLAGS) /OUT:getevent.exe getevent.obj events.obj \
            $(CMD_OBJ) $(LF_LANPLUS) $(LIBS_EX)

$(SHOWSEL).exe:     $(SHOWSEL).obj events.obj $(CMD_OBJ)
    $(LINK) $(LFLAGS) /OUT:$(SHOWSEL).exe $(SHOWSEL).obj events.obj \
            $(CMD_OBJ) $(LF_LANPLUS) $(LIBS_EX)

$(SHOWSEL).mc:     
	$(CP) ..\doc\$(SHOWSEL).mc .

$(SHOWSEL)msg.dll:     $(SHOWSEL).mc
    mc -U $(SHOWSEL).mc
    rc -r $(SHOWSEL).rc
    $(LINK) /machine:IX86 -dll -noentry -out:$(SHOWSEL)msg.dll $(SHOWSEL).res

events.exe:      $(TMP_D)\events.obj 
    $(LINK) $(LFLAGS) /OUT:events.exe $(TMP_D)\events.obj $(LIBS_EX)

$(TMP_D)\events.obj:    events.c
    $(CC) /c $(CFLAGS) /DTEST -Fo$(TMP_D)\events.obj events.c

$(TMP_D)\ipmiutil.obj:    ipmiutil.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\ipmiutil.obj ipmiutil.c

$(TMP_D)\alarms.obj:    alarms.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\alarms.obj alarms.c

$(TMP_D)\bmchealth.obj:    bmchealth.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\bmchealth.obj bmchealth.c

$(TMP_D)\hwreset.obj:    hwreset.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\hwreset.obj hwreset.c

$(TMP_D)\fruconfig.obj:    fruconfig.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\fruconfig.obj fruconfig.c

$(TMP_D)\pefconfig.obj:    pefconfig.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\pefconfig.obj pefconfig.c

$(TMP_D)\tmconfig.obj:    tmconfig.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\tmconfig.obj tmconfig.c

$(TMP_D)\sensor.obj:    sensor.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\sensor.obj sensor.c

$(TMP_D)\icmd.obj:    icmd.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\icmd.obj icmd.c

$(TMP_D)\getevent.obj:    getevent.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\getevent.obj getevent.c

$(TMP_D)\showsel.obj:    showsel.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\showsel.obj showsel.c

$(TMP_D)\isolconsole.obj:    isolconsole.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\isolconsole.obj isolconsole.c

$(TMP_D)\isolwin.obj:    isolwin.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\isolwin.obj isolwin.c

$(TMP_D)\idiscover.obj:    idiscover.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\idiscover.obj idiscover.c

$(TMP_D)\wdt.obj:    wdt.c
    $(CC) /c $(CFLAGS_M) -Fo$(TMP_D)\wdt.obj wdt.c

$(E_EXE):  $(E_OBJ) 
  $(LINK) $(LFLAGS) /OUT:$(E_EXE) $(E_OBJ) $(LF_LANPLUS) $(LIBS_PEF) $(LIBS_EX)

