/*M*
//  PVCS:
//      $Workfile:   ipmiva.c  $
//      $Revision:   1.02  $
//      $Modtime:   06 Jul 2006 11:24:14  $
//      $Author:   arcress@users.sourceforge.net  $  
//
//  Define the ipmi_cmd routines for the valinux IPMI driver.
//     /dev/ipmikcs /dev/ipmi/kcs = valinux driver by San Mehat
// 
//  07/06/06 ARC - created from ipmicmd.c
//  07/25/07 ARC - added VAOK compile flags
 *M*/
/*----------------------------------------------------------------------*
The BSD License 

Copyright (c) 2002-2005, Intel Corporation
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met:

  a.. Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer. 
  b.. Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution. 
  c.. Neither the name of Intel Corporation nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *----------------------------------------------------------------------*/
#ifdef NON_GPL
#undef VAOK
#else
#define VAOK  1
#endif

#ifdef WIN32
#include <windows.h>
#else
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <unistd.h>
#endif
#include <stdio.h>

#include "ipmicmd.h" 
#ifdef VAOK
#include "ipmi_ioctls.h"   /* for ipmi_cmd_va() */
#endif

extern ipmi_cmd_t ipmi_cmds[NCMDS];
extern FILE *fperr;
extern FILE *fpdbg;

/* #define   IOCTL_IPMI_XFER         0x01  (in ipmi_ioctls.h) */
int fd_va = 0;

int ipmi_open_va(char fdebugcmd)
{
#ifdef VAOK
    char *ipmiDev;
    int fd;
    ipmiDev = "/dev/ipmikcs";  
    if ((fd = open(ipmiDev, O_RDWR))<0) {
	if (fdebugcmd)
    	    fprintf(fperr,"ipmi_open_va: cannot open %s\n", ipmiDev);
        ipmiDev = "/dev/ipmi/kcs";  /* some use this name instead */
	}
    if ((fd = open(ipmiDev, O_RDWR))<0) {
	if (fdebugcmd)
    	    fprintf(fperr,"ipmi_open_va: cannot open %s\n", ipmiDev);
	return(-2);
	}
    if (fd > 0) fd_va = fd;
    return(0);
#else
    return(-2);
#endif
}

int ipmi_close_va(void)
{
    int rc = 0;
    if (fd_va != 0) rc = close(fd_va);
    fd_va = 0;
    return(rc);
}

int ipmi_cmdraw_va(uchar cmd, uchar netfn, uchar lun, uchar sa, uchar bus,
		uchar *pdata, uchar sdata, uchar *presp, 
		int *sresp, uchar *pcc, char fdebugcmd)
{
#ifdef VAOK
    IPMI_XFER                       xfer;
    IPMI_XFER                       *xferp = &xfer;
    int fd, rc, i;
    uchar   cc;

    if (ipmi_open_va(fdebugcmd) != 0) return(-2);
    fd = fd_va;

    INIT_XFER(xferp);
    SET_REQUEST_LUN(xferp,   lun);
    SET_REQUEST_NETFN(xferp, netfn);
    SET_REQUEST_CMD(xferp,   cmd);
    if (sdata > 0) 
	SET_REQUEST_DATA(xferp, (uchar *) pdata, sdata);
    if ((rc = ioctl(fd, IOCTL_IPMI_XFER, (void *) &xfer))<0) {
                fprintf(fperr,"ipmi_cmdraw_va[%x]: failed (%d)\n",cmd,rc);
                return(-1);
               }
    GET_RESPONSE_CC(xferp, cc);
    *pcc = cc;
    if (cc != 00) {
	fprintf(fperr,"ipmi_cmdraw_va[%x]: completionCode = %x\n",cmd,cc);
	return(-1);
	}
    else {
	GET_RESPONSE_DATA(xferp, presp);
	}

    if (fdebugcmd) {
	    fprintf(fpdbg,"ipmi_cmdraw_va: ioctl status=%x ccode=%x\n",
			(uint)rc, cc);
            if (rc == 0) {
               uchar * pc; int sz;
               sz = *sresp;
               pc = (uchar *)presp;
               fprintf(fpdbg,"ipmi_cmdraw_va: response (len=%d): ",sz);
               for (i = 0; i < sz; i++) fprintf(fpdbg,"%02x ",pc[i]);
               fprintf(fpdbg,"\n");
            }
        }
    ipmi_close_va();
    return(rc);
#else
    return(-2);
#endif
} /* end ipmi_cmdraw_va() */

int ipmi_cmd_va(ushort cmd, uchar *pdata, uchar sdata, uchar *presp, 
		int *sresp, uchar *pcc, char fdebugcmd)
{
#ifdef VAOK
    IPMI_XFER                       xfer;
    IPMI_XFER                       *xferp = &xfer;
    int fd, rc, i;
    uchar   cc;

    for (i = 0; i < NCMDS; i++) {
       if (ipmi_cmds[i].cmdtyp == cmd) break;
    }
    if (i >= NCMDS) {
	fprintf(fperr, "ipmi_cmd_va: Unknown command %x\n",cmd);
	return(-1); 
	}
    if (cmd >= CMDMASK) cmd = cmd & CMDMASK;  /* unmask it */
 
    if (ipmi_open_va(fdebugcmd) != 0) return(-2);
    fd = fd_va;

    INIT_XFER(xferp);
    SET_REQUEST_LUN(xferp, ipmi_cmds[i].lun);
    SET_REQUEST_NETFN(xferp, ipmi_cmds[i].netfn);
    SET_REQUEST_CMD(xferp, cmd);
    if (sdata > 0) 
	SET_REQUEST_DATA(xferp, (uchar *) pdata, sdata);
    if ((rc = ioctl(fd, IOCTL_IPMI_XFER, (void *) &xfer))<0) {
                fprintf(fperr,"ipmi_cmd_va[%x]: failed (%d)\n",cmd,rc);
                return(-1);
               }
    GET_RESPONSE_CC(xferp, cc);
    *pcc = cc;
    if (cc != 00) {
	fprintf(fperr,"ipmi_cmd_va[%x]: completionCode = %x\n",cmd,cc);
	return(-1);
	}
    else {
	GET_RESPONSE_DATA(xferp, presp);
	}

    if (fdebugcmd) {
	    fprintf(fpdbg,"ipmi_cmd_va: ioctl status=%x ccode=%x\n",
			(uint)rc, cc);
            if (rc == 0) {
               uchar * pc; int sz;
               sz = *sresp;
               pc = (uchar *)presp;
               fprintf(fpdbg,"ipmi_cmd_va: response (len=%d): ",sz);
               for (i = 0; i < sz; i++) fprintf(fpdbg,"%02x ",pc[i]);
               fprintf(fpdbg,"\n");
            }
        }
    ipmi_close_va();
    return(rc);
#else
    return(-2);
#endif
} /* end ipmi_cmd_va() */

/* end ipmiva.c */
