/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BOOLEAN_SYM = 295,
     BOOL_SYM = 296,
     BOTH = 297,
     BTREE_SYM = 298,
     BY = 299,
     BYTE_SYM = 300,
     CACHE_SYM = 301,
     CALL_SYM = 302,
     CASCADE = 303,
     CASCADED = 304,
     CAST_SYM = 305,
     CHAIN_SYM = 306,
     CHANGE = 307,
     CHANGED = 308,
     CHARSET = 309,
     CHAR_SYM = 310,
     CHECKSUM_SYM = 311,
     CHECK_SYM = 312,
     CIPHER_SYM = 313,
     CLIENT_SYM = 314,
     CLOSE_SYM = 315,
     COALESCE = 316,
     CODE_SYM = 317,
     COLLATE_SYM = 318,
     COLLATION_SYM = 319,
     COLUMNS = 320,
     COLUMN_SYM = 321,
     COMMENT_SYM = 322,
     COMMITTED_SYM = 323,
     COMMIT_SYM = 324,
     COMPACT_SYM = 325,
     COMPRESSED_SYM = 326,
     CONCAT = 327,
     CONCAT_WS = 328,
     CONCURRENT = 329,
     CONDITION_SYM = 330,
     CONNECTION_SYM = 331,
     CONSISTENT_SYM = 332,
     CONSTRAINT = 333,
     CONTAINS_SYM = 334,
     CONTINUE_SYM = 335,
     CONVERT_SYM = 336,
     CONVERT_TZ_SYM = 337,
     COUNT_SYM = 338,
     CREATE = 339,
     CROSS = 340,
     CUBE_SYM = 341,
     CURDATE = 342,
     CURRENT_USER = 343,
     CURSOR_SYM = 344,
     CURTIME = 345,
     DATABASE = 346,
     DATABASES = 347,
     DATA_SYM = 348,
     DATETIME = 349,
     DATE_ADD_INTERVAL = 350,
     DATE_SUB_INTERVAL = 351,
     DATE_SYM = 352,
     DAY_HOUR_SYM = 353,
     DAY_MICROSECOND_SYM = 354,
     DAY_MINUTE_SYM = 355,
     DAY_SECOND_SYM = 356,
     DAY_SYM = 357,
     DEALLOCATE_SYM = 358,
     DECIMAL_NUM = 359,
     DECIMAL_SYM = 360,
     DECLARE_SYM = 361,
     DECODE_SYM = 362,
     DEFAULT = 363,
     DEFINER_SYM = 364,
     DELAYED_SYM = 365,
     DELAY_KEY_WRITE_SYM = 366,
     DELETE_SYM = 367,
     DESC = 368,
     DESCRIBE = 369,
     DES_DECRYPT_SYM = 370,
     DES_ENCRYPT_SYM = 371,
     DES_KEY_FILE = 372,
     DETERMINISTIC_SYM = 373,
     DIRECTORY_SYM = 374,
     DISABLE_SYM = 375,
     DISCARD = 376,
     DISTINCT = 377,
     DIV_SYM = 378,
     DOUBLE_SYM = 379,
     DO_SYM = 380,
     DROP = 381,
     DUAL_SYM = 382,
     DUMPFILE = 383,
     DUPLICATE_SYM = 384,
     DYNAMIC_SYM = 385,
     EACH_SYM = 386,
     ELSEIF_SYM = 387,
     ELT_FUNC = 388,
     ENABLE_SYM = 389,
     ENCLOSED = 390,
     ENCODE_SYM = 391,
     ENCRYPT = 392,
     END = 393,
     ENGINES_SYM = 394,
     ENGINE_SYM = 395,
     ENUM = 396,
     EQ = 397,
     EQUAL_SYM = 398,
     ERRORS = 399,
     ESCAPED = 400,
     ESCAPE_SYM = 401,
     EVENTS_SYM = 402,
     EXECUTE_SYM = 403,
     EXISTS = 404,
     EXIT_SYM = 405,
     EXPANSION_SYM = 406,
     EXPORT_SET = 407,
     EXTENDED_SYM = 408,
     EXTRACT_SYM = 409,
     FALSE_SYM = 410,
     FAST_SYM = 411,
     FETCH_SYM = 412,
     FIELD_FUNC = 413,
     FILE_SYM = 414,
     FIRST_SYM = 415,
     FIXED_SYM = 416,
     FLOAT_NUM = 417,
     FLOAT_SYM = 418,
     FLUSH_SYM = 419,
     FORCE_SYM = 420,
     FOREIGN = 421,
     FORMAT_SYM = 422,
     FOR_SYM = 423,
     FOUND_SYM = 424,
     FRAC_SECOND_SYM = 425,
     FROM = 426,
     FROM_UNIXTIME = 427,
     FULL = 428,
     FULLTEXT_SYM = 429,
     FUNCTION_SYM = 430,
     FUNC_ARG0 = 431,
     FUNC_ARG1 = 432,
     FUNC_ARG2 = 433,
     FUNC_ARG3 = 434,
     GE = 435,
     GEOMCOLLFROMTEXT = 436,
     GEOMETRYCOLLECTION = 437,
     GEOMETRY_SYM = 438,
     GEOMFROMTEXT = 439,
     GEOMFROMWKB = 440,
     GET_FORMAT = 441,
     GLOBAL_SYM = 442,
     GRANT = 443,
     GRANTS = 444,
     GREATEST_SYM = 445,
     GROUP = 446,
     GROUP_CONCAT_SYM = 447,
     GROUP_UNIQUE_USERS = 448,
     GT_SYM = 449,
     HANDLER_SYM = 450,
     HASH_SYM = 451,
     HAVING = 452,
     HELP_SYM = 453,
     HEX_NUM = 454,
     HIGH_PRIORITY = 455,
     HOSTS_SYM = 456,
     HOUR_MICROSECOND_SYM = 457,
     HOUR_MINUTE_SYM = 458,
     HOUR_SECOND_SYM = 459,
     HOUR_SYM = 460,
     IDENT = 461,
     IDENTIFIED_SYM = 462,
     IDENT_QUOTED = 463,
     IF = 464,
     IGNORE_SYM = 465,
     IMPORT = 466,
     INDEXES = 467,
     INDEX_SYM = 468,
     INFILE = 469,
     INNER_SYM = 470,
     INNOBASE_SYM = 471,
     INOUT_SYM = 472,
     INSENSITIVE_SYM = 473,
     INSERT = 474,
     INSERT_METHOD = 475,
     INTERVAL_SYM = 476,
     INTO = 477,
     INT_SYM = 478,
     INVOKER_SYM = 479,
     IN_SYM = 480,
     IS = 481,
     ISOLATION = 482,
     ISSUER_SYM = 483,
     ITERATE_SYM = 484,
     JOIN_SYM = 485,
     KEYS = 486,
     KEY_SYM = 487,
     KILL_SYM = 488,
     LABEL_SYM = 489,
     LANGUAGE_SYM = 490,
     LAST_INSERT_ID = 491,
     LAST_SYM = 492,
     LE = 493,
     LEADING = 494,
     LEAST_SYM = 495,
     LEAVES = 496,
     LEAVE_SYM = 497,
     LEFT = 498,
     LEVEL_SYM = 499,
     LEX_HOSTNAME = 500,
     LIKE = 501,
     LIMIT = 502,
     LINEFROMTEXT = 503,
     LINES = 504,
     LINESTRING = 505,
     LOAD = 506,
     LOCAL_SYM = 507,
     LOCATE = 508,
     LOCATOR_SYM = 509,
     LOCKS_SYM = 510,
     LOCK_SYM = 511,
     LOGS_SYM = 512,
     LOG_SYM = 513,
     LONGBLOB = 514,
     LONGTEXT = 515,
     LONG_NUM = 516,
     LONG_SYM = 517,
     LOOP_SYM = 518,
     LOW_PRIORITY = 519,
     LT = 520,
     MAKE_SET_SYM = 521,
     MASTER_CONNECT_RETRY_SYM = 522,
     MASTER_HOST_SYM = 523,
     MASTER_LOG_FILE_SYM = 524,
     MASTER_LOG_POS_SYM = 525,
     MASTER_PASSWORD_SYM = 526,
     MASTER_PORT_SYM = 527,
     MASTER_POS_WAIT = 528,
     MASTER_SERVER_ID_SYM = 529,
     MASTER_SSL_CAPATH_SYM = 530,
     MASTER_SSL_CA_SYM = 531,
     MASTER_SSL_CERT_SYM = 532,
     MASTER_SSL_CIPHER_SYM = 533,
     MASTER_SSL_KEY_SYM = 534,
     MASTER_SSL_SYM = 535,
     MASTER_SYM = 536,
     MASTER_USER_SYM = 537,
     MATCH = 538,
     MAX_CONNECTIONS_PER_HOUR = 539,
     MAX_QUERIES_PER_HOUR = 540,
     MAX_ROWS = 541,
     MAX_SYM = 542,
     MAX_UPDATES_PER_HOUR = 543,
     MAX_USER_CONNECTIONS_SYM = 544,
     MEDIUMBLOB = 545,
     MEDIUMINT = 546,
     MEDIUMTEXT = 547,
     MEDIUM_SYM = 548,
     MERGE_SYM = 549,
     MICROSECOND_SYM = 550,
     MIGRATE_SYM = 551,
     MINUTE_MICROSECOND_SYM = 552,
     MINUTE_SECOND_SYM = 553,
     MINUTE_SYM = 554,
     MIN_ROWS = 555,
     MIN_SYM = 556,
     MLINEFROMTEXT = 557,
     MODE_SYM = 558,
     MODIFIES_SYM = 559,
     MODIFY_SYM = 560,
     MOD_SYM = 561,
     MONTH_SYM = 562,
     MPOINTFROMTEXT = 563,
     MPOLYFROMTEXT = 564,
     MULTILINESTRING = 565,
     MULTIPOINT = 566,
     MULTIPOLYGON = 567,
     MUTEX_SYM = 568,
     NAMES_SYM = 569,
     NAME_SYM = 570,
     NATIONAL_SYM = 571,
     NATURAL = 572,
     NCHAR_STRING = 573,
     NCHAR_SYM = 574,
     NDBCLUSTER_SYM = 575,
     NE = 576,
     NEW_SYM = 577,
     NEXT_SYM = 578,
     NONE_SYM = 579,
     NOT2_SYM = 580,
     NOT_SYM = 581,
     NOW_SYM = 582,
     NO_SYM = 583,
     NO_WRITE_TO_BINLOG = 584,
     NULL_SYM = 585,
     NUM = 586,
     NUMERIC_SYM = 587,
     NVARCHAR_SYM = 588,
     OFFSET_SYM = 589,
     OJ_SYM = 590,
     OLD_PASSWORD = 591,
     ON = 592,
     ONE_SHOT_SYM = 593,
     ONE_SYM = 594,
     OPEN_SYM = 595,
     OPTIMIZE = 596,
     OPTION = 597,
     OPTIONALLY = 598,
     OR2_SYM = 599,
     ORDER_SYM = 600,
     OR_OR_SYM = 601,
     OR_SYM = 602,
     OUTER = 603,
     OUTFILE = 604,
     OUT_SYM = 605,
     PACK_KEYS_SYM = 606,
     PARTIAL = 607,
     PASSWORD = 608,
     PARAM_MARKER = 609,
     PHASE_SYM = 610,
     POINTFROMTEXT = 611,
     POINT_SYM = 612,
     POLYFROMTEXT = 613,
     POLYGON = 614,
     POSITION_SYM = 615,
     PRECISION = 616,
     PREPARE_SYM = 617,
     PREV_SYM = 618,
     PRIMARY_SYM = 619,
     PRIVILEGES = 620,
     PROCEDURE = 621,
     PROCESS = 622,
     PROCESSLIST_SYM = 623,
     PURGE = 624,
     QUARTER_SYM = 625,
     QUERY_SYM = 626,
     QUICK = 627,
     RAID_0_SYM = 628,
     RAID_CHUNKS = 629,
     RAID_CHUNKSIZE = 630,
     RAID_STRIPED_SYM = 631,
     RAID_TYPE = 632,
     RAND = 633,
     READS_SYM = 634,
     READ_SYM = 635,
     REAL = 636,
     RECOVER_SYM = 637,
     REDUNDANT_SYM = 638,
     REFERENCES = 639,
     REGEXP = 640,
     RELAY_LOG_FILE_SYM = 641,
     RELAY_LOG_POS_SYM = 642,
     RELAY_THREAD = 643,
     RELEASE_SYM = 644,
     RELOAD = 645,
     RENAME = 646,
     REPAIR = 647,
     REPEATABLE_SYM = 648,
     REPEAT_SYM = 649,
     REPLACE = 650,
     REPLICATION = 651,
     REQUIRE_SYM = 652,
     RESET_SYM = 653,
     RESOURCES = 654,
     RESTORE_SYM = 655,
     RESTRICT = 656,
     RESUME_SYM = 657,
     RETURNS_SYM = 658,
     RETURN_SYM = 659,
     REVOKE = 660,
     RIGHT = 661,
     ROLLBACK_SYM = 662,
     ROLLUP_SYM = 663,
     ROUND = 664,
     ROUTINE_SYM = 665,
     ROWS_SYM = 666,
     ROW_COUNT_SYM = 667,
     ROW_FORMAT_SYM = 668,
     ROW_SYM = 669,
     RTREE_SYM = 670,
     SAVEPOINT_SYM = 671,
     SECOND_MICROSECOND_SYM = 672,
     SECOND_SYM = 673,
     SECURITY_SYM = 674,
     SELECT_SYM = 675,
     SENSITIVE_SYM = 676,
     SEPARATOR_SYM = 677,
     SERIALIZABLE_SYM = 678,
     SERIAL_SYM = 679,
     SESSION_SYM = 680,
     SET = 681,
     SET_VAR = 682,
     SHARE_SYM = 683,
     SHIFT_LEFT = 684,
     SHIFT_RIGHT = 685,
     SHOW = 686,
     SHUTDOWN = 687,
     SIGNED_SYM = 688,
     SIMPLE_SYM = 689,
     SLAVE = 690,
     SMALLINT = 691,
     SNAPSHOT_SYM = 692,
     SOUNDS_SYM = 693,
     SPATIAL_SYM = 694,
     SPECIFIC_SYM = 695,
     SQLEXCEPTION_SYM = 696,
     SQLSTATE_SYM = 697,
     SQLWARNING_SYM = 698,
     SQL_BIG_RESULT = 699,
     SQL_BUFFER_RESULT = 700,
     SQL_CACHE_SYM = 701,
     SQL_CALC_FOUND_ROWS = 702,
     SQL_NO_CACHE_SYM = 703,
     SQL_SMALL_RESULT = 704,
     SQL_SYM = 705,
     SQL_THREAD = 706,
     SSL_SYM = 707,
     STARTING = 708,
     START_SYM = 709,
     STATUS_SYM = 710,
     STD_SYM = 711,
     STDDEV_SAMP_SYM = 712,
     STOP_SYM = 713,
     STORAGE_SYM = 714,
     STRAIGHT_JOIN = 715,
     STRING_SYM = 716,
     SUBDATE_SYM = 717,
     SUBJECT_SYM = 718,
     SUBSTRING = 719,
     SUBSTRING_INDEX = 720,
     SUM_SYM = 721,
     SUPER_SYM = 722,
     SUSPEND_SYM = 723,
     SYSDATE = 724,
     TABLES = 725,
     TABLESPACE = 726,
     TABLE_SYM = 727,
     TEMPORARY = 728,
     TEMPTABLE_SYM = 729,
     TERMINATED = 730,
     TEXT_STRING = 731,
     TEXT_SYM = 732,
     TIMESTAMP = 733,
     TIMESTAMP_ADD = 734,
     TIMESTAMP_DIFF = 735,
     TIME_SYM = 736,
     TINYBLOB = 737,
     TINYINT = 738,
     TINYTEXT = 739,
     TO_SYM = 740,
     TRAILING = 741,
     TRANSACTION_SYM = 742,
     TRIGGER_SYM = 743,
     TRIGGERS_SYM = 744,
     TRIM = 745,
     TRUE_SYM = 746,
     TRUNCATE_SYM = 747,
     TYPES_SYM = 748,
     TYPE_SYM = 749,
     UDF_RETURNS_SYM = 750,
     UDF_SONAME_SYM = 751,
     ULONGLONG_NUM = 752,
     UNCOMMITTED_SYM = 753,
     UNDEFINED_SYM = 754,
     UNDERSCORE_CHARSET = 755,
     UNDO_SYM = 756,
     UNICODE_SYM = 757,
     UNION_SYM = 758,
     UNIQUE_SYM = 759,
     UNIQUE_USERS = 760,
     UNIX_TIMESTAMP = 761,
     UNKNOWN_SYM = 762,
     UNLOCK_SYM = 763,
     UNSIGNED = 764,
     UNTIL_SYM = 765,
     UPDATE_SYM = 766,
     UPGRADE_SYM = 767,
     USAGE = 768,
     USER = 769,
     USE_FRM = 770,
     USE_SYM = 771,
     USING = 772,
     UTC_DATE_SYM = 773,
     UTC_TIMESTAMP_SYM = 774,
     UTC_TIME_SYM = 775,
     VAR_SAMP_SYM = 776,
     VALUES = 777,
     VALUE_SYM = 778,
     VARBINARY = 779,
     VARCHAR = 780,
     VARIABLES = 781,
     VARIANCE_SYM = 782,
     VARYING = 783,
     VIEW_SYM = 784,
     WARNINGS = 785,
     WEEK_SYM = 786,
     WHEN_SYM = 787,
     WHERE = 788,
     WHILE_SYM = 789,
     WITH = 790,
     WORK_SYM = 791,
     WRITE_SYM = 792,
     X509_SYM = 793,
     XA_SYM = 794,
     XOR = 795,
     YEARWEEK = 796,
     YEAR_MONTH_SYM = 797,
     YEAR_SYM = 798,
     ZEROFILL = 799,
     TABLE_REF_PRIORITY = 800,
     ELSE = 801,
     THEN_SYM = 802,
     CASE_SYM = 803,
     BETWEEN_SYM = 804,
     NEG = 805
   };
#endif
/* Tokens.  */
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BOOLEAN_SYM 295
#define BOOL_SYM 296
#define BOTH 297
#define BTREE_SYM 298
#define BY 299
#define BYTE_SYM 300
#define CACHE_SYM 301
#define CALL_SYM 302
#define CASCADE 303
#define CASCADED 304
#define CAST_SYM 305
#define CHAIN_SYM 306
#define CHANGE 307
#define CHANGED 308
#define CHARSET 309
#define CHAR_SYM 310
#define CHECKSUM_SYM 311
#define CHECK_SYM 312
#define CIPHER_SYM 313
#define CLIENT_SYM 314
#define CLOSE_SYM 315
#define COALESCE 316
#define CODE_SYM 317
#define COLLATE_SYM 318
#define COLLATION_SYM 319
#define COLUMNS 320
#define COLUMN_SYM 321
#define COMMENT_SYM 322
#define COMMITTED_SYM 323
#define COMMIT_SYM 324
#define COMPACT_SYM 325
#define COMPRESSED_SYM 326
#define CONCAT 327
#define CONCAT_WS 328
#define CONCURRENT 329
#define CONDITION_SYM 330
#define CONNECTION_SYM 331
#define CONSISTENT_SYM 332
#define CONSTRAINT 333
#define CONTAINS_SYM 334
#define CONTINUE_SYM 335
#define CONVERT_SYM 336
#define CONVERT_TZ_SYM 337
#define COUNT_SYM 338
#define CREATE 339
#define CROSS 340
#define CUBE_SYM 341
#define CURDATE 342
#define CURRENT_USER 343
#define CURSOR_SYM 344
#define CURTIME 345
#define DATABASE 346
#define DATABASES 347
#define DATA_SYM 348
#define DATETIME 349
#define DATE_ADD_INTERVAL 350
#define DATE_SUB_INTERVAL 351
#define DATE_SYM 352
#define DAY_HOUR_SYM 353
#define DAY_MICROSECOND_SYM 354
#define DAY_MINUTE_SYM 355
#define DAY_SECOND_SYM 356
#define DAY_SYM 357
#define DEALLOCATE_SYM 358
#define DECIMAL_NUM 359
#define DECIMAL_SYM 360
#define DECLARE_SYM 361
#define DECODE_SYM 362
#define DEFAULT 363
#define DEFINER_SYM 364
#define DELAYED_SYM 365
#define DELAY_KEY_WRITE_SYM 366
#define DELETE_SYM 367
#define DESC 368
#define DESCRIBE 369
#define DES_DECRYPT_SYM 370
#define DES_ENCRYPT_SYM 371
#define DES_KEY_FILE 372
#define DETERMINISTIC_SYM 373
#define DIRECTORY_SYM 374
#define DISABLE_SYM 375
#define DISCARD 376
#define DISTINCT 377
#define DIV_SYM 378
#define DOUBLE_SYM 379
#define DO_SYM 380
#define DROP 381
#define DUAL_SYM 382
#define DUMPFILE 383
#define DUPLICATE_SYM 384
#define DYNAMIC_SYM 385
#define EACH_SYM 386
#define ELSEIF_SYM 387
#define ELT_FUNC 388
#define ENABLE_SYM 389
#define ENCLOSED 390
#define ENCODE_SYM 391
#define ENCRYPT 392
#define END 393
#define ENGINES_SYM 394
#define ENGINE_SYM 395
#define ENUM 396
#define EQ 397
#define EQUAL_SYM 398
#define ERRORS 399
#define ESCAPED 400
#define ESCAPE_SYM 401
#define EVENTS_SYM 402
#define EXECUTE_SYM 403
#define EXISTS 404
#define EXIT_SYM 405
#define EXPANSION_SYM 406
#define EXPORT_SET 407
#define EXTENDED_SYM 408
#define EXTRACT_SYM 409
#define FALSE_SYM 410
#define FAST_SYM 411
#define FETCH_SYM 412
#define FIELD_FUNC 413
#define FILE_SYM 414
#define FIRST_SYM 415
#define FIXED_SYM 416
#define FLOAT_NUM 417
#define FLOAT_SYM 418
#define FLUSH_SYM 419
#define FORCE_SYM 420
#define FOREIGN 421
#define FORMAT_SYM 422
#define FOR_SYM 423
#define FOUND_SYM 424
#define FRAC_SECOND_SYM 425
#define FROM 426
#define FROM_UNIXTIME 427
#define FULL 428
#define FULLTEXT_SYM 429
#define FUNCTION_SYM 430
#define FUNC_ARG0 431
#define FUNC_ARG1 432
#define FUNC_ARG2 433
#define FUNC_ARG3 434
#define GE 435
#define GEOMCOLLFROMTEXT 436
#define GEOMETRYCOLLECTION 437
#define GEOMETRY_SYM 438
#define GEOMFROMTEXT 439
#define GEOMFROMWKB 440
#define GET_FORMAT 441
#define GLOBAL_SYM 442
#define GRANT 443
#define GRANTS 444
#define GREATEST_SYM 445
#define GROUP 446
#define GROUP_CONCAT_SYM 447
#define GROUP_UNIQUE_USERS 448
#define GT_SYM 449
#define HANDLER_SYM 450
#define HASH_SYM 451
#define HAVING 452
#define HELP_SYM 453
#define HEX_NUM 454
#define HIGH_PRIORITY 455
#define HOSTS_SYM 456
#define HOUR_MICROSECOND_SYM 457
#define HOUR_MINUTE_SYM 458
#define HOUR_SECOND_SYM 459
#define HOUR_SYM 460
#define IDENT 461
#define IDENTIFIED_SYM 462
#define IDENT_QUOTED 463
#define IF 464
#define IGNORE_SYM 465
#define IMPORT 466
#define INDEXES 467
#define INDEX_SYM 468
#define INFILE 469
#define INNER_SYM 470
#define INNOBASE_SYM 471
#define INOUT_SYM 472
#define INSENSITIVE_SYM 473
#define INSERT 474
#define INSERT_METHOD 475
#define INTERVAL_SYM 476
#define INTO 477
#define INT_SYM 478
#define INVOKER_SYM 479
#define IN_SYM 480
#define IS 481
#define ISOLATION 482
#define ISSUER_SYM 483
#define ITERATE_SYM 484
#define JOIN_SYM 485
#define KEYS 486
#define KEY_SYM 487
#define KILL_SYM 488
#define LABEL_SYM 489
#define LANGUAGE_SYM 490
#define LAST_INSERT_ID 491
#define LAST_SYM 492
#define LE 493
#define LEADING 494
#define LEAST_SYM 495
#define LEAVES 496
#define LEAVE_SYM 497
#define LEFT 498
#define LEVEL_SYM 499
#define LEX_HOSTNAME 500
#define LIKE 501
#define LIMIT 502
#define LINEFROMTEXT 503
#define LINES 504
#define LINESTRING 505
#define LOAD 506
#define LOCAL_SYM 507
#define LOCATE 508
#define LOCATOR_SYM 509
#define LOCKS_SYM 510
#define LOCK_SYM 511
#define LOGS_SYM 512
#define LOG_SYM 513
#define LONGBLOB 514
#define LONGTEXT 515
#define LONG_NUM 516
#define LONG_SYM 517
#define LOOP_SYM 518
#define LOW_PRIORITY 519
#define LT 520
#define MAKE_SET_SYM 521
#define MASTER_CONNECT_RETRY_SYM 522
#define MASTER_HOST_SYM 523
#define MASTER_LOG_FILE_SYM 524
#define MASTER_LOG_POS_SYM 525
#define MASTER_PASSWORD_SYM 526
#define MASTER_PORT_SYM 527
#define MASTER_POS_WAIT 528
#define MASTER_SERVER_ID_SYM 529
#define MASTER_SSL_CAPATH_SYM 530
#define MASTER_SSL_CA_SYM 531
#define MASTER_SSL_CERT_SYM 532
#define MASTER_SSL_CIPHER_SYM 533
#define MASTER_SSL_KEY_SYM 534
#define MASTER_SSL_SYM 535
#define MASTER_SYM 536
#define MASTER_USER_SYM 537
#define MATCH 538
#define MAX_CONNECTIONS_PER_HOUR 539
#define MAX_QUERIES_PER_HOUR 540
#define MAX_ROWS 541
#define MAX_SYM 542
#define MAX_UPDATES_PER_HOUR 543
#define MAX_USER_CONNECTIONS_SYM 544
#define MEDIUMBLOB 545
#define MEDIUMINT 546
#define MEDIUMTEXT 547
#define MEDIUM_SYM 548
#define MERGE_SYM 549
#define MICROSECOND_SYM 550
#define MIGRATE_SYM 551
#define MINUTE_MICROSECOND_SYM 552
#define MINUTE_SECOND_SYM 553
#define MINUTE_SYM 554
#define MIN_ROWS 555
#define MIN_SYM 556
#define MLINEFROMTEXT 557
#define MODE_SYM 558
#define MODIFIES_SYM 559
#define MODIFY_SYM 560
#define MOD_SYM 561
#define MONTH_SYM 562
#define MPOINTFROMTEXT 563
#define MPOLYFROMTEXT 564
#define MULTILINESTRING 565
#define MULTIPOINT 566
#define MULTIPOLYGON 567
#define MUTEX_SYM 568
#define NAMES_SYM 569
#define NAME_SYM 570
#define NATIONAL_SYM 571
#define NATURAL 572
#define NCHAR_STRING 573
#define NCHAR_SYM 574
#define NDBCLUSTER_SYM 575
#define NE 576
#define NEW_SYM 577
#define NEXT_SYM 578
#define NONE_SYM 579
#define NOT2_SYM 580
#define NOT_SYM 581
#define NOW_SYM 582
#define NO_SYM 583
#define NO_WRITE_TO_BINLOG 584
#define NULL_SYM 585
#define NUM 586
#define NUMERIC_SYM 587
#define NVARCHAR_SYM 588
#define OFFSET_SYM 589
#define OJ_SYM 590
#define OLD_PASSWORD 591
#define ON 592
#define ONE_SHOT_SYM 593
#define ONE_SYM 594
#define OPEN_SYM 595
#define OPTIMIZE 596
#define OPTION 597
#define OPTIONALLY 598
#define OR2_SYM 599
#define ORDER_SYM 600
#define OR_OR_SYM 601
#define OR_SYM 602
#define OUTER 603
#define OUTFILE 604
#define OUT_SYM 605
#define PACK_KEYS_SYM 606
#define PARTIAL 607
#define PASSWORD 608
#define PARAM_MARKER 609
#define PHASE_SYM 610
#define POINTFROMTEXT 611
#define POINT_SYM 612
#define POLYFROMTEXT 613
#define POLYGON 614
#define POSITION_SYM 615
#define PRECISION 616
#define PREPARE_SYM 617
#define PREV_SYM 618
#define PRIMARY_SYM 619
#define PRIVILEGES 620
#define PROCEDURE 621
#define PROCESS 622
#define PROCESSLIST_SYM 623
#define PURGE 624
#define QUARTER_SYM 625
#define QUERY_SYM 626
#define QUICK 627
#define RAID_0_SYM 628
#define RAID_CHUNKS 629
#define RAID_CHUNKSIZE 630
#define RAID_STRIPED_SYM 631
#define RAID_TYPE 632
#define RAND 633
#define READS_SYM 634
#define READ_SYM 635
#define REAL 636
#define RECOVER_SYM 637
#define REDUNDANT_SYM 638
#define REFERENCES 639
#define REGEXP 640
#define RELAY_LOG_FILE_SYM 641
#define RELAY_LOG_POS_SYM 642
#define RELAY_THREAD 643
#define RELEASE_SYM 644
#define RELOAD 645
#define RENAME 646
#define REPAIR 647
#define REPEATABLE_SYM 648
#define REPEAT_SYM 649
#define REPLACE 650
#define REPLICATION 651
#define REQUIRE_SYM 652
#define RESET_SYM 653
#define RESOURCES 654
#define RESTORE_SYM 655
#define RESTRICT 656
#define RESUME_SYM 657
#define RETURNS_SYM 658
#define RETURN_SYM 659
#define REVOKE 660
#define RIGHT 661
#define ROLLBACK_SYM 662
#define ROLLUP_SYM 663
#define ROUND 664
#define ROUTINE_SYM 665
#define ROWS_SYM 666
#define ROW_COUNT_SYM 667
#define ROW_FORMAT_SYM 668
#define ROW_SYM 669
#define RTREE_SYM 670
#define SAVEPOINT_SYM 671
#define SECOND_MICROSECOND_SYM 672
#define SECOND_SYM 673
#define SECURITY_SYM 674
#define SELECT_SYM 675
#define SENSITIVE_SYM 676
#define SEPARATOR_SYM 677
#define SERIALIZABLE_SYM 678
#define SERIAL_SYM 679
#define SESSION_SYM 680
#define SET 681
#define SET_VAR 682
#define SHARE_SYM 683
#define SHIFT_LEFT 684
#define SHIFT_RIGHT 685
#define SHOW 686
#define SHUTDOWN 687
#define SIGNED_SYM 688
#define SIMPLE_SYM 689
#define SLAVE 690
#define SMALLINT 691
#define SNAPSHOT_SYM 692
#define SOUNDS_SYM 693
#define SPATIAL_SYM 694
#define SPECIFIC_SYM 695
#define SQLEXCEPTION_SYM 696
#define SQLSTATE_SYM 697
#define SQLWARNING_SYM 698
#define SQL_BIG_RESULT 699
#define SQL_BUFFER_RESULT 700
#define SQL_CACHE_SYM 701
#define SQL_CALC_FOUND_ROWS 702
#define SQL_NO_CACHE_SYM 703
#define SQL_SMALL_RESULT 704
#define SQL_SYM 705
#define SQL_THREAD 706
#define SSL_SYM 707
#define STARTING 708
#define START_SYM 709
#define STATUS_SYM 710
#define STD_SYM 711
#define STDDEV_SAMP_SYM 712
#define STOP_SYM 713
#define STORAGE_SYM 714
#define STRAIGHT_JOIN 715
#define STRING_SYM 716
#define SUBDATE_SYM 717
#define SUBJECT_SYM 718
#define SUBSTRING 719
#define SUBSTRING_INDEX 720
#define SUM_SYM 721
#define SUPER_SYM 722
#define SUSPEND_SYM 723
#define SYSDATE 724
#define TABLES 725
#define TABLESPACE 726
#define TABLE_SYM 727
#define TEMPORARY 728
#define TEMPTABLE_SYM 729
#define TERMINATED 730
#define TEXT_STRING 731
#define TEXT_SYM 732
#define TIMESTAMP 733
#define TIMESTAMP_ADD 734
#define TIMESTAMP_DIFF 735
#define TIME_SYM 736
#define TINYBLOB 737
#define TINYINT 738
#define TINYTEXT 739
#define TO_SYM 740
#define TRAILING 741
#define TRANSACTION_SYM 742
#define TRIGGER_SYM 743
#define TRIGGERS_SYM 744
#define TRIM 745
#define TRUE_SYM 746
#define TRUNCATE_SYM 747
#define TYPES_SYM 748
#define TYPE_SYM 749
#define UDF_RETURNS_SYM 750
#define UDF_SONAME_SYM 751
#define ULONGLONG_NUM 752
#define UNCOMMITTED_SYM 753
#define UNDEFINED_SYM 754
#define UNDERSCORE_CHARSET 755
#define UNDO_SYM 756
#define UNICODE_SYM 757
#define UNION_SYM 758
#define UNIQUE_SYM 759
#define UNIQUE_USERS 760
#define UNIX_TIMESTAMP 761
#define UNKNOWN_SYM 762
#define UNLOCK_SYM 763
#define UNSIGNED 764
#define UNTIL_SYM 765
#define UPDATE_SYM 766
#define UPGRADE_SYM 767
#define USAGE 768
#define USER 769
#define USE_FRM 770
#define USE_SYM 771
#define USING 772
#define UTC_DATE_SYM 773
#define UTC_TIMESTAMP_SYM 774
#define UTC_TIME_SYM 775
#define VAR_SAMP_SYM 776
#define VALUES 777
#define VALUE_SYM 778
#define VARBINARY 779
#define VARCHAR 780
#define VARIABLES 781
#define VARIANCE_SYM 782
#define VARYING 783
#define VIEW_SYM 784
#define WARNINGS 785
#define WEEK_SYM 786
#define WHEN_SYM 787
#define WHERE 788
#define WHILE_SYM 789
#define WITH 790
#define WORK_SYM 791
#define WRITE_SYM 792
#define X509_SYM 793
#define XA_SYM 794
#define XOR 795
#define YEARWEEK 796
#define YEAR_MONTH_SYM 797
#define YEAR_SYM 798
#define ZEROFILL 799
#define TABLE_REF_PRIORITY 800
#define ELSE 801
#define THEN_SYM 802
#define CASE_SYM 803
#define BETWEEN_SYM 804
#define NEG 805




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= thd->m_lip;

  const char *yytext= lip->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
#line 415 "sql_yacc.yy"
{
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
}
/* Line 193 of yacc.c.  */
#line 1642 "sql_yacc.cc"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 455 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 216 of yacc.c.  */
#line 1658 "sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  459
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   43762

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  570
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  669
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2027
/* YYNRULES -- Number of states.  */
#define YYNSTATES  3686

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   805

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   563,     2,     2,     2,   556,   551,     2,
     560,   561,   554,   553,   562,   552,   567,   555,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   569,   568,
       2,     2,     2,     2,   566,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   557,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   564,   550,   565,   558,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   559
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   110,   112,   114,   119,   121,   124,
     125,   130,   131,   134,   138,   140,   143,   144,   148,   149,
     155,   157,   161,   165,   169,   173,   177,   181,   185,   189,
     193,   197,   201,   205,   207,   211,   215,   219,   223,   224,
     232,   233,   245,   246,   253,   254,   258,   263,   264,   268,
     270,   271,   274,   275,   278,   281,   284,   287,   290,   294,
     298,   300,   302,   304,   307,   311,   315,   316,   321,   322,
     326,   327,   329,   333,   335,   336,   338,   342,   344,   345,
     349,   350,   352,   356,   358,   363,   364,   366,   368,   370,
     371,   375,   378,   382,   383,   387,   388,   394,   400,   401,
     409,   415,   416,   419,   421,   423,   425,   429,   431,   433,
     437,   438,   440,   442,   444,   446,   449,   451,   453,   457,
     458,   461,   462,   465,   466,   470,   471,   477,   479,   481,
     482,   485,   487,   489,   492,   495,   498,   499,   506,   509,
     510,   513,   515,   517,   521,   522,   523,   524,   532,   533,
     536,   539,   541,   543,   544,   545,   554,   555,   562,   564,
     567,   569,   572,   573,   574,   581,   582,   583,   590,   591,
     594,   595,   601,   602,   604,   605,   611,   612,   615,   616,
     622,   627,   628,   629,   638,   639,   647,   649,   651,   653,
     655,   657,   660,   663,   666,   671,   676,   677,   682,   683,
     684,   690,   691,   699,   700,   701,   708,   709,   711,   712,
     714,   716,   719,   721,   723,   724,   726,   728,   731,   733,
     734,   738,   739,   741,   743,   746,   748,   751,   755,   759,
     763,   767,   771,   775,   779,   783,   787,   791,   795,   799,
     803,   807,   811,   815,   819,   825,   827,   829,   833,   838,
     843,   847,   852,   857,   859,   861,   863,   865,   867,   869,
     871,   873,   875,   877,   879,   881,   883,   885,   888,   890,
     892,   894,   896,   898,   902,   904,   906,   909,   912,   920,
     929,   938,   941,   944,   945,   947,   950,   951,   953,   956,
     957,   962,   966,   970,   974,   976,   981,   983,   985,   991,
     994,  1000,  1003,  1008,  1010,  1016,  1022,  1027,  1031,  1033,
    1035,  1038,  1040,  1042,  1045,  1047,  1049,  1051,  1054,  1058,
    1061,  1065,  1068,  1071,  1075,  1079,  1083,  1084,  1091,  1092,
    1099,  1102,  1104,  1106,  1108,  1110,  1112,  1114,  1116,  1118,
    1120,  1122,  1124,  1127,  1130,  1132,  1135,  1137,  1140,  1144,
    1147,  1149,  1151,  1153,  1155,  1157,  1159,  1161,  1164,  1165,
    1169,  1171,  1177,  1178,  1180,  1183,  1185,  1187,  1189,  1191,
    1192,  1196,  1197,  1199,  1200,  1202,  1205,  1207,  1209,  1212,
    1215,  1220,  1222,  1226,  1229,  1231,  1234,  1237,  1240,  1243,
    1245,  1248,  1250,  1252,  1254,  1256,  1258,  1259,  1262,  1264,
    1266,  1268,  1270,  1272,  1273,  1276,  1278,  1280,  1281,  1283,
    1284,  1287,  1289,  1292,  1296,  1299,  1300,  1302,  1303,  1305,
    1307,  1310,  1311,  1313,  1314,  1319,  1321,  1326,  1330,  1332,
    1333,  1335,  1338,  1340,  1344,  1348,  1351,  1354,  1357,  1359,
    1361,  1364,  1367,  1370,  1372,  1375,  1378,  1381,  1384,  1386,
    1388,  1389,  1391,  1393,  1395,  1397,  1398,  1400,  1402,  1404,
    1405,  1408,  1411,  1413,  1415,  1417,  1422,  1425,  1427,  1432,
    1433,  1435,  1436,  1439,  1441,  1445,  1446,  1453,  1454,  1460,
    1461,  1467,  1468,  1474,  1475,  1487,  1488,  1490,  1491,  1494,
    1497,  1499,  1503,  1506,  1510,  1513,  1518,  1519,  1526,  1527,
    1528,  1537,  1542,  1547,  1551,  1555,  1558,  1561,  1568,  1574,
    1578,  1584,  1586,  1588,  1590,  1591,  1593,  1594,  1596,  1597,
    1599,  1601,  1602,  1605,  1607,  1608,  1610,  1612,  1614,  1615,
    1621,  1625,  1626,  1632,  1636,  1640,  1641,  1645,  1646,  1649,
    1651,  1655,  1656,  1658,  1660,  1661,  1664,  1666,  1670,  1671,
    1678,  1679,  1686,  1687,  1693,  1694,  1696,  1698,  1699,  1706,
    1707,  1709,  1711,  1714,  1716,  1718,  1720,  1721,  1727,  1728,
    1734,  1735,  1737,  1739,  1742,  1744,  1746,  1748,  1750,  1752,
    1755,  1756,  1762,  1763,  1765,  1767,  1768,  1773,  1778,  1782,
    1788,  1790,  1794,  1798,  1804,  1806,  1810,  1813,  1815,  1817,
    1818,  1825,  1827,  1831,  1835,  1836,  1839,  1840,  1845,  1846,
    1849,  1851,  1854,  1859,  1862,  1866,  1867,  1871,  1872,  1873,
    1880,  1883,  1885,  1887,  1890,  1893,  1902,  1907,  1908,  1910,
    1913,  1915,  1917,  1919,  1921,  1923,  1925,  1927,  1929,  1931,
    1933,  1935,  1936,  1939,  1944,  1948,  1950,  1952,  1957,  1958,
    1959,  1961,  1963,  1964,  1967,  1970,  1972,  1974,  1975,  1978,
    1982,  1986,  1990,  1993,  1997,  2002,  2006,  2011,  2015,  2020,
    2022,  2026,  2031,  2035,  2039,  2046,  2048,  2054,  2061,  2067,
    2075,  2082,  2091,  2097,  2104,  2109,  2114,  2120,  2124,  2129,
    2131,  2135,  2139,  2143,  2147,  2151,  2155,  2160,  2165,  2169,
    2173,  2177,  2181,  2185,  2189,  2191,  2193,  2195,  2197,  2199,
    2201,  2203,  2205,  2207,  2209,  2211,  2213,  2215,  2217,  2219,
    2221,  2223,  2226,  2228,  2232,  2234,  2236,  2238,  2240,  2244,
    2247,  2250,  2253,  2256,  2260,  2264,  2270,  2277,  2282,  2287,
    2295,  2300,  2303,  2310,  2316,  2323,  2330,  2335,  2340,  2344,
    2349,  2356,  2365,  2372,  2381,  2388,  2393,  2400,  2405,  2412,
    2417,  2422,  2427,  2432,  2439,  2448,  2451,  2454,  2459,  2462,
    2470,  2478,  2482,  2487,  2492,  2499,  2506,  2511,  2518,  2525,
    2532,  2537,  2544,  2549,  2556,  2565,  2576,  2589,  2596,  2601,
    2608,  2615,  2617,  2624,  2629,  2638,  2649,  2654,  2656,  2660,
    2665,  2672,  2679,  2688,  2695,  2702,  2707,  2714,  2721,  2730,
    2735,  2740,  2747,  2752,  2755,  2760,  2765,  2770,  2777,  2782,
    2787,  2791,  2800,  2807,  2812,  2819,  2823,  2830,  2839,  2844,
    2853,  2860,  2869,  2876,  2885,  2888,  2893,  2898,  2903,  2910,
    2919,  2928,  2933,  2941,  2949,  2957,  2964,  2971,  2978,  2985,
    2992,  2999,  3000,  3006,  3017,  3021,  3026,  3030,  3033,  3036,
    3039,  3044,  3051,  3056,  3061,  3068,  3075,  3082,  3089,  3094,
    3101,  3106,  3113,  3118,  3123,  3128,  3133,  3140,  3145,  3152,
    3157,  3164,  3169,  3174,  3181,  3186,  3193,  3198,  3205,  3210,
    3215,  3222,  3227,  3234,  3235,  3239,  3243,  3244,  3246,  3247,
    3250,  3252,  3256,  3261,  3266,  3272,  3277,  3282,  3287,  3293,
    3298,  3299,  3300,  3308,  3319,  3324,  3330,  3335,  3341,  3346,
    3351,  3356,  3361,  3366,  3372,  3373,  3382,  3383,  3387,  3391,
    3393,  3398,  3399,  3401,  3402,  3405,  3406,  3408,  3409,  3413,
    3416,  3420,  3423,  3425,  3428,  3430,  3433,  3435,  3437,  3439,
    3442,  3443,  3445,  3446,  3449,  3451,  3455,  3457,  3461,  3462,
    3465,  3467,  3471,  3472,  3474,  3475,  3478,  3483,  3489,  3491,
    3493,  3495,  3497,  3501,  3505,  3509,  3510,  3517,  3518,  3525,
    3526,  3535,  3540,  3541,  3550,  3551,  3562,  3569,  3570,  3579,
    3580,  3591,  3598,  3600,  3603,  3606,  3607,  3612,  3613,  3625,
    3629,  3636,  3637,  3641,  3642,  3643,  3649,  3650,  3652,  3653,
    3655,  3656,  3659,  3660,  3663,  3666,  3669,  3670,  3677,  3678,
    3680,  3684,  3686,  3688,  3690,  3694,  3696,  3698,  3700,  3702,
    3704,  3706,  3708,  3710,  3712,  3714,  3716,  3718,  3720,  3722,
    3724,  3726,  3728,  3730,  3732,  3734,  3736,  3738,  3740,  3742,
    3744,  3746,  3748,  3749,  3751,  3753,  3754,  3757,  3758,  3760,
    3761,  3762,  3766,  3767,  3768,  3772,  3775,  3776,  3777,  3782,
    3787,  3790,  3791,  3794,  3797,  3801,  3805,  3807,  3810,  3811,
    3813,  3814,  3819,  3824,  3827,  3828,  3830,  3832,  3833,  3835,
    3836,  3838,  3841,  3843,  3847,  3851,  3853,  3855,  3857,  3859,
    3860,  3863,  3865,  3867,  3869,  3871,  3873,  3875,  3877,  3879,
    3881,  3883,  3885,  3886,  3887,  3894,  3895,  3897,  3901,  3903,
    3906,  3907,  3910,  3914,  3916,  3919,  3921,  3922,  3926,  3927,
    3933,  3936,  3938,  3939,  3943,  3950,  3951,  3958,  3963,  3970,
    3975,  3980,  3985,  3991,  3996,  3998,  4002,  4004,  4005,  4008,
    4009,  4011,  4012,  4013,  4022,  4023,  4024,  4031,  4032,  4034,
    4036,  4038,  4040,  4042,  4045,  4047,  4049,  4051,  4055,  4060,
    4061,  4065,  4069,  4071,  4074,  4077,  4078,  4082,  4083,  4089,
    4093,  4095,  4099,  4101,  4105,  4107,  4109,  4110,  4112,  4113,
    4118,  4119,  4121,  4125,  4127,  4129,  4131,  4132,  4133,  4140,
    4141,  4142,  4154,  4158,  4160,  4164,  4168,  4170,  4174,  4175,
    4177,  4178,  4183,  4184,  4191,  4192,  4198,  4199,  4206,  4208,
    4212,  4216,  4222,  4223,  4226,  4227,  4230,  4232,  4234,  4236,
    4240,  4241,  4243,  4244,  4248,  4251,  4256,  4261,  4266,  4271,
    4272,  4277,  4284,  4301,  4304,  4307,  4308,  4315,  4321,  4324,
    4327,  4330,  4332,  4338,  4344,  4347,  4350,  4354,  4357,  4360,
    4363,  4367,  4370,  4373,  4376,  4378,  4380,  4384,  4389,  4393,
    4397,  4400,  4403,  4407,  4411,  4415,  4419,  4423,  4427,  4429,
    4431,  4433,  4435,  4436,  4438,  4439,  4442,  4443,  4445,  4447,
    4449,  4450,  4453,  4454,  4457,  4458,  4461,  4464,  4465,  4470,
    4471,  4476,  4478,  4480,  4481,  4483,  4484,  4486,  4488,  4489,
    4494,  4498,  4500,  4501,  4505,  4510,  4513,  4515,  4517,  4519,
    4521,  4523,  4525,  4527,  4529,  4530,  4532,  4533,  4537,  4541,
    4543,  4545,  4547,  4550,  4551,  4555,  4559,  4562,  4565,  4566,
    4571,  4572,  4574,  4576,  4579,  4580,  4585,  4591,  4592,  4593,
    4594,  4595,  4614,  4617,  4618,  4620,  4621,  4623,  4625,  4626,
    4628,  4630,  4631,  4634,  4637,  4639,  4643,  4648,  4652,  4656,
    4657,  4660,  4663,  4665,  4669,  4673,  4674,  4678,  4679,  4683,
    4686,  4690,  4692,  4694,  4697,  4698,  4701,  4703,  4705,  4708,
    4711,  4713,  4715,  4717,  4719,  4721,  4724,  4727,  4729,  4731,
    4733,  4735,  4737,  4739,  4741,  4744,  4747,  4750,  4753,  4756,
    4758,  4760,  4762,  4764,  4766,  4768,  4770,  4774,  4780,  4782,
    4784,  4786,  4788,  4790,  4794,  4799,  4805,  4807,  4813,  4817,
    4820,  4822,  4826,  4829,  4831,  4833,  4835,  4837,  4839,  4841,
    4843,  4845,  4847,  4849,  4851,  4853,  4855,  4857,  4861,  4864,
    4866,  4868,  4870,  4872,  4874,  4876,  4878,  4880,  4882,  4884,
    4886,  4888,  4890,  4892,  4894,  4896,  4898,  4900,  4902,  4904,
    4906,  4908,  4910,  4912,  4914,  4916,  4918,  4920,  4922,  4924,
    4926,  4928,  4930,  4932,  4934,  4936,  4938,  4940,  4942,  4944,
    4946,  4948,  4950,  4952,  4954,  4956,  4958,  4960,  4962,  4964,
    4966,  4968,  4970,  4972,  4974,  4976,  4978,  4980,  4982,  4984,
    4986,  4988,  4990,  4992,  4994,  4996,  4998,  5000,  5002,  5004,
    5006,  5008,  5010,  5012,  5014,  5016,  5018,  5020,  5022,  5024,
    5026,  5028,  5030,  5032,  5034,  5036,  5038,  5040,  5042,  5044,
    5046,  5048,  5050,  5052,  5054,  5056,  5058,  5060,  5062,  5064,
    5066,  5068,  5070,  5072,  5074,  5076,  5078,  5080,  5082,  5084,
    5086,  5088,  5090,  5092,  5094,  5096,  5098,  5100,  5102,  5104,
    5106,  5108,  5110,  5112,  5114,  5116,  5118,  5120,  5122,  5124,
    5126,  5128,  5130,  5132,  5134,  5136,  5138,  5140,  5142,  5144,
    5146,  5148,  5150,  5152,  5154,  5156,  5158,  5160,  5162,  5164,
    5166,  5168,  5170,  5172,  5174,  5176,  5178,  5180,  5182,  5184,
    5186,  5188,  5190,  5192,  5194,  5196,  5198,  5200,  5202,  5204,
    5206,  5208,  5210,  5212,  5214,  5216,  5218,  5220,  5222,  5224,
    5226,  5228,  5230,  5232,  5234,  5236,  5238,  5240,  5242,  5244,
    5246,  5248,  5250,  5252,  5254,  5256,  5258,  5260,  5262,  5264,
    5266,  5268,  5270,  5272,  5274,  5276,  5278,  5280,  5282,  5284,
    5286,  5288,  5290,  5292,  5294,  5296,  5298,  5300,  5302,  5304,
    5306,  5308,  5310,  5312,  5314,  5316,  5318,  5320,  5322,  5324,
    5326,  5328,  5330,  5332,  5334,  5336,  5338,  5340,  5342,  5344,
    5346,  5348,  5350,  5352,  5354,  5356,  5358,  5360,  5362,  5364,
    5365,  5370,  5371,  5373,  5375,  5379,  5380,  5383,  5385,  5387,
    5389,  5391,  5392,  5394,  5395,  5397,  5399,  5401,  5402,  5405,
    5408,  5411,  5413,  5416,  5421,  5427,  5432,  5439,  5442,  5446,
    5450,  5454,  5460,  5462,  5466,  5470,  5473,  5476,  5479,  5481,
    5483,  5488,  5493,  5495,  5497,  5499,  5501,  5503,  5504,  5509,
    5511,  5513,  5515,  5519,  5523,  5525,  5527,  5530,  5533,  5534,
    5538,  5543,  5547,  5548,  5556,  5558,  5561,  5563,  5565,  5567,
    5569,  5571,  5573,  5574,  5580,  5582,  5584,  5586,  5588,  5590,
    5594,  5601,  5608,  5615,  5623,  5627,  5636,  5645,  5654,  5655,
    5657,  5659,  5662,  5663,  5665,  5667,  5671,  5672,  5676,  5677,
    5681,  5682,  5686,  5687,  5691,  5693,  5695,  5697,  5699,  5701,
    5703,  5705,  5707,  5709,  5711,  5713,  5716,  5719,  5721,  5725,
    5728,  5731,  5734,  5737,  5740,  5743,  5746,  5749,  5750,  5752,
    5756,  5758,  5761,  5764,  5767,  5769,  5773,  5777,  5779,  5781,
    5785,  5787,  5791,  5796,  5802,  5804,  5805,  5809,  5813,  5815,
    5817,  5818,  5821,  5824,  5827,  5830,  5831,  5834,  5837,  5839,
    5842,  5845,  5848,  5851,  5854,  5855,  5859,  5860,  5862,  5863,
    5867,  5870,  5871,  5873,  5876,  5877,  5879,  5884,  5889,  5895,
    5898,  5902,  5903,  5905,  5906,  5911,  5912,  5914,  5916,  5917,
    5920,  5923,  5925,  5926,  5928,  5930,  5931,  5937,  5944,  5945,
    5946,  5949,  5952,  5956,  5958,  5960,  5962,  5964,  5966,  5968,
    5970,  5972,  5974,  5976,  5978,  5979,  5983,  5985,  5988,  5990,
    5993,  5997,  6001,  6005,  6006,  6008,  6009,  6013,  6017,  6018,
    6027,  6028,  6032,  6034,  6038,  6039,  6042,  6046,  6052,  6053,
    6057,  6062,  6067,  6068,  6083,  6092,  6100,  6101,  6102,  6103,
    6104,  6105,  6121,  6122,  6123,  6124,  6125,  6138,  6143,  6148,
    6152,  6157,  6161,  6164,  6166,  6170,  6176,  6178,  6180,  6181,
    6183,  6185,  6186,  6189,  6190,  6191,  6195,  6196
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     571,     0,    -1,     3,    -1,   572,     3,    -1,   573,    -1,
    1176,    -1,   769,    -1,   810,    -1,   800,    -1,   602,    -1,
     585,    -1,   812,    -1,   802,    -1,  1182,    -1,   590,    -1,
     574,    -1,  1020,    -1,  1047,    -1,   976,    -1,   978,    -1,
     578,    -1,  1053,    -1,  1151,    -1,  1142,    -1,   583,    -1,
     984,    -1,  1067,    -1,  1071,    -1,  1134,    -1,   817,    -1,
     825,    -1,   829,    -1,   576,    -1,  1063,    -1,  1185,    -1,
     820,    -1,   805,    -1,   987,    -1,  1059,    -1,   798,    -1,
    1149,    -1,  1183,    -1,  1184,    -1,   837,    -1,  1117,    -1,
    1033,    -1,   787,    -1,   790,    -1,  1031,    -1,  1140,    -1,
    1012,    -1,  1070,    -1,  1231,    -1,   575,   362,  1111,    -1,
     103,    -1,   126,    -1,   362,  1111,   171,   577,    -1,  1108,
      -1,   566,  1113,    -1,    -1,   148,  1111,   579,   580,    -1,
      -1,   517,   581,    -1,   581,   562,   582,    -1,   582,    -1,
     566,  1113,    -1,    -1,   198,   584,  1113,    -1,    -1,    52,
     281,   485,   586,   587,    -1,   588,    -1,   587,   562,   588,
      -1,   268,   142,  1108,    -1,   282,   142,  1108,    -1,   271,
     142,  1108,    -1,   272,   142,   961,    -1,   267,   142,   961,
      -1,   280,   142,   961,    -1,   276,   142,  1108,    -1,   275,
     142,  1108,    -1,   277,   142,  1108,    -1,   278,   142,  1108,
      -1,   279,   142,  1108,    -1,   589,    -1,   269,   142,  1108,
      -1,   270,   142,   962,    -1,   386,   142,  1108,    -1,   387,
     142,   961,    -1,    -1,    84,   687,   472,   690,  1105,   591,
     674,    -1,    -1,    84,   761,   213,  1111,   762,   337,  1105,
     592,   560,   764,   561,    -1,    -1,    84,    91,   690,  1111,
     593,   684,    -1,    -1,    84,   594,  1198,    -1,    84,   514,
     595,  1167,    -1,    -1,  1111,   567,  1111,    -1,  1111,    -1,
      -1,   597,   599,    -1,    -1,   598,   600,    -1,    67,  1108,
      -1,   235,   450,    -1,   328,   450,    -1,    79,   450,    -1,
     379,   450,    93,    -1,   304,   450,    93,    -1,   601,    -1,
     599,    -1,   118,    -1,   864,   118,    -1,   450,   419,   109,
      -1,   450,   419,   224,    -1,    -1,    47,   596,   603,   604,
      -1,    -1,   560,   605,   561,    -1,    -1,   606,    -1,   606,
     562,   858,    -1,   858,    -1,    -1,   608,    -1,   608,   562,
     610,    -1,   610,    -1,    -1,  1111,   609,   713,    -1,    -1,
     612,    -1,   612,   562,   613,    -1,   613,    -1,   614,   609,
    1111,   713,    -1,    -1,   225,    -1,   350,    -1,   217,    -1,
      -1,   615,   631,   568,    -1,   631,   568,    -1,   616,   631,
     568,    -1,    -1,   617,   618,   568,    -1,    -1,   106,   629,
     619,   713,   630,    -1,   106,  1111,    75,   168,   626,    -1,
      -1,   106,   623,   195,   168,   620,   624,   631,    -1,   106,
    1111,    89,   168,   621,    -1,    -1,   622,   573,    -1,   150,
      -1,    80,    -1,   625,    -1,   624,   562,   625,    -1,   628,
      -1,   961,    -1,   442,   627,  1109,    -1,    -1,   523,    -1,
     626,    -1,  1111,    -1,   443,    -1,   864,   169,    -1,   441,
      -1,  1111,    -1,   629,   562,  1111,    -1,    -1,   108,   858,
      -1,    -1,   632,   573,    -1,    -1,   404,   633,   858,    -1,
      -1,   209,   634,   639,   138,   209,    -1,   644,    -1,   659,
      -1,    -1,   635,   668,    -1,   662,    -1,   664,    -1,   242,
    1112,    -1,   229,  1112,    -1,   340,  1111,    -1,    -1,   157,
     637,  1111,   222,   636,   638,    -1,    60,  1111,    -1,    -1,
     323,   171,    -1,   171,    -1,  1111,    -1,   638,   562,  1111,
      -1,    -1,    -1,    -1,   640,   858,   547,   641,   616,   642,
     643,    -1,    -1,   132,   639,    -1,   546,   616,    -1,   645,
      -1,   648,    -1,    -1,    -1,   548,   646,   858,   647,   650,
     658,   138,   548,    -1,    -1,   548,   649,   651,   658,   138,
     548,    -1,   652,    -1,   650,   652,    -1,   655,    -1,   651,
     655,    -1,    -1,    -1,   532,   653,   858,   654,   547,   616,
      -1,    -1,    -1,   532,   656,   858,   657,   547,   616,    -1,
      -1,   546,   616,    -1,    -1,  1112,   569,   660,   668,   661,
      -1,    -1,  1112,    -1,    -1,  1112,   569,   663,   666,   661,
      -1,    -1,   665,   666,    -1,    -1,    28,   667,   617,   615,
     138,    -1,   263,   616,   138,   263,    -1,    -1,    -1,   534,
     669,   858,   125,   670,   616,   138,   534,    -1,    -1,   394,
     616,   510,   671,   858,   138,   394,    -1,    27,    -1,     8,
      -1,   219,    -1,   511,    -1,   112,    -1,   560,   675,    -1,
     691,   677,    -1,   246,  1105,    -1,   560,   246,  1105,   561,
      -1,   703,   561,   691,   677,    -1,    -1,   680,   561,   676,
    1189,    -1,    -1,    -1,  1080,   683,   680,   678,  1186,    -1,
      -1,  1080,   683,   560,   680,   561,   679,  1189,    -1,    -1,
      -1,   420,   681,   847,   851,   682,   701,    -1,    -1,    18,
      -1,    -1,   685,    -1,   686,    -1,   685,   686,    -1,   696,
      -1,   695,    -1,    -1,   688,    -1,   689,    -1,   689,   688,
      -1,   473,    -1,    -1,   209,   864,   149,    -1,    -1,   693,
      -1,   694,    -1,   694,   692,    -1,   694,    -1,   694,   693,
      -1,   694,   562,   693,    -1,   140,  1004,   697,    -1,   494,
    1004,   697,    -1,   286,  1004,   962,    -1,   300,  1004,   962,
      -1,    24,  1004,   961,    -1,   353,  1004,  1108,    -1,    67,
    1004,  1108,    -1,    23,  1004,   962,    -1,   351,  1004,   961,
      -1,   351,  1004,   108,    -1,    56,  1004,   961,    -1,   111,
    1004,   961,    -1,   413,  1004,   698,    -1,   377,  1004,   699,
      -1,   374,  1004,   961,    -1,   375,  1004,   961,    -1,   503,
    1004,   560,  1058,   561,    -1,   695,    -1,   696,    -1,   220,
    1004,   700,    -1,    93,   119,  1004,  1108,    -1,   213,   119,
    1004,  1108,    -1,    76,  1004,  1108,    -1,   743,   734,  1004,
     736,    -1,   743,    63,  1004,   742,    -1,  1113,    -1,   108,
      -1,   161,    -1,   130,    -1,    71,    -1,   383,    -1,    70,
      -1,   376,    -1,   373,    -1,   961,    -1,   328,    -1,   160,
      -1,   237,    -1,   956,    -1,   846,   850,    -1,   461,    -1,
     381,    -1,   105,    -1,   223,    -1,   704,    -1,   703,   562,
     704,    -1,   705,    -1,   706,    -1,   711,   707,    -1,   711,
     748,    -1,   756,   766,   762,   560,   764,   561,   762,    -1,
     709,   757,   766,   762,   560,   764,   561,   762,    -1,   709,
     166,   232,   766,   560,   764,   561,   748,    -1,   710,   707,
      -1,   709,   708,    -1,    -1,   708,    -1,    57,   858,    -1,
      -1,   710,    -1,    78,   766,    -1,    -1,  1104,   712,   713,
     730,    -1,   721,   728,   725,    -1,   722,   729,   725,    -1,
     163,   723,   725,    -1,    37,    -1,    37,   560,   331,   561,
      -1,    41,    -1,    40,    -1,   717,   560,   331,   561,   744,
      -1,   717,   744,    -1,   718,   560,   331,   561,   745,    -1,
     718,   745,    -1,    32,   560,   331,   561,    -1,    32,    -1,
     719,   560,   331,   561,   744,    -1,   720,   560,   331,   561,
     745,    -1,   524,   560,   331,   561,    -1,   543,   728,   725,
      -1,    97,    -1,   481,    -1,   478,   728,    -1,    94,    -1,
     482,    -1,    39,   728,    -1,   716,    -1,   290,    -1,   259,
      -1,   262,   524,    -1,   262,   719,   744,    -1,   484,   744,
      -1,   477,   728,   744,    -1,   292,   744,    -1,   260,   744,
      -1,   105,   723,   725,    -1,   332,   723,   725,    -1,   161,
     723,   725,    -1,    -1,   141,   714,   560,   768,   561,   744,
      -1,    -1,   426,   715,   560,   768,   561,   744,    -1,   262,
     744,    -1,   424,    -1,   183,    -1,   182,    -1,   357,    -1,
     311,    -1,   250,    -1,   310,    -1,   359,    -1,   312,    -1,
      55,    -1,   319,    -1,   316,    55,    -1,   717,   528,    -1,
     525,    -1,   316,   525,    -1,   333,    -1,   319,   525,    -1,
     316,    55,   528,    -1,   319,   528,    -1,   223,    -1,   483,
      -1,   436,    -1,   291,    -1,    31,    -1,   381,    -1,   124,
      -1,   124,   361,    -1,    -1,   560,   331,   561,    -1,   724,
      -1,   560,   331,   562,   331,   561,    -1,    -1,   726,    -1,
     726,   727,    -1,   727,    -1,   433,    -1,   509,    -1,   544,
      -1,    -1,   560,   331,   561,    -1,    -1,   724,    -1,    -1,
     731,    -1,   731,   732,    -1,   732,    -1,   330,    -1,   864,
     330,    -1,   108,   733,    -1,   337,   511,   327,   857,    -1,
      23,    -1,   424,   108,   523,    -1,   747,   232,    -1,   504,
      -1,   504,   232,    -1,    67,  1108,    -1,    63,   740,    -1,
     327,   857,    -1,  1095,    -1,    55,   426,    -1,    54,    -1,
    1113,    -1,    32,    -1,   735,    -1,   108,    -1,    -1,   734,
     736,    -1,  1113,    -1,    32,    -1,   738,    -1,   108,    -1,
    1113,    -1,    -1,    63,   742,    -1,   740,    -1,   108,    -1,
      -1,   108,    -1,    -1,    20,   745,    -1,    45,    -1,   502,
     745,    -1,   734,   735,   745,    -1,    32,   746,    -1,    -1,
      32,    -1,    -1,    20,    -1,   502,    -1,   734,   735,    -1,
      -1,   364,    -1,    -1,   384,  1105,   749,   750,    -1,   752,
      -1,   560,   751,   561,   752,    -1,   751,   562,  1111,    -1,
    1111,    -1,    -1,   753,    -1,   753,   754,    -1,   754,    -1,
     337,   112,   755,    -1,   337,   511,   755,    -1,   283,   173,
      -1,   283,   352,    -1,   283,   434,    -1,   401,    -1,    48,
      -1,   426,   330,    -1,   328,     5,    -1,   426,   108,    -1,
     758,    -1,   174,   759,    -1,   439,   759,    -1,   364,   232,
      -1,   504,   759,    -1,   232,    -1,   213,    -1,    -1,   758,
      -1,   231,    -1,   213,    -1,   212,    -1,    -1,   504,    -1,
     174,    -1,   439,    -1,    -1,   517,   763,    -1,   494,   763,
      -1,    43,    -1,   415,    -1,   196,    -1,   764,   562,   765,
     954,    -1,   765,   954,    -1,  1111,    -1,  1111,   560,   331,
     561,    -1,    -1,  1104,    -1,    -1,   567,  1111,    -1,  1093,
      -1,   768,   562,  1093,    -1,    -1,    13,   783,   472,  1105,
     770,   776,    -1,    -1,    13,    91,   775,   771,   685,    -1,
      -1,    13,   366,   596,   772,   597,    -1,    -1,    13,   175,
     596,   773,   597,    -1,    -1,    13,  1207,  1201,  1208,   529,
    1105,   774,  1211,    18,  1213,  1216,    -1,    -1,  1111,    -1,
      -1,   121,   471,    -1,   211,   471,    -1,   778,    -1,   776,
     562,   778,    -1,     6,   782,    -1,   777,   705,   785,    -1,
       6,   706,    -1,   777,   560,   703,   561,    -1,    -1,    52,
     782,  1104,   779,   711,   785,    -1,    -1,    -1,   305,   782,
    1104,   780,   713,   730,   781,   785,    -1,   126,   782,  1104,
     784,    -1,   126,   166,   232,   766,    -1,   126,   364,   232,
      -1,   126,   758,  1104,    -1,   120,   231,    -1,   134,   231,
      -1,    13,   782,  1104,   426,   108,  1095,    -1,    13,   782,
    1104,   126,   108,    -1,   391,   786,  1105,    -1,    81,   485,
     734,   736,   741,    -1,   692,    -1,   165,    -1,   947,    -1,
      -1,    66,    -1,    -1,   210,    -1,    -1,   401,    -1,    48,
      -1,    -1,     8,  1111,    -1,   160,    -1,    -1,   485,    -1,
     142,    -1,    18,    -1,    -1,   454,   435,   792,   788,   796,
      -1,   458,   435,   792,    -1,    -1,   435,   454,   792,   789,
     796,    -1,   435,   458,   792,    -1,   454,   487,   791,    -1,
      -1,   535,    77,   437,    -1,    -1,   793,   794,    -1,   795,
      -1,   794,   562,   795,    -1,    -1,   451,    -1,   388,    -1,
      -1,   510,   797,    -1,   589,    -1,   797,   562,   589,    -1,
      -1,   400,  1136,   799,   980,   171,  1108,    -1,    -1,    26,
    1136,   801,   980,   485,  1108,    -1,    -1,    56,  1136,   803,
     980,   804,    -1,    -1,   372,    -1,   153,    -1,    -1,   392,
     819,  1136,   806,   980,   807,    -1,    -1,   808,    -1,   809,
      -1,   809,   808,    -1,   372,    -1,   153,    -1,   515,    -1,
      -1,    14,   819,  1136,   811,   980,    -1,    -1,    57,  1136,
     813,   980,   814,    -1,    -1,   815,    -1,   816,    -1,   816,
     815,    -1,   372,    -1,   156,    -1,   293,    -1,   153,    -1,
      53,    -1,   168,   512,    -1,    -1,   341,   819,  1136,   818,
     980,    -1,    -1,   329,    -1,   252,    -1,    -1,   391,  1136,
     821,   823,    -1,   391,   514,   595,   822,    -1,  1114,   485,
    1114,    -1,   822,   562,  1114,   485,  1114,    -1,   824,    -1,
     823,   562,   824,    -1,  1105,   485,  1105,    -1,    46,   213,
     826,   225,   828,    -1,   827,    -1,   826,   562,   827,    -1,
    1105,   833,    -1,  1111,    -1,   108,    -1,    -1,   251,   213,
     222,    46,   830,   831,    -1,   832,    -1,   831,   562,   832,
      -1,  1105,   833,   836,    -1,    -1,   834,   835,    -1,    -1,
     759,   560,   930,   561,    -1,    -1,   210,   241,    -1,   838,
      -1,   420,   840,    -1,   560,   839,   561,  1189,    -1,   420,
     842,    -1,   560,   839,   561,    -1,    -1,   842,   841,  1186,
      -1,    -1,    -1,   843,   847,   851,   844,   845,   850,    -1,
     950,   956,    -1,   972,    -1,   846,    -1,   972,   846,    -1,
     846,   972,    -1,   171,   903,   939,   944,   941,   950,   956,
     963,    -1,   171,   127,   939,   956,    -1,    -1,   848,    -1,
     848,   849,    -1,   849,    -1,   460,    -1,   200,    -1,   122,
      -1,   449,    -1,   444,    -1,   445,    -1,   447,    -1,   448,
      -1,   446,    -1,    12,    -1,    -1,   168,   511,    -1,   256,
     225,   428,   303,    -1,   851,   562,   852,    -1,   852,    -1,
     554,    -1,   853,   855,   854,   856,    -1,    -1,    -1,  1099,
      -1,   858,    -1,    -1,    18,  1111,    -1,    18,  1108,    -1,
    1111,    -1,  1108,    -1,    -1,   560,   561,    -1,   858,   862,
     858,    -1,   858,   540,   858,    -1,   858,   863,   858,    -1,
     326,   858,    -1,   859,   226,   491,    -1,   859,   226,   864,
     491,    -1,   859,   226,   155,    -1,   859,   226,   864,   155,
      -1,   859,   226,   507,    -1,   859,   226,   864,   507,    -1,
     859,    -1,   859,   226,   330,    -1,   859,   226,   864,   330,
      -1,   859,   143,   860,    -1,   859,   866,   860,    -1,   859,
     866,   867,   560,  1195,   561,    -1,   860,    -1,   861,   225,
     560,  1195,   561,    -1,   861,   864,   225,   560,  1195,   561,
      -1,   861,   225,   560,   858,   561,    -1,   861,   225,   560,
     858,   562,   892,   561,    -1,   861,   864,   225,   560,   858,
     561,    -1,   861,   864,   225,   560,   858,   562,   892,   561,
      -1,   861,   549,   861,    16,   860,    -1,   861,   864,   549,
     861,    16,   860,    -1,   861,   438,   246,   861,    -1,   861,
     246,   869,   943,    -1,   861,   864,   246,   869,   943,    -1,
     861,   385,   861,    -1,   861,   864,   385,   861,    -1,   861,
      -1,   861,   550,   861,    -1,   861,   551,   861,    -1,   861,
     429,   861,    -1,   861,   430,   861,    -1,   861,   553,   861,
      -1,   861,   552,   861,    -1,   861,   553,   868,   932,    -1,
     861,   552,   868,   932,    -1,   861,   554,   861,    -1,   861,
     555,   861,    -1,   861,   556,   861,    -1,   861,   123,   861,
      -1,   861,   306,   861,    -1,   861,   557,   861,    -1,   869,
      -1,   347,    -1,   344,    -1,    16,    -1,    15,    -1,   326,
      -1,   325,    -1,   563,    -1,   325,    -1,   142,    -1,   180,
      -1,   194,    -1,   238,    -1,   265,    -1,   321,    -1,    12,
      -1,    17,    -1,   221,   858,    -1,  1101,    -1,   869,    63,
    1113,    -1,  1096,    -1,  1094,    -1,   882,    -1,   878,    -1,
     869,   346,   869,    -1,   553,   869,    -1,   552,   869,    -1,
     558,   869,    -1,   865,   869,    -1,   560,  1195,   561,    -1,
     560,   858,   561,    -1,   560,   858,   562,   892,   561,    -1,
     414,   560,   858,   562,   892,   561,    -1,   149,   560,  1195,
     561,    -1,   564,  1111,   858,   565,    -1,   283,   895,     9,
     560,   861,   872,   561,    -1,    20,   560,   858,   561,    -1,
      32,   869,    -1,    50,   560,   858,    18,   890,   561,    -1,
     548,   899,   901,   900,   138,    -1,    81,   560,   858,   562,
     890,   561,    -1,    81,   560,   858,   517,   735,   561,    -1,
     108,   560,  1101,   561,    -1,   522,   560,  1102,   561,    -1,
     176,   560,   561,    -1,   177,   560,   858,   561,    -1,   178,
     560,   858,   562,   858,   561,    -1,   179,   560,   858,   562,
     858,   562,   858,   561,    -1,     7,   560,   858,   562,   858,
     561,    -1,     7,   560,   858,   562,   221,   858,   932,   561,
      -1,   394,   560,   858,   562,   858,   561,    -1,    22,   560,
     858,   561,    -1,    22,   560,   858,   562,   858,   561,    -1,
      55,   560,   892,   561,    -1,    55,   560,   892,   517,   735,
     561,    -1,    54,   560,   858,   561,    -1,    61,   560,   892,
     561,    -1,    64,   560,   858,   561,    -1,    72,   560,   892,
     561,    -1,    73,   560,   858,   562,   892,   561,    -1,    82,
     560,   858,   562,   858,   562,   858,   561,    -1,    87,   857,
      -1,    90,   857,    -1,    90,   560,   858,   561,    -1,    88,
     857,    -1,    95,   560,   858,   562,   868,   932,   561,    -1,
      96,   560,   858,   562,   868,   932,   561,    -1,    91,   560,
     561,    -1,    97,   560,   858,   561,    -1,   102,   560,   858,
     561,    -1,   133,   560,   858,   562,   892,   561,    -1,   266,
     560,   858,   562,   892,   561,    -1,   137,   560,   858,   561,
      -1,   137,   560,   858,   562,   858,   561,    -1,   107,   560,
     858,   562,  1109,   561,    -1,   136,   560,   858,   562,  1109,
     561,    -1,   115,   560,   858,   561,    -1,   115,   560,   858,
     562,   858,   561,    -1,   116,   560,   858,   561,    -1,   116,
     560,   858,   562,   858,   561,    -1,   152,   560,   858,   562,
     858,   562,   858,   561,    -1,   152,   560,   858,   562,   858,
     562,   858,   562,   858,   561,    -1,   152,   560,   858,   562,
     858,   562,   858,   562,   858,   562,   858,   561,    -1,   167,
     560,   858,   562,   331,   561,    -1,   172,   560,   858,   561,
      -1,   172,   560,   858,   562,   858,   561,    -1,   158,   560,
     858,   562,   892,   561,    -1,   871,    -1,   186,   560,   935,
     562,   858,   561,    -1,   205,   560,   858,   561,    -1,   209,
     560,   858,   562,   858,   562,   858,   561,    -1,   219,   560,
     858,   562,   858,   562,   858,   562,   858,   561,    -1,   868,
     932,   553,   858,    -1,   868,    -1,   236,   560,   561,    -1,
     236,   560,   858,   561,    -1,   243,   560,   858,   562,   858,
     561,    -1,   253,   560,   858,   562,   858,   561,    -1,   253,
     560,   858,   562,   858,   562,   858,   561,    -1,   190,   560,
     858,   562,   892,   561,    -1,   240,   560,   858,   562,   892,
     561,    -1,   258,   560,   858,   561,    -1,   258,   560,   858,
     562,   858,   561,    -1,   273,   560,   858,   562,   858,   561,
      -1,   273,   560,   858,   562,   858,   562,   858,   561,    -1,
     295,   560,   858,   561,    -1,   299,   560,   858,   561,    -1,
     306,   560,   858,   562,   858,   561,    -1,   307,   560,   858,
     561,    -1,   327,   857,    -1,   327,   560,   858,   561,    -1,
     353,   560,   858,   561,    -1,   336,   560,   858,   561,    -1,
     360,   560,   861,   225,   858,   561,    -1,   370,   560,   858,
     561,    -1,   378,   560,   858,   561,    -1,   378,   560,   561,
      -1,   395,   560,   858,   562,   858,   562,   858,   561,    -1,
     406,   560,   858,   562,   858,   561,    -1,   409,   560,   858,
     561,    -1,   409,   560,   858,   562,   858,   561,    -1,   412,
     560,   561,    -1,   462,   560,   858,   562,   858,   561,    -1,
     462,   560,   858,   562,   221,   858,   932,   561,    -1,   418,
     560,   858,   561,    -1,   464,   560,   858,   562,   858,   562,
     858,   561,    -1,   464,   560,   858,   562,   858,   561,    -1,
     464,   560,   858,   171,   858,   168,   858,   561,    -1,   464,
     560,   858,   171,   858,   561,    -1,   465,   560,   858,   562,
     858,   562,   858,   561,    -1,   469,   857,    -1,   469,   560,
     858,   561,    -1,   481,   560,   858,   561,    -1,   478,   560,
     858,   561,    -1,   478,   560,   858,   562,   858,   561,    -1,
     479,   560,   933,   562,   858,   562,   858,   561,    -1,   480,
     560,   933,   562,   858,   562,   858,   561,    -1,   490,   560,
     858,   561,    -1,   490,   560,   239,   858,   171,   858,   561,
      -1,   490,   560,   486,   858,   171,   858,   561,    -1,   490,
     560,    42,   858,   171,   858,   561,    -1,   490,   560,   239,
     171,   858,   561,    -1,   490,   560,   486,   171,   858,   561,
      -1,   490,   560,    42,   171,   858,   561,    -1,   490,   560,
     858,   171,   858,   561,    -1,   492,   560,   858,   562,   858,
     561,    -1,  1111,   567,  1111,   560,   891,   561,    -1,    -1,
    1107,   560,   870,   873,   561,    -1,   505,   560,  1092,   562,
     331,   562,   331,   562,   892,   561,    -1,   506,   560,   561,
      -1,   506,   560,   858,   561,    -1,   514,   560,   561,    -1,
     518,   857,    -1,   520,   857,    -1,   519,   857,    -1,   531,
     560,   858,   561,    -1,   531,   560,   858,   562,   858,   561,
      -1,   543,   560,   858,   561,    -1,   541,   560,   858,   561,
      -1,   541,   560,   858,   562,   858,   561,    -1,    29,   560,
     961,   562,   858,   561,    -1,   154,   560,   932,   171,   858,
     561,    -1,    79,   560,   858,   562,   858,   561,    -1,   184,
     560,   858,   561,    -1,   184,   560,   858,   562,   858,   561,
      -1,   185,   560,   858,   561,    -1,   185,   560,   858,   562,
     858,   561,    -1,   182,   560,   892,   561,    -1,   250,   560,
     892,   561,    -1,   310,   560,   892,   561,    -1,   302,   560,
     858,   561,    -1,   302,   560,   858,   562,   858,   561,    -1,
     308,   560,   858,   561,    -1,   308,   560,   858,   562,   858,
     561,    -1,   309,   560,   858,   561,    -1,   309,   560,   858,
     562,   858,   561,    -1,   311,   560,   892,   561,    -1,   312,
     560,   892,   561,    -1,   357,   560,   858,   562,   858,   561,
      -1,   356,   560,   858,   561,    -1,   356,   560,   858,   562,
     858,   561,    -1,   358,   560,   858,   561,    -1,   358,   560,
     858,   562,   858,   561,    -1,   359,   560,   892,   561,    -1,
     181,   560,   858,   561,    -1,   181,   560,   858,   562,   858,
     561,    -1,   248,   560,   858,   561,    -1,   248,   560,   858,
     562,   858,   561,    -1,    -1,   535,   371,   151,    -1,   225,
      40,   303,    -1,    -1,   874,    -1,    -1,   875,   876,    -1,
     877,    -1,   876,   562,   877,    -1,   853,   858,   854,   856,
      -1,    25,   560,   888,   561,    -1,    25,   560,   122,   888,
     561,    -1,    35,   560,   888,   561,    -1,    36,   560,   888,
     561,    -1,    38,   560,   888,   561,    -1,    83,   560,   938,
     554,   561,    -1,    83,   560,   888,   561,    -1,    -1,    -1,
      83,   560,   122,   879,   892,   880,   561,    -1,   193,   560,
    1092,   562,   331,   562,   331,   562,   888,   561,    -1,   301,
     560,   888,   561,    -1,   301,   560,   122,   888,   561,    -1,
     287,   560,   888,   561,    -1,   287,   560,   122,   888,   561,
      -1,   456,   560,   888,   561,    -1,   527,   560,   888,   561,
      -1,   457,   560,   888,   561,    -1,   521,   560,   888,   561,
      -1,   466,   560,   888,   561,    -1,   466,   560,   122,   888,
     561,    -1,    -1,   192,   560,   885,   881,   892,   887,   886,
     561,    -1,    -1,   566,   883,   884,    -1,  1113,   427,   858,
      -1,  1113,    -1,   566,  1126,  1113,   767,    -1,    -1,   122,
      -1,    -1,   422,  1093,    -1,    -1,   951,    -1,    -1,   938,
     889,   858,    -1,    32,   728,    -1,    55,   728,   744,    -1,
     319,   728,    -1,   433,    -1,   433,   223,    -1,   509,    -1,
     509,   223,    -1,    97,    -1,   481,    -1,    94,    -1,   105,
     723,    -1,    -1,   892,    -1,    -1,   893,   894,    -1,   858,
      -1,   894,   562,   858,    -1,   896,    -1,   560,   896,   561,
      -1,    -1,   897,   898,    -1,  1101,    -1,   898,   562,  1101,
      -1,    -1,   858,    -1,    -1,   546,   858,    -1,   532,   858,
     547,   858,    -1,   901,   532,   858,   547,   858,    -1,   914,
      -1,   905,    -1,   904,    -1,   902,    -1,   904,   562,   902,
      -1,   902,   913,   902,    -1,   902,   460,   914,    -1,    -1,
     902,   913,   902,   337,   906,   858,    -1,    -1,   902,   460,
     914,   337,   907,   858,    -1,    -1,   902,   913,   902,   517,
     908,   560,   931,   561,    -1,   902,   317,   230,   914,    -1,
      -1,   902,   243,   924,   230,   902,   337,   909,   858,    -1,
      -1,   902,   243,   924,   230,   914,   910,   517,   560,   931,
     561,    -1,   902,   317,   243,   924,   230,   914,    -1,    -1,
     902,   406,   924,   230,   902,   337,   911,   858,    -1,    -1,
     902,   406,   924,   230,   914,   912,   517,   560,   931,   561,
      -1,   902,   317,   406,   924,   230,   914,    -1,   230,    -1,
     215,   230,    -1,    85,   230,    -1,    -1,   915,  1105,   937,
     926,    -1,    -1,   564,  1111,   902,   243,   348,   230,   902,
     337,   916,   858,   565,    -1,   923,   922,   919,    -1,   560,
     922,   917,  1189,   561,   937,    -1,    -1,   922,   918,   904,
      -1,    -1,    -1,   920,   847,   851,   921,   701,    -1,    -1,
     420,    -1,    -1,   348,    -1,    -1,   168,   230,    -1,    -1,
     516,   927,    -1,   165,   927,    -1,   210,   927,    -1,    -1,
     758,   925,   928,   560,   929,   561,    -1,    -1,   930,    -1,
     930,   562,  1111,    -1,  1111,    -1,   364,    -1,  1111,    -1,
     931,   562,  1111,    -1,   934,    -1,    98,    -1,    99,    -1,
     100,    -1,   101,    -1,   202,    -1,   203,    -1,   204,    -1,
     297,    -1,   298,    -1,   417,    -1,   542,    -1,   934,    -1,
     170,    -1,   102,    -1,   531,    -1,   205,    -1,   299,    -1,
     307,    -1,   370,    -1,   418,    -1,   295,    -1,   543,    -1,
      97,    -1,   481,    -1,    94,    -1,   478,    -1,    -1,    18,
      -1,   142,    -1,    -1,   936,  1111,    -1,    -1,    12,    -1,
      -1,    -1,   533,   940,   858,    -1,    -1,    -1,   197,   942,
     858,    -1,   146,   869,    -1,    -1,    -1,   191,    44,   945,
     946,    -1,   945,   562,  1100,   954,    -1,  1100,   954,    -1,
      -1,   535,    86,    -1,   535,   408,    -1,   345,    44,   948,
      -1,   948,   562,   949,    -1,   949,    -1,  1102,   954,    -1,
      -1,   951,    -1,    -1,   345,    44,   952,   953,    -1,   953,
     562,  1100,   954,    -1,  1100,   954,    -1,    -1,    19,    -1,
     113,    -1,    -1,   957,    -1,    -1,   957,    -1,   247,   958,
      -1,   959,    -1,   959,   562,   959,    -1,   959,   334,   959,
      -1,  1094,    -1,   497,    -1,   261,    -1,   331,    -1,    -1,
     247,   959,    -1,   331,    -1,   199,    -1,   261,    -1,   497,
      -1,   104,    -1,   162,    -1,   331,    -1,   497,    -1,   261,
      -1,   104,    -1,   162,    -1,    -1,    -1,   366,  1111,   964,
     560,   965,   561,    -1,    -1,   966,    -1,   966,   562,   967,
      -1,   967,    -1,   853,   858,    -1,    -1,   969,   970,    -1,
     970,   562,   971,    -1,   971,    -1,   566,  1113,    -1,  1113,
      -1,    -1,   222,   973,   974,    -1,    -1,   349,  1110,   975,
    1081,  1084,    -1,   128,  1110,    -1,   968,    -1,    -1,   125,
     977,   892,    -1,   126,   983,  1136,   982,   980,   784,    -1,
      -1,   126,   213,  1111,   337,  1105,   979,    -1,   126,    91,
     982,  1111,    -1,   126,   175,   982,  1111,   567,  1111,    -1,
     126,   175,   982,  1111,    -1,   126,   366,   982,   596,    -1,
     126,   514,   595,  1166,    -1,   126,   529,   982,   980,   784,
      -1,   126,   488,   982,   596,    -1,   981,    -1,   980,   562,
     981,    -1,  1105,    -1,    -1,   209,   149,    -1,    -1,   473,
      -1,    -1,    -1,   219,   985,   990,   783,   992,   986,   994,
    1010,    -1,    -1,    -1,   395,   988,   991,   992,   989,   994,
      -1,    -1,   264,    -1,   110,    -1,   200,    -1,  1019,    -1,
     110,    -1,   222,   993,    -1,   993,    -1,   981,    -1,   997,
      -1,   560,   561,   997,    -1,   560,   996,   561,   997,    -1,
      -1,   426,   995,  1001,    -1,   996,   562,  1098,    -1,  1098,
      -1,   522,  1000,    -1,   523,  1000,    -1,    -1,   680,   998,
    1186,    -1,    -1,   560,   680,   561,   999,  1189,    -1,  1000,
     562,  1005,    -1,  1005,    -1,  1001,   562,  1002,    -1,  1002,
      -1,  1102,  1003,  1009,    -1,   142,    -1,   427,    -1,    -1,
    1003,    -1,    -1,   560,  1006,  1007,   561,    -1,    -1,  1008,
      -1,  1008,   562,  1009,    -1,  1009,    -1,   858,    -1,   108,
      -1,    -1,    -1,   337,   129,  1011,   232,   511,  1017,    -1,
      -1,    -1,   511,  1013,  1019,   783,   903,   426,  1015,  1014,
     939,   950,   960,    -1,  1015,   562,  1016,    -1,  1016,    -1,
    1102,  1003,  1009,    -1,  1017,   562,  1018,    -1,  1018,    -1,
    1102,  1003,  1009,    -1,    -1,   264,    -1,    -1,   112,  1021,
    1029,  1022,    -1,    -1,   171,  1105,  1023,   939,   950,   960,
      -1,    -1,  1026,  1024,   171,   903,   939,    -1,    -1,   171,
    1026,  1025,   517,   903,   939,    -1,  1027,    -1,  1026,   562,
    1027,    -1,  1111,  1028,   937,    -1,  1111,   567,  1111,  1028,
     937,    -1,    -1,   567,   554,    -1,    -1,  1030,  1029,    -1,
     372,    -1,   264,    -1,   210,    -1,   492,  1032,   981,    -1,
      -1,   472,    -1,    -1,   431,  1034,  1035,    -1,    92,  1046,
      -1,  1042,   470,  1041,  1046,    -1,  1042,   489,  1041,  1046,
      -1,   472,   455,  1041,  1046,    -1,   340,   470,  1041,  1046,
      -1,    -1,   140,   697,  1036,  1038,    -1,  1042,    65,  1043,
    1105,  1041,  1046,    -1,   322,   281,   168,   435,   535,   269,
     142,  1108,    16,   270,   142,   962,    16,   274,   142,   961,
      -1,  1039,   257,    -1,   435,   201,    -1,    -1,    33,   147,
    1044,  1045,  1037,   955,    -1,   760,  1043,  1105,  1041,   939,
      -1,    66,   493,    -1,   472,   493,    -1,  1040,   139,    -1,
     365,    -1,    83,   560,   554,   561,   530,    -1,    83,   560,
     554,   561,   144,    -1,   530,   955,    -1,   144,   955,    -1,
    1125,   455,  1046,    -1,   216,   455,    -1,   313,   455,    -1,
    1042,   368,    -1,  1125,   526,  1046,    -1,   734,  1046,    -1,
      64,  1046,    -1,    30,   257,    -1,   257,    -1,   189,    -1,
     189,   168,  1114,    -1,    84,    91,   690,  1111,    -1,    84,
     472,  1105,    -1,    84,   529,  1105,    -1,   281,   455,    -1,
     435,   455,    -1,    84,   366,   596,    -1,    84,   175,   596,
      -1,   366,   455,  1046,    -1,   175,   455,  1046,    -1,   366,
      62,   596,    -1,   175,    62,   596,    -1,   455,    -1,   257,
      -1,   281,    -1,    32,    -1,    -1,   459,    -1,    -1,  1043,
    1111,    -1,    -1,   173,    -1,   171,    -1,   225,    -1,    -1,
     225,  1108,    -1,    -1,   171,   962,    -1,    -1,   246,  1108,
      -1,   533,   858,    -1,    -1,  1050,  1105,  1048,  1052,    -1,
      -1,  1050,  1051,  1049,   837,    -1,   113,    -1,   114,    -1,
      -1,   153,    -1,    -1,  1093,    -1,  1111,    -1,    -1,   164,
     819,  1054,  1055,    -1,  1055,   562,  1056,    -1,  1056,    -1,
      -1,  1136,  1057,  1058,    -1,   470,   535,   380,   256,    -1,
     371,    46,    -1,   201,    -1,   365,    -1,   257,    -1,   455,
      -1,   435,    -1,   281,    -1,   117,    -1,   399,    -1,    -1,
     980,    -1,    -1,   398,  1060,  1061,    -1,  1061,   562,  1062,
      -1,  1062,    -1,   435,    -1,   281,    -1,   371,    46,    -1,
      -1,   369,  1064,  1065,    -1,  1039,   257,  1066,    -1,   485,
    1108,    -1,    27,   858,    -1,    -1,   233,  1068,  1069,   858,
      -1,    -1,    76,    -1,   371,    -1,   516,  1111,    -1,    -1,
     251,    93,  1072,  1073,    -1,   251,   472,  1105,   171,   281,
      -1,    -1,    -1,    -1,    -1,  1079,  1078,   214,  1110,  1074,
    1080,   222,  1075,   472,  1105,  1076,   737,  1077,  1081,  1084,
    1087,  1088,  1091,    -1,   171,   281,    -1,    -1,   252,    -1,
      -1,    74,    -1,   264,    -1,    -1,   395,    -1,   210,    -1,
      -1,    65,  1082,    -1,  1082,  1083,    -1,  1083,    -1,   475,
      44,  1093,    -1,   343,   135,    44,  1093,    -1,   135,    44,
    1093,    -1,   145,    44,  1093,    -1,    -1,   249,  1085,    -1,
    1085,  1086,    -1,  1086,    -1,   475,    44,  1093,    -1,   453,
      44,  1093,    -1,    -1,   210,   331,   249,    -1,    -1,   560,
    1089,   561,    -1,   560,   561,    -1,  1089,   562,  1090,    -1,
    1090,    -1,  1102,    -1,   566,  1113,    -1,    -1,   426,  1017,
      -1,   476,    -1,   318,    -1,   500,   476,    -1,  1092,  1109,
      -1,  1109,    -1,   199,    -1,    34,    -1,   354,    -1,  1096,
      -1,   553,  1097,    -1,   552,  1097,    -1,  1092,    -1,  1097,
      -1,   330,    -1,   155,    -1,   491,    -1,   199,    -1,    34,
      -1,   500,   199,    -1,   500,    34,    -1,    97,  1092,    -1,
     481,  1092,    -1,   478,  1092,    -1,   331,    -1,   261,    -1,
     497,    -1,   104,    -1,   162,    -1,  1102,    -1,  1099,    -1,
    1111,   567,   554,    -1,  1111,   567,  1111,   567,   554,    -1,
     858,    -1,  1111,    -1,  1103,    -1,  1111,    -1,  1103,    -1,
    1111,   567,  1111,    -1,   567,  1111,   567,  1111,    -1,  1111,
     567,  1111,   567,  1111,    -1,  1111,    -1,  1111,   567,  1111,
     567,  1111,    -1,  1111,   567,  1111,    -1,   567,  1111,    -1,
    1111,    -1,  1111,   567,  1111,    -1,   567,  1111,    -1,  1111,
      -1,   206,    -1,   208,    -1,   476,    -1,   476,    -1,   476,
      -1,  1107,    -1,  1115,    -1,  1107,    -1,  1116,    -1,  1111,
      -1,  1108,    -1,   245,    -1,  1113,    -1,  1113,   566,  1113,
      -1,    88,   857,    -1,  1116,    -1,    20,    -1,    26,    -1,
      28,    -1,    45,    -1,    46,    -1,    54,    -1,    56,    -1,
      60,    -1,    67,    -1,    69,    -1,    79,    -1,   103,    -1,
     125,    -1,   138,    -1,   148,    -1,   164,    -1,   195,    -1,
     198,    -1,   235,    -1,   328,    -1,   340,    -1,   362,    -1,
     392,    -1,   398,    -1,   400,    -1,   407,    -1,   416,    -1,
     419,    -1,   433,    -1,   435,    -1,   454,    -1,   458,    -1,
     492,    -1,   502,    -1,   539,    -1,   512,    -1,     5,    -1,
       7,    -1,     8,    -1,     9,    -1,    10,    -1,    11,    -1,
      17,    -1,    23,    -1,    24,    -1,    25,    -1,    30,    -1,
      33,    -1,    37,    -1,    41,    -1,    40,    -1,    43,    -1,
      49,    -1,    51,    -1,    53,    -1,    58,    -1,    59,    -1,
      62,    -1,    64,    -1,    65,    -1,    68,    -1,    70,    -1,
      71,    -1,    74,    -1,    76,    -1,    77,    -1,    86,    -1,
      93,    -1,    94,    -1,    97,    -1,   102,    -1,   109,    -1,
     111,    -1,   117,    -1,   119,    -1,   121,    -1,   128,    -1,
     129,    -1,   130,    -1,   141,    -1,   140,    -1,   139,    -1,
     144,    -1,   146,    -1,   147,    -1,   151,    -1,   153,    -1,
     156,    -1,   169,    -1,   120,    -1,   134,    -1,   173,    -1,
     159,    -1,   160,    -1,   161,    -1,   170,    -1,   183,    -1,
     182,    -1,   186,    -1,   189,    -1,   187,    -1,   196,    -1,
     201,    -1,   205,    -1,   207,    -1,   224,    -1,   211,    -1,
     212,    -1,   227,    -1,   228,    -1,   216,    -1,   220,    -1,
     388,    -1,   237,    -1,   241,    -1,   244,    -1,   250,    -1,
     252,    -1,   255,    -1,   257,    -1,   286,    -1,   281,    -1,
     268,    -1,   272,    -1,   269,    -1,   270,    -1,   282,    -1,
     271,    -1,   274,    -1,   267,    -1,   280,    -1,   276,    -1,
     275,    -1,   277,    -1,   278,    -1,   279,    -1,   284,    -1,
     285,    -1,   288,    -1,   289,    -1,   293,    -1,   294,    -1,
     295,    -1,   296,    -1,   299,    -1,   300,    -1,   305,    -1,
     303,    -1,   307,    -1,   310,    -1,   311,    -1,   312,    -1,
     313,    -1,   315,    -1,   314,    -1,   316,    -1,   319,    -1,
     320,    -1,   323,    -1,   322,    -1,   324,    -1,   333,    -1,
     334,    -1,   336,    -1,   338,    -1,   339,    -1,   351,    -1,
     352,    -1,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
     363,    -1,   365,    -1,   367,    -1,   368,    -1,   370,    -1,
     371,    -1,   372,    -1,   373,    -1,   374,    -1,   375,    -1,
     376,    -1,   377,    -1,   382,    -1,   383,    -1,   386,    -1,
     387,    -1,   390,    -1,   393,    -1,   396,    -1,   399,    -1,
     402,    -1,   403,    -1,   408,    -1,   410,    -1,   411,    -1,
     413,    -1,   414,    -1,   415,    -1,   418,    -1,   424,    -1,
     423,    -1,   425,    -1,   434,    -1,   428,    -1,   432,    -1,
     437,    -1,   438,    -1,   446,    -1,   445,    -1,   448,    -1,
     451,    -1,   455,    -1,   459,    -1,   461,    -1,   462,    -1,
     463,    -1,   467,    -1,   468,    -1,   470,    -1,   471,    -1,
     473,    -1,   474,    -1,   477,    -1,   487,    -1,   489,    -1,
     478,    -1,   479,    -1,   480,    -1,   481,    -1,   493,    -1,
     494,    -1,   495,    -1,   175,    -1,   498,    -1,   499,    -1,
     507,    -1,   510,    -1,   514,    -1,   515,    -1,   526,    -1,
     529,    -1,   523,    -1,   530,    -1,   531,    -1,   536,    -1,
     538,    -1,   543,    -1,    -1,   426,  1119,  1118,  1120,    -1,
      -1,   342,    -1,  1121,    -1,  1120,   562,  1121,    -1,    -1,
    1122,  1127,    -1,  1124,    -1,   187,    -1,   252,    -1,   425,
      -1,    -1,   338,    -1,    -1,   187,    -1,   252,    -1,   425,
      -1,    -1,   187,   567,    -1,   252,   567,    -1,   425,   567,
      -1,  1128,    -1,  1124,  1129,    -1,  1123,  1130,  1003,  1133,
      -1,  1123,   487,   227,   244,  1131,    -1,   566,  1113,  1003,
     858,    -1,   566,   566,  1126,  1130,  1003,  1133,    -1,   734,
     739,    -1,   314,  1003,   858,    -1,   314,   736,   741,    -1,
     353,  1003,  1132,    -1,   353,   168,  1114,  1003,  1132,    -1,
    1111,    -1,  1111,   567,  1111,    -1,   108,   567,  1111,    -1,
     380,   498,    -1,   380,    68,    -1,   393,   380,    -1,   423,
      -1,   476,    -1,   353,   560,   476,   561,    -1,   336,   560,
     476,   561,    -1,   858,    -1,   108,    -1,   337,    -1,    12,
      -1,    32,    -1,    -1,   256,  1136,  1135,  1137,    -1,   472,
      -1,   470,    -1,  1138,    -1,  1137,   562,  1138,    -1,  1105,
     937,  1139,    -1,   380,    -1,   537,    -1,   264,   537,    -1,
     380,   252,    -1,    -1,   508,  1141,  1136,    -1,   195,  1105,
     340,   937,    -1,   195,  1106,    60,    -1,    -1,   195,  1106,
     380,  1143,  1144,   939,   956,    -1,  1145,    -1,  1111,  1146,
      -1,   160,    -1,   323,    -1,   160,    -1,   323,    -1,   363,
      -1,   237,    -1,    -1,  1148,  1147,   560,  1008,   561,    -1,
     142,    -1,   180,    -1,   238,    -1,   194,    -1,   265,    -1,
     405,   595,  1150,    -1,  1154,   337,  1153,  1165,   171,  1167,
      -1,  1154,   337,   175,  1165,   171,  1167,    -1,  1154,   337,
     366,  1165,   171,  1167,    -1,    12,  1155,   562,   188,   342,
     171,  1167,    -1,   188,   595,  1152,    -1,  1154,   337,  1153,
    1165,   485,  1167,  1172,  1173,    -1,  1154,   337,   175,  1165,
     485,  1167,  1172,  1173,    -1,  1154,   337,   366,  1165,   485,
    1167,  1172,  1173,    -1,    -1,   472,    -1,  1156,    -1,    12,
    1155,    -1,    -1,   365,    -1,  1157,    -1,  1156,   562,  1157,
      -1,    -1,   420,  1158,  1169,    -1,    -1,   219,  1159,  1169,
      -1,    -1,   511,  1160,  1169,    -1,    -1,   384,  1161,  1169,
      -1,   112,    -1,   513,    -1,   213,    -1,    13,    -1,    84,
      -1,   126,    -1,   148,    -1,   390,    -1,   432,    -1,   367,
      -1,   159,    -1,   188,   342,    -1,   431,    92,    -1,   467,
      -1,    84,   473,   470,    -1,   256,   470,    -1,   396,   435,
      -1,   396,    59,    -1,    84,   529,    -1,   431,   529,    -1,
      84,   410,    -1,    13,   410,    -1,    84,   514,    -1,    -1,
      16,    -1,  1164,  1162,  1163,    -1,  1164,    -1,   463,   476,
      -1,   228,   476,    -1,    58,   476,    -1,   554,    -1,  1111,
     567,   554,    -1,   554,   567,   554,    -1,  1105,    -1,  1114,
      -1,  1166,   562,  1114,    -1,  1168,    -1,  1167,   562,  1168,
      -1,  1114,   207,    44,   476,    -1,  1114,   207,    44,   353,
     476,    -1,  1114,    -1,    -1,   560,  1170,   561,    -1,  1170,
     562,  1171,    -1,  1171,    -1,  1111,    -1,    -1,   397,  1163,
      -1,   397,   452,    -1,   397,   538,    -1,   397,   324,    -1,
      -1,   535,  1174,    -1,  1174,  1175,    -1,  1175,    -1,   188,
     342,    -1,   285,   961,    -1,   288,   961,    -1,   284,   961,
      -1,   289,   961,    -1,    -1,    28,  1177,  1178,    -1,    -1,
     536,    -1,    -1,    16,   328,    51,    -1,    16,    51,    -1,
      -1,   389,    -1,   328,   389,    -1,    -1,   416,    -1,    69,
    1178,  1179,  1180,    -1,   407,  1178,  1179,  1180,    -1,   407,
    1178,   485,  1181,  1111,    -1,   416,  1111,    -1,   389,   416,
    1111,    -1,    -1,  1187,    -1,    -1,   503,  1193,  1188,   838,
      -1,    -1,  1187,    -1,  1190,    -1,    -1,  1191,  1192,    -1,
     951,   955,    -1,   957,    -1,    -1,   122,    -1,    12,    -1,
      -1,   420,  1196,   840,  1194,  1197,    -1,   560,  1196,   839,
    1194,  1197,   561,    -1,    -1,    -1,  1203,  1199,    -1,  1202,
    1200,    -1,  1204,  1201,  1209,    -1,  1209,    -1,  1217,    -1,
    1226,    -1,  1220,    -1,  1209,    -1,  1217,    -1,  1226,    -1,
    1220,    -1,  1219,    -1,  1202,    -1,  1203,    -1,    -1,   109,
     142,  1114,    -1,  1205,    -1,  1205,  1206,    -1,  1206,    -1,
     347,   395,    -1,    11,   142,   499,    -1,    11,   142,   294,
      -1,    11,   142,   474,    -1,    -1,  1206,    -1,    -1,   450,
     419,   109,    -1,   450,   419,   224,    -1,    -1,  1208,   529,
    1105,  1210,  1211,    18,  1213,  1216,    -1,    -1,   560,  1212,
     561,    -1,  1111,    -1,  1212,   562,  1111,    -1,    -1,  1214,
    1215,    -1,   420,   853,   840,    -1,   560,   853,   839,   561,
    1189,    -1,    -1,   535,    57,   342,    -1,   535,    49,    57,
     342,    -1,   535,   252,    57,   342,    -1,    -1,   488,   853,
     596,   672,   673,   337,   853,  1105,   168,   853,   131,   414,
    1218,   631,    -1,    10,   853,   175,  1111,   403,   702,   496,
    1108,    -1,   853,   175,  1111,   403,   702,   496,  1108,    -1,
      -1,    -1,    -1,    -1,    -1,   853,   175,   596,   560,  1221,
     607,   561,  1222,   403,  1223,   713,  1224,   598,  1225,   631,
      -1,    -1,    -1,    -1,    -1,   366,   853,   596,  1227,   560,
    1228,   611,   561,  1229,   598,  1230,   631,    -1,   539,  1233,
    1232,  1234,    -1,   539,   138,  1232,  1236,    -1,   539,   362,
    1232,    -1,   539,    69,  1232,  1235,    -1,   539,   407,  1232,
      -1,   539,   382,    -1,  1093,    -1,  1093,   562,  1093,    -1,
    1093,   562,  1093,   562,   961,    -1,    28,    -1,   454,    -1,
      -1,   230,    -1,   402,    -1,    -1,   339,   355,    -1,    -1,
      -1,   468,  1237,  1238,    -1,    -1,   168,   296,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1206,  1206,  1220,  1223,  1224,  1229,  1230,  1231,  1232,
    1233,  1234,  1235,  1236,  1237,  1238,  1239,  1240,  1241,  1242,
    1243,  1244,  1245,  1246,  1247,  1248,  1249,  1250,  1251,  1252,
    1253,  1254,  1255,  1256,  1257,  1258,  1259,  1260,  1261,  1262,
    1263,  1264,  1265,  1266,  1267,  1268,  1269,  1270,  1271,  1272,
    1273,  1274,  1275,  1279,  1288,  1289,  1294,  1303,  1310,  1320,
    1319,  1330,  1332,  1336,  1337,  1340,  1353,  1352,  1371,  1370,
    1381,  1382,  1385,  1390,  1395,  1400,  1405,  1409,  1414,  1418,
    1422,  1426,  1430,  1435,  1439,  1443,  1459,  1463,  1475,  1474,
    1494,  1493,  1514,  1513,  1526,  1525,  1533,  1541,  1555,  1570,
    1589,  1590,  1594,  1595,  1600,  1602,  1604,  1606,  1608,  1610,
    1612,  1618,  1619,  1620,  1624,  1628,  1636,  1635,  1648,  1650,
    1653,  1655,  1659,  1663,  1670,  1672,  1676,  1677,  1682,  1701,
    1727,  1729,  1733,  1734,  1738,  1764,  1765,  1766,  1767,  1771,
    1772,  1776,  1777,  1782,  1785,  1812,  1811,  1872,  1887,  1886,
    1933,  1959,  1959,  1991,  1992,  1997,  1999,  2004,  2027,  2033,
    2048,  2049,  2053,  2057,  2066,  2071,  2076,  2084,  2099,  2117,
    2118,  2122,  2122,  2174,  2173,  2202,  2201,  2205,  2206,  2208,
    2208,  2219,  2221,  2223,  2273,  2313,  2331,  2330,  2349,  2368,
    2370,  2371,  2375,  2396,  2419,  2424,  2439,  2419,  2458,  2460,
    2461,  2465,  2466,  2471,  2478,  2470,  2497,  2496,  2512,  2513,
    2517,  2518,  2523,  2528,  2522,  2545,  2550,  2544,  2565,  2575,
    2580,  2579,  2615,  2616,  2621,  2620,  2653,  2653,  2668,  2667,
    2704,  2716,  2721,  2715,  2747,  2746,  2769,  2771,  2776,  2778,
    2780,  2785,  2786,  2787,  2793,  2802,  2803,  2803,  2807,  2809,
    2808,  2811,  2810,  2816,  2832,  2815,  2846,  2847,  2850,  2851,
    2854,  2855,  2858,  2859,  2862,  2863,  2866,  2867,  2870,  2873,
    2874,  2876,  2878,  2881,  2882,  2885,  2886,  2887,  2890,  2891,
    2892,  2893,  2894,  2895,  2896,  2897,  2898,  2913,  2919,  2920,
    2921,  2922,  2927,  2932,  2937,  2952,  2953,  2954,  2955,  2956,
    2957,  2961,  2978,  2994,  3004,  3005,  3006,  3007,  3008,  3009,
    3012,  3013,  3014,  3017,  3018,  3019,  3022,  3023,  3026,  3027,
    3028,  3029,  3032,  3033,  3037,  3038,  3042,  3043,  3050,  3058,
    3066,  3083,  3087,  3093,  3095,  3099,  3103,  3104,  3108,  3113,
    3112,  3134,  3135,  3136,  3137,  3139,  3141,  3143,  3145,  3147,
    3149,  3152,  3155,  3158,  3161,  3163,  3166,  3169,  3170,  3171,
    3172,  3185,  3186,  3188,  3190,  3202,  3204,  3206,  3208,  3209,
    3210,  3211,  3212,  3213,  3215,  3217,  3219,  3219,  3221,  3221,
    3223,  3224,  3233,  3234,  3235,  3238,  3239,  3240,  3241,  3242,
    3246,  3250,  3251,  3255,  3256,  3260,  3261,  3262,  3263,  3264,
    3268,  3269,  3270,  3271,  3272,  3275,  3277,  3278,  3282,  3283,
    3284,  3287,  3294,  3295,  3298,  3299,  3302,  3303,  3304,  3307,
    3308,  3311,  3312,  3315,  3316,  3319,  3320,  3323,  3324,  3325,
    3326,  3328,  3329,  3335,  3341,  3347,  3353,  3354,  3370,  3371,
    3375,  3376,  3380,  3388,  3392,  3393,  3396,  3397,  3401,  3410,
    3414,  3415,  3418,  3428,  3429,  3433,  3434,  3437,  3438,  3441,
    3442,  3443,  3444,  3453,  3454,  3457,  3458,  3461,  3462,  3463,
    3472,  3474,  3476,  3481,  3480,  3492,  3493,  3496,  3497,  3501,
    3502,  3505,  3506,  3509,  3510,  3511,  3512,  3513,  3516,  3517,
    3518,  3519,  3520,  3523,  3524,  3525,  3537,  3538,  3541,  3542,
    3545,  3546,  3550,  3551,  3552,  3555,  3556,  3557,  3558,  3571,
    3572,  3573,  3576,  3577,  3581,  3584,  3585,  3588,  3589,  3600,
    3601,  3604,  3605,  3608,  3609,  3617,  3616,  3640,  3639,  3653,
    3652,  3671,  3670,  3690,  3688,  3708,  3709,  3711,  3712,  3713,
    3714,  3715,  3718,  3726,  3727,  3731,  3736,  3735,  3743,  3752,
    3742,  3764,  3771,  3775,  3782,  3789,  3795,  3801,  3807,  3814,
    3832,  3853,  3858,  3862,  3869,  3870,  3873,  3874,  3878,  3879,
    3880,  3884,  3885,  3886,  3889,  3890,  3891,  3892,  3900,  3899,
    3910,  3918,  3917,  3927,  3937,  3946,  3947,  3954,  3954,  3960,
    3961,  3965,  3966,  3967,  3971,  3972,  3989,  3990,  3995,  3994,
    4005,  4004,  4015,  4014,  4024,  4025,  4026,  4031,  4030,  4042,
    4043,  4046,  4047,  4050,  4051,  4052,  4056,  4055,  4068,  4067,
    4084,  4085,  4088,  4089,  4092,  4093,  4094,  4095,  4096,  4097,
    4101,  4100,  4112,  4113,  4114,  4119,  4118,  4124,  4131,  4136,
    4144,  4145,  4148,  4160,  4169,  4170,  4173,  4186,  4187,  4192,
    4191,  4201,  4202,  4205,  4218,  4218,  4228,  4229,  4238,  4239,
    4248,  4257,  4259,  4262,  4292,  4296,  4295,  4317,  4325,  4317,
    4331,  4332,  4333,  4334,  4335,  4338,  4345,  4352,  4354,  4365,
    4366,  4369,  4370,  4376,  4377,  4378,  4379,  4385,  4391,  4397,
    4411,  4414,  4416,  4422,  4432,  4433,  4434,  4447,  4473,  4480,
    4487,  4488,  4491,  4492,  4493,  4494,  4495,  4499,  4500,  4504,
    4553,  4558,  4599,  4601,  4603,  4605,  4607,  4609,  4611,  4613,
    4617,  4619,  4621,  4623,  4625,  4627,  4630,  4634,  4640,  4644,
    4650,  4654,  4664,  4666,  4672,  4675,  4677,  4679,  4680,  4682,
    4685,  4687,  4689,  4691,  4693,  4695,  4697,  4699,  4701,  4703,
    4705,  4707,  4709,  4711,  4713,  4716,  4716,  4717,  4717,  4718,
    4718,  4719,  4719,  4721,  4722,  4723,  4724,  4725,  4726,  4729,
    4730,  4734,  4739,  4740,  4747,  4748,  4749,  4750,  4751,  4753,
    4754,  4755,  4756,  4757,  4761,  4762,  4767,  4772,  4776,  4777,
    4781,  4782,  4786,  4793,  4795,  4801,  4803,  4814,  4816,  4827,
    4838,  4849,  4860,  4862,  4864,  4866,  4868,  4870,  4872,  4874,
    4876,  4878,  4880,  4882,  4884,  4890,  4892,  4894,  4899,  4904,
    4906,  4908,  4913,  4915,  4917,  4919,  4921,  4926,  4927,  4929,
    4931,  4933,  4935,  4937,  4939,  4941,  4943,  4945,  4947,  4949,
    4953,  4955,  4965,  4967,  4969,  4971,  4973,  4976,  4985,  4990,
    4995,  4997,  4999,  5001,  5003,  5005,  5007,  5009,  5014,  5019,
    5021,  5023,  5025,  5027,  5029,  5031,  5037,  5039,  5041,  5043,
    5045,  5047,  5049,  5051,  5053,  5054,  5059,  5061,  5063,  5065,
    5067,  5069,  5071,  5073,  5075,  5082,  5089,  5091,  5093,  5095,
    5097,  5099,  5101,  5103,  5105,  5107,  5109,  5111,  5113,  5115,
    5117,  5132,  5131,  5271,  5275,  5280,  5282,  5284,  5286,  5288,
    5290,  5295,  5297,  5299,  5301,  5303,  5308,  5312,  5314,  5316,
    5318,  5320,  5322,  5326,  5329,  5332,  5334,  5336,  5338,  5340,
    5342,  5344,  5347,  5350,  5352,  5354,  5356,  5358,  5360,  5363,
    5365,  5367,  5369,  5374,  5375,  5376,  5380,  5381,  5385,  5385,
    5391,  5395,  5402,  5433,  5435,  5437,  5439,  5441,  5443,  5445,
    5448,  5450,  5447,  5453,  5455,  5462,  5464,  5466,  5468,  5470,
    5472,  5474,  5476,  5478,  5481,  5480,  5495,  5494,  5509,  5515,
    5521,  5534,  5535,  5539,  5542,  5547,  5550,  5562,  5561,  5577,
    5578,  5579,  5580,  5581,  5582,  5583,  5584,  5585,  5586,  5587,
    5591,  5592,  5596,  5596,  5601,  5602,  5605,  5606,  5609,  5609,
    5614,  5615,  5618,  5619,  5622,  5623,  5626,  5632,  5642,  5643,
    5652,  5657,  5658,  5678,  5680,  5684,  5682,  5699,  5697,  5715,
    5713,  5720,  5729,  5727,  5745,  5744,  5754,  5765,  5763,  5782,
    5781,  5792,  5802,  5803,  5804,  5809,  5809,  5828,  5826,  5845,
    5867,  5915,  5914,  5937,  5955,  5937,  5962,  5966,  5992,  5993,
    5995,  5997,  6000,  6001,  6007,  6014,  6023,  6022,  6029,  6030,
    6034,  6038,  6042,  6048,  6056,  6065,  6066,  6067,  6068,  6069,
    6070,  6071,  6072,  6073,  6074,  6075,  6076,  6079,  6080,  6099,
    6100,  6101,  6102,  6103,  6104,  6105,  6106,  6107,  6111,  6112,
    6113,  6114,  6117,  6119,  6120,  6123,  6124,  6127,  6129,  6133,
    6135,  6134,  6148,  6151,  6150,  6165,  6171,  6184,  6186,  6189,
    6191,  6195,  6196,  6209,  6227,  6231,  6232,  6236,  6249,  6251,
    6255,  6254,  6287,  6289,  6293,  6294,  6295,  6300,  6306,  6310,
    6311,  6315,  6319,  6326,  6333,  6342,  6346,  6347,  6348,  6353,
    6357,  6365,  6366,  6367,  6368,  6369,  6370,  6374,  6375,  6376,
    6377,  6378,  6381,  6384,  6383,  6412,  6413,  6416,  6417,  6420,
    6435,  6435,  6446,  6447,  6451,  6463,  6496,  6495,  6508,  6507,
    6516,  6528,  6539,  6538,  6555,  6562,  6562,  6574,  6581,  6597,
    6616,  6628,  6632,  6638,  6648,  6649,  6652,  6660,  6661,  6665,
    6666,  6674,  6683,  6673,  6693,  6700,  6692,  6710,  6722,  6723,
    6724,  6728,  6729,  6732,  6733,  6736,  6745,  6746,  6747,  6749,
    6748,  6758,  6759,  6762,  6763,  6764,  6764,  6765,  6765,  6769,
    6770,  6773,  6775,  6778,  6786,  6787,  6791,  6792,  6797,  6796,
    6809,  6810,  6813,  6818,  6826,  6827,  6830,  6832,  6832,  6840,
    6849,  6839,  6871,  6872,  6875,  6882,  6883,  6886,  6895,  6896,
    6902,  6901,  6915,  6914,  6923,  6922,  6930,  6929,  6939,  6940,
    6943,  6950,  6963,  6964,  6968,  6969,  6972,  6973,  6974,  6977,
    6987,  6989,  6994,  6993,  7007,  7015,  7024,  7033,  7042,  7052,
    7051,  7054,  7064,  7074,  7078,  7083,  7082,  7087,  7097,  7102,
    7108,  7113,  7118,  7120,  7122,  7124,  7126,  7135,  7137,  7139,
    7141,  7150,  7158,  7166,  7168,  7170,  7180,  7187,  7193,  7201,
    7209,  7213,  7217,  7224,  7231,  7241,  7251,  7261,  7274,  7288,
    7301,  7302,  7304,  7306,  7309,  7310,  7313,  7314,  7317,  7318,
    7321,  7322,  7325,  7326,  7328,  7330,  7333,  7345,  7344,  7359,
    7358,  7368,  7369,  7372,  7373,  7377,  7378,  7379,  7387,  7386,
    7398,  7399,  7402,  7402,  7403,  7404,  7405,  7406,  7407,  7408,
    7409,  7410,  7411,  7412,  7415,  7416,  7420,  7419,  7428,  7429,
    7432,  7433,  7434,  7438,  7437,  7447,  7451,  7455,  7467,  7467,
    7475,  7476,  7477,  7482,  7492,  7491,  7507,  7525,  7536,  7543,
    7553,  7524,  7558,  7567,  7568,  7571,  7572,  7584,  7588,  7589,
    7590,  7592,  7594,  7597,  7598,  7601,  7606,  7613,  7618,  7624,
    7626,  7629,  7630,  7633,  7638,  7644,  7646,  7653,  7654,  7655,
    7658,  7660,  7665,  7666,  7671,  7672,  7678,  7696,  7704,  7709,
    7728,  7730,  7741,  7754,  7775,  7776,  7777,  7786,  7787,  7788,
    7793,  7794,  7795,  7796,  7797,  7817,  7836,  7837,  7838,  7841,
    7842,  7843,  7844,  7852,  7867,  7868,  7871,  7877,  7888,  7891,
    7928,  7932,  7940,  7944,  8012,  8027,  8051,  8052,  8068,  8078,
    8081,  8082,  8083,  8087,  8091,  8092,  8117,  8129,  8142,  8154,
    8155,  8164,  8165,  8174,  8175,  8176,  8179,  8192,  8205,  8219,
    8220,  8221,  8222,  8223,  8224,  8225,  8226,  8227,  8228,  8229,
    8230,  8231,  8232,  8233,  8234,  8235,  8236,  8237,  8238,  8239,
    8240,  8241,  8242,  8243,  8244,  8245,  8246,  8247,  8248,  8249,
    8250,  8251,  8252,  8253,  8254,  8255,  8265,  8266,  8267,  8268,
    8269,  8270,  8271,  8272,  8273,  8274,  8275,  8276,  8277,  8278,
    8279,  8280,  8281,  8282,  8283,  8284,  8285,  8286,  8287,  8288,
    8289,  8290,  8291,  8292,  8293,  8294,  8295,  8296,  8297,  8298,
    8299,  8300,  8301,  8302,  8303,  8304,  8305,  8306,  8307,  8308,
    8309,  8310,  8311,  8312,  8313,  8314,  8315,  8316,  8317,  8318,
    8319,  8320,  8321,  8322,  8323,  8324,  8325,  8326,  8327,  8328,
    8329,  8330,  8331,  8332,  8333,  8334,  8335,  8336,  8337,  8338,
    8339,  8340,  8341,  8342,  8343,  8344,  8345,  8346,  8347,  8348,
    8349,  8350,  8351,  8352,  8353,  8354,  8355,  8356,  8357,  8358,
    8359,  8360,  8361,  8362,  8363,  8364,  8365,  8366,  8367,  8368,
    8369,  8370,  8371,  8372,  8373,  8374,  8375,  8376,  8377,  8378,
    8379,  8380,  8381,  8382,  8383,  8384,  8385,  8386,  8387,  8388,
    8389,  8390,  8391,  8392,  8393,  8394,  8395,  8396,  8397,  8398,
    8399,  8400,  8401,  8402,  8403,  8404,  8405,  8406,  8407,  8408,
    8409,  8410,  8411,  8412,  8413,  8414,  8415,  8416,  8417,  8418,
    8419,  8420,  8421,  8422,  8423,  8424,  8425,  8426,  8427,  8428,
    8429,  8430,  8431,  8432,  8433,  8434,  8435,  8436,  8437,  8438,
    8439,  8440,  8441,  8442,  8443,  8444,  8445,  8446,  8447,  8448,
    8449,  8450,  8451,  8452,  8453,  8454,  8455,  8456,  8457,  8458,
    8459,  8460,  8461,  8462,  8463,  8464,  8465,  8466,  8467,  8468,
    8469,  8470,  8471,  8472,  8473,  8474,  8475,  8476,  8477,  8484,
    8483,  8497,  8498,  8501,  8502,  8505,  8505,  8583,  8584,  8585,
    8586,  8590,  8591,  8595,  8596,  8597,  8598,  8602,  8603,  8604,
    8605,  8609,  8610,  8613,  8695,  8708,  8712,  8717,  8724,  8739,
    8752,  8773,  8780,  8818,  8861,  8875,  8876,  8877,  8878,  8882,
    8883,  8890,  8899,  8900,  8901,  8902,  8903,  8911,  8910,  8926,
    8927,  8930,  8931,  8934,  8942,  8943,  8944,  8945,  8950,  8949,
    8970,  8982,  8995,  8994,  9013,  9014,  9018,  9019,  9023,  9024,
    9025,  9026,  9028,  9027,  9038,  9039,  9040,  9041,  9042,  9048,
    9053,  9060,  9073,  9085,  9092,  9097,  9105,  9118,  9132,  9134,
    9137,  9138,  9145,  9147,  9151,  9152,  9155,  9155,  9156,  9156,
    9157,  9157,  9158,  9158,  9159,  9160,  9161,  9162,  9163,  9164,
    9165,  9166,  9167,  9168,  9169,  9170,  9171,  9172,  9173,  9174,
    9175,  9176,  9177,  9178,  9179,  9180,  9181,  9186,  9187,  9191,
    9192,  9196,  9206,  9216,  9229,  9243,  9256,  9269,  9282,  9283,
    9292,  9293,  9302,  9327,  9329,  9336,  9340,  9343,  9344,  9347,
    9368,  9369,  9373,  9377,  9381,  9388,  9389,  9392,  9393,  9397,
    9398,  9404,  9410,  9416,  9426,  9425,  9435,  9436,  9440,  9441,
    9442,  9446,  9447,  9448,  9452,  9453,  9457,  9467,  9474,  9484,
    9493,  9507,  9508,  9513,  9512,  9553,  9554,  9555,  9559,  9559,
    9583,  9584,  9588,  9589,  9590,  9594,  9599,  9604,  9611,  9632,
    9654,  9656,  9658,  9663,  9664,  9665,  9666,  9670,  9671,  9672,
    9673,  9674,  9684,  9685,  9690,  9703,  9716,  9718,  9720,  9725,
    9730,  9732,  9734,  9740,  9741,  9747,  9748,  9750,  9756,  9755,
    9770,  9771,  9775,  9780,  9788,  9788,  9806,  9815,  9828,  9829,
    9831,  9833,  9846,  9844,  9920,  9931,  9949,  9983,  9991,  9999,
   10011,  9945, 10044, 10075, 10084, 10093, 10043, 10117, 10121, 10125,
   10129, 10133, 10137, 10143, 10150, 10157, 10166, 10167, 10171, 10172,
   10173, 10177, 10178, 10182, 10183, 10183, 10188, 10189
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM", "BY",
  "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED", "CAST_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM", "CHECKSUM_SYM",
  "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM", "COALESCE",
  "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS", "COLUMN_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT", "CONTAINS_SYM",
  "CONTINUE_SYM", "CONVERT_SYM", "CONVERT_TZ_SYM", "COUNT_SYM", "CREATE",
  "CROSS", "CUBE_SYM", "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FETCH_SYM", "FIELD_FUNC", "FILE_SYM",
  "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM",
  "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM", "FOUND_SYM",
  "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL", "FULLTEXT_SYM",
  "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2", "FUNC_ARG3", "GE",
  "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GEOMFROMTEXT",
  "GEOMFROMWKB", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS",
  "GREATEST_SYM", "GROUP", "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS",
  "GT_SYM", "HANDLER_SYM", "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM",
  "HIGH_PRIORITY", "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM", "LANGUAGE_SYM",
  "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING", "LEAST_SYM", "LEAVES",
  "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT",
  "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD", "LOCAL_SYM", "LOCATE",
  "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGS_SYM", "LOG_SYM",
  "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MAKE_SET_SYM", "MASTER_CONNECT_RETRY_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_POS_WAIT",
  "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM",
  "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MERGE_SYM",
  "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM", "QUICK",
  "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE", "RAID_STRIPED_SYM",
  "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL", "RECOVER_SYM",
  "REDUNDANT_SYM", "REFERENCES", "REGEXP", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD", "RENAME",
  "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE", "REPLICATION",
  "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT",
  "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE",
  "SMALLINT", "SNAPSHOT_SYM", "SOUNDS_SYM", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT",
  "SQL_BUFFER_RESULT", "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS",
  "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD",
  "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM", "STD_SYM",
  "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "TIMESTAMP", "TIMESTAMP_ADD",
  "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB", "TINYINT", "TINYTEXT",
  "TO_SYM", "TRAILING", "TRANSACTION_SYM", "TRIGGER_SYM", "TRIGGERS_SYM",
  "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM",
  "UDF_RETURNS_SYM", "UDF_SONAME_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM",
  "UNDEFINED_SYM", "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM",
  "UNION_SYM", "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP",
  "UNKNOWN_SYM", "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM",
  "UPGRADE_SYM", "USAGE", "USER", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM",
  "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES",
  "VARIANCE_SYM", "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM",
  "WHEN_SYM", "WHERE", "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM",
  "X509_SYM", "XA_SYM", "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM",
  "ZEROFILL", "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM",
  "BETWEEN_SYM", "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'",
  "'~'", "NEG", "'('", "')'", "','", "'!'", "'{'", "'}'", "'@'", "'.'",
  "';'", "':'", "$accept", "query", "verb_clause", "statement",
  "deallocate", "deallocate_or_drop", "prepare", "prepare_src", "execute",
  "@1", "execute_using", "execute_var_list", "execute_var_ident", "help",
  "@2", "change", "@3", "master_defs", "master_def", "master_file_def",
  "create", "@4", "@5", "@6", "@7", "clear_privileges", "sp_name",
  "sp_a_chistics", "sp_c_chistics", "sp_chistic", "sp_c_chistic",
  "sp_suid", "call", "@8", "opt_sp_cparam_list", "opt_sp_cparams",
  "sp_cparams", "sp_fdparam_list", "sp_fdparams", "sp_init_param",
  "sp_fdparam", "sp_pdparam_list", "sp_pdparams", "sp_pdparam",
  "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1", "sp_decls", "sp_decl",
  "@9", "@10", "sp_cursor_stmt", "@11", "sp_handler_type", "sp_hcond_list",
  "sp_hcond_element", "sp_cond", "opt_value", "sp_hcond", "sp_decl_idents",
  "sp_opt_default", "sp_proc_stmt", "@12", "@13", "@14", "@15", "@16",
  "sp_opt_fetch_noise", "sp_fetch_list", "sp_if", "@17", "@18", "@19",
  "sp_elseifs", "case_stmt_specification", "simple_case_stmt", "@20",
  "@21", "searched_case_stmt", "@22", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "@23", "@24",
  "searched_when_clause", "@25", "@26", "else_clause_opt",
  "sp_labeled_control", "@27", "sp_opt_label", "sp_labeled_block", "@28",
  "sp_unlabeled_block", "@29", "sp_block_content", "@30",
  "sp_unlabeled_control", "@31", "@32", "@33", "trg_action_time",
  "trg_event", "create2", "create2a", "@34", "create3", "@35", "@36",
  "create_select", "@37", "@38", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_type", "field_list",
  "field_list_item", "column_def", "key_def", "opt_check_constraint",
  "check_constraint", "opt_constraint", "constraint", "field_spec", "@39",
  "type", "@40", "@41", "spatial_type", "char", "nchar", "varchar",
  "nvarchar", "int_type", "real_type", "float_options", "precision",
  "field_options", "field_opt_list", "field_option", "opt_len",
  "opt_precision", "opt_attribute", "opt_attribute_list", "attribute",
  "now_or_signed_literal", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@42", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_component", "string_list", "alter", "@43", "@44", "@45", "@46",
  "@47", "ident_or_empty", "alter_list", "add_column", "alter_list_item",
  "@48", "@49", "@50", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "@51", "@52", "start",
  "start_transaction_opts", "slave_thread_opts", "@53",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@54", "backup", "@55", "checksum", "@56",
  "opt_checksum_type", "repair", "@57", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@58", "check", "@59",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@60", "opt_no_write_to_binlog", "rename", "@61", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@62", "preload_list",
  "preload_keys", "cache_keys_spec", "@63", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@64", "select_part2", "@65", "@66", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "bool_pri", "predicate", "bit_expr", "or", "and", "not", "not2",
  "comp_op", "all_or_any", "interval_expr", "simple_expr", "@67",
  "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@68", "udf_expr_list3", "udf_expr", "sum_expr", "@69",
  "@70", "@71", "variable", "@72", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@73",
  "cast_type", "opt_expr_list", "expr_list", "@74", "expr_list2",
  "ident_list_arg", "ident_list", "@75", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@76", "@77", "@78", "@79", "@80",
  "@81", "@82", "normal_join", "table_factor", "@83", "@84",
  "select_derived", "@85", "select_derived2", "@86", "@87",
  "get_select_lex", "select_derived_init", "opt_outer", "opt_for_join",
  "opt_key_definition", "key_usage_list", "@88", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_stamp",
  "interval_time_st", "date_time_type", "table_alias", "opt_table_alias",
  "opt_all", "where_clause", "@89", "having_clause", "@90", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@91", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@92", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@93",
  "select_var_list", "select_var_ident", "into", "@94", "into_destination",
  "@95", "do", "@96", "drop", "@97", "table_list", "table_name",
  "if_exists", "opt_temporary", "insert", "@98", "@99", "replace", "@100",
  "@101", "insert_lock_option", "replace_lock_option", "insert2",
  "insert_table", "insert_field_spec", "@102", "fields", "insert_values",
  "@103", "@104", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "@105", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@106", "update", "@107", "@108",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@109", "single_multi", "@110", "@111",
  "@112", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "show", "@113", "show_param", "@114", "@115", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@116", "@117",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@118", "flush_options", "flush_option", "@119",
  "opt_table_list", "reset", "@120", "reset_options", "reset_option",
  "purge", "@121", "purge_options", "purge_option", "kill", "@122",
  "kill_option", "use", "load", "@123", "load_data", "@124", "@125",
  "@126", "@127", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "@128", "opt_option", "option_value_list", "option_type_value",
  "@129", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "@130",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "@131", "handler", "@132", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "@133",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "@134", "@135", "@136",
  "@137", "opt_and", "require_list", "require_list_element", "grant_ident",
  "user_list", "grant_list", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "grant_option_list", "grant_option", "begin", "@138", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "@139",
  "union_opt", "union_order_or_limit", "@140", "order_or_limit",
  "union_option", "take_first_select", "subselect", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "definer_tail",
  "no_definer_tail", "definer_opt", "no_definer", "definer",
  "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@141", "view_list_opt",
  "view_list", "view_select", "@142", "view_select_aux",
  "view_check_option", "trigger_tail", "@143", "udf_tail", "sf_tail",
  "@144", "@145", "@146", "@147", "@148", "sp_tail", "@149", "@150",
  "@151", "@152", "xa", "xid", "begin_or_start", "opt_join_or_resume",
  "opt_one_phase", "opt_suspend", "@153", "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     124,    38,    45,    43,    42,    47,    37,    94,   126,   805,
      40,    41,    44,    33,   123,   125,    64,    46,    59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   570,   571,   571,   572,   572,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   574,   575,   575,   576,   577,   577,   579,
     578,   580,   580,   581,   581,   582,   584,   583,   586,   585,
     587,   587,   588,   588,   588,   588,   588,   588,   588,   588,
     588,   588,   588,   588,   589,   589,   589,   589,   591,   590,
     592,   590,   593,   590,   594,   590,   590,   595,   596,   596,
     597,   597,   598,   598,   599,   599,   599,   599,   599,   599,
     599,   600,   600,   600,   601,   601,   603,   602,   604,   604,
     605,   605,   606,   606,   607,   607,   608,   608,   609,   610,
     611,   611,   612,   612,   613,   614,   614,   614,   614,   615,
     615,   616,   616,   617,   617,   619,   618,   618,   620,   618,
     618,   622,   621,   623,   623,   624,   624,   625,   626,   626,
     627,   627,   628,   628,   628,   628,   628,   629,   629,   630,
     630,   632,   631,   633,   631,   634,   631,   631,   631,   635,
     631,   631,   631,   631,   631,   631,   636,   631,   631,   637,
     637,   637,   638,   638,   640,   641,   642,   639,   643,   643,
     643,   644,   644,   646,   647,   645,   649,   648,   650,   650,
     651,   651,   653,   654,   652,   656,   657,   655,   658,   658,
     660,   659,   661,   661,   663,   662,   665,   664,   667,   666,
     668,   669,   670,   668,   671,   668,   672,   672,   673,   673,
     673,   674,   674,   674,   674,   675,   676,   675,   677,   678,
     677,   679,   677,   681,   682,   680,   683,   683,   684,   684,
     685,   685,   686,   686,   687,   687,   688,   688,   689,   690,
     690,   691,   691,   692,   692,   693,   693,   693,   694,   694,
     694,   694,   694,   694,   694,   694,   694,   694,   694,   694,
     694,   694,   694,   694,   694,   694,   694,   694,   694,   694,
     694,   695,   696,   697,   698,   698,   698,   698,   698,   698,
     699,   699,   699,   700,   700,   700,   701,   701,   702,   702,
     702,   702,   703,   703,   704,   704,   705,   705,   706,   706,
     706,   706,   706,   707,   707,   708,   709,   709,   710,   712,
     711,   713,   713,   713,   713,   713,   713,   713,   713,   713,
     713,   713,   713,   713,   713,   713,   713,   713,   713,   713,
     713,   713,   713,   713,   713,   713,   713,   713,   713,   713,
     713,   713,   713,   713,   713,   713,   714,   713,   715,   713,
     713,   713,   716,   716,   716,   716,   716,   716,   716,   716,
     717,   718,   718,   719,   719,   720,   720,   720,   720,   720,
     721,   721,   721,   721,   721,   722,   722,   722,   723,   723,
     723,   724,   725,   725,   726,   726,   727,   727,   727,   728,
     728,   729,   729,   730,   730,   731,   731,   732,   732,   732,
     732,   732,   732,   732,   732,   732,   732,   732,   733,   733,
     734,   734,   735,   735,   736,   736,   737,   737,   738,   738,
     739,   739,   740,   741,   741,   742,   742,   743,   743,   744,
     744,   744,   744,   744,   744,   745,   745,   746,   746,   746,
     746,   747,   747,   749,   748,   750,   750,   751,   751,   752,
     752,   753,   753,   754,   754,   754,   754,   754,   755,   755,
     755,   755,   755,   756,   756,   756,   757,   757,   758,   758,
     759,   759,   760,   760,   760,   761,   761,   761,   761,   762,
     762,   762,   763,   763,   763,   764,   764,   765,   765,   766,
     766,   767,   767,   768,   768,   770,   769,   771,   769,   772,
     769,   773,   769,   774,   769,   775,   775,   776,   776,   776,
     776,   776,   777,   778,   778,   778,   779,   778,   780,   781,
     778,   778,   778,   778,   778,   778,   778,   778,   778,   778,
     778,   778,   778,   778,   782,   782,   783,   783,   784,   784,
     784,   785,   785,   785,   786,   786,   786,   786,   788,   787,
     787,   789,   787,   787,   790,   791,   791,   793,   792,   794,
     794,   795,   795,   795,   796,   796,   797,   797,   799,   798,
     801,   800,   803,   802,   804,   804,   804,   806,   805,   807,
     807,   808,   808,   809,   809,   809,   811,   810,   813,   812,
     814,   814,   815,   815,   816,   816,   816,   816,   816,   816,
     818,   817,   819,   819,   819,   821,   820,   820,   822,   822,
     823,   823,   824,   825,   826,   826,   827,   828,   828,   830,
     829,   831,   831,   832,   834,   833,   835,   835,   836,   836,
     837,   838,   838,   839,   839,   841,   840,   843,   844,   842,
     845,   845,   845,   845,   845,   846,   846,   847,   847,   848,
     848,   849,   849,   849,   849,   849,   849,   849,   849,   849,
     849,   850,   850,   850,   851,   851,   851,   852,   853,   854,
     855,   855,   856,   856,   856,   856,   856,   857,   857,   858,
     858,   858,   858,   858,   858,   858,   858,   858,   858,   858,
     859,   859,   859,   859,   859,   859,   860,   860,   860,   860,
     860,   860,   860,   860,   860,   860,   860,   860,   860,   860,
     861,   861,   861,   861,   861,   861,   861,   861,   861,   861,
     861,   861,   861,   861,   861,   862,   862,   863,   863,   864,
     864,   865,   865,   866,   866,   866,   866,   866,   866,   867,
     867,   868,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   870,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   871,   871,   871,
     871,   871,   871,   871,   871,   871,   871,   871,   871,   871,
     871,   871,   871,   871,   871,   871,   871,   871,   871,   871,
     871,   871,   871,   872,   872,   872,   873,   873,   875,   874,
     876,   876,   877,   878,   878,   878,   878,   878,   878,   878,
     879,   880,   878,   878,   878,   878,   878,   878,   878,   878,
     878,   878,   878,   878,   881,   878,   883,   882,   884,   884,
     884,   885,   885,   886,   886,   887,   887,   889,   888,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     891,   891,   893,   892,   894,   894,   895,   895,   897,   896,
     898,   898,   899,   899,   900,   900,   901,   901,   902,   902,
     903,   904,   904,   905,   905,   906,   905,   907,   905,   908,
     905,   905,   909,   905,   910,   905,   905,   911,   905,   912,
     905,   905,   913,   913,   913,   915,   914,   916,   914,   914,
     914,   918,   917,   920,   921,   919,   922,   923,   924,   924,
     925,   925,   926,   926,   926,   926,   928,   927,   929,   929,
     930,   930,   930,   931,   931,   932,   932,   932,   932,   932,
     932,   932,   932,   932,   932,   932,   932,   933,   933,   934,
     934,   934,   934,   934,   934,   934,   934,   934,   935,   935,
     935,   935,   936,   936,   936,   937,   937,   938,   938,   939,
     940,   939,   941,   942,   941,   943,   943,   944,   944,   945,
     945,   946,   946,   946,   947,   948,   948,   949,   950,   950,
     952,   951,   953,   953,   954,   954,   954,   955,   955,   956,
     956,   957,   958,   958,   958,   959,   959,   959,   959,   960,
     960,   961,   961,   961,   961,   961,   961,   962,   962,   962,
     962,   962,   963,   964,   963,   965,   965,   966,   966,   967,
     969,   968,   970,   970,   971,   971,   973,   972,   975,   974,
     974,   974,   977,   976,   978,   979,   978,   978,   978,   978,
     978,   978,   978,   978,   980,   980,   981,   982,   982,   983,
     983,   985,   986,   984,   988,   989,   987,   990,   990,   990,
     990,   991,   991,   992,   992,   993,   994,   994,   994,   995,
     994,   996,   996,   997,   997,   998,   997,   999,   997,  1000,
    1000,  1001,  1001,  1002,  1003,  1003,  1004,  1004,  1006,  1005,
    1007,  1007,  1008,  1008,  1009,  1009,  1010,  1011,  1010,  1013,
    1014,  1012,  1015,  1015,  1016,  1017,  1017,  1018,  1019,  1019,
    1021,  1020,  1023,  1022,  1024,  1022,  1025,  1022,  1026,  1026,
    1027,  1027,  1028,  1028,  1029,  1029,  1030,  1030,  1030,  1031,
    1032,  1032,  1034,  1033,  1035,  1035,  1035,  1035,  1035,  1036,
    1035,  1035,  1035,  1035,  1035,  1037,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1038,  1038,
    1039,  1039,  1040,  1040,  1041,  1041,  1042,  1042,  1043,  1043,
    1044,  1044,  1045,  1045,  1046,  1046,  1046,  1048,  1047,  1049,
    1047,  1050,  1050,  1051,  1051,  1052,  1052,  1052,  1054,  1053,
    1055,  1055,  1057,  1056,  1056,  1056,  1056,  1056,  1056,  1056,
    1056,  1056,  1056,  1056,  1058,  1058,  1060,  1059,  1061,  1061,
    1062,  1062,  1062,  1064,  1063,  1065,  1066,  1066,  1068,  1067,
    1069,  1069,  1069,  1070,  1072,  1071,  1071,  1074,  1075,  1076,
    1077,  1073,  1073,  1078,  1078,  1079,  1079,  1079,  1080,  1080,
    1080,  1081,  1081,  1082,  1082,  1083,  1083,  1083,  1083,  1084,
    1084,  1085,  1085,  1086,  1086,  1087,  1087,  1088,  1088,  1088,
    1089,  1089,  1090,  1090,  1091,  1091,  1092,  1092,  1092,  1092,
    1093,  1093,  1093,  1094,  1095,  1095,  1095,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1097,
    1097,  1097,  1097,  1097,  1098,  1098,  1099,  1099,  1100,  1101,
    1101,  1102,  1102,  1103,  1103,  1103,  1104,  1104,  1104,  1104,
    1105,  1105,  1105,  1106,  1107,  1107,  1108,  1109,  1110,  1111,
    1111,  1112,  1112,  1113,  1113,  1113,  1114,  1114,  1114,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1118,
    1117,  1119,  1119,  1120,  1120,  1122,  1121,  1123,  1123,  1123,
    1123,  1124,  1124,  1125,  1125,  1125,  1125,  1126,  1126,  1126,
    1126,  1127,  1127,  1128,  1128,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1130,  1130,  1130,  1131,  1131,  1131,  1131,  1132,
    1132,  1132,  1133,  1133,  1133,  1133,  1133,  1135,  1134,  1136,
    1136,  1137,  1137,  1138,  1139,  1139,  1139,  1139,  1141,  1140,
    1142,  1142,  1143,  1142,  1144,  1144,  1145,  1145,  1146,  1146,
    1146,  1146,  1147,  1146,  1148,  1148,  1148,  1148,  1148,  1149,
    1150,  1150,  1150,  1150,  1151,  1152,  1152,  1152,  1153,  1153,
    1154,  1154,  1155,  1155,  1156,  1156,  1158,  1157,  1159,  1157,
    1160,  1157,  1161,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1162,  1162,  1163,
    1163,  1164,  1164,  1164,  1165,  1165,  1165,  1165,  1166,  1166,
    1167,  1167,  1168,  1168,  1168,  1169,  1169,  1170,  1170,  1171,
    1172,  1172,  1172,  1172,  1172,  1173,  1173,  1174,  1174,  1175,
    1175,  1175,  1175,  1175,  1177,  1176,  1178,  1178,  1179,  1179,
    1179,  1180,  1180,  1180,  1181,  1181,  1182,  1183,  1183,  1184,
    1185,  1186,  1186,  1188,  1187,  1189,  1189,  1189,  1191,  1190,
    1192,  1192,  1193,  1193,  1193,  1194,  1195,  1195,  1196,  1197,
    1198,  1198,  1198,  1199,  1199,  1199,  1199,  1200,  1200,  1200,
    1200,  1200,  1201,  1201,  1202,  1203,  1204,  1204,  1204,  1205,
    1206,  1206,  1206,  1207,  1207,  1208,  1208,  1208,  1210,  1209,
    1211,  1211,  1212,  1212,  1214,  1213,  1215,  1215,  1216,  1216,
    1216,  1216,  1218,  1217,  1219,  1219,  1221,  1222,  1223,  1224,
    1225,  1220,  1227,  1228,  1229,  1230,  1226,  1231,  1231,  1231,
    1231,  1231,  1231,  1232,  1232,  1232,  1233,  1233,  1234,  1234,
    1234,  1235,  1235,  1236,  1237,  1236,  1238,  1238
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     3,     3,     3,     0,     7,
       0,    11,     0,     6,     0,     3,     4,     0,     3,     1,
       0,     2,     0,     2,     2,     2,     2,     2,     3,     3,
       1,     1,     1,     2,     3,     3,     0,     4,     0,     3,
       0,     1,     3,     1,     0,     1,     3,     1,     0,     3,
       0,     1,     3,     1,     4,     0,     1,     1,     1,     0,
       3,     2,     3,     0,     3,     0,     5,     5,     0,     7,
       5,     0,     2,     1,     1,     1,     3,     1,     1,     3,
       0,     1,     1,     1,     1,     2,     1,     1,     3,     0,
       2,     0,     2,     0,     3,     0,     5,     1,     1,     0,
       2,     1,     1,     2,     2,     2,     0,     6,     2,     0,
       2,     1,     1,     3,     0,     0,     0,     7,     0,     2,
       2,     1,     1,     0,     0,     8,     0,     6,     1,     2,
       1,     2,     0,     0,     6,     0,     0,     6,     0,     2,
       0,     5,     0,     1,     0,     5,     0,     2,     0,     5,
       4,     0,     0,     8,     0,     7,     1,     1,     1,     1,
       1,     2,     2,     2,     4,     4,     0,     4,     0,     0,
       5,     0,     7,     0,     0,     6,     0,     1,     0,     1,
       1,     2,     1,     1,     0,     1,     1,     2,     1,     0,
       3,     0,     1,     1,     2,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     5,     1,     1,     3,     4,     4,
       3,     4,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     1,     1,     3,     1,     1,     2,     2,     7,     8,
       8,     2,     2,     0,     1,     2,     0,     1,     2,     0,
       4,     3,     3,     3,     1,     4,     1,     1,     5,     2,
       5,     2,     4,     1,     5,     5,     4,     3,     1,     1,
       2,     1,     1,     2,     1,     1,     1,     2,     3,     2,
       3,     2,     2,     3,     3,     3,     0,     6,     0,     6,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     1,     2,     1,     2,     3,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     3,
       1,     5,     0,     1,     2,     1,     1,     1,     1,     0,
       3,     0,     1,     0,     1,     2,     1,     1,     2,     2,
       4,     1,     3,     2,     1,     2,     2,     2,     2,     1,
       2,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       1,     1,     1,     0,     2,     1,     1,     0,     1,     0,
       2,     1,     2,     3,     2,     0,     1,     0,     1,     1,
       2,     0,     1,     0,     4,     1,     4,     3,     1,     0,
       1,     2,     1,     3,     3,     2,     2,     2,     1,     1,
       2,     2,     2,     1,     2,     2,     2,     2,     1,     1,
       0,     1,     1,     1,     1,     0,     1,     1,     1,     0,
       2,     2,     1,     1,     1,     4,     2,     1,     4,     0,
       1,     0,     2,     1,     3,     0,     6,     0,     5,     0,
       5,     0,     5,     0,    11,     0,     1,     0,     2,     2,
       1,     3,     2,     3,     2,     4,     0,     6,     0,     0,
       8,     4,     4,     3,     3,     2,     2,     6,     5,     3,
       5,     1,     1,     1,     0,     1,     0,     1,     0,     1,
       1,     0,     2,     1,     0,     1,     1,     1,     0,     5,
       3,     0,     5,     3,     3,     0,     3,     0,     2,     1,
       3,     0,     1,     1,     0,     2,     1,     3,     0,     6,
       0,     6,     0,     5,     0,     1,     1,     0,     6,     0,
       1,     1,     2,     1,     1,     1,     0,     5,     0,     5,
       0,     1,     1,     2,     1,     1,     1,     1,     1,     2,
       0,     5,     0,     1,     1,     0,     4,     4,     3,     5,
       1,     3,     3,     5,     1,     3,     2,     1,     1,     0,
       6,     1,     3,     3,     0,     2,     0,     4,     0,     2,
       1,     2,     4,     2,     3,     0,     3,     0,     0,     6,
       2,     1,     1,     2,     2,     8,     4,     0,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     4,     3,     1,     1,     4,     0,     0,
       1,     1,     0,     2,     2,     1,     1,     0,     2,     3,
       3,     3,     2,     3,     4,     3,     4,     3,     4,     1,
       3,     4,     3,     3,     6,     1,     5,     6,     5,     7,
       6,     8,     5,     6,     4,     4,     5,     3,     4,     1,
       3,     3,     3,     3,     3,     3,     4,     4,     3,     3,
       3,     3,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     3,     1,     1,     1,     1,     3,     2,
       2,     2,     2,     3,     3,     5,     6,     4,     4,     7,
       4,     2,     6,     5,     6,     6,     4,     4,     3,     4,
       6,     8,     6,     8,     6,     4,     6,     4,     6,     4,
       4,     4,     4,     6,     8,     2,     2,     4,     2,     7,
       7,     3,     4,     4,     6,     6,     4,     6,     6,     6,
       4,     6,     4,     6,     8,    10,    12,     6,     4,     6,
       6,     1,     6,     4,     8,    10,     4,     1,     3,     4,
       6,     6,     8,     6,     6,     4,     6,     6,     8,     4,
       4,     6,     4,     2,     4,     4,     4,     6,     4,     4,
       3,     8,     6,     4,     6,     3,     6,     8,     4,     8,
       6,     8,     6,     8,     2,     4,     4,     4,     6,     8,
       8,     4,     7,     7,     7,     6,     6,     6,     6,     6,
       6,     0,     5,    10,     3,     4,     3,     2,     2,     2,
       4,     6,     4,     4,     6,     6,     6,     6,     4,     6,
       4,     6,     4,     4,     4,     4,     6,     4,     6,     4,
       6,     4,     4,     6,     4,     6,     4,     6,     4,     4,
       6,     4,     6,     0,     3,     3,     0,     1,     0,     2,
       1,     3,     4,     4,     5,     4,     4,     4,     5,     4,
       0,     0,     7,    10,     4,     5,     4,     5,     4,     4,
       4,     4,     4,     5,     0,     8,     0,     3,     3,     1,
       4,     0,     1,     0,     2,     0,     1,     0,     3,     2,
       3,     2,     1,     2,     1,     2,     1,     1,     1,     2,
       0,     1,     0,     2,     1,     3,     1,     3,     0,     2,
       1,     3,     0,     1,     0,     2,     4,     5,     1,     1,
       1,     1,     3,     3,     3,     0,     6,     0,     6,     0,
       8,     4,     0,     8,     0,    10,     6,     0,     8,     0,
      10,     6,     1,     2,     2,     0,     4,     0,    11,     3,
       6,     0,     3,     0,     0,     5,     0,     1,     0,     1,
       0,     2,     0,     2,     2,     2,     0,     6,     0,     1,
       3,     1,     1,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     0,     2,     0,     1,     0,
       0,     3,     0,     0,     3,     2,     0,     0,     4,     4,
       2,     0,     2,     2,     3,     3,     1,     2,     0,     1,
       0,     4,     4,     2,     0,     1,     1,     0,     1,     0,
       1,     2,     1,     3,     3,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     0,     6,     0,     1,     3,     1,     2,
       0,     2,     3,     1,     2,     1,     0,     3,     0,     5,
       2,     1,     0,     3,     6,     0,     6,     4,     6,     4,
       4,     4,     5,     4,     1,     3,     1,     0,     2,     0,
       1,     0,     0,     8,     0,     0,     6,     0,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     3,     4,     0,
       3,     3,     1,     2,     2,     0,     3,     0,     5,     3,
       1,     3,     1,     3,     1,     1,     0,     1,     0,     4,
       0,     1,     3,     1,     1,     1,     0,     0,     6,     0,
       0,    11,     3,     1,     3,     3,     1,     3,     0,     1,
       0,     4,     0,     6,     0,     5,     0,     6,     1,     3,
       3,     5,     0,     2,     0,     2,     1,     1,     1,     3,
       0,     1,     0,     3,     2,     4,     4,     4,     4,     0,
       4,     6,    16,     2,     2,     0,     6,     5,     2,     2,
       2,     1,     5,     5,     2,     2,     3,     2,     2,     2,
       3,     2,     2,     2,     1,     1,     3,     4,     3,     3,
       2,     2,     3,     3,     3,     3,     3,     3,     1,     1,
       1,     1,     0,     1,     0,     2,     0,     1,     1,     1,
       0,     2,     0,     2,     0,     2,     2,     0,     4,     0,
       4,     1,     1,     0,     1,     0,     1,     1,     0,     4,
       3,     1,     0,     3,     4,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     0,     3,     3,     1,
       1,     1,     2,     0,     3,     3,     2,     2,     0,     4,
       0,     1,     1,     2,     0,     4,     5,     0,     0,     0,
       0,    18,     2,     0,     1,     0,     1,     1,     0,     1,
       1,     0,     2,     2,     1,     3,     4,     3,     3,     0,
       2,     2,     1,     3,     3,     0,     3,     0,     3,     2,
       3,     1,     1,     2,     0,     2,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     3,     5,     1,     1,
       1,     1,     1,     3,     4,     5,     1,     5,     3,     2,
       1,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       4,     0,     1,     1,     3,     0,     2,     1,     1,     1,
       1,     0,     1,     0,     1,     1,     1,     0,     2,     2,
       2,     1,     2,     4,     5,     4,     6,     2,     3,     3,
       3,     5,     1,     3,     3,     2,     2,     2,     1,     1,
       4,     4,     1,     1,     1,     1,     1,     0,     4,     1,
       1,     1,     3,     3,     1,     1,     2,     2,     0,     3,
       4,     3,     0,     7,     1,     2,     1,     1,     1,     1,
       1,     1,     0,     5,     1,     1,     1,     1,     1,     3,
       6,     6,     6,     7,     3,     8,     8,     8,     0,     1,
       1,     2,     0,     1,     1,     3,     0,     3,     0,     3,
       0,     3,     0,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     3,     2,
       2,     2,     2,     2,     2,     2,     2,     0,     1,     3,
       1,     2,     2,     2,     1,     3,     3,     1,     1,     3,
       1,     3,     4,     5,     1,     0,     3,     3,     1,     1,
       0,     2,     2,     2,     2,     0,     2,     2,     1,     2,
       2,     2,     2,     2,     0,     3,     0,     1,     0,     3,
       2,     0,     1,     2,     0,     1,     4,     4,     5,     2,
       3,     0,     1,     0,     4,     0,     1,     1,     0,     2,
       2,     1,     0,     1,     1,     0,     5,     6,     0,     0,
       2,     2,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     3,     1,     2,     1,     2,
       3,     3,     3,     0,     1,     0,     3,     3,     0,     8,
       0,     3,     1,     3,     0,     2,     3,     5,     0,     3,
       4,     4,     0,    14,     8,     7,     0,     0,     0,     0,
       0,    15,     0,     0,     0,     0,    12,     4,     4,     3,
       4,     3,     2,     1,     3,     5,     1,     1,     0,     1,
       1,     0,     2,     0,     0,     3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     2,  1973,   632,     0,  1914,     0,     0,     0,     0,
       0,  1916,    94,    54,  1260,  1351,  1352,  1182,  1199,     0,
     632,    97,     0,    66,  1201,  1388,     0,     0,   632,     0,
    1383,     0,     0,   632,  1204,  1376,     0,    97,  1916,     0,
     667,  1751,  1282,     0,     0,     0,  1280,  1808,  1249,     0,
       0,     0,     0,     0,     4,    15,     0,    32,    20,    24,
      10,    14,     9,     6,    46,    47,    39,     8,    12,    36,
       7,    11,    29,    35,    30,    31,    43,   660,    18,    19,
      25,    37,    50,    16,    48,    45,    17,  1353,    21,    38,
      33,    26,    51,    27,    44,    28,    49,    23,    40,    22,
       5,    13,    41,    42,    34,    52,     0,   535,     0,   567,
       0,     0,  1974,  1964,   634,   633,     0,  1800,  1799,   600,
    1916,     0,  1536,  1537,  1538,  1539,  1540,  1541,  1542,  1500,
    1543,  1544,  1545,  1501,  1502,  1546,  1547,  1548,  1550,  1549,
    1551,  1503,  1504,  1552,  1553,  1554,  1505,  1506,  1555,  1556,
    1507,  1557,  1558,  1559,  1508,  1560,  1509,  1561,  1562,  1563,
    1564,  1565,  1510,  1566,  1567,  1568,  1569,  1570,  1511,  1571,
    1572,  1573,  1574,  1589,  1575,  1512,  1576,  1577,  1578,  1590,
    1513,  1581,  1580,  1579,  1582,  1583,  1584,  1514,  1585,  1586,
    1587,  1592,  1593,  1594,  1515,  1588,  1595,  1591,  1734,  1597,
    1596,  1598,  1600,  1599,  1516,  1601,  1517,  1602,  1603,  1484,
    1604,  1485,  1606,  1607,  1610,  1611,  1605,  1608,  1609,  1518,
    1613,  1614,  1615,  1616,  1617,  1618,  1619,  1629,  1622,  1624,
    1625,  1627,  1623,  1628,  1632,  1631,  1633,  1634,  1635,  1630,
    1621,  1626,  1636,  1637,  1620,  1638,  1639,  1640,  1641,  1642,
    1643,  1644,  1645,  1647,  1646,  1648,  1649,  1650,  1651,  1652,
    1654,  1653,  1655,  1656,  1657,  1659,  1658,  1660,  1519,  1661,
    1662,  1663,  1664,  1665,  1520,  1666,  1667,  1668,  1669,  1670,
    1671,  1521,  1672,  1673,  1674,  1675,  1676,  1677,  1678,  1679,
    1680,  1681,  1682,  1683,  1684,  1685,  1686,  1687,  1612,  1688,
    1522,  1689,  1690,  1523,  1691,  1524,  1692,  1693,  1525,  1694,
    1695,  1696,  1697,  1698,  1699,  1526,  1700,  1527,  1702,  1701,
    1703,  1705,  1706,  1528,  1704,  1529,  1707,  1708,  1710,  1709,
    1711,  1712,  1530,  1713,  1531,  1714,  1715,  1716,  1717,  1718,
    1719,  1720,  1721,  1722,  1723,  1724,  1727,  1728,  1729,  1730,
    1725,  1726,  1532,  1731,  1732,  1733,  1735,  1736,  1533,  1737,
    1738,  1535,  1739,  1740,  1743,  1741,  1742,  1744,  1745,  1746,
    1747,  1534,  1748,   116,  1489,    99,  1490,  1499,     0,   602,
     618,  1917,  1918,   269,   507,   508,   268,   506,    97,  1964,
       0,   265,   266,     0,  1274,  1002,  1197,  1197,     0,  1197,
    1200,  1197,    97,  1197,     0,    59,  1358,     0,     0,     0,
       0,  1483,     0,  1207,  1390,  1394,     0,     0,  1797,     0,
       0,     0,     0,    97,   635,     0,  1258,     0,   598,     0,
    1918,  1929,   661,   665,   677,  1752,  1749,  1336,   587,   587,
     587,   585,   587,  1281,     0,     0,  1258,  1393,  2016,     0,
       0,     0,  2012,     0,  2017,     0,   667,     0,     0,     1,
       3,     0,  1586,  1349,  1347,  1480,     0,   527,   536,   531,
     529,     0,     0,  1975,  1962,  1963,   616,     0,  1915,     0,
     644,   654,   118,     0,    68,     0,     0,     0,  1921,     0,
       0,     0,     0,    95,   698,   698,  1964,  1966,  1968,   269,
     267,     0,  1278,  1277,  1276,     0,  1274,  1183,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,    61,     0,
    1842,  1857,  1858,  1854,  1859,  1860,  1864,     0,  1856,  1848,
       0,  1863,  1852,  1861,     0,  1846,     0,  1862,  1867,  1850,
    1855,  1834,     0,  1840,  1844,  1482,  1102,  1811,  1812,     0,
    1495,  1486,  1494,  1493,    67,  1209,  1210,  1208,   566,  1391,
    1392,     0,  1405,     0,     0,     0,   630,     0,  1331,  1330,
       0,  1384,  1930,     0,     0,   607,  1212,  1259,     0,  1211,
    1381,     0,  1380,  1377,  1379,     0,  1842,  1829,     0,  1924,
    1921,  1931,   690,   683,   682,   685,   686,   689,   687,   688,
     684,   681,   698,   678,   680,  1755,     0,     0,   441,     0,
    1344,     0,     0,     0,  1344,     0,  1137,  1337,     0,  1764,
    1315,   504,   503,     0,   502,  1765,  1314,  1330,     0,     0,
       0,  1301,     0,  1766,     0,  1333,     0,  1137,  1344,     0,
    1283,     0,     0,     0,     0,   581,   591,   583,   578,     0,
     584,   580,  1279,  1196,  1809,   566,  1442,  1441,  1487,  2013,
    1440,  2021,  2023,  2009,  2011,  2018,   663,     0,  1935,    53,
       0,  1355,  1971,  1972,  1970,   457,   100,   100,   525,     0,
       0,     0,     0,     0,  1194,     0,     0,   646,   656,   120,
     117,    98,     0,   604,   620,  1920,     0,     0,  1922,  1926,
     760,   759,     0,    92,   707,  1496,  1894,    96,  1890,  1969,
     698,   698,   698,     0,  1951,     0,  1957,  1958,  1961,  1960,
    1959,     0,  1950,  1953,  1954,  1956,  1955,  1975,  1967,     0,
     509,     0,  1261,  1264,  1268,  1272,  1275,  1537,  1500,     0,
    1545,     0,     0,  1453,     0,     0,     0,     0,  1505,     0,
       0,  1558,     0,     0,  1510,     0,     0,     0,   707,   707,
     707,     0,     0,     0,  1569,  1570,  1462,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1450,     0,  1463,
       0,     0,     0,     0,     0,     0,     0,  1597,     0,     0,
    1598,     0,     0,     0,  1452,  1603,     0,     0,     0,     0,
       0,     0,     0,  1616,     0,     0,  1460,     0,     0,  1008,
       0,  1642,  1644,     0,     0,     0,  1648,     0,     0,  1649,
    1650,  1651,  1437,   762,     0,   707,  1449,  1459,  1663,  1668,
    1443,     0,  1670,     0,  1671,     0,  1676,     0,     0,     0,
       0,     0,     0,  1698,  1700,     0,     0,  1716,     0,     0,
       0,   707,  1436,  1727,  1728,  1729,  1730,     0,  1451,  1532,
    1461,     0,     0,     0,  1739,   707,   707,   707,     0,     0,
       0,  1745,     0,  1748,  1012,     0,     0,     0,     0,   761,
       0,   976,     0,  1004,   719,   725,   739,     0,   847,   754,
     841,   777,   776,  1003,  1447,   775,   774,  1448,   772,  1470,
    1489,  1469,  1198,  1187,  1189,     0,  1190,  1193,  1888,  1191,
     568,     0,     0,    60,  1372,  1366,  1368,  1371,  1367,     0,
    1373,  1370,  1369,  1800,  1359,  1361,  1362,  1843,  1841,  1875,
    1874,     0,  1876,  1872,  1865,  1895,  1869,  1895,  1871,  1870,
    1895,  1866,  1873,  1895,  1838,     0,  1103,  1104,     0,  1810,
       0,  1481,     0,  1389,  1406,     0,  1407,  1395,  1403,   649,
       0,  1102,  1798,  1801,     0,     0,    56,    57,     0,   637,
       0,   636,   640,     0,     0,     0,  1215,  1205,  1214,  1382,
       0,     0,  1841,  1838,  1925,     0,  1927,  1942,   666,  1932,
     696,   668,   695,     0,   679,  1750,  1753,  1761,  1313,  1340,
     440,     0,     0,  1312,  1298,     0,   269,     0,     0,     0,
       0,  1284,  1289,   303,     0,  1305,  1138,     0,  1344,     0,
    1307,  1320,  1308,     0,  1334,     0,  1344,  1294,  1321,  1334,
    1299,  1304,  1311,  1338,  1339,     0,  1293,  1300,     0,  1309,
    1334,  1334,  1344,  1344,   594,   593,   592,   588,   589,   594,
       0,  1045,     0,     0,  2010,  2024,  2008,  2019,  2020,  2007,
     664,  1936,   662,  1937,     0,  1350,  1348,  1356,  1357,   458,
     457,   260,   263,   262,     0,   532,   530,   457,  1965,     0,
       0,   617,     0,     0,   648,   643,   647,   645,   499,   498,
     501,     0,   655,     0,   121,   123,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    69,    70,    83,   606,   605,   603,   628,   627,   625,
       0,   626,   624,   619,   621,   622,  1919,  1923,   270,   457,
       0,  1498,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1952,    88,     0,     0,     0,  1266,  1262,  1272,     0,
       0,     0,  1102,     0,     0,     0,  1107,     0,   791,  1107,
    1107,  1107,     0,     0,  1002,  1002,     0,  1002,     0,     0,
       0,     0,  1107,   815,   818,     0,   816,     0,     0,     0,
       0,     0,  1456,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1002,     0,     0,     0,     0,   981,     0,     0,
       0,     0,   771,     0,     0,     0,     0,  1002,     0,     0,
       0,     0,  1008,     0,  1006,     0,  1107,     0,     0,  1107,
       0,     0,     0,     0,     0,  1002,  1002,  1002,   712,     0,
     863,     0,     0,     0,     0,     0,  1002,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,  1107,     0,
       0,     0,  1107,     0,   884,     0,  1458,     0,     0,     0,
    1457,     0,     0,  1455,  1454,  1438,     0,     0,     0,   907,
     909,   908,  1107,     0,  1107,     0,     0,     0,  1013,     0,
     780,   779,   781,  1948,     0,     0,     0,     0,     0,     0,
     758,   757,   756,   755,     0,     0,     0,   763,     0,   764,
     765,     0,   766,   767,   768,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   782,  1076,  1077,  1078,  1079,  1089,
    1080,  1081,  1082,  1091,  1096,  1083,  1084,  1092,  1093,  1094,
    1085,  1095,  1090,  1086,  1097,     0,  1075,     0,     0,     0,
    1439,   901,     0,     0,  1185,     0,   570,   569,  1192,   568,
       0,    62,    64,  1365,     0,     0,  1374,  1868,     0,  1849,
    1853,  1847,  1851,     0,     0,  1839,     0,  1845,  1106,  1593,
    1658,     0,  1109,  1814,  1202,  1402,  1404,     0,     0,  1396,
       0,     0,   631,    58,     0,     0,  1385,     0,     0,     0,
       0,   609,  1213,     0,  1378,     0,     0,     0,     0,     0,
    1928,  1944,  1943,  1933,   698,  1128,   699,   701,   700,  1469,
    1755,  1758,  1759,  1762,  1760,     0,  1757,  1756,  1771,     0,
    1342,  1345,  1346,     0,     0,  1323,  1322,  1318,  1319,     0,
    1147,  1148,  1146,  1141,  1142,  1145,  1327,  1325,  1316,     0,
    1344,     0,  1326,  1324,  1344,  1334,     0,  1344,  1344,  1306,
    1310,     0,   582,   591,   579,   586,  1057,  1056,     0,  1021,
       0,  1020,  1019,  1018,     0,  1056,  2014,  2022,  2026,     0,
    1137,  1941,  1939,   261,  1236,  1236,     0,     0,     0,     0,
       0,     0,     0,   101,   110,   564,   564,  1236,  1236,   564,
    1236,  1236,  1236,     0,     0,  1236,     0,     0,   564,     0,
    1236,   562,     0,     0,  1236,  1236,  1236,   564,     0,  1236,
    1236,  1236,  1236,  1236,   574,  1236,  1236,  1236,   561,   273,
     295,   296,   526,     0,   540,   563,  1976,  1977,   533,   601,
    1195,     0,   119,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     629,   623,    93,   457,   708,  1497,     0,  1891,     0,  2002,
       0,     0,    99,  1978,   271,   512,   514,   513,   511,   510,
       0,     0,  1109,     0,  1269,  1045,  1273,  1272,  1270,     0,
       0,     0,  1108,  1107,     0,   987,  1155,  1156,  1152,  1153,
    1151,  1154,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   960,     0,   987,     0,
     821,     0,     0,     0,     0,     0,     0,  1469,     0,     0,
       0,     0,     0,  1948,     0,     0,     0,     0,     0,     0,
     798,     0,     0,     0,     0,     0,     0,     0,  1100,  1098,
    1101,  1099,     0,     0,   982,   974,     0,     0,     0,     0,
     848,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1009,  1010,  1107,     0,     0,     0,  1107,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   870,     0,     0,
       0,     0,     0,   875,     0,     0,     0,     0,     0,     0,
       0,  1107,     0,     0,     0,  1088,     0,  1087,     0,     0,
       0,     0,     0,     0,     0,     0,   904,     0,   906,     0,
       0,  1472,  1471,     0,     0,     0,     0,     0,  1014,   667,
       0,   784,  1002,   783,     0,  1767,   977,   979,     0,   710,
     709,   711,   722,   715,   720,   713,   717,     0,   769,  1542,
     723,     0,   751,     0,  1116,   752,   737,   742,   743,     0,
       0,   740,   741,   745,   847,   744,   847,   748,   749,   750,
     753,     0,     0,     0,     0,     0,   773,   778,  1005,   948,
    1473,  1188,  1186,  1889,  1184,    65,     0,     0,  1360,  1375,
    1363,  1899,     0,  1898,  1884,  1887,  1480,     0,     0,     0,
    1824,  1818,  1825,  1827,  1821,  1826,  1828,  1819,  1820,  1815,
    1822,  1110,  1139,     0,     0,   650,   651,   654,     0,  1804,
    1805,  1803,  1802,  1387,  1386,     0,   638,   641,   642,   614,
     613,   615,   608,   610,   611,   253,  1219,     0,     0,     0,
    1225,  1206,  1216,   599,     0,     0,     0,     0,     0,   694,
    1045,  1176,   691,   672,  1139,  1129,   671,   702,     0,  1754,
       0,  1725,  1782,     0,     0,     0,     0,     0,  1772,  1341,
       0,  1295,     0,  1317,  1329,  1328,  1290,     0,     0,     0,
    1288,  1335,  1287,  1109,  1334,  1285,  1286,   596,   595,   590,
    1056,  1045,     0,     0,  1042,  1058,     0,  1058,  1045,  1045,
       0,  1045,  1102,  1053,     0,     0,  2025,  1130,  1940,  1234,
    1235,  1237,     0,     0,   104,   107,   105,     0,   106,     0,
       0,   565,   519,   500,   500,   544,     0,   333,   519,   493,
     542,     0,     0,     0,     0,     0,     0,     0,     0,  1236,
       0,   555,   538,     0,     0,     0,     0,   556,     0,   539,
    1236,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   577,   576,   575,     0,     0,     0,     0,   274,   457,
     336,     0,   571,   333,   339,  1476,  1980,  1072,     0,  1071,
     122,    76,    72,    84,  1160,  1161,  1159,  1157,  1158,    85,
      74,    75,    79,    78,    80,    81,    82,    77,    73,    86,
      87,    71,     0,  1892,     0,     0,   237,   236,     0,  1996,
       0,  1980,     0,   336,    89,  1408,   272,   275,    90,  1045,
    1128,  1272,  1109,     0,  1102,     0,   790,   805,     0,     0,
     953,     0,     0,   955,   956,   957,     0,   809,     0,   807,
     810,   811,   812,  1002,     0,     0,     0,     0,  1002,   959,
       0,   817,     0,     0,   822,   823,     0,   796,     0,   830,
       0,   832,     0,  1002,     0,   826,     0,   787,     0,     0,
    1002,     0,   838,     0,   799,     0,     0,   939,     0,   922,
     918,     0,   920,     0,     0,  1002,  1002,     0,   843,     0,
       0,   849,  1002,     0,   941,     0,   923,     0,   855,     0,
    1002,     0,  1007,     0,     0,     0,   966,   859,   860,     0,
     964,   925,     0,     0,   862,   927,     0,   929,     0,   924,
     931,   932,   864,   866,   865,   934,     0,     0,   936,     0,
     938,     0,   868,   869,     0,     0,     0,   873,     0,  1002,
     878,   968,   970,     0,     0,     0,     0,     0,   972,   885,
     887,     0,     0,     0,   886,     0,     0,     0,     0,     0,
       0,     0,   891,     0,     0,   905,   971,   797,   969,   910,
       0,   913,     0,   912,     0,     0,     0,     0,  1945,  1945,
       0,   788,     0,     0,     0,     0,     0,  1474,   716,   721,
     714,   718,     0,     0,     0,     0,   735,   734,     0,   747,
     746,     0,  1116,   738,     0,   846,     0,   947,   698,  1002,
       0,    63,  1364,  1896,     0,     0,     0,     0,     0,     0,
       0,     0,  1813,  1140,  1246,  1488,  1397,     0,   658,  1806,
    1807,     0,   612,   677,     0,  1238,  1223,  1230,  1224,     0,
       0,     0,  1222,  1465,  1464,  1471,  1931,     0,     0,     0,
       0,  1934,  1109,  1109,  1170,     0,     0,   669,   674,   670,
     673,     0,   697,   706,   705,  1466,  1473,     0,     0,     0,
       0,   443,   445,   444,   453,     0,   442,     0,     0,  1767,
       0,   449,   451,   450,  1777,   448,  1343,  1137,  1303,  1302,
    1144,  1143,     0,  1297,  1344,     0,  1938,  1051,     0,  1044,
    1043,  1059,     0,  1045,  1058,  1058,     0,  1024,  1023,  1250,
    1253,     0,  1022,  1062,  1049,   677,  2015,  2027,     0,   456,
     455,   302,   452,   301,   109,   108,   114,   115,   338,   520,
     494,   495,     0,     0,     0,   500,   332,   519,   331,   334,
     509,     0,   285,   282,   546,   288,   284,   300,     0,     0,
     289,   519,   553,   554,   568,   278,     0,   314,   315,   313,
     297,   280,   281,   548,  1124,  1126,  1134,   287,   286,   283,
     292,   293,   311,   310,   291,   312,   559,   309,   307,   304,
     306,   305,   308,   290,   279,  1374,   541,     0,   322,   324,
     325,  1479,     0,   573,   543,     0,   326,   327,     0,     0,
       0,     0,   657,     0,  1893,     0,  2003,   240,   238,   239,
       0,   124,   320,   321,   319,   318,     0,     0,   243,     0,
     241,     0,     0,  1410,  1409,   242,   256,   457,   276,     0,
    1109,  1149,  1265,  1271,     0,     0,     0,   954,   988,     0,
     419,   419,   998,   996,   408,   419,   992,   997,   994,     0,
       0,     0,     0,     0,     0,     0,   961,   958,     0,     0,
       0,  1473,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   985,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     943,  1011,   967,   965,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   973,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1015,
     793,  1949,  1949,   785,  1768,  1769,  1770,   521,   978,     0,
     728,  1002,   726,  1115,   732,     0,     0,   736,     0,   902,
       0,   949,   950,     0,  1001,  1475,  1897,  1886,  1885,  1900,
    1900,  1900,     0,  1111,     0,  1203,  1408,   652,     0,   653,
     639,   698,  1220,  1232,     0,  1240,     0,     0,  1217,  1227,
       0,     0,     0,  1226,     0,  1831,  1832,  1830,  1139,  1117,
       0,     0,  1181,     0,  1177,   692,     0,   704,   703,     0,
    1784,     0,  1783,  1795,  1796,  1793,  1794,  1792,  1773,     0,
    1779,  1778,     0,     0,     0,  1789,  1780,     0,     0,  1296,
       0,  1291,   597,     0,  1045,  1058,  1045,  1031,     0,     0,
    1045,  1027,  1025,  1029,     0,  1109,     0,     0,     0,     0,
    1046,   698,  1468,  1131,  1134,   335,   519,   496,   497,   509,
       0,     0,     0,     0,   453,   298,   552,   551,   299,     0,
       0,  1135,  1136,  1127,     0,   545,   336,   572,   473,   404,
     353,   344,   419,   347,   346,   390,   361,   358,   408,   406,
     376,   408,   408,   383,   382,   400,   386,   366,   459,   459,
     365,   403,   459,   387,   385,   389,     0,   391,   408,   396,
     384,   388,   405,   381,   378,   402,   419,   419,   359,   362,
     401,   459,     0,   394,   419,   423,   364,   459,   465,     0,
       0,   419,   421,  1478,  1982,     0,  1984,  1070,     0,   135,
     698,     0,   125,   127,   128,     0,  1984,     0,   246,   271,
     257,     0,   277,     0,  1267,     0,  1263,   771,   802,   806,
     915,     0,   989,   459,     0,   999,   410,   991,   993,   995,
     792,   808,   813,   917,   795,   794,     0,     0,     0,     0,
     828,   831,   833,   824,   829,   827,     0,   916,   840,   837,
     839,   800,     0,   940,   919,   921,   842,   853,   983,   986,
       0,     0,     0,   854,   850,   942,   851,     0,   856,   825,
     857,     0,     0,     0,     0,   926,   861,   928,   930,   935,
     933,   937,   867,   804,     0,   872,   874,   786,   771,   876,
       0,   882,   880,     0,     0,   888,     0,     0,   897,     0,
     895,     0,   896,     0,   898,   899,     0,   911,   914,  1016,
       0,  1946,     0,     0,   980,   724,     0,   730,  1002,   727,
     733,   699,   698,   900,     0,  1905,  1905,  1905,  1245,  1244,
       0,  1243,  1247,     0,   659,   254,     0,     0,     0,  1241,
    1229,  1935,  1218,  1221,  1473,  1833,   676,     0,  1112,  1180,
    1178,     0,  1171,  1173,  1175,     0,  1467,     0,     0,  1788,
    1774,   454,     0,     0,     0,     0,  1775,     0,  1102,  1052,
       0,     0,  1018,  1045,  1045,     0,  1018,     0,     0,     0,
    1252,  1128,  1254,  1060,  1064,  1065,  1063,  1054,     0,  1133,
       0,     0,     0,   558,     0,   571,   560,   423,  1125,   294,
     323,   479,     0,     0,   363,   412,   407,     0,   412,   412,
     465,   467,   461,   465,     0,   372,   390,   367,     0,   459,
     380,   371,   392,   395,   397,   399,   412,     0,   459,   360,
     369,     0,   412,   431,     0,     0,     0,   427,     0,   472,
       0,   434,   340,   424,   426,     0,     0,   393,     0,   349,
     466,     0,   351,     0,     0,   412,     0,   422,   412,     0,
    1981,     0,  1988,     0,     0,   138,   136,   137,     0,   131,
     133,   128,     0,  1997,     0,     0,  1995,  1988,   244,  1935,
    1408,     0,   249,     0,  1134,   517,  1150,     0,     0,   990,
       0,     0,   962,   819,   820,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   789,     0,     0,     0,
       0,     0,     0,     0,   894,   892,   893,     0,  1017,  1947,
     522,   729,     0,   702,   951,     0,     0,  1904,  1902,     0,
    1903,  1901,  1877,     0,  1836,  1837,  1835,  1823,     0,     0,
    1398,  1139,  1231,  1233,  1239,  1228,     0,  1113,  1128,  1411,
    1174,     0,   693,  1786,  1785,  1787,  1781,     0,     0,     0,
       0,  1050,  1045,  1032,     0,  1036,  1041,  1037,     0,  1028,
    1026,     0,  1149,     0,  1066,  1139,  1134,     0,     0,     0,
       0,     0,     0,     0,     0,   557,  1444,   547,   549,     0,
       0,     0,   474,   475,   480,   482,     0,     0,   416,   417,
     418,   373,   413,   415,     0,   375,   343,   460,   468,   469,
       0,   464,   462,   465,   368,   398,   374,     0,   370,     0,
     357,   437,   436,   707,   429,   439,     0,     0,   435,   425,
     433,   428,     0,     0,     0,     0,   341,     0,   342,  1477,
    1983,     0,   534,   698,   698,  1985,  1994,  2004,   135,     0,
       0,     0,   126,   129,  1979,   247,   245,     0,  1931,    91,
       0,   516,     0,   803,   420,   409,     0,   814,   834,     0,
     801,   984,   975,  1107,   844,     0,   852,   858,   945,   944,
     871,   877,   881,   879,   883,   889,   890,  1002,   731,   952,
    1883,  1882,  1881,  1878,     0,     0,     0,     0,     0,     0,
    1906,  1908,  1242,     0,     0,   255,   691,   316,  1121,  1134,
       0,  1139,     0,  1419,  1172,  1791,  1790,  1776,     0,     0,
       0,     0,     0,     0,     0,  1073,  1251,  1061,     0,  1055,
    1132,     0,     0,   509,  1446,  1445,   571,   485,   486,   487,
       0,     0,     0,   478,   481,   352,   345,   414,     0,   523,
     470,   463,     0,   356,   438,   707,   432,   459,   465,   459,
     465,     0,     0,     0,   667,     0,   102,   132,     0,   698,
    1998,   251,   250,  1134,     0,     0,     0,     0,     0,     0,
    1879,  1909,  1912,  1910,  1911,  1913,  1907,     0,     0,   317,
       0,     0,  1118,  1120,  1114,  1162,     0,     0,     0,     0,
    1412,  1414,     0,  1179,     0,  1047,  1033,     0,  1038,     0,
    1030,     0,  1068,     0,   509,   328,   550,   489,     0,   488,
       0,   483,   484,   479,     0,   459,     0,   459,   430,   348,
     350,   354,   355,     0,  1989,     0,  1986,     0,  2005,   134,
       0,     0,  1935,   515,   518,   411,   835,     0,   963,   845,
     903,  1248,  1256,     0,  1399,  1122,  1123,  1134,     0,   675,
       0,     0,     0,     0,  1413,     0,     0,  1420,  1422,     0,
       0,     0,     0,  1074,     0,  1069,   330,   329,   491,   492,
     490,   476,   477,   377,   524,   379,  1990,  1991,  1935,   112,
     111,   103,     0,   171,     0,  1999,   252,     0,     0,     0,
     446,  1119,  1163,  1417,  1418,     0,  1415,     0,     0,  1421,
       0,     0,  1035,  1040,  1067,  1987,   113,     0,   189,   175,
       0,     0,     0,   173,   203,  2006,     0,     0,   177,   201,
     202,   178,   181,   182,     0,  1491,     0,  1492,  1992,   102,
     836,  1255,  1257,     0,  1400,     0,  1416,  1424,  1423,     0,
    1048,   188,   191,     0,     0,   194,   184,   183,   185,     0,
       0,     0,   172,   171,   171,   231,   180,   228,   227,   220,
     171,  2000,   447,  1411,   698,     0,   190,     0,     0,     0,
     174,   204,   215,   218,   210,   171,     0,   171,     0,   143,
       0,     0,  1993,   171,  1419,     0,     0,  1166,  1168,     0,
     186,     0,     0,     0,     0,   171,   211,     0,     0,     0,
     141,   234,     0,   139,   222,   222,  2001,  1425,  1169,  1164,
     698,  1292,     0,   176,   195,   212,   218,   208,   216,   171,
       0,   230,   142,     0,   232,     0,   171,     0,   221,   223,
     225,     0,  1427,  1167,   187,   192,   171,     0,   209,     0,
       0,   207,     0,   171,   154,   153,     0,   145,   167,   229,
       0,   144,     0,     0,  1434,     0,   171,   213,     0,   171,
       0,   171,     0,     0,     0,     0,     0,   140,  1426,  1429,
       0,     0,  1431,  1432,     0,  1401,   193,   198,     0,   205,
     171,   235,     0,   148,   168,   169,     0,   151,  1433,  1428,
       0,  1435,   194,   171,   197,   171,   233,     0,     0,   146,
     160,   147,   158,   150,     0,  1430,   199,   171,   171,   166,
     164,   171,   155,   162,   157,     0,   163,   170,   161,     0,
     152,     0,   149,   165,   159,   156
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    52,    53,    54,    55,    56,    57,   966,    58,   518,
     913,  1371,  1372,    59,   412,    60,   692,  1111,  1112,  1113,
      61,  1584,  2449,  1129,   389,   407,  1581,  1075,  3388,  1503,
    3441,  1504,    62,   482,   690,  1093,  1094,  2751,  2752,  3025,
    2753,  3018,  3019,  3020,  3021,  3586,  3535,  3563,  3587,  3624,
    3657,  3663,  3664,  3606,  3671,  3672,  3673,  3679,  3674,  3607,
    3659,  3536,  3476,  3509,  3505,  3477,  3572,  3504,  3594,  3528,
    3529,  3596,  3637,  3654,  3478,  3479,  3510,  3553,  3480,  3511,
    3576,  3533,  3577,  3597,  3638,  3534,  3554,  3600,  3557,  3481,
    3540,  3588,  3482,  3541,  3483,  3484,  3518,  3539,  3516,  3538,
    3603,  3583,  2028,  2430,  2034,  2440,  3029,  2445,  3208,  3392,
    1860,  2253,  3091,  2761,  1572,  1070,  1071,   390,   391,   392,
     490,  2035,  1538,  2036,  2037,  1540,  1541,  1012,  2403,  2394,
    2380,  3255,  2436,  2407,  2408,  2409,  2410,  2358,  2359,  1946,
    1947,  1993,  2418,  2735,  2957,  2977,  2736,  2737,  2738,  2739,
    2740,  2741,  2742,  2775,  2776,  3151,  3152,  3153,  2772,  3008,
    2992,  2993,  2994,  3174,  2964,  2293,  2294,  3494,  2303,  2304,
    2340,  2630,  2341,  1074,  2965,  3002,  3161,  2995,  2417,  2951,
    3142,  3292,  3143,  3144,  3145,  3371,  1948,  2357,  1090,  1091,
     639,   393,  1145,  1588,  3033,  3034,  2348,  2864,  3298,    63,
    1077,   675,   677,   676,  1996,   467,  1542,  1543,  1544,  2673,
    2679,  3286,  1950,   111,  1368,  2414,  1984,    64,  1049,  1044,
      65,   650,   645,   646,  1047,  1048,  1472,  1908,    66,   585,
      67,   477,    68,   485,  1116,    69,   974,  1852,  1853,  1854,
      70,   682,    71,   486,  1123,  1124,  1125,    72,   964,   116,
      73,   574,   969,   971,   972,    74,   479,   480,  1085,    75,
    1398,  1835,  1836,   687,   688,  1092,  2589,    76,    77,   458,
     432,   591,   433,   434,  1425,  1872,  3256,   602,   603,   604,
    2277,   991,   992,   993,  1877,  1426,  2282,  1131,  2879,   884,
     885,   886,  1305,  1306,  2996,   887,  1315,  1771,   888,   889,
    1799,   890,  2824,  2226,  2227,  2228,  2571,  2572,   891,  2068,
    2787,  2106,   892,  1298,  1756,  1665,  3048,  2808,  1604,  2051,
    2469,  2573,   507,   508,   893,  1223,  1224,  1225,  1682,  1289,
    2197,  1748,  1479,  1480,  1481,  1482,  2928,  2927,  2929,  3270,
    3114,  3272,  3118,  1919,  1483,  1484,  3420,  2316,  2644,  2334,
    2335,  3125,  1910,  1485,  2322,  3124,  2660,  2934,  3278,  3424,
    1998,  3274,  1355,  1726,  1356,  1662,   948,   949,  1605,  1832,
    2241,  3098,  3260,  2216,  2898,  3258,  3342,  1545,  2384,  2385,
    1874,  1875,  2338,  2663,  2683,  1015,  3257,  2243,  1453,  1454,
    2766,  3662,  2009,  3409,  3495,  3546,  3547,  3548,  2612,  2613,
    2902,  2903,  1876,  2274,  2614,  3099,    78,   395,    79,  1802,
    1809,   684,   510,   404,    80,   413,  1833,    81,   426,  1413,
     558,   578,   977,   978,  1861,  2254,  2261,  1862,  2266,  2891,
    2256,  2592,  2593,  1931,  1932,  2257,  2595,  2888,  2880,  2881,
    2585,  3089,    82,   446,  2655,  2329,  2330,  3401,  3402,   579,
      83,   394,   732,  1592,  1150,  1591,   733,   734,  1152,   505,
     506,    84,   444,    85,   437,   640,  1449,  2307,  1896,   570,
     642,  1460,   643,  1461,  1440,  1891,  1003,    86,   671,   670,
      87,   463,  1066,    88,   519,   924,   925,  1376,  1810,    89,
     427,   583,   584,    90,   421,   571,  1406,    91,   414,   561,
      92,    93,   562,   957,  2586,  3254,  3450,  3523,  1397,   958,
    2446,  3263,  3350,  3351,  3353,  3417,  3418,  3592,  3614,  3631,
    3632,  3635,   894,   659,   895,  3135,   896,   897,  2262,  2263,
    2664,   898,  3403,   899,  1994,   653,   410,   900,   552,   660,
    2246,   901,  3486,   705,   706,   376,   377,    94,   605,   436,
     995,   996,   997,  1435,  1436,   644,  2205,  1437,  1438,  1888,
    1883,  2910,  2636,  2628,    95,   565,   926,   962,   963,  1841,
      96,   445,    97,   950,  1392,  1393,  1829,  2240,  1830,    98,
     587,    99,   541,  1386,   542,   928,   543,   544,   940,   935,
     943,   937,  3244,  3081,  3082,  1817,   909,   707,   708,  1379,
    1812,  1813,  2875,  3084,  3250,  3251,   100,   120,   382,   488,
     699,   985,   101,   102,   103,   104,   988,  1061,  1868,  1062,
    1063,  1064,  1492,  1423,  2551,  1296,  1750,  2861,   493,   722,
     714,   473,   474,   475,   496,   497,   112,   113,   715,   716,
    2031,  2421,  2745,  3012,  3013,  3195,  3192,   717,  3520,   718,
     719,  2431,  3201,  3391,  3489,  3543,   720,  2025,  2749,  3316,
    3443,   105,   661,   455,  1059,  1054,  1056,  1488,  1926
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3204
static const int yypact[] =
{
    3708, -3204,   953,   840,   501, -3204,   128, 42145,   569,   501,
     501,  -167,  1673, -3204, -3204, -3204, -3204, -3204,  2775, 42145,
     840, -3204, 21125, -3204, -3204, -3204,   217,   501,   840, 42145,
   -3204,    94,  1094,   840, -3204, -3204,   501, -3204,  -167, 42145,
   -3204,   518, -3204,   386,   -84,   461,   484, -3204, -3204, 42145,
    2847,   481,   981,  1024, -3204, -3204,   718, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, 21665, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204,   948, 42145, 42145, -3204,
   42145,   640, -3204,  1040, -3204, -3204,   501, -3204, -3204, -3204,
    -167, 21125, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204,   597, -3204, -3204,   695, -3204,
   -3204, -3204,  1213,  1068, -3204, -3204, -3204, -3204, -3204,   378,
     801, -3204,   876,  1099,   769, -3204,  1150,  1150, 42145,  1150,
   -3204,  1150, -3204,  1150,   501, -3204, -3204,  3720, 42145,  1053,
     169,  -100, 37312,   183,   110, -3204,  1175, 21125, -3204,   501,
    1235,   214, 42145, -3204, -3204,   501,   165,    38, -3204,  4038,
      97, -3204, -3204, -3204,  2719, -3204, -3204,  4739, -3204, -3204,
   -3204,   892, -3204, -3204, 21125,   501,  1170, -3204, -3204,   135,
     135,   135, -3204,   135, -3204,   135, -3204,   481,   920, -3204,
   -3204, 42145,   492, -3204, -3204,   881,   594, -3204, -3204, -3204,
   -3204, 21125,  1352,  1047, -3204, -3204, -3204, 21125, -3204,   -45,
   -3204, -3204,   942, 42145, -3204, 21125, 21125,   270,   909,  1203,
   42145, 35164,  1140, -3204,   111,   363,  1040,  1497, -3204,  1068,
   -3204, 42145, -3204, -3204, -3204, 38923,   769, -3204, 13412,  1389,
   42145, 42145,  1208, 42145, 42145, 35164, 21125,  1150,  1032,  3358,
    1187,  1149,  1005, -3204, -3204, -3204, -3204,  1214, -3204, -3204,
    1107, -3204, -3204, -3204,    92, -3204,    54, -3204, -3204, -3204,
   -3204, -3204,  1250,  1028, -3204, -3204,    89, -3204, -3204, 42145,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,  1382, -3204,
   -3204, 13412,   189,  1550,  1429, 21125, -3204,   353, -3204, -3204,
    1348, -3204, -3204, 35164, 21125, -3204, -3204, -3204, 18955, -3204,
   -3204,  1570, -3204,  1059, -3204, 21125,  1187, -3204,  1291,  1218,
     909,  1139, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204,  1082,  2719, -3204, -3204,  1387,  1505, -3204,  1236,
     -48,  1167,  1108,   833,   -48, 37312,  1424, -3204,   179, -3204,
    1509, -3204, -3204,  1229, -3204, -3204, -3204,  1233,  1242,  1409,
    1237, -3204,   229, -3204,    27, -3204,  -120,  1424,   -48,   172,
   -3204,  1456,  1578,   346,   360, -3204,   -57, -3204, -3204,  1648,
   -3204, -3204, -3204, -3204, -3204,  1382, -3204, -3204, -3204,  1174,
   -3204,  1399,  1261, -3204, -3204,    37, -3204,  1197,   522, -3204,
     720, 35701, -3204, -3204, -3204,  1633, -3204, -3204, -3204, 35164,
    1334,  1231, 21125,  -160, -3204, 39460, 21125, -3204,   210, 13412,
   -3204, -3204,  3676,     2,   786, -3204,  1711,  1380, -3204, -3204,
   -3204, -3204,  1622, -3204,  1215,  1224,  1592,  1247, -3204, -3204,
   -3204, -3204, -3204,  1659, -3204,  1300, -3204, -3204, -3204, -3204,
   -3204,  1671, -3204, -3204, -3204, -3204, -3204,  1047, -3204, 21125,
    -133, 21125, -3204,  1301, -3204,  1289, -3204,  1308,  1312,  1321,
    1328,  1332, 16227, -3204,  1342,  1357,  1360,  1362,  1370,  1372,
    1386,  1391,  1394,  1396,  1402,  1404,  1406,  1420,  1215,  1215,
    1448,  1454,  1458,  1464,   499,  1467, -3204,  1469,  1479,  1481,
    1484,  1488,  1499,  1503,  1516,  1519,  1522, -3204,  1525, -3204,
    1527,  1528,  1535,  1544,  1564,  1569,  1571,  1574,  1577,  1581,
    1582,  1583,  1584,  1594, -3204,  1595,  1598,  1600, 13412,  1602,
    1603,  1605,  1608,  1610,  1611,  1613, -3204,  1618,  1621,  1624,
    1628,  1631,  1632,  1636,  1637,  1640,  1641,  1652,  1655,  1656,
    1657,  1662, -3204, -3204, 13412,  1664, -3204, -3204,  1668,  1674,
   -3204,  1677,  1678,  1681,  1682,  1685,  1698,  1706,  1713,  1725,
    1737,  1746,  1748,  1749,  1753,  1755,  1759,  1762,  1774,  1775,
    1779,  1782, -3204,   806,  1784,  1789,   818,  1793, -3204,  1799,
   -3204,   205,  1805,  1806,  1807,  1215,  1215,  1215,  1809,  1813,
    1817,  1818,  1826,  1830, 13412, 16227, 16227, 16227,  8908, -3204,
   42145, -3204, 42145,  2534,  1938, -3204,  3792, 16227,  3082,   377,
   -3204, -3204, -3204,  1346,  1593, -3204, -3204, -3204, -3204, -3204,
    1835,  1343, -3204, -3204,  1373, 21125, -3204, -3204, -3204,  1548,
     115, 21125,  1330, -3204, -3204, -3204, -3204, -3204, -3204,  2060,
   -3204, -3204, -3204,  1658,  1684, -3204, -3204, -3204, -3204, -3204,
   -3204,  1724, -3204, -3204, -3204,  1842, -3204,  1842, -3204, -3204,
    1842, -3204, -3204,  1842,    59,  3845, -3204, -3204, 42145, -3204,
   42682, -3204, 18955,  2534, -3204,  1952, -3204, -3204,  2025, -3204,
    2018,   182,  1845, -3204, 21125, 37312, -3204, -3204,   107,  1848,
    1851,  1849, -3204,  1861, 21125, 21125, -3204, -3204, -3204, -3204,
      38,    67,  1852,   616, -3204, 42145, -3204,   310, -3204, -3204,
   -3204,  1853, -3204, 13412, -3204,  1855, -3204,  1285, -3204,  2179,
   -3204,  1943, 13412, -3204, -3204,  1868,  1068, 42145, 42145, 21125,
   21125, -3204, -3204, -3204,  1194, -3204, -3204, 42145,   -48, 35164,
   -3204, -3204, -3204,  2262,   172, 42145,   -48, -3204, -3204,   172,
   -3204, -3204, -3204, -3204, -3204, 21125, -3204, -3204,   172, -3204,
     172,   172,   -48,   -48,  1927, -3204, -3204,  1871, -3204,  1927,
    2005,   887,   135,  2088, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204,    73, -3204, -3204, -3204, -3204, -3204,
      87, -3204, -3204, -3204,  1540,  2526,  2526,  1808, -3204,   203,
   21125,  1883,  1943, 21125, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204,  1886, -3204,  1887,  1885,  2534,  2307,  2310,  2313,  2316,
    2320,  2322,  2325,  2327,  2328,  2333,  2351,  2353,  2355,  2357,
    2358,  1889, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
    1989, -3204, -3204, -3204, -3204,  1217, -3204, -3204, -3204,    95,
    1921, -3204, 37312,  2459, 35164,  2329, 42145, 42145, 42145, 21125,
   42145, -3204, -3204,   336,   336,  2168,  1301, -3204,    81, 42145,
    2338, 25440,   100, 13412, 13412, 13412,   798,  1168,  2449,  2501,
    2501,  2501, 13412, 13412, -3204, -3204, 13412, -3204, 13412, 13412,
   13412, 13412,   811, -3204, -3204,  9471, -3204,  1961, 13412, 13412,
    2048, 13412,  1593, 13412, 13412, 22205, 13412, 13412, 13412, 13412,
   13412,   732, 13412,  3082, 13412, 13412, 13412,  1969, 13412, 13412,
   13412, 13412, -3204, 13412, 13412,   281, 13412,  2416,   538, 13412,
   13412, 13412, -3204, 10034, 13412, 13412, 13412, -3204, 13412, 13412,
   13412, 13412, -3204,  2530, -3204, 22205,   826, 13412, 13412,   910,
   13412, 13412, 13412, 13412, 13412, -3204, -3204, -3204, -3204,  9471,
   -3204, 13412, 13412, 13412, 13412, 13412, -3204, 16227, 13412, 10597,
   13412, 13412, 13412, 13412,  1982, 13412, 13412,  2501,  2501, 13412,
   13412, 13412,  1035,  9471, -3204, 13412,  1593,  2692,  2692, 13412,
    1593,  7782, 13412, -3204, -3204, -3204,   538, 11160,  1986, -3204,
   -3204, -3204,  2501, 22205,  2501, 13412, 13412, 13412,  2534,  2020,
    2449,  2449,  2449, -3204,  8908,   175,  1993, 13412, 23285,  1991,
   -3204, -3204, -3204, -3204, 13412, 13412, 13412, -3204, 16227, -3204,
   -3204,  2417, -3204, -3204, -3204, 13975, 16227,  2006, 16227, 16227,
   16227, 16227, 16227,  2315, 16227, 16227, 16227, 16227, 16227, 16227,
   16227, 16227, 16227,   835,  2449, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204,  2012, -3204, 37312, 16227, 13412,
   -3204, -3204, 42145, 42145, -3204, 35164, -3204, -3204, -3204,   115,
   37312,  2008, -3204, -3204,  2188,  3358, 21125, -3204, 42145, -3204,
   -3204, -3204, -3204, 19495, 19495, -3204, 19495, -3204, -3204,    68,
      82,  2646,  2038, -3204, -3204, -3204, -3204,  2360, 21125, -3204,
     474, 21125,  1883, -3204, 13412,  1943, -3204, 35164, 35164, 21125,
   21125,   -16, -3204,   994, -3204,  1943,  2391, 19495, 19495, 19495,
   -3204, -3204, -3204, -3204, -3204,   155, -3204,  2534, -3204,  2019,
   -3204, -3204, -3204, -3204, -3204, 39997,   138, -3204, -3204,  1943,
    2418, -3204,  2534,  2027, 42145, -3204, -3204, -3204, -3204,   -27,
   -3204, -3204, -3204, -3204,   -65, -3204, -3204, -3204, -3204,  2156,
     -48, 42145, -3204, -3204,   -48,   172, 21125,   -48,   -48, -3204,
   -3204,   839, -3204,   -57, -3204, -3204, -3204, -3204, 42145,  1819,
    2170,  2037, -3204, -3204, 21125, -3204,  2039, -3204,  2442,  2581,
    1424, -3204, -3204, -3204,   282,   282,  1943,  2182,  2189,  2199,
    2205,  2207,  2210, -3204, -3204,  2765,  2572,   282,   282,  2572,
     282,   282,   282,  2163,  2535,   282,  2427,  2192,  1115,  2429,
     282, -3204,  2194,  2550,   282,   282,   282,  2572,  2626,   282,
     282,   282,   282,   282,   141,   282,   282,   282, -3204,  4922,
   -3204, -3204,  2113, 20035, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, 40534, -3204, 13412,  1168,  1943,  1943,   825,  1943,  1168,
    1943,  1943,  1943,  1943,  1943,  1168,  1943,  1943,  1168,  3676,
   -3204, -3204, -3204,   124, -3204, -3204,   -55, -3204, 42145, -3204,
    1177,  2118,  -118, -3204,  3794, -3204, -3204, -3204, -3204, -3204,
   21125,  2165,  2038, 25440, -3204,   887, -3204,  2116, -3204,   284,
     456,   194, -3204,  2501,  2119, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204,  2126,  2135,  2139,  2140,  1686,  1234,   585,  2146,
    1317,  2149,   644,   912,   186,   969, -3204,  2151,  2161,  1546,
   -3204,  1042,  1069,  1634,  1699,  1079,  2157,  2150,   228,   232,
    1089,  1119,   240, -3204,  2162,  1123,  2557,  1138,  1146,   266,
   -3204,  1703,  1159,  1180,   280,  2169,   286,   321, -3204, -3204,
   -3204, -3204,  2175,  1186, -3204, -3204,  -126,  1708,  1195,  1199,
   -3204,  1717,  1206,  1223,   329,  2178,  1263,   349,  1268,  1273,
    2190,  2180,  2191, -3204,  2501,  2196,  1767,  1772,  2501,  2201,
     355,  1286,  1776,   521,   605,  2212,  2214,  2216,  1786,  1791,
    1822,   630,  1288,   636,  2221,  3115,  1828, -3204,  1923,  1293,
    1299,  1311,   672, -3204,  1325,  1937,  2230,  2237,  1329,   246,
    1336,  2501,  2242,  1954,   679, -3204,  2206, -3204,  2209,  1956,
   11723, 12286, 12849,   221,  1359,   631, -3204,  1970, -3204,  2243,
    2246, -3204,  2150,  2247,   690,   696,  1974, 13412,  -179, -3204,
     481, -3204, -3204, -3204,   104,   671, -3204,  2323, 42145,   366,
     134, -3204, -3204, -3204, -3204, -3204, -3204,   414, -3204,  2249,
   -3204,  2250,  2257,  8908,   295,  2257,  1654,  1739,  1739, 16227,
    2661,  3145,  3228,   543,  3082,   543,  3082,  2257,  2257,  2257,
   -3204,  2259, 16227, 16227, 16227, 13412, -3204,  2449,  2534,  2255,
     701, -3204, -3204, -3204, -3204, -3204,  1330,  2568, -3204,  1883,
   -3204, -3204,  1012, -3204,  2258, -3204,  2261,  2354,  2361,  2362,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204,  1424,   994,  2366,  2265, -3204, -3204,  2299,  2592,
   -3204, -3204, -3204,  2534, -3204,  2367, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204,    24, -3204, -3204,  2285,  2285, 17870,
   -3204, -3204, -3204, -3204,  2515,  2682,  2688,  2694,   720, -3204,
     137, -3204,   710,  2641,  1424, -3204,  2696, 37849, 25979, -3204,
    2301,  2642,  2304,   282, 33553,   108, 23822, 34090, -3204, -3204,
     825, -3204,    13, -3204, -3204, -3204, -3204,  1194,  1194,  2337,
   -3204, -3204, -3204,  2038,   172, -3204, -3204, -3204,  2314, -3204,
   -3204,   887,  2655,  2656, -3204,  2539,    84,  2539,   887,   887,
   22205,   887,  1350, -3204,  1168,  2594, -3204, -3204, -3204, -3204,
   -3204, -3204, 36238, 34627, -3204, -3204, -3204,  2796, -3204,  2799,
     966, -3204, 22745,   995,   995, -3204,    69,   176, 22745, -3204,
   -3204, 22745,   825,  1168, 22745,  1168,  1943,  1943,  1530,   282,
    1168, -3204, -3204,  2663,  2664, 22745, 22745, -3204, 37312, -3204,
     282,   117,   825,   825, 22745, 22205,  2675,  1943,  1168,  1168,
    2267, -3204, -3204, -3204, 21125,  1390, 37312,  2346, -3204,  5459,
   17330, 42145,   624,   130, -3204,  2326,  2350, -3204,  1052, -3204,
    2534, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204,  2422, -3204,  2510,  2363, -3204, -3204,    33, -3204,
     774,  2350, 21125, 16790, -3204,    79, -3204,  3302, -3204,   887,
    2569,    86,  2038,  2368,   100, 14538, -3204, -3204, 13412,  2371,
   -3204, 13412, 13412, -3204, -3204, -3204,   258, -3204, 36775, -3204,
   -3204, -3204, -3204, -3204, 13412, 36775,   258, 13412, -3204, -3204,
    2372, -3204,  2707,  2707, -3204, -3204,  1593, -3204, 42145, -3204,
   13412, -3204, 13412, -3204,  1593, -3204, 13412, -3204, 13412, 13412,
   -3204,  2584, -3204, 13412, -3204, 13412, 13412, -3204, 13412, -3204,
   -3204, 13412, -3204, 13412, 13412, -3204, -3204,  2598, -3204, 13412,
   13412, -3204, -3204, 13412, -3204, 13412, -3204, 13412, -3204, 13412,
   -3204, 13412, -3204, 16227, 22205,  2373, -3204, -3204, -3204,  2380,
   -3204, -3204, 13412, 13412, -3204, -3204, 13412, -3204, 13412, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, 13412, 13412, -3204, 13412,
   -3204, 13412, -3204, -3204, 13412, 13412, 13412, -3204, 13412, -3204,
   -3204, -3204, -3204, 15101, 13412, 13412, 13412,  2381, -3204, -3204,
   -3204, 13412, 13412, 13412, -3204, 13412,  1309, 13412,  2112, 13412,
    2273, 13412, -3204, 13412,  2614, -3204, -3204, -3204, -3204, -3204,
   13412, -3204, 13412, -3204,   323, 13412, 13412,  2805, -3204, -3204,
    2386, -3204,  2387,  2389,  2393, 37312, 13412, -3204, -3204, -3204,
   -3204, -3204,   732,   702,  2400, 16227, -3204,  1654, 16227, -3204,
   -3204,  8908,   295,  1654,  2689, -3204,  2401, -3204, -3204,  2403,
   42145, -3204, -3204, -3204, 42145,  2394, 26518, 35164, 35164, 35164,
    2392, 13412, -3204, -3204,  2629, -3204, -3204, 21125,  2758, -3204,
   -3204, 35164, -3204,  2719, 22205, -3204,  2409, -3204,  2409,   812,
    2412,  1064, -3204, -3204, -3204,  2407,  1139,  2811, 35164, 35164,
   35164, -3204,  2038,  2038,   131,  2468,  2756, -3204, -3204, -3204,
   -3204, 41071, -3204, -3204, -3204, -3204,   733, 42145,  2745, 42145,
    8345, -3204, -3204, -3204,  2927, 13412, -3204, 35164,   598,   671,
     282, -3204, -3204, -3204, -3204, -3204, -3204,  1424, -3204, -3204,
   -3204, -3204,  2723, -3204,   -48,   839,  -163, -3204,  3022, -3204,
   -3204, -3204,  2763,   887,  2539,  2539,  2764,  2659,   -51,  2438,
   -3204,   282,  1819,    93, -3204,  2719, -3204, -3204, 13412, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, 13412,  2771,  2773,   995, -3204, 22745, -3204, -3204,
    -133,   125, -3204, -3204, -3204, -3204, -3204, -3204, 34627,  1943,
   -3204, 22745, -3204, -3204,   133, -3204,  1943, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204,  2446, -3204,   299, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, 21125, -3204,  1077, -3204, -3204,
   -3204, -3204, 42145, -3204, -3204, 21125, -3204, -3204,  4779, 42145,
   42145,  2994, -3204, 42145, -3204,   774, -3204, -3204, -3204, -3204,
    2676, 42145, -3204, -3204, -3204, -3204,  2518,  3003, -3204, 21125,
   -3204,  2461,  1113, -3204, -3204, -3204,  3005,  4846, -3204,  2465,
    2038,  2779, -3204, -3204, 13412,  1976,  1983, -3204,  2534,  1985,
    2467,  2467, -3204, -3204,  2478,  2467,  2813, -3204,  2817,  2480,
    2486,  2487,  1994,  2488,  2489,  1365, -3204, -3204,  3082,  3082,
    2493,  2492,  1996,  2001,  2494,  2499,  2016,  1383,  2050,  2500,
    2502,  2052,  2062,  1393,  2074,  2076,  2081,  2106,  2503,  2569,
    2466,  1434,  1442,  2506,  2110,  2124,   725,  2132,  2507,   759,
    2852, -3204, -3204, -3204,  2134,  2136,  2141,  2164,  2174,  2198,
    2204,  2220,  2234,  1453,  2236,  2238,  2509, 13412,  2240,   856,
     803,  1473, -3204,  2256,  1480,  1498,  2260, 13412,  2271, 13412,
    2289, 13412,  2309,  2340,  2513,  2342,  2359, 13412,   508,  2534,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204,  2512,  2534,  2519,
   -3204, -3204, -3204,   377, -3204,   821,  2520, -3204, 16227, -3204,
   13412,  2514, -3204,  2525, -3204, -3204, -3204, -3204, -3204,   483,
     483,   483, 15664,  2534,  2942, -3204,    39, -3204,  2851, -3204,
   -3204,  1082,  2531, -3204,   282, 15664,  2285,  2668, -3204, -3204,
     812, 22205, 25979, -3204, 35164,  1247,  1247,  1247,  1424,  2905,
    2366,  2366, -3204, 24359, -3204, -3204,  2673, -3204, -3204, 27057,
   -3204,  1063, -3204, -3204, 16227,  1479, -3204,  2534, -3204, 36238,
   -3204,  2534,   282,  2546,  2548, -3204, -3204, 41608, 13412, -3204,
    2967, -3204, -3204,  2551,   887,  2767,   887, -3204,  2886,  2894,
     887, -3204, -3204, -3204, 22205,  2038, 15664,   995,   995,   995,
   -3204,  1082,  2534,  2580,   299,  2534, 22745, -3204, -3204,  -133,
    2570,  3035,  3036, 22745,  2927, -3204, -3204, -3204, -3204,  4779,
   22205, -3204, -3204, -3204,  2588, -3204, 17330, -3204, -3204, -3204,
    2585,  2590,  2467, -3204, -3204, -3204, -3204, -3204,  2478,  2794,
   -3204,  2478,  2478, -3204, -3204, -3204, -3204, -3204,   252,   233,
   -3204, -3204,   252, -3204, -3204, -3204,    56,   419,  2478, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204,  2467,  2467, -3204, -3204,
   -3204,   252,  2596, -3204,  2467,  2810, -3204,   225,    78,  2597,
    2600,  2467,  2609,  2603, -3204,  1193, -3204, -3204,  2677,    43,
   -3204,  2615,  2613, -3204, -3204,  1943, -3204,  2617, -3204,  4922,
   -3204,   757, -3204, 42145, -3204,  1194, -3204,  3082, -3204, -3204,
   -3204,  2856, -3204,   252,  2858, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, 13412,  2630,  2632,  2633,
   -3204, -3204, -3204, -3204, -3204, -3204, 13412, -3204, -3204, -3204,
   -3204, -3204, 13412, -3204, -3204, -3204, -3204, -3204,  2774, -3204,
    2867, 13412, 13412, -3204, -3204, -3204, -3204, 13412, -3204, -3204,
   -3204, 13412,  3159,  2829,  2640, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, 13412, -3204, -3204, -3204,  3082, -3204,
   13412, -3204, -3204, 13412, 13412, -3204, 13412, 13412, -3204,  2369,
   -3204,  2377, -3204,  2385, -3204, -3204,  2871, -3204, -3204,  2534,
   13412, -3204,  2644, 42145, -3204, -3204,  2645, -3204, -3204, -3204,
   -3204,  2534, -3204, -3204,   685,  2672,  2672,  2672,  1479,  2534,
    1204, -3204, -3204,  2986, -3204,  1853, 22205, 15664,  2665,  2658,
   -3204,   522, -3204, -3204,  2657,  1247, -3204,  3178,  3028, -3204,
   -3204, 37312,  2666, -3204, -3204,  2928, -3204,    96,  2850, -3204,
   -3204, -3204,   598,  2760,  2780,   282,  2534,  1943,  1537,  2037,
    3002,  2815,  2730,   887,   887,  2916,  2732, 13412, 13412,  2697,
   -3204,  2569, -3204,  3091, -3204, -3204, -3204,  1853, 13412, -3204,
    2700,  2701, 42145, -3204,  3154,   624, -3204,  2810, -3204, -3204,
   -3204,   462,  2931,  2933, -3204,  -124, -3204,  2706,  -124,  -124,
    3238,   120, -3204,  3238, 36775, -3204,  1236, -3204,  2743,   252,
   -3204, -3204,  2744, -3204, -3204, -3204,  -124,  2713,   252, -3204,
   -3204,  2943,  -124, -3204, 37312,  1943,  2949, -3204,  2766, -3204,
    3170,  3056, -3204,  2810, -3204,  3058,  2963, -3204,  2964, -3204,
   -3204,  2968, -3204,  2969,  2971,  -124,  2972, -3204,  -124, 42145,
   -3204, 42145,  2776,   797,  1943, -3204, -3204, -3204,  2747,  2748,
   -3204, -3204, 21125, -3204, 42145,  4779, -3204,  2776, -3204,   522,
      79,  2668, -3204,  1243,   299,  2746, -3204,  2751,  2752, -3204,
    1254,  2411, -3204, -3204, -3204,   884,  2419,   135,  2754,  2755,
    2423,  1553,  2425,  2458,  3015,  3168, -3204,  2471,  2762,  2476,
    2491,  2504,  2511,  2517, -3204, -3204, -3204,  2770,  2534, -3204,
   -3204, -3204,  2768, 37849, -3204,  2857,  2859, -3204, -3204,  2861,
   -3204, -3204,    88,  1534, -3204, -3204, -3204, -3204, 15664,  3095,
   -3204,   159, -3204, -3204, -3204, -3204, 13412, -3204,  2569,  3263,
   -3204, 24359, -3204, -3204, -3204, -3204, -3204,  2777,  2783,  8345,
    3318, -3204,   887, -3204,  2830, -3204, -3204, -3204,  2832,  2534,
    2534, 42145,  2779,  3130, -3204,   159,   299, 42145, 42145,  1279,
     538,   538,   538,  1192,  1192, -3204, -3204, -3204, -3204,    16,
      41, 42145, -3204, -3204,   992, -3204,  2800,  2802, -3204, -3204,
   -3204, -3204,  -124, -3204,   135, -3204, -3204, -3204, -3204, -3204,
   36775, -3204, -3204,  3238, -3204, -3204, -3204,   135, -3204,  2803,
   -3204, -3204, -3204,  1215, -3204, -3204,  3039,  2845, -3204, -3204,
   -3204, -3204,  2809,  2814,  2821,  2822, -3204,  2812, -3204, -3204,
   -3204,   972, -3204, -3204, -3204, -3204, -3204, -3204,  1037, 42145,
    3203,  2981, -3204, -3204, -3204, -3204, -3204,  2824,  1139, -3204,
   42145, -3204,  3041, -3204, -3204, -3204,  3055, -3204, -3204, 13412,
   -3204, -3204, -3204,  2501, -3204, 13412, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204,   247,  3049,  1168,  1168,  1168,  1168,
    1534, -3204, -3204,  2881,  2921, -3204,   710, -3204,  -176,   299,
   13412,  1424,   780,  3148, -3204, -3204, -3204, -3204,  3128,  3077,
   13412,  2840, 13412,  2860,  1297, -3204, -3204, -3204,  2862, -3204,
   -3204,  1333,  1345,  -133, -3204, -3204,   624, -3204, -3204, -3204,
     845,   845,  1353, -3204, -3204, -3204, -3204, -3204,  1375, -3204,
   -3204, -3204,  1388, -3204, -3204,  1215, -3204,   252,  3238,   252,
    3238,  3354,  3070,  3359, -3204,   481, -3204, -3204,  4779, -3204,
   -3204, -3204, -3204,   299,  2863,  2865,   922,  2868,  2544,  2870,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, 22205, 21125, -3204,
      85, 13412, -3204, -3204,  2534,  3051,  3374,  3375,  3288,  3389,
     780, -3204,   -87, -3204,  3292, -3204,  2534, 42145,  2534, 42145,
   -3204, 42145, 40534,  3053,  -133, -3204, -3204, -3204,  3430, -3204,
     166, -3204, -3204,   992, 42145,   252,   135,   252, -3204, -3204,
   -3204, -3204, -3204,  3096, -3204,  3101, -3204,  2883,  3020, -3204,
    3314,  4779,   522, -3204, -3204, -3204, -3204, 13412, -3204, -3204,
   -3204,  2885, -3204,   282, -3204, -3204, -3204,   299, 42145, -3204,
     135,   135,  3404,   135, -3204,  3406,  3409,   -87, -3204,   825,
   13412,  1414,  1426, -3204,  2893,  2895, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,   522, -3204,
   -3204, -3204,  3337, 31932,  3042, -3204, -3204,  2593, 22205, 15664,
    1530, -3204, -3204, -3204, -3204,   135, -3204,   135,   135, -3204,
    3442,   168, -3204, -3204, -3204, -3204, -3204, 42145,   595, -3204,
   43219, 43219, 42145, -3204,  2929, -3204,  4226,   645, -3204, -3204,
   -3204, -3204, -3204, -3204,  3431, -3204,  2897, -3204, -3204, -3204,
   -3204, -3204, -3204, 34627, -3204,  2902, -3204, -3204, -3204,  3193,
   -3204, -3204, -3204,  3297, 42145, -3204, -3204, -3204, -3204, 13412,
   13412,  2939, -3204, 31932, 31932, -3204, -3204, -3204, -3204,  3445,
   31932,  3020, -3204,  3263,  2915,  3335, -3204,  3256,  3341, 13412,
    2534,  2534, -3204,   311, -3204, 29222,  2912, 32474, 13412, -3204,
     645,  3431, -3204, 31932,  3148, 13412,  2920,  2925, -3204,  1168,
   -3204,  3279,  1232,  2957, 13412, 31932, -3204,  3352,  3232,  2923,
   -3204,  2934,  2611,  3390, 43219, 43219, -3204,  3294,  2534, -3204,
   -3204, -3204, 42145, -3204, -3204, -3204,   728, -3204,  2534, 29764,
    2950, -3204, -3204, 13412, -3204, 38386, 30306,  2937, -3204, -3204,
   -3204,  3177,  2951, -3204,  2947, -3204, 31932, 13412, -3204,  3372,
    2965, -3204,  2560, 31932, -3204, -3204,  3319,  2954,  1271, -3204,
    2958, -3204,  3269, 18410,  3093, 42145, 27596,  2534,  2977, 31932,
    3133, 30848,  3361, 42145,  4779,  3363,  3364, -3204, -3204, -3204,
   37312,  1433, -3204, -3204, 22205, -3204, -3204,    -1,  2988, -3204,
   28138, -3204,  2999, -3204, -3204,  3432,  2808, -3204, -3204, -3204,
   20580,  2885, -3204, 31932, -3204, 31932, -3204, 33016, 13412, -3204,
    3016, -3204, -3204, -3204,  4226, -3204, -3204, 31390, 28680, -3204,
   -3204, 24896, -3204, -3204, -3204,  3369, -3204,  2534, -3204,  1593,
   -3204, 33016, -3204, -3204, -3204, -3204
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3204, -3204, -3204, -3203, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204,  1735, -3204, -3204, -3204, -3204, -3204,  1973, -1401,
   -3204, -3204, -3204, -3204, -3204,   358,    46,  2866,    57, -3077,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,   526,
     525, -3204, -3204,   352, -3204, -3204,   170, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204,  -130,   -94, -3204, -3204, -3204,
   -3204,  -147, -3204, -3204, -3204, -3204, -3204, -3204, -3204,   -99,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204,   -22, -3204, -3204,    22, -3204, -3204,   -20, -3204,
   -3204,    -4, -3204, -3204, -3204, -3204,    25, -3204,    23, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204,   537, -3204, -3204,
   -1826, -3204, -3204, -3204, -3204,  2439,  -977, -3204,  3179, -3204,
    -400,   810,  2031, -1899, -1013,  -608,  -601,  -701, -3204, -3204,
   -3204,   448,  1155,  1549,   895,  2040,  2079,  1597,  1639, -3204,
   -3204,   918, -3204, -2618, -3204, -3204, -3204,   883, -3204,   885,
   -3204, -3204, -3204, -1100,   851,  -314, -3204,   443,     0, -3204,
     651, -3204,   606, -3204,  -432, -2009, -1905, -3204, -3204, -3204,
     617,   926,   974, -3204, -2579, -2101, -3204, -3204,   241, -3204,
   -3204, -3204,   234, -3204,   466,   320, -3204, -3204, -1470, -1808,
   -3204, -3204, -2297,  2473, -2138,   408, -1869, -3204,   459, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,  1645, -3204,
   -3204, -3204,   139,   219, -1310, -2651, -3204, -3204, -3204, -3204,
   -3204, -3204,  1002, -3204, -3204,  2155,  2587, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,  1787, -3204,
   -3204, -3204, -3204, -3204, -3204,  2524, -3204, -3204, -3204,  1303,
   -3204, -3204, -3204, -3204,  2229, -3204, -3204,  2956, -3204, -3204,
   -3204, -3204,  1397,  1803, -3204, -3204, -3204,  2982,  1788,  -455,
   -1723, -3204,  3206, -3204, -3204, -3204, -1296, -1921, -3204,  3060,
     403, -1448,  2251,  -485,   802, -3204,   607,  -742,  4199, -3204,
   -1278, -1108, -3204, -3204,  -486, -3204, -3204, -3204, -1251,  -715,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204,   809, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -1114, -3204,
    1612, -3204, -1070, -3204, -3204, -3204,  2460, -3204, -3204, -3204,
   -3204, -3204, -1867, -1341,  1039, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -1858, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -1357, -3204, -1560, -3204, -3204,  -656, -3204, -3204,
     324, -1969, -1168,  2420,   739, -3204, -3204,  -953,  2521, -1541,
   -3204, -3204, -3204,  1463, -3204, -3204, -3204, -3204, -3204,  1007,
   -1978, -1035, -3204, -3204, -2576,  -614, -1796,  -596, -3204, -1829,
     567, -1146, -1856, -3204, -3204, -3204, -3204,   121, -3204, -3204,
   -3204,   589,  1821, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
    -169,  -363,  1295, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204,  2753,  2728,  1875, -3204, -3204, -1910, -3204, -3204,
    1846, -3204,   823, -1845,  2791,  1114, -3204, -3204,  1117, -2583,
   -3204, -3204, -3204, -3204, -3204, -3204,  1060,    83,   265,  3270,
   -3204, -3204, -3204, -3204, -3204, -3204,  2987,  2571, -1456,  3213,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,  3287,
   -3204,  -954, -3204,  -433, -3204, -3204,  -583, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204,  2352, -3204,  1323, -3204,
   -3204, -3204,  2750, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
    1145,   212, -3204,   376,   193, -3204,   322, -3204, -3204, -3204,
      90, -3204,  -751,  -665,  -995,   752, -2133, -1111,  1141,  2769,
   -2750, -1119, -1259, -1262, -1769,    21, -3204,    -7,  -445,  -890,
    -574,  2612, -2227,  -411,  -501, -3204,  2049, -3204, -3204, -3204,
   -3204,  2311, -3204, -3204, -3204, -3204,  1444, -3204, -3204, -3204,
    1110, -3204,   841,   647, -3204, -3204,  2917, -3204,  2344, -3204,
   -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204, -3204,
   -3204, -3204, -3204,  2784,  3329,  3173, -3204,  2823, -3204, -3204,
   -3204, -3204, -3204,   527, -3204,  1368, -3204, -1307,  2635,   564,
   -3204,  1536,  -524,  -803, -3204,   524, -3204, -3204,  1133,  3342,
    3185, -3204, -3204, -3204, -3204, -3204, -2201,  -584, -3204, -2266,
   -3204, -3204, -3204, -3204,  1579, -1134,  2483,  1227, -3204, -3204,
   -3204,  3290,  3398,  3399, -3204, -3204,   -41, -3204,  3317,  -172,
   -3204,  1760, -3204,  1038, -3204, -3204,   768,  3303, -3204, -3204,
    3304, -3204, -3204, -3204, -3204, -3204,  3305, -3204, -3204, -3204,
   -3204, -3204,  1294, -3204, -3204, -3204, -3204, -3204, -3204
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1976
static const yytype_int16 yytable[] =
{
     374,   554,   667,   702,  1360,   638,  1067,   989,  1400,   713,
     721,  1612,   374,  1182,   908,   374,  1173,  1174,  1176,  1455,
    1016,  1741,   374,  1031,  1740,  1646,  2198,  1158,  2343,  1490,
    1762,  1011,   374,  2260,  2306,  1949,  2242,  1770,  2290,  2295,
    2298,  1016,   374,   409,  2318,  1613,  1614,  1615,  1965,  2470,
    2643,  2040,  2328,   373,  2332,  1032,  2473,  1644,  1627,  1804,
    2327,  2947,  2451,  2670,  1539,  2603,  1636,  1072,  2310,  2311,
    1907, -1816,   970,  2932,  1073,  1464,  1784,  1786,  2279,  2360,
     374,   652,  -248,  1240, -1480, -1817,  1467,  1468,  2939, -1481,
    -528, -1880, -1105,  1493,  1618,  1619,  2362,  1621,  -258,   729,
     374,   374,  1266,   374,  3243,  1270,  1683,   946,   464,  1264,
    3000,  2972,  1685,   487,   374,  1689,  2381,  2382,   946,  1300,
    1301,   710,   967,  1279,  1280,  1281,  2352,  -259,  1923,  1873,
    2970,  3652,  1655,  2971,  1404,  2350,  2351,  1849,  2448,  1705,
    3158,  2044,   481,  1716,  1717,  2427,   941,  1675,  1722,  1300,
    1301,   938,  2980,  3290,   469,  1114,   470,  2308,  2999,  1981,
    1290,  1291,  1292,  1366,  3103,  1695,  1696,  1697,  1739,   656,
    1743,  3405,  1334,  2349,   608,   609,  1704,  1849,  1078,  2349,
     685,  1366,  2361,  1300,  1301,  2364,   559,  2352,  3126,  3287,
    1300,  1301,   608,   609,  3039,  1069,  2373,  2374,  1001,  1598,
     946,  1300,  1301,  1069,  1013,  2383,  1035,  2441,  1772,  1300,
    1301,  1775,  1776,  1777,  1778,   976,  1780,  1781,  1782,  1783,
    1785,  1787,  1788,  1789,  1790,  1135,  1136,  1137,  1027,   547,
    1894,   947,  1069,  2352,  1383,  2353,  1300,  1301,  1415,  1273,
   -1480,  1017,   947,  1300,  1301,  2960,   568,  1300,  1301,  2443,
    1929,  2671,  2428,  2960,  2042,  1300,  1301,  2961,  2657,  2610,
    3015,  1300,  1301,   954,  2272,  2961,  1916,  1057,  3016,  1897,
    2962, -1105,  2960,  3512,  3429,   576,  2297,  2377,  2962,   608,
     609,  1300,  1301,  1982,  2961,  2030,  2652,   608,  2966,  2443,
    2460,  1025,  1360,   555,  3137,  1300,  1301,  2962,  2022,  1300,
    1301,  1300,  1301,  2658,  3093,  3075,   608,   609,   683,  3148,
     415,  3440,  1546,  2461,  2323, -1816,   693,   694,  2681,   580,
    1014,   695,  1421,   723,   947,  1082,  1870,  2324, -1480, -1817,
    1870,  1045,  2591, -1481,   657,  1029,  1300,  1301,  1300,  1301,
     987,   121,  -337,  1033,  1300,  1301,  3259,   910,   498,  2598,
     658,   440,  2462,  2195,  2378,  2463,  1850,  2326,  1357,  3340,
     955,  1143,  2313,  2464,  1300,  1301,  3415,  2196,  3288,   381,
    1300,  1301,  2941,  1030,  1115,  1658,  1360,  1871,  1659,  1585,
    1360,  1300,  1301,   556,  1144,  3149,  3341,  1486,  3416,   106,
    3164,   374,  2181,  3017,  1046,   429,  1850,  1034, -1935,  3168,
    1333,   374,  1083,   441,  1274,   374,  1014,  3203,  2001,   581,
     374,  1038,  2682,  2011,  2661,   374,   981,  2164,  1489,  2017,
    3150,  2023,  2020,  1088,  1929,  1384, -1480,  1547,  1895,   577,
     416, -1481,  1422,  2354,  2444,  1457,  2107,   374,   564,  1058,
    1357,  2215,  1089,  1463,  3440,  2379, -1105,   557,  1302,   483,
    3289,  1303,  1884,   956,   374,  2638,   728,  1666,  3211,  1469,
    1470,  3680,  1072,  2674,   374,  2647,  2653,   549,  1491,  1073,
     374,  1300,  1301,   582,  2444,  3076,   374,   711,   374,   374,
    2611,   560,  1028,   374,   374,  1002,  2656,   472,  2669,  2049,
    2325,  1885,   678,  3406,   374,   569,  3430,  1898,   374,  1851,
    1489,  2452,  2676,   374,   374,  3252,   374,   374,   374,   374,
     422,  1903,  1302,  1081,  2415,  1303,  1367,   686,  1458,  1302,
    1949,  1072,  1303,  1300,  1301,  1735,  1539,   939,  1073,  2273,
    1302,  1385,  1586,  1303,  1367,  1930,  1300,  1301,  1302,  1851,
    -337,  1303,   374,  2309,  2429,  3653,  1083,  2668,  2762,   548,
    3280,  2672,  3291,  2317,  1403,  1141,  1441,  1476,   374,   906,
     907,   680, -1105,  1949,  1083,  1302,   374,   374,  1303,  2208,
    2125,   374,  1302,  2355,  2129,  1303,  1302,  2465,   374,  1303,
    2280,  2973,   589,   942,  1302,  2044,   961,  1303,  2349,   976,
    1302,  3407,  1405,  1303,  3104,   973,  1493,  1741,   696,   712,
    2264, -1816,  2349,  1774,  -130,  1466,  1444,  2167,   374,  2659,
    1302,   658,   976,  1303, -1480, -1817,  2219, -1105,  2220, -1481,
    1300,  1301,  3159, -1880,  1302,  3095,  1983,  1303,  1302,  1083,
    1302,  1303,  2412,  1303,  1018,  3366, -1816,  1549,  3001,  2214,
   -1975,  1358,  1495,  1797,  1304,  1300,  1301,  -248,  1593, -1480,
   -1817,  1300,  1301,  2043, -1481,  -528, -1880, -1105,  1741,  1300,
    1301,  2331, -1105,  -258,   374,  1302,  1316,  1302,  1303,  2201,
    1303,  2217,   374,  1302,  1304,   374,  1303,  1083,   374,   374,
    -337,  1275,  2200,  3343,  1026,  2223,  2224,  1300,  1301,   417,
    2892,  2466,  -259,  1302,  1300,  1301,  1303,  1477,  2450,  1302,
    3389,  1478,  1303,  2065,  1886,  1300,  1301,   481,  1304,  1930,
    3079,  1300,  1301,  1741,  1039,  1304,  2386,  1300,  1301, -1105,
    1550,  1575,   374,  1358,   374,   492,  1304,  2963,  3379,   711,
    3381,  2608,  2609,  3500,  1304,  2963,  1751,  1752,  1838,  2467,
    1300,  1301,  1369,  3075,  2209,  3139,   491,  3393,  2066,  2887,
    1142,  1587,  1147,  2997,  2963,  2047,  2048,  2967,  2733,  1660,
     515,  1304,  1661,  3205,  2648,  2649,  3502,  2468,  1304, -1938,
    -500,  2260,  1304,  3445,  1300,  1301,  1360,   952,  2336,  2921,
    1304,   573,  2182,  2925,  2413,  2998,  1304,  2912,  2922,  2079,
    2080,  1417,  2926,  2081,  2082,  1402,  3433,  2940,  3435,  3140,
    1302,  2085,  2086,  1303,  3129,  1411,  1304,  2363,  2165,  2365,
    1602,  3136,  2896,   680,  2370,  1042,  1040,   822,  1300,  1301,
    1304,  2478,  2479,  1602,  1304,  1767,  1304,  2092,  2093,   551,
    2388,  3451,  2390,  2391,  2395,  1041,  1300,  1301,  1602,  1117,
     438,  2097,  2098,  3532,   439,  1360,  2045,  2100,  2101,  1319,
     378,   712,  1302,  3136,  1839,  1303,   822,  3555,  2202,  3157,
     435,  1304,  3162,  1304,  1803,  1302,  3492, -1938,  1303,  1304,
    2547,  1300,  1301,   374,  1051,   374,  1928,  1900,  2275,  2432,
    2874,  1902,  2102,  2103,  1905,  1906,  1043,  1757,   672,  1304,
    2114,  2115, -1975,  3367,  1016,  1304,   442,  2349,   374,  1300,
    1301,   456,  1455,  1455,   374,  2210,  1845,  1846,  3513,  2764,
    2118,  2119, -1354,  3076,  2642,  3346,  2131,  2132,  3503,   965,
    1603,  2211,  1602,  2203,  1006,  3347,  1364,  1300,  1301,  2004,
    2579,  2580,  2581,  1626,  2633,  3032,  3036,  1300,  1301,  1118,
    2564,   374,  1119,   374,  2974,   374,  1796,  2975,  1684,  1302,
    2314,  2634,  1303,  3122,  1120,  3163,   443,   374,   374,  1805,
    1844,  2605,  2606,  2607,   106,  1072,  2276,   374,   374,  2333,
    1863,   117,  1073,   118,  1302,   852,  1539,  1303,   374,   502,
    1302,   459,  1418,  1303,  1300,  1301,  3365,  2005,  1302,  3281,
    3282,  1303,  1741,  2471,  1889,  2594,  1304,  2433,  2476,  1180,
     374,   374,   374,   374,  1887,  2511,  3645,  3322,  1007,  3077,
     374,  1840,   374,  2484,   852,  2510,  1302,  2046,   374,  1303,
    2489,  3311,  3141,  1302,  2840,   987,  1303,   460,   374,  3312,
    1447,  1448,  1688,   503,  1302,  2498,  2499,  1303,  1180,  3514,
    1302,   457,  2503,  1303,   107,  1134,  1302,  1602,  1304,  1303,
    2508,  1934, -1354,  1445,  1446,  2860,  1465,  1300,  1301,  1181,
    1791,  1304,  3301,  1456,  2677,  3115,  3116,  3427,   673,  1302,
    3109,  1462,  1303,   374,  2635,  2346,   374,  2222,  2559,  1121,
     461,  1792,  2135,  2136,  1300,  1301,  2006,  2566,  1385,  2526,
     466,  2453,   114,   674,  1300,  1301,  2204,  1329,  1330,  1331,
    1332,  1548,  2058,  1302,  1300,  1301,  1303,   658,  1098,  1099,
    2002,  2003,   471,  2010,  2931,  2012,  2013,  2014,  2015,  2016,
    3261,  2018,  2019,  3348,   822,   374,  3446,   374,   108,   374,
     374,   374,   374,   374,  1300,  1301,   822,  3078,  1300,  1301,
      40,   504,   374,  2885,   374,  1304,  2059,  1302,  3079,   472,
    1303,  3300,  1293,  1300,  1301,  2434,  2007,  1721,  1122,  2574,
    1583,  1300,  1301,   109,   483,  1302,  2137,  2138,  1303,   115,
    1304,   430,  3465,  3368,  1300,  1301,  1304,  1855,   374,  3515,
     484,  1941,  1579,  1580,  1304,  2026,  2480,  2933,  2933,  2933,
    2347,  2145,  2146,  2184,  2485,  1300,  1301,  2148,  2149,  1008,
    1302,  1300,  1301,  1303,  2027,  3207,  2063,  3380,  1088,  3382,
    1300,  1301,  1304,  2937,  1300,  1301,  1949,  3193,   374,  1304,
    1793,  1300,  1301,  3080,  3313,  1109,  1110,  1089,  1302,   487,
    1304,  1303,  1855,  2157,  2158,  2435,  1304,   697,  1300,  1301,
    2170,  2171,  1304,  3506,  3507,  3269,  3369,  1300,  1301,  1300,
    1301,  2189,  2190,   478,  3015,  3349,  1302,  2191,  2192,  1303,
    3575,  2229,  3016,  2560,  2561,  1304,  1302,  2375,  2230,  1303,
    1117,  3370,  1606,   499,  3555,  3139,   374,   489,  1300,  1301,
      51,  1963,   852,  1300,  1301,  2404,  2816,  2817,  1300,  1301,
    2870,   374,  1643,  2229,   852,  2199,   766,  2895,   698,  1304,
    2619,  1300,  1301,  1300,  1301,  1009,  1180,  1476,  1300,  1301,
    2788,  2789,   501,  1302,  1300,  1301,  1303,  3031,  1180,   110,
    2820,  2821,  2008,   406,  1300,  1301,  1300,  1301,  1088,  3140,
    1607,   419,  1300,  1301,  1857,  1858,   425,  3589,  3589,  1741,
    1300,  1301,  2264,  1304,  1300,  1301,  3625,  1089,  1083,   386,
     374,  1300,  1301, -1105,   779,   374,   374,  3194,   374,   509,
    3626,  1304,  1010,   374,  2842,  2843,  1265,  1608,   946,   374,
    1118,   374,  2597,  1119,  1300,  1301,   374,   374,  1269,   374,
    1300,  1301,  2867,  2868,  1794,  1120,  1302,  3017,  3421,  1303,
    3422,   374,  1741,   546,   374,  2331,  1304,   563,  1300,  1301,
     374,   374,   374,   374,  1815,  1815,   567,  1815,  1300,  1301,
     374,   374,   374,  1302,  1855,   930,  1303,  2841,  1741,  1837,
    1856,  2386,   961,  1302,  1304,  -566,  1303,   649,   374,  1609,
     973,  1848,  2283,  1302,   577, -1105,  1303,   374,  1815,  1815,
    1815,   647,   648,  2907,   651,  3218,  3219,  1477,   549,  1300,
    1301,  1478,  1304,   806,   374,  1450,  2908,  1300,  1301,   374,
    2397,  2398,  1304,  1302,  2809,  3345,  1303,  1302,  1300,  1301,
    1303,   374,  1431,  2296,  2064,  2300,  2305,   374,   931,  1964,
    2537,   668,  1302,  3396,  3397,  1303,  2909,  1904,  1300,  1301,
    1302,  2866,   947,  1303,   679,  1300,  1301,   680,  2399,  1610,
    2563,  1380,   689,  1302,  1381,  1922,  1303,  1382,   106,  1304,
    1121,  2366,  2367,  1300,  1301, -1105,  1857,  1858, -1105,   932,
    2400,  2342,  2296,   827,  1302,  1451,  2368,  1303,   700,   701,
    1302,  2067,  2389,  1303,   933,   709,   374,  1432,   902,  1302,
   -1105, -1105,  1303,  1302,   374,   905,  1303, -1105,   830,   912,
    1302,  2401,   927,  1303,  1859,   946,   934,  1013,  3449,   929,
   -1105,  1300,  1301,  3460,   117, -1105,   118,  1302,  1300,  1301,
    1303,   374, -1105,  2233,  2234,  1013,  1302,   936,  1302,  1303,
   -1105,  1303,  1304,   374,   608,   609,   374,   944,  3522,  1122,
     945,  3386,   109, -1105,   608,   609,   959, -1105,  2955,  3037,
     960,  2958,  2959,  1494,  2072,   968, -1105,  1302,   423,  1304,
    1303,  2038,  1302,  2422,  2423,  1303,   979,  1302,  2976,  1304,
    1303,   980, -1105,  1433,  1741,  2600,  2601,  2594,   983,  1304,
    1302,  2073,  1302,  1303,   984,  1303,   990,  1302,  2685,  2686,
    1303,  2076,   987,  1302,   998,  1951,  1303,  2296,  1954,  1300,
    1301,  2083,   999,  1302,  2296,  1302,  1303,  1966,  1303,  1304,
    1004,  1302,  1000,  1304,  1303,  1611,  1974, -1105,  1005,  1302,
    3058,  1014,  1303,  1302,  2759,  2686,  1303,  1019,  1304,   947,
    1302,  2084,   989,  1303,  1020,  2088,  1304, -1105,  1021,   860,
    1023,  1452,   511,  2639,   513, -1105,   514,  1022,   516,  1304,
    2090,  1300,  1301,  1302,  2056, -1105,  1303,  1024,  2091,  1302,
    1434,  1016,  1303,  1036,  1300,  1301, -1105,  1037,  1300,  1301,
    1304,  2095,  3245,  1300,  1301,  1050,  1304,  1302, -1105,  1055,
    1303,  2641,  1300,  1301, -1105,  1304,  1052,  1302,  1053,  1304,
    1303,  1069,  2096,  2570,   662,   663,  1304,   664,  2105,   665,
    2590,   374, -1105,  1079,  3010,  3011, -1105,  2109,  1060, -1105,
    1080,  2110,  1126,  1304,   383,  3087,  3088, -1105,  2112,  1127,
    1455,  1128,  1304,  2402,  1304,  1130, -1105,  1316,  1302,  3574,
   -1105,  1303,  1300,  1301, -1105,  2113,  1302,  1300,  1301,  1303,
    1132,  1300,  1301, -1105,  2557,  2057,  2632,  1302,  3072,  1133,
    1303,  1300,  1301,  1304,  3209,  3210,  1300,  1301,  1304,  1134,
   -1105,  -537,   911,  1304,  1505,  3215,  3216,  1302,  3246,  3247,
    1303,  1506,  3248,  3249,  1302,  2117,  1304,  1303,  1304,  1139,
    2120,  1507,  1508,  1304,  1138,  2121,  2617,  1300,  1301,  1304,
    3283,  3210,  1302,  1300,  1301,  1303,  1140,   384,  2133,  1304,
    2147,  1304,   374, -1105, -1105,  2154,  1151,  1304,  3360,  3361,
    1509,  2155,  1316,  1149,  1510,  1304, -1105, -1105,  1153,  1304,
     374,   374,  1154,  2156, -1105,  1511,  1304,   374,  2061,   374,
     374,  1155, -1105, -1105,  1512, -1105,  -505,  2159,  1156,  1513,
    1302,  2163,  1157,  1303,  3363,  3210,  1370,  1302,  2166,  1304,
    1303,  1514,  1159, -1105,  1912,  1304,  3364,  3210,  1359,  1158,
    1362, -1105, -1105,   374,  3373,  3374,  1069,  1160, -1105,  1515,
    1161,  2183,  1162,  1304,  2675,   374,   374,  2786,  1516,  1517,
    1163,  2678,  1164,  1304,  1518,   374,  3375,  3376,  1300,  1301,
    1363,   374,  1519, -1105,   374,  2796,  1165,   374,  1520,  3377,
    3376,  1166,  1300,  1301,  1167,  2802,  1168,  2296,   374,   374,
    1319,   374,  1169, -1105,  1170,  3111,  1171,   374,   374,  1300,
    1301,  1300,  1301,  1521,  1304,  3462,  3361,   374,  1302,   374,
    1172,  1303,  1304,   374,   374,  1300,  1301,  3463,  3361,  1300,
    1301,  1300,  1301,  1304,  3649,  3650,  2811, -1105,  1300,  1301,
    1300,  1301,  2935,  2936,  2812,  2396,  1727,  1727,  1175,  1300,
    1301,  1300,  1301,  1304,  1177,  2834,  1300,  1301,  1178,  1522,
    1304,  1523,  3284,  3285,  1179,   374,   374,  1183,  1524,  1184,
    1302,  1300,  1301,  1303,  1913,  2844,  2899,  2900,  1304,  1185,
   -1105,  1186,  2846,  1302,  1187,  1319,  1303,  1302,  1188,  1914,
    1303,   374,  1302,  2438, -1105,  1303,  2876,  2877,   374,  1189,
    2847,  1302,  1915,  1190,  1303,  1300,  1301,  1300,  1301,   658,
   -1105,   374, -1105,  3085,  3086,  1741,  1191,  1300,  1301,  1192,
    1307,  1308,  1193,  1321,  1322,  1194,  1304,  1195,  1196,  1300,
    1301,  1300,  1301,  1304,  1525,  1197,  1300,  1301, -1105, -1105,
    3332,  3333,  3334,  3335,  1198, -1105,  1373,  2071,  1526,  3327,
    1365,  1302,   385,  1527,  1303,  3225,  1302,   374,  1309,  1303,
    1302,  1300,  1301,  1303,  1199,  1300,  1301,  1300,  1301,  1200,
    1302,  1201,  1310,  1303,  1202,  1302,  1916,  1203,  1303,  1300,
    1301,  1204,  1205,  1206,  1207,  -264,   386,  1300,  1301,  1300,
    1301,  1300,  1301,  1528,  1208,  1209,  1300,  1301,  1210,  1529,
    1211,  1530,  1213,  1214,  1311,  1215,  1302,  3329,  1216,  1303,
    1217,  1218,  1302,  1219,  1304,  1303,  1312,   387,  1220,  1300,
    1301,  1221,  1531,  1532,  1222,  1533,  1741,   388,  1226,  1300,
    1301,  1227,  1228,  1374,  1377,  2074,  1229,  1230,   374,  1534,
    1231,  1232,  2904,  1313,  1325,  1326,  1327,  1328,  1329,  1330,
    1331,  1332,  1233,  1300,  1301,  1234,  1235,  1236,  2342,  1300,
    1301,  1535,  1237,   374,  1239,  1917,  1304,   374,  1241,   374,
     374,   374,   374,  1395,  1242,  1300,  1301,  1243,  1244,  1304,
     374,  1245,  1246,  1304,   374,  1247,  1375,   374,  1304,  1300,
    1301,  1300,  1301,  1300,  1301,  1300,  1301,  1304,  1248,  1314,
    2075,   374,   374,   374,  2094,  3022,  1249,  1302,  1837,  2108,
    1303,  1300,  1301,  1250,   374,  1300,  1301,  1396,  2111,  1918,
     374,  1302,   374,  2539,  1303,  1251,  1300,  1301,  1300,  1301,
     374,  1327,  1328,  1329,  1330,  1331,  1332,  1252,  1302,  1399,
    1302,  1303,  1536,  1303,  1300,  1301,  1253,  1304,  1254,  1255,
    3026,  1537,  1304,  1256,  1302,  1257,  1304,  1303,  1302,  1258,
    1302,  1303,  1259,  1303,  1300,  1301,  1304,  1302,  2127,  1302,
    1303,  1304,  1303,  2128,  1260,  1261,  1408,  2134,  1302,  1262,
    1302,  1303,  1263,  1303,  1267,  1302,  1410,  2142,  1303,  1268,
     374,  1741,  2143,  1271,  3633,  1300,  1301,  1300,  1301,  1272,
    1302,   374,  1304,  1303,   374,  1276,  1277,  1278,  1304,  1282,
    -537,  1606,  1741,  1283,  1300,  1301,  -537,  1284,  1285,  1182,
    1266,  1270,  3221,  2144,  1300,  1301,  1286,  2570,  1741,  2152,
    1287,  3633,  1300,  1301,  1302,  1361,  1302,  1303,   374,  1303,
    1300,  1301,  1378,  3571,  1439,   374,  1302,  1401,   374,  1303,
    1407,  1409,   374,   374,  1416,  1424,   374,  1430,  1302,   551,
    1302,  1303,  1443,  1303,   374,  1302,  1300,  1301,  1303,  1607,
    1459,  3304,   374,  1473,  1300,  1301,  2688,  1471,  1300,  1301,
    1300,  1301,  1475,  1487,  2541,  1083,  1551,  1553,  1552,  1554,
    1302,  1569,  1555,  1303,  1302,  1556,  1302,  1303,  1557,  1303,
    2757,  2773,  1558,  1304,  1559,  2777,  1608,  1560,  1302,  1561,
    1562,  1303,  3110,  1300,  1301,  1563,  1302,  1304,  1302,  1303,
    1302,  1303,  1574,  1303,  2153,  1302,  1300,  1301,  1303,  3299,
    3100,  1300,  1301,  1564,  1304,  1565,  1304,  1566,  2160,  1567,
    1568,  1570,  3299,  1576,  1578,  1590,  1300,  1301,  1302,  1595,
    1304,  1303,  1357,  1602,  1304,  2169,  1304,  2174,  1302,  1300,
    1301,  1303,  1630,  1304,  1275,  1304,  1300,  1301,  1609,  3160,
    1650,  2185,  1300,  1301,  1304,  2193,  1304,  2768,  1664,  1681,
    3172,  1304,  1302,  1713,  2769,  1303,  2770,  1738,  1302,  1300,
    1301,  1303,  1747,  2296,  1753,  2783,  1304,  2791,  1758,  1300,
    1301,  1779,  2792,  3378,  1302,  1795,  1773,  1303,  1807,  3196,
    1806,  1831,  1763,  2342,  1834,  1300,  1301,  2795,  1302,  1864,
    1302,  1303,  1302,  1303,  1302,  1303,  1878,  1303,  1892,  1890,
    1304,  1899,  1304,  1496,   374,   374,  1920,   374,  1610,  1921,
    1302,  1924,  1304,  1303,  1302,  1497,   374,  1303,  1300,  1301,
    1925,  2797,   374,  2800,  1304,  1302,  1304,  1302,  1303,   375,
    1303,  1304,   374,  2801,   989,  1927,  1300,  1301,  2283,  1940,
     374,   405,  1935,  1302,   411,  2803,  1303,  2804,  1941,  1936,
    2392,   420,  2805,  2393,  3155,  3156,  1304,   374,  1958,  1937,
    1304,   431,  1304,  1302,  1959,  1938,  1303,  1939,  1961,   374,
    1967,   447,  3166,  1962,  1304,  1969,   374,  2806,  3170,  1970,
    1975,  2814,  1304,   374,  1304,  1989,  1304,  2218,  2029,   374,
    2050,  1304,  2039,  2043,  1302,  2815,  1302,  1303,  2052,  1303,
    2904,  3186,  2954,  2818,  3188,  2825,  2053,  2826,  3620,   465,
    2054,  2055,  2827,  1302,  1304,  2568,  1303,  2060,  3314,  3315,
    2062,  3434,  2069,  1302,  1304,  2070,  1303,  2078,  2077,   468,
     375,  1302,   375,  2087,  1303,  2828,  2978,  2979,  2089,  1302,
    2099,   592,  1303,   465,  2982,  2829,  3584,  2104,  1304,  2116,
    2123,  3005,   700,   701,  1304,  3453,  3454,  1764,  3456,  2296,
    2206,  2122,  1818,  2124,  1819,  1302,   374,  2126,  1303,  2830,
    1304,  1498,  2130,  1302,  1611,  2831,  1303,  1302,  2172,  1302,
    1303,  2173,  1303,  2139,  1304,  2140,  1304,  2141,  1304,  1606,
    1304,  2832,  2150,  2387,  1316,  1865,  1866,  1867,  1820,  3684,
    3496,  2161,  3497,  3498,  1339,  2833,  1304,  2835,  2162,  2836,
    1304,  2839,  1302,  2168,  2186,  1303,  1821,  2187,  2188,  -770,
    2212,  1304,  1316,  1304,  1332,  1302,  -946,  2845,  1303,  2221,
    1302,  2848,  -336,  1303,  2232,  2235,  1822,  2247,  2236,  1304,
    1499,  1941,  2850,  2983,  3390,  1302,  2249,  1607,  1303,  2237,
    1823,   593,  2245,  1942,  2250,  2255,  2238,  2239,  1302,  1304,
    2852,  1303,  2251,  2268,  1500,  1302,   374,  2267,  1303,  2269,
    3387,  1302,  1725,  1871,  1303,  2270,   396,  1870,  2287,  2288,
    2854,  2289,  2312,  2984,  1608,   448,  2315,  2985,  1302,   374,
    1304,  1303,  1304,  1824,  1825,  2319,  2320,  2321,  1302,  2344,
    2337,  1303,  2345,  2419,   374,  2371,  2372,  1343,  2424,  1304,
    1912,  2855,  3442,  2857,  1302,  1501,  2405,  1303,  1765,  1304,
    2420,  1826,  1606,  2425,  1489,  2490,   449,  1304,  2986,   594,
    2858,   119,  1596,  2426,  1766,  1304,   379,   380,   798,  2500,
    3064,  -336,  2457,  2477,  2512,   374,  1609,  1302,  3065,  1943,
    1303,  2513,  2532,  2550,   418,  2544,  3066,  2553,  2577,   424,
     397,  1304,  2582,   428,  2554,  1302,  2555,   374,  1303,  1304,
    2556,  2562,  2569,  1304, -1000,  1304,  2584,  1319,  2588,  1827,
    1607,  2596,  3217,  2599,  2602,  1316,  1502,   374,  1088,  2615,
    3220,  2616,  2604,   743,  3224,   450,  3226,  1344,   398,  2621,
    2629,  1347,  2640,  2646,  2650,  1319,  2651,  1089,  1304,  1348,
    2654,  1912,   374,  2666,   374,  2667,  1610,  1608,  2680,  1828,
     512,  1304,  2746,  2750,  2755,   374,  1304,   374,  3493,  3227,
     545,  2756,  2758,  2760,   553,  2763,  2765,  2771,  2810,   465,
    1913,  1304,  3230,   476,   572,  3442,  2778,  3232,  2774,  3545,
    2779,  2780,  -471,  3200,  1304,  1914,  3130,  2781,  2782,  2784,
    2785,  1304,  3233,   766,  2790,  2793,   465,  1304,  1915,  2230,
    2794,  2798,  1349,  2799,  2807,  3234,   374,  2813,  2819,  1609,
    2837,  2882,  3235,   669,  1304,  2856,  2872,  2822,  3236,  2863,
    2865,  2869,  2296,   465,  1304,  3545,  2873,  1496,  1855,   465,
    1321,  1322,  2884,  2886,   374,   691,  2897,   465,   465,  1497,
    1304,  2905,   703,   553,   777,  3399,  2913,  1912,  2914,  2917,
    1351,   779,  2918,   730,   374,  2920,  2923,   735,  1321,  1322,
     374,   374,   903,   904,  2924,   375,   375,   553,   465,  -336,
    2942,  1913,  1916,  1304,   374,   700,   701,   -55,  3439,  1610,
    2987,   399,  2938,  2943,  2944,  2952,  1914,  2988,   794,  2949,
    2953,  1304,  3113,   374,  3490,  2956,  2981,  3003,  1319,  1915,
    3004,   951,  1912,   595,   596,   597,   598,   599,   600,  3006,
    3009,  3675,  1611,  3014,  2989,  3024,  3023,   465,  3028,   601,
    1335,  1336,  1337,  1338,  1339,   553,   465,  3038,   743,  3040,
     465,  3042,   374,  3043,  3044,  3675,  3047,   465,  3049,  3054,
    3055,  3056,  3067,   374,  1944,  3069,  3071,  3083,  3090,   451,
     806,  1325,  1326,  1327,  1328,  1329,  1330,  1331,  1332,  3648,
    3088,  1917,  3096,  1352,  2619,  3097,  3094,   553,  3101,   452,
    3105,  3102,  3112,  1916,  2990,  1354,  3107,  1913,  1316,  1325,
    1326,  1327,  1328,  1329,  1330,  1331,  1332, -1034,   400, -1039,
    3660,  3130,  1914,  3117,   453,  1498,  3108,  3121,   766,  3123,
    3127,  3128,  3146,   401,  3147,  2645,  3154,   822,  1316,  -336,
    3000,  2997,  3165,  3167,  3169,  1918,  3173,  3176,  3177,   826,
     827,  1321,  1322,  1068,  1340,  1341,  1342,  1343,  3178,   402,
    3180,   553,  1913,  3181,   465,  3182,  3475,  1086,   465,  3183,
    3184,   454,  3185,  3187,   403,  1611,  3212,  1914,  3197,   777,
    3198,  3191,  3213,  3214,  2991,  3222,   779,  3223,  3228,  3229,
    1915,   517,  1917,  3231,  1499,  1507,  1508,  3253,  3262,  3238,
     374,   374,  3237,  3240,  3268,  3241,   566,  3242,  3265,  1916,
    2151,   465,   575,  1148,  3266,   700,   701,  3271,  1500,  3273,
     374,  1316,   374,   794,   374,   374,  -457,  -457,  1510,  3404,
    3277,  3295,   654,  3296,  3303,  -457,  3305,   374,  3306,  1511,
    3307,  3319,  3324,  3542,  3216,  3308,  1918,  1344,  1512,  1345,
    1346,  1347,  3309,  3310,  3320,  3321,  3325,  2823,  3559,  1348,
    3559,  3331,  3337,  3338,  1916,  1514,  3566,  3352,  3354,  1501,
    3357,   374,  1325,  1326,  1327,  1328,  1329,  1330,  1331,  1332,
    1069,  3383,  3384,  1515,  3355,   806,  3385,  3408,  3410,  3411,
    3359,  1319,  3362,  3412,  3394,   852,  3395,  3131,  1917,  3398,
    3132,  3400,  3559,  3413,  3419,  3428,  3485,  2415,  3436,  3610,
     858,   374,  1520,  3437,  3438,  3444,   860,  3448,  3455,   861,
    3457,  1319,  1349,  3458,  3464,  3466,  3488,  2423,  3499,  3517,
     374,  -206,  3524,  3485,  3485,   374,  3519,  3525,  3526,  3559,
    1502,  3532,   822,  -224,  3559,   914, -1165,  3549,  3550,  3551,
    3560,  3569,  1918,  1917,   826,   827,   374,  3570,  3573,  3575,
    3580,  3582,  1297,  3559,  1299,  3581,  3585,   374,  3601,  1350,
    1351,  3133,  3134, -1738,  3591,  3611,  3485,  3485,  3612,  3615,
    3618,  3613,  3619,  3485,  3622,  1523,  3623,   465,  3628,  3634,
    3559,  3559,  1524,   465,  3682,  3639,  3627,  3641,  3485,  3643,
    3485,  3646,  3647,  3656,  1319,  3655,  3485,  1918,  3683,  3678,
    3658,  2231,  2021,  1076,  1321,  1322,  3521,  3199,  3485,  3202,
    3317,  3685,  3661,  3666,  3598,  3556,  3599,  3485,  3485,   915,
    1388,  3590,  1391,  3564,   465,   374,  3565,  3206,  1573,  3030,
    1988,   500,  3485,  3279,  1321,  1322,   465,   553,   374,  3485,
    2748,  2950,  2442,  1992,  1945,  2356,   465,   465,  1525,  3485,
    2416,  2945,  2968,  3007,  2969,  3297,  3485,  1420,  3138,  3179,
    2946,  3171,  1526,  2911,  3426,  1429,   374,  3431,   374,  3485,
    3294,  3372,  3485,  1352,  3485,   916,   374,  1589,  3323,   375,
     375,   465,   465,   374,  1353,  1354,  3302,   374,  1909,   375,
     852,   553,  3131,  3485,  2406,  3132,  1474,   375,  1847,   917,
    2248,  2252,  1087,   374,  2587,   858,  3485,   465,  3485,  1571,
     374,   860,  1065,  1529,   861,  1530,  2271,  1321,  1322,  3339,
    3485,  3485,   666,   994,  3485,  1325,  1326,  1327,  1328,  1329,
    1330,  1331,  1332,  3073,   374,  1869,  1531,  1532,  2474,  1533,
    3239,  3074,  1680,  2919,  3537,  2567,  3425,  2948,  1728,  3276,
    3264,  3593,   465,  1628,  2278,   465,  1326,  1327,  1328,  1329,
    1330,  1331,  1332,  1412,  2258,  1394,  3133,  3134,  2244,  3092,
    2890,     1,  2889,  3491,  2930,  1535,   655,  3651,  1146,   736,
    1594,     2,     3,   918,   641,  3579,  3414,  1808,  2684,   919,
    1414,  2883,   520,   521,     4,  3544,     5,  3567,  3175,  3459,
    3665,  1879,  2893,  2637,   553,  1842,   553,  2915,   375,   375,
    1582,   465,   375,  3106,     6,     7,  3267,   920,   588,   982,
       8,   735,  1428,  1597,     9,    10,  3616,  1419,  1387,  1577,
    2576,  3330,   590,  3621,  3336,   986,  1749,    11,  2552,  2862,
    1327,  1328,  1329,  1330,  1331,  1332,   727,   494,   495,  3640,
     681,  2437,    12,   921,  3027,  3204,  1536,  1637,   724,   725,
     726,     0,     0,     0,   522,  1537,     0,     0,     0,     0,
       0,    13,     0,   922,     0,     0,     0,  1507,  1508,     0,
      14,    15,    16,  3667,     0,  3668,     0,     0,   923,     0,
     118,     0,   523,    17,    18,     0,     0,  1637,     0,     0,
       0,     0,     0,     0,     0,     0,   524,     0,  -457,  -457,
    1510,     0,     0,     0,     0,     0,    19,  -457,   521,     0,
       0,  1511,     0,     0,  2447,     0,     0,     0,   525,     0,
    1512,     0,    20,     0,     0,     0,     0,     0,     0,   526,
       0,     0,     0,     0,     0,     0,     0,  1514,     0,     0,
       0,     0,     0,     0,     0,  1742,    21,     0,     0,     0,
       0,     0,  1069,    22,     0,  1515,    23,     0,   527,     0,
     553,     0,     0,     0,     0,  1316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    24,     0,   522,
       0,     0,     0,   528,  1520,     0,     0,     0,     0,   529,
       0,    25,     0,  1096,  1097,  1098,  1099,  1100,  1101,     0,
       0,  1102,  1103,  1104,  1105,  1106,  1107,   523,  1108,    26,
       0,     0,     0,     0,    27,     0,     0,     0,     0,   553,
       0,   524,     0,     0,  1800,  1801,   530,   553,     0,     0,
       0,     0,   553,     0,     0,     0,     0,     0,   465,     0,
    1811,     0,     0,   525,     0,  1816,  1816,     0,  1816,     0,
       0,     0,     0,     0,   526,     0,     0,  1523,     0,     0,
     465,     0,     0,   465,  1524,     0,     0,  1317,     0,   553,
     553,   465,   465,     0,     0,     0,     0,     0,     0,  1816,
    1816,  1816,     0,   527,     0,     0,     0,     0,  1318,     0,
    2032,     0,     0,     0,     0,     0,     0,  1882,     0,    28,
     586,   521,     0,     0,     0,     0,  1893,     0,   528,     0,
       0,     0,  1109,  1110,   529,     0,     0,     0,     0,     0,
      29,     0,     0,  1901,     0,     0,     0,    30,   465,     0,
    1525,     0,     0,     0,     0,     0,     0,   531,     0,     0,
    1911,     0,     0,     0,  1526,     0,   465,    31,  1319,    32,
      33,   530,     0,    34,   532,     0,    35,     0,    36,     0,
     533,     0,     0,    37,     0,    38,   534,   700,   701,     0,
       0,     0,   522,     0,    39,     0,     0,     0,    40,     0,
       0,     0,     0,     0,    41,     0,     0,     0,     0,    42,
     535,     0,     0,    43,     0,  1529,     0,  1530,     0,     0,
     523,   536,   537,     0,     0,  1995,     0,     0,     0,     0,
       0,     0,    44,  1999,   524,     0,    45,     0,  1531,  1532,
       0,  1533,     0,     0,     0,     0,     0,  1320,     0,     0,
       0,     0,     0,     0,     0,     0,   525,   538,     0,     0,
    2024,     0,     0,     0,     0,     0,     0,   526,     0,     0,
      46,     0,   465,     0,     0,  2041,     0,  1535,     0,     0,
       0,     0,   531,     0,     0,     0,    47,     0,     0,    48,
       0,  1321,  1322,     0,    49,     0,   527,     0,     0,   532,
    1323,   539,     0,   540,     0,   533,     0,     0,     0,     2,
       3,   534,     0,     0,     0,     0,     0,    50,     0,     0,
       0,   528,     4,     0,     0,     0,     0,   529,     0,     0,
       0,     0,     0,     0,     0,   535,     0,     0,    51,     0,
       0,     0,     6,     7,     0,     0,   536,   537,     8,     0,
       0,     0,     9,    10,     0,     0,  1933,     0,  1536,     0,
       0,     0,     0,     0,   530,    11,     0,  1537,  1952,  1953,
       0,  1955,  1956,  1957,     0,     0,  1960,     0,     0,     0,
      12,  1968,   538,     0,     0,  1971,  1972,  1973,     0,     0,
    1976,  1977,  1978,  1979,  1980,     0,  1985,  1986,  1987,    13,
       0,     0,     0,     0,     0,     0,     0,     0,    14,    15,
      16,  1324,  1325,  1326,  1327,  1328,  1329,  1330,  1331,  1332,
       0,    17,    18,     0,  2033,     0,   539,     0,   540,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2207,     0,     0,     0,    19,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      20,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   531,     0,     0,     0,     0,
       0,     0,     0,     0,    21,     0,     0,     0,     0,     0,
       0,    22,   532,     0,    23,     0,     0,     0,   533,     0,
       0,     0,     0,     0,   534,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    24,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   535,    25,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   536,
     537,  2265,     0,     0,     0,     0,     0,    26,     0,     0,
       0,     0,    27,     0,     0,     0,     0,     0,     0,  2284,
    2286,     0,     0,     0,     0,     0,   553,     0,   553,   553,
       0,     0,     0,     0,     0,   538,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1742,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   553,   553,     0,     0,     0,   539,
       0,   540,     0,     0,  1995,     0,     0,     0,     0,     0,
    1995,     0,     0,  1995,     0,     0,  1995,    28,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1995,  1995,     0,
     553,     0,     0,     0,     0,     0,  1995,  1742,    29,     0,
       0,     0,     0,     0,     0,    30,   465,     0,   553,     0,
       0,     0,  1995,  2411,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    31,     0,    32,    33,     0,
       0,    34,     0,     0,    35,     0,    36,     0,     0,     0,
       0,    37,     0,    38,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,   465,  1995,    40,     0,     0,     0,
       0,     0,    41,     0,     0,     0,     0,    42,     0,     0,
       0,    43,     0,     0,     0,     0,     0,     0,     0,     0,
     553,     0,     0,     0,     0,     0,     0,   553,     0,     0,
      44,     0,     0,     0,    45,     0,     0,     0,     0,     0,
    2481,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   883,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,  1637,    48,     0,     0,
       0,     0,    49,     0,     0,     0,     0,     0,     0,     0,
    2369,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     953,  2376,     0,     0,     0,    50,     0,     0,     0,   606,
       0,   568,   607,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    51,     0,     0,     0,
       0,     0,     0,   608,   609,     0,     0,     0,     0,     0,
       0,     0,     0,   610,     0,   611,     0,     0,     0,     0,
    2689,  2690,     0,     0,     0,     0,  2691,   553,  2692,  2693,
    2694,     0,   612,   613,     0,     0,     0,     0,     0,     0,
       0,   614,     0,     0,  2695,     0,     0,     0,     0,     0,
       0,     0,  2575,     0,     0,     0,  1811,     0,   951,   553,
     553,   553,     0,     0,     0,     0,     0,     0,     0,   465,
       0,     0,     0,   553,     0,     0,  1742,     0,     0,  1507,
    1508,     0,     0,  2696,     0,     0,  2697,     0, -1332,   615,
     553,   553,   553,   616,  2698,     0,     0,     0,  1095,     0,
       0,     0,     0,  2618,     0,     0,     0,     0,     0,  2620,
       0,  2622,  1510,  2699,     0,     0,     0,     0,     0,   553,
       0,     0,   617,  1511,   618,     0,     0,     0,     0,     0,
    2700,     0,  1512,     0,     0,     0,   619,     0,   620,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1514,
    2701,     0,  2702,     0,     0,  1507,  1508,     0,     0,     0,
       0,   621,   622,     0,  1069,   623,     0,  1515,     0,     0,
       0,  2703,  2704,     0,     0,     0,     0,     0,     0,  1995,
     624,     0,     0,     0,     0,     0,  -457,  -457,  1510,     0,
     553,     0,     0,  1995,     0,  -457,  1520,     0,     0,  1511,
       0,   625,     0,     0,     0,     0,   626,  1212,  1512,     0,
       0,     0,  2705,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1514,     0,   465,     0,     0,
     627,     0,     0,  1238,  2687,     0,     0,   465,     0,  2706,
    1069,  2743,  2744,  1515,     0,  2747,     0,     0,  2707,  2708,
       0,  2709,     0,  2754,     0,     0,     0,     0,     0,     0,
       0,   465,   628,     0,     0,     0,     0,     0,     0,  1523,
       0,   629,  1520,     0,     0,     0,  1524,     0,     0,  2710,
    2711,  2712,     0,  1288,     0,     0,     0,  1295,     0,   630,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2713,
    2714,  2715,     0,     0,     0,  2716,     0,     0,  2717,     0,
       0,     0,     0,     0,   631,   632,     0,     0,     0,     0,
       0,  2718,  2719,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1525,     0,     0,  1523,  2720,     0,  2721,     0,
       0,     0,  1524,     0,     0,     0,  1526,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2722,     0,     0,     0,   633,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   634,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1427,     0, -1763,     0,     0,  1529,   635,  1530,
       0,  1442,     0,  2723,     0,  2724,     0,     0,  1525,     0,
       0,   636,     0,  2265,  2894,  2725,   553,     0,     0,     0,
    1531,  1532,  1526,  1533,     0,   553,     0,     0,     0,     0,
       0,  2575,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   553,     0,     0,     0,     0,     0,     0,     0,  1882,
       0,     0,     0,     0,     0,     0,  2726,  2727,     0,  1535,
    2728,  2729,  2730,  2731,     0, -1763,  1742,     0,     0,   637,
       0,     0,     0,  1529,     0,  1530,     0,     0,  1995,     0,
       0,     0,     0,     0,     0,  1995,     0,     0,     0,     0,
       0,     0,  1742,     0,     0,     0,  1531,  1532,  1995,  1533,
       0,     0,     0,  2732,  2733,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2734,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1535,     0,     0,     0,     0,
    1536,     0,     0,     0,     0,     0,     0,     0,     0,  1537,
       0,     0,  1599,  1600,  1601,     0,     0,     0,     0,     0,
       0,  1616,  1617,     0,     0,  1620,     0,  1622,  1623,  1624,
    1625,     0,     0,     0,  1629,  3035,     0,  1631,  1632,     0,
    1633,     0,  1634,  1635,     0,  1638,  1639,  1640,  1641,  1642,
       0,  1645,     0,  1647,  1648,  1649,     0,  1651,  1652,  1653,
    1654,     0,  1656,  1657,     0,  1663,     0,     0,  1667,  1668,
    1669,     0,  1671,  1672,  1673,  1674,  1536,  1676,  1677,  1678,
    1679,     0,     0,     0,     0,  1537,  1686,  1687,     0,  1690,
    1691,  1692,  1693,  1694,     0,     0,     0,     0,  1698,     0,
    1699,  1700,  1701,  1702,  1703,     0,     0,  1706,  1708,  1709,
    1710,  1711,  1712,     0,  1714,  1715,     0,     0,  1718,  1719,
    1720,     0,  1723,     0,  1724,  1505,     0,     0,  1729,     0,
    1733,  1734,  1506,     0,     0,  3070,  1737,     0,     0,     0,
       0,     0,  1507,  1508,  1744,  1745,  1746,     0,     0,     0,
       0,     0,  3487,  1295,     0,     0,  1754,     0,  1742,     0,
       0,     0,     0,  1759,  1760,  1761,     0,     0,     0,     0,
       0,  1509,     0,   553,     0,  1510,     0,     0,     0,  3487,
    3487,     0,     0,     0,     0,     0,  1511,     0,     0,     0,
       0,     0,     0,     0,     0,  1512,     0,     0,     0,     0,
    1513,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1514,     0,  3035,     0,     0,     0,  1798,     0,
       0,     0,  3487,  3487,     0,     0,     0,  1069,     0,  3487,
    1515,     0,     0,     0,     0,     0,   553,     0,     0,  1516,
       0,     0,     0,     0,  3487,  1518,  3487,     0,     0,     0,
       0,     0,  3487,  1519,     0,     0,   553,     0,     0,  1520,
       0,     0,     0,  1843,  3487,     0,     0,     0,     0,     0,
       0,     0,     0,  3487,  3487,     0,     0,     0,     0,     0,
       0,  3189,     0,  3190,  1521,     0,     0,     0,  3487,     0,
       0,     0,     0,     0,   465,  3487,  2754,     0,     0,     0,
       0,     0,     0,     0,     0,  3487,     0,     0,     0,     0,
       0,     0,  3487,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3487,     0,     0,  3487,     0,
    3487,     0,  1523,     0,     0,     0,     0,     0,     0,  1524,
       0,     0,     0,     0,     0,  2284,     0,     0,     0,  3487,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3487,     0,  3487,     0,     0,     0,     0,     0,
       0,     0,     0,   553,     0,     0,  3487,  3487,     0,     0,
    3487,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3275,     0,     0,     0,     0,     0,  3035,
    3035,     0,     0,     0,     0,  1525,     0,     0,     0,     0,
       0,     0,  2000,  3293,     0,     0,     0,     0,     0,  1526,
       0,     0,     0,     0,  1527,     0,     0,     0,     0,     0,
       0,     0,   553,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1528,     0,     0,     0,     0,     0,
    1529,  3318,  1530,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3035,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1531,  1532,     0,  1533,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1534,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1535,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2176,
    2178,  2180,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2194,     0,     0,  1742,
     465,     0,     0,  1536,     0,     0,     0,     0,     0,     0,
       0,     0,  1537,     0,     0,     0,     0,     0,     0,  3275,
       0,  3275,  2213,  3423,  1999,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3432,     0,     0,     0,
       0,     0,     0,     0,  2225,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3452,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1742,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3501,
       0,     0,     0,     0,  3508,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   553,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3527,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3595,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3608,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1742,     0,  3636,     0,     0,
       0,     0,     0,     0,     0,  3644,     0,     0,     0,     0,
       0,     0,   553,     0,  2455,     0,  1742,  2456,     0,     0,
    2458,  2459,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1742,  2472,     0,     0,  2475,     0,     0,  3676,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2482,
       0,  2483,     0,     0,     0,  2486,     0,  2487,  2488,     0,
       0,     0,  2491,  3676,  2492,  2493,     0,  2494,     0,     0,
    2495,     0,  2496,  2497,     0,     0,     0,     0,  2501,  2502,
       0,     0,  2504,     0,  2505,     0,  2506,     0,  2507,     0,
    2509,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2514,  2515,     0,     0,  2516,     0,  2517,     0,     0,
       0,     0,     0,     0,     0,  2518,  2519,     0,  2520,     0,
    2521,     0,     0,  2522,  2523,  2524,     0,  2525,     0,     0,
       0,     0,  2528,  2529,  2530,  2531,     0,     0,     0,     0,
    2533,  2534,  2535,     0,  2536,     0,  2538,     0,  2540,     0,
    2542,     0,  2543,     0,     0,     0,     0,     0,     0,  2545,
       0,  2546,     0,     0,  2548,  2549,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2558,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2565,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2583,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2627,
       0,     0,     0,     0,  2631,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2662,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2665,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2767,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2838,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2849,     0,  2851,     0,
    2853,     0,     0,     0,     0,     0,  2859,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2871,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2916,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3041,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3045,     0,     0,     0,     0,
       0,  3046,     0,     0,     0,     0,     0,     0,     0,     0,
    3050,  3051,     0,     0,     0,     0,  3052,     0,     0,     0,
    3053,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3057,     0,     0,     0,     0,     0,  3059,
       0,     0,  3060,  3061,     0,  3062,  3063,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3068,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3119,  3120,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2662,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2662,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2627,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3326,     0,
       0,     0,     0,     0,  3328,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3344,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3356,
       0,  3358,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2662,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3447,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3461,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3530,  3531,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3552,     0,
       0,     0,     0,     0,     0,     0,     0,  3562,     0,     0,
       0,     0,     0,     0,  3568,     0,     0,     0,     0,     0,
       0,     0,     0,  3578,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3602,     0,     0,     0,     0,   122,     0,   737,
     124,   125,   126,   127,     0,     0,  3617,     0,     0,   128,
       0,     0,   738,     0,   739,   130,   131,   740,   133,     0,
     134,   741,   135,     0,   742,   136,   743,   744,   745,   137,
     746,     0,   138,   139,  1730,   140,     0,   141,   142,     0,
       0,   143,   747,   144,     0,   145,   748,   749,   147,     0,
     148,   149,   150,   750,   151,     0,   751,   153,     0,   154,
     155,   156,   157,   158,   752,   753,   159,  3677,   160,   161,
       0,   754,     0,   755,   756,   757,     0,     0,   163,   758,
     759,     0,   760,   761,     0,   164,   165,   762,   763,   764,
       0,     0,     0,     0,   765,   168,   766,     0,     0,   767,
     768,   169,     0,   170,     0,     0,     0,   769,   770,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,   771,   179,     0,   772,   773,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,   774,     0,   188,   775,   189,   776,   777,   190,     0,
     778,   191,   192,   193,   779,     0,   194,     0,     0,   780,
       0,   195,   196,     0,   781,   197,     0,   198,   782,   783,
     784,   785,     0,   786,   787,   200,   788,   789,   790,   202,
       0,   203,   791,     0,   792,   793,     0,   204,   205,     0,
     206,   794,     0,   207,     0,     0,     0,   795,   209,   210,
     211,   796,     0,   212,   213,     0,     0,     0,   214,     0,
       0,   797,   215,   798,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,   799,   220,
       0,  1731,   800,   221,     0,   801,   222,     0,     0,     0,
     802,     0,   803,     0,   224,   804,     0,   225,     0,   226,
     805,     0,     0,   806,     0,     0,     0,     0,   807,   227,
     228,   229,   230,   231,   232,   808,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   809,   242,   243,   244,   810,
     245,   246,     0,     0,     0,   247,   248,   811,   250,     0,
       0,   812,   252,   813,   814,   253,     0,   254,   815,   816,
     817,   818,   819,   820,   821,   259,   260,   261,   262,     0,
     822,   263,   264,     0,   265,   266,   267,   823,   824,   825,
     268,     0,   826,   827,     0,   269,   270,     0,   828,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   829,   830,   278,   831,   832,
     833,   834,   835,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   836,   287,   288,   289,   290,   291,   292,   293,
     837,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,   838,   839,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,   840,   308,
     309,   841,   310,   311,   842,   312,   843,   314,   315,     0,
     844,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,   845,   846,
     334,   335,     0,   336,   847,   338,   848,   849,   850,   339,
     340,   851,   341,   342,     0,   343,   344,     0,   852,   345,
     853,   854,   855,   856,     0,     0,     0,     0,  1732,   350,
       0,   351,   857,   858,   859,   353,   354,   355,     0,   860,
     356,   357,   861,     0,   358,     0,     0,   862,   863,   359,
       0,     0,   360,     0,   361,     0,   864,   363,     0,     0,
     865,   866,   867,   868,   869,   364,     0,     0,   365,   870,
       0,   366,   367,   871,     0,     0,     0,     0,   369,     0,
     370,   371,     0,   872,     0,   873,     0,     0,     0,     0,
     874,     0,     0,     0,   875,   876,     0,     0,     0,     0,
     877,     0,   878,     0,     0,   879,   880,     0,   881,   882,
     122,     0,   737,   124,   125,   126,   127,  2623,     0,     0,
       0,     0,   128,     0,     0,   738,     0,   739,   130,   131,
     740,   133,     0,   134,   741,   135,     0,  2624,   136,   743,
     744,   745,   137,   746,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,   747,   144,     0,   145,   748,
     749,   147,     0,   148,   149,   150,   750,   151,     0,   751,
     153,     0,   154,   155,   156,   157,   158,   752,   753,   159,
       0,   160,   161,     0,   754,     0,   755,   756,   757,     0,
       0,   163,   758,   759,     0,   760,   761,     0,   164,   165,
     762,   763,   764,     0,     0,     0,     0,   765,   168,   766,
       0,     0,   767,  2625,   169,     0,   170,     0,     0,     0,
     769,   770,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,   771,   179,
       0,   772,   773,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,   774,     0,   188,   775,   189,   776,
     777,   190,     0,   778,   191,   192,   193,   779,     0,   194,
       0,     0,   780,     0,   195,   196,     0,   781,   197,     0,
     198,   782,   783,   784,   785,     0,   786,   787,   200,   788,
     789,   790,   202,     0,   203,   791,     0,   792,   793,     0,
     204,   205,     0,   206,   794,     0,   207,     0,     0,     0,
     795,   209,   210,   211,   796,     0,   212,   213,     0,     0,
       0,   214,     0,     0,   797,   215,   798,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,   799,   220,     0,     0,   800,   221,     0,   801,   222,
       0,     0,     0,   802,     0,   803,     0,   224,   804,     0,
     225,     0,   226,   805,     0,     0,   806,     0,     0,     0,
       0,   807,   227,   228,   229,   230,   231,   232,   808,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   809,   242,
     243,   244,   810,   245,   246,     0,     0,     0,   247,   248,
     811,   250,     0,     0,   812,   252,   813,   814,   253,     0,
     254,   815,   816,   817,   818,   819,   820,   821,   259,   260,
     261,   262,     0,   822,   263,   264,     0,   265,   266,   267,
     823,   824,   825,   268,     0,   826,   827,     0,   269,   270,
       0,   828,  2626,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   829,   830,
     278,   831,   832,   833,   834,   835,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   836,   287,   288,   289,   290,
     291,   292,   293,   837,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,   838,
     839,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,   840,   308,   309,   841,   310,   311,   842,   312,   843,
     314,   315,     0,   844,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,   845,   846,   334,   335,     0,   336,   847,   338,   848,
     849,   850,   339,   340,   851,   341,   342,     0,   343,   344,
       0,   852,   345,   853,   854,   855,   856,     0,     0,     0,
       0,     0,   350,     0,   351,   857,   858,   859,   353,   354,
     355,     0,   860,   356,   357,   861,     0,   358,     0,     0,
     862,   863,   359,     0,     0,   360,     0,   361,     0,   864,
     363,     0,     0,   865,   866,   867,   868,   869,   364,     0,
       0,   365,   870,     0,   366,   367,   871,     0,     0,     0,
       0,   369,     0,   370,   371,     0,   872,     0,   873,     0,
       0,     0,     0,   874,     0,     0,     0,   875,   876,     0,
       0,     0,     0,   877,     0,   878,     0,     0,   879,   880,
       0,   881,   882,   122,     0,   737,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   738,     0,
     739,   130,   131,   740,   133,     0,   134,   741,   135,     0,
     742,   136,   743,   744,   745,   137,   746,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,   747,   144,
       0,   145,   748,   749,   147,     0,   148,   149,   150,   750,
     151,     0,   751,   153,     0,   154,   155,   156,   157,   158,
     752,   753,   159,     0,   160,   161,     0,   754,     0,   755,
     756,   757,     0,     0,   163,   758,   759,     0,   760,   761,
       0,   164,   165,   762,   763,   764,     0,     0,     0,     0,
     765,   168,   766,     0,     0,   767,   768,   169,     0,   170,
       0,     0,     0,   769,   770,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,   771,   179,     0,   772,   773,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,   774,     0,   188,
     775,   189,   776,   777,   190,     0,   778,   191,   192,   193,
     779,     0,   194,     0,     0,   780,     0,   195,   196,     0,
     781,   197,     0,   198,   782,   783,   784,   785,     0,   786,
     787,   200,   788,   789,   790,   202,     0,   203,   791,     0,
     792,   793,     0,   204,   205,     0,   206,   794,     0,   207,
       0,     0,     0,   795,   209,   210,   211,   796,     0,   212,
     213,     0,     0,     0,   214,     0,     0,   797,   215,   798,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,   799,   220,     0,     0,   800,   221,
       0,   801,   222,     0,     0,     0,   802,     0,   803,     0,
     224,   804,     0,   225,     0,   226,   805,     0,     0,   806,
       0,     0,     0,     0,   807,   227,   228,   229,   230,   231,
     232,   808,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   809,   242,   243,   244,   810,   245,   246,     0,     0,
       0,   247,   248,   811,   250,     0,     0,   812,   252,   813,
     814,   253,     0,   254,   815,   816,   817,   818,   819,   820,
     821,   259,   260,   261,   262,     0,   822,   263,   264,     0,
     265,   266,   267,   823,   824,   825,   268,     0,   826,   827,
       0,   269,   270,     0,   828,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   829,   830,   278,   831,   832,   833,   834,   835,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   836,   287,
     288,   289,   290,   291,   292,   293,   837,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,   838,   839,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,   840,   308,   309,   841,   310,   311,
     842,   312,   843,   314,   315,     0,   844,   317,  1293,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,   845,   846,   334,   335,     0,   336,
     847,   338,   848,   849,   850,   339,   340,   851,   341,   342,
       0,   343,   344,     0,   852,   345,   853,   854,   855,   856,
       0,     0,     0,     0,     0,   350,     0,   351,   857,   858,
     859,   353,   354,   355,     0,   860,   356,   357,   861,     0,
     358,     0,     0,   862,   863,   359,     0,     0,   360,     0,
     361,     0,   864,   363,     0,     0,   865,   866,   867,   868,
     869,   364,     0,     0,   365,   870,     0,   366,   367,   871,
       0,     0,     0,     0,   369,     0,   370,   371,     0,   872,
       0,   873,     0,     0,     0,     0,   874,     0,     0,     0,
     875,   876,     0,     0,     0,     0,   877,     0,  1294,     0,
       0,   879,   880,     0,   881,   882,   122,     0,   737,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   738,     0,   739,   130,   131,   740,   133,     0,   134,
     741,   135,     0,   742,   136,   743,   744,   745,   137,   746,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,   747,   144,     0,   145,   748,   749,   147,     0,   148,
     149,   150,   750,   151,     0,   751,   153,     0,   154,   155,
     156,   157,   158,   752,   753,   159,     0,   160,   161,     0,
     754,     0,   755,   756,   757,     0,     0,   163,   758,   759,
       0,   760,   761,     0,   164,   165,   762,   763,   764,     0,
       0,     0,     0,   765,   168,   766,     0,     0,   767,   768,
     169,     0,   170,     0,     0,     0,   769,   770,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,   771,   179,     0,   772,   773,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
     774,     0,   188,   775,   189,   776,   777,   190,     0,   778,
     191,   192,   193,   779,     0,   194,     0,     0,   780,     0,
     195,   196,     0,   781,   197,     0,   198,   782,   783,   784,
     785,     0,   786,   787,   200,   788,   789,   790,   202,     0,
     203,   791,     0,   792,   793,     0,   204,   205,     0,   206,
     794,     0,   207,     0,     0,     0,   795,   209,   210,   211,
     796,     0,   212,   213,     0,     0,     0,   214,     0,     0,
     797,   215,   798,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,   799,   220,     0,
       0,   800,   221,     0,   801,   222,     0,     0,     0,   802,
       0,   803,     0,   224,   804,     0,   225,     0,   226,   805,
       0,     0,   806,     0,     0,     0,     0,   807,   227,   228,
     229,   230,   231,   232,   808,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   809,   242,   243,   244,   810,   245,
     246,     0,     0,     0,   247,   248,   811,   250,     0,     0,
     812,   252,   813,   814,   253,     0,   254,   815,   816,   817,
     818,   819,   820,   821,   259,   260,   261,   262,     0,   822,
     263,   264,     0,   265,   266,   267,   823,   824,   825,   268,
       0,   826,   827,     0,   269,   270,     0,   828,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   829,   830,   278,   831,   832,   833,
     834,   835,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   836,   287,   288,   289,   290,   291,   292,   293,   837,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,   838,   839,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,   840,   308,   309,
     841,   310,   311,   842,   312,   843,   314,   315,     0,   844,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,   845,   846,   334,
     335,     0,   336,   847,   338,   848,   849,   850,   339,   340,
     851,   341,   342,     0,   343,   344,     0,   852,   345,   853,
     854,   855,   856,     0,     0,     0,     0,     0,   350,     0,
     351,   857,   858,   859,   353,   354,   355,     0,   860,   356,
     357,   861,     0,   358,     0,     0,   862,   863,   359,     0,
       0,   360,     0,   361,     0,   864,   363,     0,     0,   865,
     866,   867,   868,   869,   364,     0,     0,   365,   870,     0,
     366,   367,   871,     0,     0,     0,     0,   369,     0,   370,
     371,     0,   872,     0,   873,     0,     0,     0,     0,   874,
       0,     0,     0,   875,   876,     0,     0,     0,     0,   877,
       0,   878,  1574,     0,   879,   880,     0,   881,   882,   122,
       0,   737,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   738,     0,   739,   130,   131,   740,
     133,     0,   134,   741,   135,     0,   742,   136,   743,   744,
     745,   137,   746,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,   747,   144,     0,   145,   748,   749,
     147,     0,   148,   149,   150,   750,   151,     0,   751,   153,
       0,   154,   155,   156,   157,   158,   752,   753,   159,     0,
     160,   161,     0,   754,     0,   755,   756,   757,     0,     0,
     163,   758,   759,     0,   760,   761,     0,   164,   165,   762,
     763,   764,     0,     0,     0,     0,   765,   168,   766,     0,
       0,   767,   768,   169,     0,   170,     0,     0,     0,   769,
     770,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,   771,   179,     0,
     772,   773,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,   774,     0,   188,   775,   189,   776,   777,
     190,     0,   778,   191,   192,   193,   779,     0,   194,     0,
       0,   780,     0,   195,   196,     0,   781,   197,     0,   198,
     782,   783,   784,   785,     0,   786,   787,   200,   788,   789,
     790,   202,     0,   203,   791,     0,   792,   793,     0,   204,
     205,     0,   206,   794,     0,   207,     0,     0,     0,   795,
     209,   210,   211,   796,     0,   212,   213,     0,     0,     0,
     214,     0,     0,   797,   215,   798,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
     799,   220,     0,     0,   800,   221,     0,   801,   222,     0,
       0,     0,   802,     0,   803,     0,   224,   804,     0,   225,
       0,   226,   805,     0,     0,   806,     0,     0,     0,     0,
     807,   227,   228,   229,   230,   231,   232,   808,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   809,   242,   243,
     244,   810,   245,   246,     0,     0,     0,   247,   248,   811,
     250,     0,     0,   812,   252,   813,   814,   253,     0,   254,
     815,   816,   817,   818,   819,   820,   821,   259,   260,   261,
     262,     0,   822,   263,   264,     0,   265,   266,   267,   823,
     824,   825,   268,     0,   826,   827,     0,   269,   270,     0,
     828,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   829,   830,   278,
     831,   832,   833,   834,   835,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   836,   287,   288,   289,   290,   291,
     292,   293,   837,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,   838,   839,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
     840,   308,   309,   841,   310,   311,   842,   312,   843,   314,
     315,     0,   844,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
     845,   846,   334,   335,     0,   336,   847,   338,   848,   849,
     850,   339,   340,   851,   341,   342,     0,   343,   344,     0,
     852,   345,   853,   854,   855,   856,     0,     0,     0,     0,
       0,   350,     0,   351,   857,   858,   859,   353,   354,   355,
       0,   860,   356,   357,   861,     0,   358,     0,     0,   862,
     863,   359,     0,     0,   360,     0,   361,     0,   864,   363,
       0,     0,   865,   866,   867,   868,   869,   364,     0,     0,
     365,   870,     0,   366,   367,   871,     0,     0,     0,     0,
     369,     0,   370,   371,     0,   872,     0,   873,     0,     0,
       0,     0,   874,     0,     0,     0,   875,   876,     0,     0,
       0,     0,   877,     0,   878,  1670,     0,   879,   880,     0,
     881,   882,   122,     0,   737,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   738,     0,   739,
     130,   131,   740,   133,     0,   134,   741,   135,     0,   742,
     136,   743,   744,   745,   137,   746,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,   747,   144,     0,
     145,   748,   749,   147,     0,   148,   149,   150,   750,   151,
       0,   751,   153,     0,   154,   155,   156,   157,   158,   752,
     753,   159,     0,   160,   161,     0,   754,     0,   755,   756,
     757,     0,     0,   163,   758,   759,     0,   760,   761,     0,
     164,   165,   762,   763,   764,     0,     0,     0,     0,   765,
     168,   766,     0,     0,   767,   768,   169,     0,   170,     0,
       0,     0,   769,   770,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
     771,   179,     0,   772,   773,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,   774,     0,   188,   775,
     189,   776,   777,   190,     0,   778,   191,   192,   193,   779,
       0,   194,     0,     0,   780,     0,   195,   196,     0,   781,
     197,     0,   198,   782,   783,   784,   785,     0,   786,   787,
     200,   788,   789,   790,   202,     0,   203,   791,     0,   792,
     793,     0,   204,   205,     0,   206,   794,     0,   207,     0,
       0,     0,   795,   209,   210,   211,   796,     0,   212,   213,
       0,     0,     0,   214,     0,     0,   797,   215,   798,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,   799,   220,     0,     0,   800,   221,     0,
     801,   222,     0,     0,     0,   802,     0,   803,     0,   224,
     804,     0,   225,     0,   226,   805,     0,     0,   806,     0,
       0,     0,     0,   807,   227,   228,   229,   230,   231,   232,
     808,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     809,   242,   243,   244,   810,   245,   246,     0,     0,     0,
     247,   248,   811,   250,     0,     0,   812,   252,   813,   814,
     253,     0,   254,   815,   816,   817,   818,   819,   820,   821,
     259,   260,   261,   262,     0,   822,   263,   264,     0,   265,
     266,   267,   823,   824,   825,   268,     0,   826,   827,     0,
     269,   270,     0,   828,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     829,   830,   278,   831,   832,   833,   834,   835,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   836,   287,   288,
     289,   290,   291,   292,   293,   837,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,   838,   839,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,   840,   308,   309,   841,   310,   311,   842,
     312,   843,   314,   315,     0,   844,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,   845,   846,   334,   335,     0,   336,   847,
     338,   848,   849,   850,   339,   340,   851,   341,   342,     0,
     343,   344,     0,   852,   345,   853,   854,   855,   856,     0,
       0,     0,     0,     0,   350,     0,   351,   857,   858,   859,
     353,   354,   355,     0,   860,   356,   357,   861,     0,   358,
       0,     0,   862,   863,   359,     0,     0,   360,     0,   361,
       0,   864,   363,     0,     0,   865,   866,   867,   868,   869,
     364,     0,     0,   365,   870,     0,   366,   367,   871,     0,
       0,     0,     0,   369,     0,   370,   371,     0,   872,     0,
     873,     0,     0,     0,     0,   874,     0,     0,     0,   875,
     876,     0,     0,     0,     0,   877,     0,   878,  1707,     0,
     879,   880,     0,   881,   882,   122,     0,   737,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     738,     0,   739,   130,   131,   740,   133,     0,   134,   741,
     135,     0,   742,   136,   743,   744,   745,   137,   746,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
     747,   144,     0,   145,   748,   749,   147,     0,   148,   149,
     150,   750,   151,     0,   751,   153,     0,   154,   155,   156,
     157,   158,   752,   753,   159,     0,   160,   161,     0,   754,
       0,   755,   756,   757,     0,     0,   163,   758,   759,     0,
     760,   761,     0,   164,   165,   762,   763,   764,     0,     0,
       0,     0,   765,   168,   766,     0,     0,   767,   768,   169,
       0,   170,     0,     0,     0,   769,   770,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,   771,   179,     0,   772,   773,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,   774,
       0,   188,   775,   189,   776,   777,   190,     0,   778,   191,
     192,   193,   779,     0,   194,     0,     0,   780,     0,   195,
     196,     0,   781,   197,     0,   198,   782,   783,   784,   785,
       0,   786,   787,   200,   788,   789,   790,   202,     0,   203,
     791,     0,   792,   793,     0,   204,   205,     0,   206,   794,
       0,   207,     0,     0,     0,   795,   209,   210,   211,   796,
       0,   212,   213,     0,     0,     0,   214,     0,     0,   797,
     215,   798,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,   799,   220,     0,     0,
     800,   221,     0,   801,   222,     0,     0,     0,   802,     0,
     803,     0,   224,   804,     0,   225,     0,   226,   805,     0,
       0,   806,     0,     0,     0,     0,   807,   227,   228,   229,
     230,   231,   232,   808,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   809,   242,   243,   244,   810,   245,   246,
       0,     0,     0,   247,   248,   811,   250,     0,     0,   812,
     252,   813,   814,   253,     0,   254,   815,   816,   817,   818,
     819,   820,   821,   259,   260,   261,   262,     0,   822,   263,
     264,     0,   265,   266,   267,   823,   824,   825,   268,     0,
     826,   827,     0,   269,   270,     0,   828,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   829,   830,   278,   831,   832,   833,   834,
     835,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     836,   287,   288,   289,   290,   291,   292,   293,   837,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,   838,   839,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,   840,   308,   309,   841,
     310,   311,   842,   312,   843,   314,   315,     0,   844,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,   845,   846,   334,   335,
       0,   336,   847,   338,   848,   849,   850,   339,   340,   851,
     341,   342,     0,   343,   344,     0,   852,   345,   853,   854,
     855,   856,     0,     0,     0,     0,     0,   350,     0,   351,
     857,   858,   859,   353,   354,   355,     0,   860,   356,   357,
     861,     0,   358,     0,     0,   862,   863,   359,     0,     0,
     360,     0,   361,     0,   864,   363,     0,     0,   865,   866,
     867,   868,   869,   364,     0,     0,   365,   870,     0,   366,
     367,   871,     0,     0,     0,     0,   369,     0,   370,   371,
       0,   872,     0,   873,     0,     0,     0,     0,   874,     0,
       0,     0,   875,   876,     0,     0,     0,     0,   877,     0,
     878,  1736,     0,   879,   880,     0,   881,   882,   122,     0,
     737,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   738,     0,   739,   130,   131,   740,   133,
       0,   134,   741,   135,     0,   742,   136,   743,   744,   745,
     137,   746,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,   747,   144,     0,   145,   748,   749,   147,
       0,   148,   149,   150,   750,   151,     0,   751,   153,     0,
     154,   155,   156,   157,   158,   752,   753,   159,     0,   160,
     161,     0,   754,     0,   755,   756,   757,     0,     0,   163,
     758,   759,     0,   760,   761,     0,   164,   165,   762,   763,
     764,     0,     0,     0,     0,   765,   168,   766,     0,     0,
     767,   768,   169,     0,   170,     0,     0,     0,   769,   770,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,   771,   179,     0,   772,
     773,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,   774,     0,   188,   775,   189,   776,   777,   190,
       0,   778,   191,   192,   193,   779,     0,   194,     0,     0,
     780,     0,   195,   196,  2175,   781,   197,     0,   198,   782,
     783,   784,   785,     0,   786,   787,   200,   788,   789,   790,
     202,     0,   203,   791,     0,   792,   793,     0,   204,   205,
       0,   206,   794,     0,   207,     0,     0,     0,   795,   209,
     210,   211,   796,     0,   212,   213,     0,     0,     0,   214,
       0,     0,   797,   215,   798,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,   799,
     220,     0,     0,   800,   221,     0,   801,   222,     0,     0,
       0,   802,     0,   803,     0,   224,   804,     0,   225,     0,
     226,   805,     0,     0,   806,     0,     0,     0,     0,   807,
     227,   228,   229,   230,   231,   232,   808,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   809,   242,   243,   244,
     810,   245,   246,     0,     0,     0,   247,   248,   811,   250,
       0,     0,   812,   252,   813,   814,   253,     0,   254,   815,
     816,   817,   818,   819,   820,   821,   259,   260,   261,   262,
       0,   822,   263,   264,     0,   265,   266,   267,   823,   824,
     825,   268,     0,   826,   827,     0,   269,   270,     0,   828,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   829,   830,   278,   831,
     832,   833,   834,   835,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   836,   287,   288,   289,   290,   291,   292,
     293,   837,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,   838,   839,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,   840,
     308,   309,   841,   310,   311,   842,   312,   843,   314,   315,
       0,   844,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,   845,
     846,   334,   335,     0,   336,   847,   338,   848,   849,   850,
     339,   340,   851,   341,   342,     0,   343,   344,     0,   852,
     345,   853,   854,   855,   856,     0,     0,     0,     0,     0,
     350,     0,   351,   857,   858,   859,   353,   354,   355,     0,
     860,   356,   357,   861,     0,   358,     0,     0,   862,   863,
     359,     0,     0,   360,     0,   361,     0,   864,   363,     0,
       0,   865,   866,   867,   868,   869,   364,     0,     0,   365,
     870,     0,   366,   367,   871,     0,     0,     0,     0,   369,
       0,   370,   371,     0,   872,     0,   873,     0,     0,     0,
       0,   874,     0,     0,     0,   875,   876,     0,     0,     0,
       0,   877,     0,   878,     0,     0,   879,   880,     0,   881,
     882,   122,     0,   737,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   738,     0,   739,   130,
     131,   740,   133,     0,   134,   741,   135,     0,   742,   136,
     743,   744,   745,   137,   746,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,   747,   144,     0,   145,
     748,   749,   147,     0,   148,   149,   150,   750,   151,     0,
     751,   153,     0,   154,   155,   156,   157,   158,   752,   753,
     159,     0,   160,   161,     0,   754,     0,   755,   756,   757,
       0,     0,   163,   758,   759,     0,   760,   761,     0,   164,
     165,   762,   763,   764,     0,     0,     0,     0,   765,   168,
     766,     0,     0,   767,   768,   169,     0,   170,     0,     0,
       0,   769,   770,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,   771,
     179,     0,   772,   773,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,   774,     0,   188,   775,   189,
     776,   777,   190,     0,   778,   191,   192,   193,   779,     0,
     194,     0,     0,   780,     0,   195,   196,  2177,   781,   197,
       0,   198,   782,   783,   784,   785,     0,   786,   787,   200,
     788,   789,   790,   202,     0,   203,   791,     0,   792,   793,
       0,   204,   205,     0,   206,   794,     0,   207,     0,     0,
       0,   795,   209,   210,   211,   796,     0,   212,   213,     0,
       0,     0,   214,     0,     0,   797,   215,   798,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,   799,   220,     0,     0,   800,   221,     0,   801,
     222,     0,     0,     0,   802,     0,   803,     0,   224,   804,
       0,   225,     0,   226,   805,     0,     0,   806,     0,     0,
       0,     0,   807,   227,   228,   229,   230,   231,   232,   808,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   809,
     242,   243,   244,   810,   245,   246,     0,     0,     0,   247,
     248,   811,   250,     0,     0,   812,   252,   813,   814,   253,
       0,   254,   815,   816,   817,   818,   819,   820,   821,   259,
     260,   261,   262,     0,   822,   263,   264,     0,   265,   266,
     267,   823,   824,   825,   268,     0,   826,   827,     0,   269,
     270,     0,   828,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   829,
     830,   278,   831,   832,   833,   834,   835,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   836,   287,   288,   289,
     290,   291,   292,   293,   837,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
     838,   839,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,   840,   308,   309,   841,   310,   311,   842,   312,
     843,   314,   315,     0,   844,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,   845,   846,   334,   335,     0,   336,   847,   338,
     848,   849,   850,   339,   340,   851,   341,   342,     0,   343,
     344,     0,   852,   345,   853,   854,   855,   856,     0,     0,
       0,     0,     0,   350,     0,   351,   857,   858,   859,   353,
     354,   355,     0,   860,   356,   357,   861,     0,   358,     0,
       0,   862,   863,   359,     0,     0,   360,     0,   361,     0,
     864,   363,     0,     0,   865,   866,   867,   868,   869,   364,
       0,     0,   365,   870,     0,   366,   367,   871,     0,     0,
       0,     0,   369,     0,   370,   371,     0,   872,     0,   873,
       0,     0,     0,     0,   874,     0,     0,     0,   875,   876,
       0,     0,     0,     0,   877,     0,   878,     0,     0,   879,
     880,     0,   881,   882,   122,     0,   737,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   738,
       0,   739,   130,   131,   740,   133,     0,   134,   741,   135,
       0,   742,   136,   743,   744,   745,   137,   746,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,   747,
     144,     0,   145,   748,   749,   147,     0,   148,   149,   150,
     750,   151,     0,   751,   153,     0,   154,   155,   156,   157,
     158,   752,   753,   159,     0,   160,   161,     0,   754,     0,
     755,   756,   757,     0,     0,   163,   758,   759,     0,   760,
     761,     0,   164,   165,   762,   763,   764,     0,     0,     0,
       0,   765,   168,   766,     0,     0,   767,   768,   169,     0,
     170,     0,     0,     0,   769,   770,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,   771,   179,     0,   772,   773,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,   774,     0,
     188,   775,   189,   776,   777,   190,     0,   778,   191,   192,
     193,   779,     0,   194,     0,     0,   780,     0,   195,   196,
    2179,   781,   197,     0,   198,   782,   783,   784,   785,     0,
     786,   787,   200,   788,   789,   790,   202,     0,   203,   791,
       0,   792,   793,     0,   204,   205,     0,   206,   794,     0,
     207,     0,     0,     0,   795,   209,   210,   211,   796,     0,
     212,   213,     0,     0,     0,   214,     0,     0,   797,   215,
     798,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,   799,   220,     0,     0,   800,
     221,     0,   801,   222,     0,     0,     0,   802,     0,   803,
       0,   224,   804,     0,   225,     0,   226,   805,     0,     0,
     806,     0,     0,     0,     0,   807,   227,   228,   229,   230,
     231,   232,   808,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   809,   242,   243,   244,   810,   245,   246,     0,
       0,     0,   247,   248,   811,   250,     0,     0,   812,   252,
     813,   814,   253,     0,   254,   815,   816,   817,   818,   819,
     820,   821,   259,   260,   261,   262,     0,   822,   263,   264,
       0,   265,   266,   267,   823,   824,   825,   268,     0,   826,
     827,     0,   269,   270,     0,   828,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   829,   830,   278,   831,   832,   833,   834,   835,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   836,
     287,   288,   289,   290,   291,   292,   293,   837,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,   838,   839,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,   840,   308,   309,   841,   310,
     311,   842,   312,   843,   314,   315,     0,   844,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,   845,   846,   334,   335,     0,
     336,   847,   338,   848,   849,   850,   339,   340,   851,   341,
     342,     0,   343,   344,     0,   852,   345,   853,   854,   855,
     856,     0,     0,     0,     0,     0,   350,     0,   351,   857,
     858,   859,   353,   354,   355,     0,   860,   356,   357,   861,
       0,   358,     0,     0,   862,   863,   359,     0,     0,   360,
       0,   361,     0,   864,   363,     0,     0,   865,   866,   867,
     868,   869,   364,     0,     0,   365,   870,     0,   366,   367,
     871,     0,     0,     0,     0,   369,     0,   370,   371,     0,
     872,     0,   873,     0,     0,     0,     0,   874,     0,     0,
       0,   875,   876,     0,     0,     0,     0,   877,     0,   878,
       0,     0,   879,   880,     0,   881,   882,   122,     0,   737,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   738,     0,   739,   130,   131,   740,   133,     0,
     134,   741,   135,     0,   742,   136,   743,   744,   745,   137,
     746,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,   747,   144,     0,   145,   748,   749,   147,     0,
     148,   149,   150,   750,   151,     0,   751,   153,     0,   154,
     155,   156,   157,   158,   752,   753,   159,     0,   160,   161,
       0,   754,     0,   755,   756,   757,     0,     0,   163,   758,
     759,     0,   760,   761,     0,   164,   165,   762,   763,   764,
       0,     0,     0,     0,   765,   168,   766,     0,     0,   767,
     768,   169,     0,   170,     0,     0,     0,   769,   770,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,   771,   179,     0,   772,   773,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,   774,     0,   188,   775,   189,   776,   777,   190,     0,
     778,   191,   192,   193,   779,     0,   194,     0,     0,   780,
       0,   195,   196,     0,   781,   197,     0,   198,   782,   783,
     784,   785,     0,   786,   787,   200,   788,   789,   790,   202,
       0,   203,   791,     0,   792,   793,     0,   204,   205,     0,
     206,   794,     0,   207,     0,     0,     0,   795,   209,   210,
     211,   796,     0,   212,   213,     0,     0,     0,   214,     0,
       0,   797,   215,   798,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,   799,   220,
       0,     0,   800,   221,     0,   801,   222,     0,     0,     0,
     802,     0,   803,     0,   224,   804,     0,   225,     0,   226,
     805,     0,     0,   806,     0,     0,     0,     0,   807,   227,
     228,   229,   230,   231,   232,   808,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   809,   242,   243,   244,   810,
     245,   246,     0,     0,     0,   247,   248,   811,   250,     0,
       0,   812,   252,   813,   814,   253,     0,   254,   815,   816,
     817,   818,   819,   820,   821,   259,   260,   261,   262,     0,
     822,   263,   264,     0,   265,   266,   267,   823,   824,   825,
     268,     0,   826,   827,     0,   269,   270,     0,   828,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   829,   830,   278,   831,   832,
     833,   834,   835,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   836,   287,   288,   289,   290,   291,   292,   293,
     837,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,   838,   839,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,   840,   308,
     309,   841,   310,   311,   842,   312,   843,   314,   315,     0,
     844,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,   845,   846,
     334,   335,     0,   336,   847,   338,   848,   849,   850,   339,
     340,   851,   341,   342,     0,   343,   344,     0,   852,   345,
     853,   854,   855,   856,     0,     0,     0,     0,     0,   350,
       0,   351,   857,   858,   859,   353,   354,   355,     0,   860,
     356,   357,   861,     0,   358,     0,     0,   862,   863,   359,
       0,     0,   360,     0,   361,     0,   864,   363,     0,     0,
     865,   866,   867,   868,   869,   364,     0,     0,   365,   870,
       0,   366,   367,   871,     0,     0,     0,     0,   369,     0,
     370,   371,     0,   872,     0,   873,     0,     0,     0,     0,
     874,     0,     0,     0,   875,   876,     0,     0,     0,     0,
     877,     0,   878,     0,     0,   879,   880,     0,   881,   882,
     122,     0,   737,   124,   125,   126,   127,  1768,     0,     0,
       0,     0,  1769,     0,     0,   738,     0,   739,   130,   131,
     740,   133,     0,   134,   741,   135,     0,   742,   136,   743,
     744,   745,   137,   746,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,   747,   144,     0,   145,   748,
     749,   147,     0,   148,   149,   150,   750,   151,     0,   751,
     153,     0,   154,   155,   156,   157,   158,   752,   753,   159,
       0,   160,   161,     0,   754,     0,   755,   756,   757,     0,
       0,   163,   758,   759,     0,   760,   761,     0,   164,   165,
     762,   763,   764,     0,     0,     0,     0,   765,   168,   766,
       0,     0,   767,   768,   169,     0,   170,     0,     0,     0,
     769,   770,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,   771,   179,
       0,   772,   773,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,   774,     0,   188,   775,   189,   776,
     777,   190,     0,   778,   191,   192,   193,   779,     0,   194,
       0,     0,   780,     0,   195,   196,     0,   781,   197,     0,
     198,   782,   783,   784,   785,     0,   786,   787,   200,   788,
     789,   790,   202,     0,   203,   791,     0,   792,   793,     0,
     204,   205,     0,   206,   794,     0,   207,     0,     0,     0,
     795,   209,   210,   211,   796,     0,   212,   213,     0,     0,
       0,   214,     0,     0,   797,   215,   798,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,   799,   220,     0,     0,   800,   221,     0,   801,   222,
       0,     0,     0,   802,     0,   803,     0,   224,   804,     0,
     225,     0,   226,   805,     0,     0,   806,     0,     0,     0,
       0,   807,   227,   228,   229,   230,   231,   232,   808,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   809,   242,
     243,   244,   810,   245,   246,     0,     0,     0,   247,   248,
     811,   250,     0,     0,   812,   252,   813,   814,   253,     0,
     254,   815,   816,   817,   818,   819,   820,   821,   259,   260,
     261,   262,     0,   822,   263,   264,     0,   265,   266,   267,
     823,     0,   825,   268,     0,   826,   827,     0,   269,   270,
       0,   828,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   829,   830,
     278,   831,   832,   833,   834,   835,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   836,   287,   288,   289,   290,
     291,   292,   293,   837,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,   838,
     839,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,   840,   308,   309,   841,   310,   311,   842,   312,   843,
     314,   315,     0,   844,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,   845,   846,   334,   335,     0,   336,   847,   338,   848,
     849,   850,   339,   340,   851,   341,   342,     0,   343,   344,
       0,   852,   345,   853,   854,   855,   856,     0,     0,     0,
       0,     0,   350,     0,   351,   857,   858,   859,   353,   354,
     355,     0,   860,   356,   357,   861,     0,   358,     0,     0,
     862,   863,   359,     0,     0,   360,     0,   361,     0,   864,
     363,     0,     0,   865,   866,   867,   868,   869,   364,     0,
       0,   365,   870,     0,   366,   367,   871,     0,     0,     0,
       0,   369,     0,   370,   371,     0,   872,     0,   873,     0,
       0,     0,     0,   874,     0,     0,     0,   875,   876,     0,
       0,     0,     0,   877,     0,   878,     0,     0,   879,   880,
       0,   881,   882,   122,     0,   737,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   738,     0,
     739,   130,   131,   740,   133,     0,   134,   741,   135,     0,
     742,   136,   743,   744,   745,   137,   746,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,   747,   144,
       0,   145,   748,   749,   147,     0,   148,   149,   150,   750,
     151,     0,   751,   153,     0,   154,   155,   156,   157,   158,
     752,   753,   159,     0,   160,   161,     0,   754,     0,   755,
     756,   757,     0,     0,   163,   758,   759,     0,   760,   761,
       0,   164,   165,   762,   763,   764,     0,     0,     0,     0,
     765,   168,   766,     0,     0,   767,   768,   169,     0,   170,
       0,     0,     0,   769,   770,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,   771,   179,     0,   772,   773,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,   774,     0,   188,
     775,   189,   776,   777,   190,     0,   778,   191,   192,   193,
     779,     0,   194,     0,     0,   780,     0,   195,   196,     0,
     781,   197,     0,   198,   782,   783,   784,   785,     0,   786,
     787,   200,   788,   789,   790,   202,     0,   203,   791,     0,
     792,   793,     0,   204,   205,     0,   206,   794,     0,   207,
       0,     0,     0,   795,   209,   210,   211,   796,     0,   212,
     213,     0,     0,     0,   214,     0,     0,   797,   215,  2454,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,   799,   220,     0,     0,   800,   221,
       0,   801,   222,     0,     0,     0,   802,     0,   803,     0,
     224,   804,     0,   225,     0,   226,   805,     0,     0,   806,
       0,     0,     0,     0,   807,   227,   228,   229,   230,   231,
     232,   808,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   809,   242,   243,   244,   810,   245,   246,     0,     0,
       0,   247,   248,   811,   250,     0,     0,   812,   252,   813,
     814,   253,     0,   254,   815,   816,   817,   818,   819,   820,
     821,   259,   260,   261,   262,     0,   822,   263,   264,     0,
     265,   266,   267,   823,   824,   825,   268,     0,   826,   827,
       0,   269,   270,     0,   828,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   829,   830,   278,   831,   832,   833,   834,   835,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   836,   287,
     288,   289,   290,   291,   292,   293,   837,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,   838,   839,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,   840,   308,   309,   841,   310,   311,
     842,   312,   843,   314,   315,     0,   844,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,   845,   846,   334,   335,     0,   336,
     847,   338,   848,   849,   850,   339,   340,   851,   341,   342,
       0,   343,   344,     0,   852,   345,   853,   854,   855,   856,
       0,     0,     0,     0,     0,   350,     0,   351,   857,   858,
     859,   353,   354,   355,     0,   860,   356,   357,   861,     0,
     358,     0,     0,   862,   863,   359,     0,     0,   360,     0,
     361,     0,   864,   363,     0,     0,   865,   866,   867,   868,
     869,   364,     0,     0,   365,   870,     0,   366,   367,   871,
       0,     0,     0,     0,   369,     0,   370,   371,     0,   872,
       0,   873,     0,     0,     0,     0,   874,     0,     0,     0,
     875,   876,     0,     0,     0,     0,   877,     0,   878,     0,
       0,   879,   880,     0,   881,   882,   122,     0,   737,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   738,     0,   739,   130,   131,   740,   133,     0,   134,
     741,   135,     0,   742,   136,   743,   744,   745,   137,   746,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,   747,   144,     0,   145,   748,   749,   147,     0,   148,
     149,   150,   750,   151,     0,   751,   153,     0,   154,   155,
     156,   157,   158,   752,   753,   159,     0,   160,   161,     0,
     754,     0,   755,   756,   757,     0,     0,   163,   758,   759,
       0,   760,   761,     0,   164,   165,   762,   763,   764,     0,
       0,     0,     0,   765,   168,   766,     0,     0,   767,   768,
     169,     0,   170,     0,     0,     0,   769,   770,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,   771,   179,     0,   772,   773,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
     774,     0,   188,   775,   189,   776,   777,   190,     0,   778,
     191,   192,   193,   779,     0,   194,     0,     0,   780,     0,
     195,   196,     0,   781,   197,     0,   198,   782,   783,   784,
     785,     0,   786,   787,   200,   788,   789,   790,   202,     0,
     203,   791,     0,   792,   793,     0,   204,   205,     0,   206,
     794,     0,   207,     0,     0,     0,   795,   209,   210,   211,
     796,     0,   212,   213,     0,     0,     0,   214,     0,     0,
     797,   215,  2527,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,   799,   220,     0,
       0,   800,   221,     0,   801,   222,     0,     0,     0,   802,
       0,   803,     0,   224,   804,     0,   225,     0,   226,   805,
       0,     0,   806,     0,     0,     0,     0,   807,   227,   228,
     229,   230,   231,   232,   808,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   809,   242,   243,   244,   810,   245,
     246,     0,     0,     0,   247,   248,   811,   250,     0,     0,
     812,   252,   813,   814,   253,     0,   254,   815,   816,   817,
     818,   819,   820,   821,   259,   260,   261,   262,     0,   822,
     263,   264,     0,   265,   266,   267,   823,   824,   825,   268,
       0,   826,   827,     0,   269,   270,     0,   828,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   829,   830,   278,   831,   832,   833,
     834,   835,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   836,   287,   288,   289,   290,   291,   292,   293,   837,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,   838,   839,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,   840,   308,   309,
     841,   310,   311,   842,   312,   843,   314,   315,     0,   844,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,   845,   846,   334,
     335,     0,   336,   847,   338,   848,   849,   850,   339,   340,
     851,   341,   342,     0,   343,   344,     0,   852,   345,   853,
     854,   855,   856,     0,     0,     0,     0,     0,   350,     0,
     351,   857,   858,   859,   353,   354,   355,     0,   860,   356,
     357,   861,     0,   358,     0,     0,   862,   863,   359,     0,
       0,   360,     0,   361,     0,   864,   363,     0,     0,   865,
     866,   867,   868,   869,   364,     0,     0,   365,   870,     0,
     366,   367,   871,     0,     0,     0,     0,   369,     0,   370,
     371,     0,   872,     0,   873,     0,     0,     0,     0,   874,
       0,     0,     0,   875,   876,     0,     0,     0,     0,   877,
       0,   878,     0,     0,   879,   880,     0,   881,   882,   122,
       0,   737,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   738,     0,   739,   130,   131,   740,
     133,     0,   134,   741,   135,     0,   742,   136,   743,   744,
     745,   137,   746,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,   747,   144,     0,   145,   748,   749,
     147,     0,   148,   149,   150,   750,   151,     0,   751,   153,
       0,   154,   155,   156,   157,   158,   752,   753,   159,     0,
     160,   161,     0,   754,     0,   755,   756,   757,     0,     0,
     163,   758,   759,     0,   760,   761,     0,   164,   165,   762,
     763,   764,     0,     0,     0,     0,   765,   168,   766,     0,
       0,   767,  2878,   169,     0,   170,     0,     0,     0,   769,
     770,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,   771,   179,     0,
     772,   773,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,   774,     0,   188,   775,   189,   776,   777,
     190,     0,   778,   191,   192,   193,   779,     0,   194,     0,
       0,   780,     0,   195,   196,     0,   781,   197,     0,   198,
     782,   783,   784,   785,     0,   786,   787,   200,   788,   789,
     790,   202,     0,   203,   791,     0,   792,   793,     0,   204,
     205,     0,   206,   794,     0,   207,     0,     0,     0,   795,
     209,   210,   211,   796,     0,   212,   213,     0,     0,     0,
     214,     0,     0,   797,   215,   798,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
     799,   220,     0,     0,   800,   221,     0,   801,   222,     0,
       0,     0,   802,     0,   803,     0,   224,   804,     0,   225,
       0,   226,   805,     0,     0,   806,     0,     0,     0,     0,
     807,   227,   228,   229,   230,   231,   232,   808,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   809,   242,   243,
     244,   810,   245,   246,     0,     0,     0,   247,   248,   811,
     250,     0,     0,   812,   252,   813,   814,   253,     0,   254,
     815,   816,   817,   818,   819,   820,   821,   259,   260,   261,
     262,     0,   822,   263,   264,     0,   265,   266,   267,   823,
     824,   825,   268,     0,   826,   827,     0,   269,   270,     0,
     828,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   829,   830,   278,
     831,   832,   833,   834,   835,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   836,   287,   288,   289,   290,   291,
     292,   293,   837,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,   838,   839,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
     840,   308,   309,   841,   310,   311,   842,   312,   843,   314,
     315,     0,   844,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
     845,   846,   334,   335,     0,   336,   847,   338,   848,   849,
     850,   339,   340,   851,   341,   342,     0,   343,   344,     0,
     852,   345,   853,   854,   855,   856,     0,     0,     0,     0,
       0,   350,     0,   351,   857,   858,   859,   353,   354,   355,
       0,   860,   356,   357,   861,     0,   358,     0,     0,   862,
     863,   359,     0,     0,   360,     0,   361,     0,   864,   363,
       0,     0,   865,   866,   867,   868,   869,   364,     0,     0,
     365,   870,     0,   366,   367,   871,     0,     0,     0,     0,
     369,     0,   370,   371,     0,   872,     0,   873,     0,     0,
       0,     0,   874,     0,     0,     0,   875,   876,     0,     0,
       0,     0,   877,     0,   878,     0,     0,   879,   880,     0,
     881,   882,   122,     0,   737,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   738,     0,   739,
     130,   131,   740,   133,     0,   134,   741,   135,     0,   742,
     136,   743,   744,   745,   137,   746,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,   747,   144,     0,
     145,   748,   749,   147,     0,   148,   149,   150,   750,   151,
       0,   751,   153,     0,   154,   155,   156,   157,   158,   752,
     753,   159,     0,   160,   161,     0,   754,     0,   755,   756,
     757,     0,     0,   163,   758,   759,     0,   760,   761,     0,
     164,   165,   762,   763,   764,     0,     0,     0,     0,   765,
     168,   766,     0,     0,   767,   768,   169,     0,   170,     0,
       0,     0,   769,   770,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
     771,   179,     0,   772,   773,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,   774,     0,   188,   775,
     189,   776,   777,   190,     0,   778,   191,   192,   193,   779,
       0,   194,     0,     0,   780,     0,   195,   196,     0,   781,
     197,     0,   198,   782,   783,   784,   785,     0,   786,   787,
     200,   788,   789,   790,   202,     0,   203,   791,     0,   792,
     793,     0,   204,   205,     0,   206,   794,     0,   207,     0,
       0,     0,   795,   209,   210,   211,   796,     0,   212,   213,
       0,     0,     0,   214,     0,     0,   797,   215,   798,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,   799,   220,     0,     0,   800,   221,     0,
     801,   222,     0,     0,     0,   802,     0,   803,     0,   224,
     804,     0,   225,     0,   226,   805,     0,     0,   806,     0,
       0,     0,     0,   807,   227,   228,   229,   230,   231,   232,
     808,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     809,   242,   243,   244,   810,   245,   246,     0,     0,     0,
     247,   248,   811,   250,     0,     0,   812,   252,   813,   814,
     253,     0,   254,   815,   816,   817,   818,   819,   820,   821,
     259,   260,   261,   262,     0,   822,   263,   264,     0,   265,
     266,   267,   823,     0,   825,   268,     0,   826,   827,     0,
     269,   270,     0,   828,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     829,   830,   278,   831,   832,   833,   834,   835,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   836,   287,   288,
     289,   290,   291,   292,   293,   837,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,   838,   839,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,   840,   308,   309,   841,   310,   311,   842,
     312,   843,   314,   315,     0,   844,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,   845,   846,   334,   335,     0,   336,   847,
     338,   848,   849,   850,   339,   340,   851,   341,   342,     0,
     343,   344,     0,   852,   345,   853,   854,   855,   856,     0,
       0,     0,     0,     0,   350,     0,   351,   857,   858,   859,
     353,   354,   355,     0,   860,   356,   357,   861,     0,   358,
       0,     0,   862,   863,   359,     0,     0,   360,     0,   361,
       0,   864,   363,     0,     0,   865,   866,   867,   868,   869,
     364,     0,     0,   365,   870,     0,   366,   367,   871,     0,
       0,     0,     0,   369,     0,   370,   371,     0,   872,     0,
     873,     0,     0,     0,     0,   874,     0,     0,     0,   875,
     876,     0,     0,     0,     0,   877,     0,   878,     0,     0,
     879,   880,     0,   881,   882,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,  1942,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,  1943,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,  1088,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,  1089,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,  2439,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
    1855,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,  1944,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,     0,   372,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,  1991,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,  1942,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,  1943,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,  1088,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,  1089,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,  1944,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,     0,   372,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,  1991,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
    1855,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,     0,   372,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,  2259,     0,   130,   131,   132,   133,   882,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,     0,   372,     0,     0,     0,     0,     0,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,  3629,   128,     0,     0,   129,  3630,   882,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,   975,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,     0,   372,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,   408,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,     0,   372,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,  1814,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,   408,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,     0,   372,     0,
       0,     0,     0,     0,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,  1990,     0,   128,     0,     0,
     129,     0,  1991,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,     0,   372,     0,     0,     0,     0,     0,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,  3630,   882,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,     0,   372,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,   408,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   462,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,     0,   372,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,   408,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,     0,   372,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,   882,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,     0,   372,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,  1991,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
     550,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,   551,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,  1755,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,   550,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,   551,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,   122,   372,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,  2299,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,   550,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,   551,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,   122,   372,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,   130,
     131,   132,     0,     0,  -226,  2901,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,     0,     0,     0,     0,   143,     0,   144,     0,   145,
       0,     0,     0,     0,   148,   149,  3467,     0,   151,     0,
     152,   153,     0,     0,   155,     0,   157,   158,     0,     0,
     159,     0,   160,   161,     0,     0,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,     0,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,     0,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,     0,   181,   182,   183,     0,     0,
     184,     0,   185,   186,     0,     0,     0,   188,     0,   189,
       0,     0,   190,  3468,     0,   191,   192,   193,     0,     0,
       0,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,  3469,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,  3470,     0,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,   221,  3471,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,  -179,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,     0,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,  3472,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,     0,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,     0,   301,
    -179,     0,   302,     0,     0,   304,     0,     0,   306,   307,
    3473,     0,     0,     0,   309,     0,   310,   311,     0,   312,
     313,   314,     0,     0,   316,     0,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,     0,
     324,     0,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
       0,   333,     0,     0,     0,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,     0,   353,
     354,   355,     0,     0,   356,   357,     0,     0,     0,     0,
       0,     0,     0,   359,     0,     0,   360,     0,     0,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
    -179,     0,   369,     0,   370,     0,     0,     0,     0,   372,
       0,     0,     0,     0,  3474,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,  3681,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,     0,   372,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,  1596,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,     0,   372,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,  2285,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
       0,   372,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,  2578,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,     0,
     372,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,  2906,     0,   128,     0,     0,     0,     0,     0,   130,
     131,   132,     0,     0,  -226,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,     0,     0,     0,     0,   143,     0,   144,     0,   145,
       0,     0,     0,     0,   148,   149,  3467,     0,   151,     0,
     152,   153,     0,     0,   155,     0,   157,   158,     0,     0,
     159,     0,   160,   161,     0,     0,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,     0,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,     0,     0,     0,   176,   177,   178,     0,  -196,     0,
     179,     0,     0,     0,  -196,   181,   182,   183,     0,     0,
     184,     0,   185,   186,     0,     0,     0,   188,     0,   189,
       0,     0,   190,  3468,     0,   191,   192,   193,     0,     0,
       0,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,  3469,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,  3470,     0,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,   221,  3471,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,  -179,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,     0,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,  3472,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,     0,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,     0,   301,
    -179,     0,   302,     0,     0,   304,     0,     0,   306,   307,
    3473,     0,     0,     0,   309,     0,   310,   311,     0,   312,
     313,   314,     0,     0,   316,     0,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,     0,
     324,     0,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
       0,   333,     0,     0,     0,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,     0,   353,
     354,   355,     0,     0,   356,   357,     0,     0,     0,     0,
       0,     0,     0,   359,     0,     0,   360,     0,     0,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
    -179,     0,   369,     0,   370,     0,     0,     0,     0,   372,
       0,     0,  -196,   122,  3474,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -226,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,     0,     0,     0,     0,   143,     0,   144,
       0,   145,     0,     0,     0,     0,   148,   149,  3467,     0,
     151,     0,   152,   153,     0,     0,   155,     0,   157,   158,
       0,     0,   159,     0,   160,   161,     0,     0,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,     0,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,  -217,   181,   182,   183,
       0,     0,   184,     0,   185,   186,     0,     0,     0,   188,
       0,   189,     0,     0,   190,  3468,     0,   191,   192,   193,
       0,     0,     0,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,     0,   205,     0,     0,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,  3469,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,  3470,     0,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,   221,
    3471,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,  -179,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,     0,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,  3472,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
       0,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
       0,   301,  -179,     0,   302,     0,     0,   304,     0,     0,
     306,   307,  3473,     0,     0,     0,   309,     0,   310,   311,
       0,   312,   313,   314,     0,     0,   316,     0,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,     0,   324,     0,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,     0,   333,     0,     0,     0,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
       0,   353,   354,   355,     0,     0,   356,   357,     0,     0,
       0,     0,     0,     0,     0,   359,     0,     0,   360,     0,
       0,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
    -217,     0,  -179,     0,   369,     0,   370,     0,     0,     0,
       0,   372,     0,     0,  -217,   122,  3474,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -226,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,     0,     0,     0,     0,   143,
       0,   144,     0,   145,     0,     0,     0,     0,   148,   149,
    3467,     0,   151,     0,   152,   153,     0,     0,   155,     0,
     157,   158,     0,     0,   159,     0,   160,   161,     0,     0,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,     0,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,  -214,   181,
     182,   183,     0,     0,   184,     0,   185,   186,     0,     0,
       0,   188,     0,   189,     0,     0,   190,  3468,     0,   191,
     192,   193,     0,     0,     0,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,     0,   205,     0,     0,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,  3469,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,  3470,
       0,     0,     0,     0,     0,     0,     0,   220,     0,     0,
       0,   221,  3471,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,  -179,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,     0,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
    3472,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,     0,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,     0,   301,  -179,     0,   302,     0,     0,   304,
       0,     0,   306,   307,  3473,     0,     0,     0,   309,     0,
     310,   311,     0,   312,   313,   314,     0,     0,   316,     0,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,     0,   324,     0,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,     0,   333,     0,     0,     0,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,     0,   353,   354,   355,     0,     0,   356,   357,
       0,     0,     0,     0,     0,     0,     0,   359,     0,     0,
     360,     0,     0,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,  -214,     0,  -179,     0,   369,     0,   370,     0,
       0,     0,     0,   372,     0,     0,  -214,   122,  3474,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,     0,     0,     0,   130,   131,   132,     0,     0,
    -226,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,     0,     0,     0,
       0,   143,     0,   144,     0,   145,     0,     0,     0,     0,
     148,   149,  3467,     0,   151,     0,   152,   153,     0,     0,
     155,     0,   157,   158,     0,     0,   159,     0,   160,   161,
       0,     0,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,     0,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
    3558,   181,   182,   183,     0,     0,   184,     0,   185,   186,
       0,     0,     0,   188,     0,   189,     0,     0,   190,  3468,
       0,   191,   192,   193,     0,     0,     0,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,     0,   205,     0,
       0,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,  3469,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,  3470,     0,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,   221,  3471,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,  -179,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
       0,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,  3472,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,     0,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,     0,   301,  -179,     0,   302,     0,
       0,   304,     0,     0,   306,   307,  3473,     0,     0,     0,
     309,     0,   310,   311,     0,   312,   313,   314,     0,     0,
     316,     0,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,     0,   324,     0,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,     0,   333,     0,     0,
       0,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,     0,   353,   354,   355,     0,     0,
     356,   357,     0,     0,     0,     0,     0,     0,     0,   359,
       0,     0,   360,     0,     0,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,  -179,     0,   369,     0,
     370,     0,     0,     0,     0,   372,     0,     0,     0,   122,
    3474,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -226,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,     0,
       0,     0,     0,   143,     0,   144,     0,   145,     0,     0,
       0,     0,   148,   149,  3467,     0,   151,     0,   152,   153,
       0,     0,   155,     0,   157,   158,     0,     0,   159,     0,
     160,   161,     0,     0,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,     0,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,     0,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,  -219,   181,   182,   183,     0,     0,   184,     0,
     185,   186,     0,     0,     0,   188,     0,   189,     0,     0,
     190,  3468,     0,   191,   192,   193,     0,     0,     0,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,     0,
     205,     0,     0,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,  3469,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,  3470,     0,     0,     0,     0,     0,     0,
       0,   220,     0,     0,     0,   221,  3471,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,  -179,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,     0,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,  3472,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,     0,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,     0,   301,  -179,     0,
     302,     0,     0,   304,     0,     0,   306,   307,  3473,     0,
       0,     0,   309,     0,   310,   311,     0,   312,   313,   314,
       0,     0,   316,     0,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,     0,   324,     0,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,     0,   333,
       0,     0,     0,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,     0,   353,   354,   355,
       0,     0,   356,   357,     0,     0,     0,     0,     0,     0,
       0,   359,     0,     0,   360,     0,     0,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,  -179,     0,
     369,     0,   370,     0,     0,     0,     0,   372,     0,     0,
       0,   122,  3474,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,   130,
     131,   132,     0,     0,  -226,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,     0,     0,     0,     0,   143,     0,   144,     0,   145,
       0,     0,     0,     0,   148,   149,  3467,     0,   151,     0,
     152,   153,     0,     0,   155,     0,   157,   158,     0,     0,
     159,     0,   160,   161,     0,     0,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,     0,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,     0,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,  3609,   181,   182,   183,     0,     0,
     184,     0,   185,   186,     0,     0,     0,   188,     0,   189,
       0,     0,   190,  3468,     0,   191,   192,   193,     0,     0,
       0,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,  3469,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,  3470,     0,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,   221,  3471,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,  -179,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,     0,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,  3472,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,     0,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,     0,   301,
    -179,     0,   302,     0,     0,   304,     0,     0,   306,   307,
    3473,     0,     0,     0,   309,     0,   310,   311,     0,   312,
     313,   314,     0,     0,   316,     0,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,     0,
     324,     0,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
       0,   333,     0,     0,     0,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,     0,   353,
     354,   355,     0,     0,   356,   357,     0,     0,     0,     0,
       0,     0,     0,   359,     0,     0,   360,     0,     0,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
    -179,     0,   369,     0,   370,     0,     0,     0,     0,   372,
       0,     0,     0,   122,  3474,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -226,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,     0,     0,     0,     0,   143,     0,   144,
       0,   145,     0,     0,     0,     0,   148,   149,  3467,     0,
     151,     0,   152,   153,     0,     0,   155,     0,   157,   158,
       0,     0,   159,     0,   160,   161,     0,     0,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,     0,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,  3642,   181,   182,   183,
       0,     0,   184,     0,   185,   186,     0,     0,     0,   188,
       0,   189,     0,     0,   190,  3468,     0,   191,   192,   193,
       0,     0,     0,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,     0,   205,     0,     0,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,  3469,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,  3470,     0,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,   221,
    3471,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,  -179,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,     0,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,  3472,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
       0,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
       0,   301,  -179,     0,   302,     0,     0,   304,     0,     0,
     306,   307,  3473,     0,     0,     0,   309,     0,   310,   311,
       0,   312,   313,   314,     0,     0,   316,     0,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,     0,   324,     0,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,     0,   333,     0,     0,     0,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
       0,   353,   354,   355,     0,     0,   356,   357,     0,     0,
       0,     0,     0,     0,     0,   359,     0,     0,   360,     0,
       0,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,  -179,     0,   369,     0,   370,     0,     0,     0,
       0,   372,     0,     0,     0,   122,  3474,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -226,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,     0,     0,     0,     0,   143,
       0,   144,     0,   145,     0,     0,     0,     0,   148,   149,
    3467,     0,   151,     0,   152,   153,     0,     0,   155,     0,
     157,   158,     0,     0,   159,     0,   160,   161,     0,     0,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,     0,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,  -200,   181,
     182,   183,     0,     0,   184,     0,   185,   186,     0,     0,
       0,   188,     0,   189,     0,     0,   190,  3468,     0,   191,
     192,   193,     0,     0,     0,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,     0,   205,     0,     0,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,  3469,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,  3470,
       0,     0,     0,     0,     0,     0,     0,   220,     0,     0,
       0,   221,  3471,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,  -179,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,     0,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
    3472,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,     0,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,     0,   301,  -179,     0,   302,     0,     0,   304,
       0,     0,   306,   307,  3473,     0,     0,     0,   309,     0,
     310,   311,     0,   312,   313,   314,     0,     0,   316,     0,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,     0,   324,     0,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,     0,   333,     0,     0,     0,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,     0,   353,   354,   355,     0,     0,   356,   357,
       0,     0,     0,     0,     0,     0,     0,   359,     0,     0,
     360,     0,     0,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,  -179,     0,   369,     0,   370,     0,
       0,     0,     0,   372,     0,     0,     0,   122,  3474,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,     0,     0,     0,   130,   131,   132,     0,     0,
    -226,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,     0,     0,     0,
       0,   143,     0,   144,     0,   145,     0,     0,     0,     0,
     148,   149,  3467,     0,   151,     0,   152,   153,     0,     0,
     155,     0,   157,   158,     0,     0,   159,     0,   160,   161,
       0,     0,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,     0,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
       0,   181,   182,   183,     0,     0,   184,     0,   185,   186,
       0,     0,     0,   188,     0,   189,     0,     0,   190,  3468,
       0,   191,   192,   193,     0,     0,     0,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,     0,   205,     0,
       0,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,  3469,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,  3470,     0,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,   221,  3471,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,  -179,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
       0,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,  3472,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,     0,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,     0,   301,  -179,     0,   302,     0,
       0,   304,     0,     0,   306,   307,  3473,     0,     0,     0,
     309,     0,   310,   311,     0,   312,   313,   314,     0,     0,
     316,     0,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,     0,   324,     0,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,     0,   333,     0,     0,
       0,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,     0,   353,   354,   355,     0,     0,
     356,   357,     0,     0,     0,     0,     0,     0,     0,   359,
       0,     0,   360,     0,     0,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,  -179,     0,   369,     0,
     370,     0,     0,     0,     0,   372,     0,     0,     0,   122,
    3474,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -226,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,     0,
       0,     0,     0,   143,     0,   144,     0,   145,     0,     0,
       0,     0,   148,   149,  3467,     0,   151,     0,   152,   153,
       0,     0,   155,     0,   157,   158,     0,     0,   159,     0,
     160,   161,     0,     0,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,     0,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,     0,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,     0,   181,   182,   183,     0,     0,   184,     0,
     185,   186,     0,     0,     0,   188,     0,   189,     0,     0,
     190,  3468,     0,   191,   192,   193,     0,     0,     0,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,     0,
     205,     0,     0,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,  3469,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,  3470,     0,     0,     0,     0,     0,     0,
       0,   220,     0,     0,     0,   221,  3471,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,  -179,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,     0,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,  3472,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,     0,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,     0,   301,  -179,     0,
     302,     0,     0,   304,     0,     0,   306,   307,  3473,     0,
       0,     0,   309,     0,   310,   311,     0,   312,   313,   314,
       0,     0,   316,     0,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,     0,   324,     0,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,     0,   333,
       0,     0,     0,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,     0,   353,   354,   355,
       0,     0,   356,   357,     0,     0,     0,     0,     0,     0,
       0,   359,     0,     0,  3561,     0,     0,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,  -179,     0,
     369,     0,   370,     0,     0,     0,     0,   372,     0,     0,
       0,   122,  3474,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
    1606,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,  1607,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,  1608,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,  1609,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,   700,   701,     0,   268,     0,     0,  1610,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,  3669,  3660,  3670,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,  1611,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,   122,   372,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,  2291,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,  2292,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,  1929,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,   550,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
    1930,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,   551,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,  2301,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,  2302,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,   550,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,   551,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,  2291,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,  2292,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,   550,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,   551,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,   122,
     372,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,   704,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,   550,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
     551,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,   656,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
     657,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,   658,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,  2339,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,   550,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,   551,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,  2291,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
     550,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,   551,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,   550,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,   551,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,   122,   372,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,  2281,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,   551,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,   122,   372,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,  3604,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,  3605,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,   122,   372,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,   731,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,  1084,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,  1880,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,  1881,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,   122,
     372,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,  1997,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,   551,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,  1880,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,  1389,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,  1390,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,   122,   372,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,     0,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,     0,     0,     0,     0,   143,     0,
     144,     0,   145,     0,     0,     0,     0,   148,   149,     0,
       0,   151,     0,   152,   153,     0,     0,   155,     0,   157,
     158,     0,     0,   159,     0,   160,   161,     0,     0,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,     0,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,     0,   181,   182,
     183,     0,     0,   184,     0,   185,   186,     0,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,     0,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,     0,   205,     0,     0,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,     0,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,     0,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,     0,   301,     0,     0,   302,     0,     0,   304,     0,
       0,   306,   307,     0,     0,     0,     0,   309,     0,   310,
     311,     0,   312,   313,   314,     0,     0,   316,     0,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,     0,   324,     0,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,     0,   333,     0,     0,     0,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,     0,   353,   354,   355,     0,     0,   356,   357,     0,
       0,     0,     0,     0,     0,     0,   359,     0,     0,   360,
       0,     0,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,     0,     0,
       0,     0,   372
};

static const yytype_int16 yycheck[] =
{
       7,   412,   457,   489,   894,   437,   671,   591,   961,   494,
     495,  1157,    19,   764,   515,    22,   758,   759,   760,  1014,
     616,  1283,    29,   637,  1283,  1193,  1749,   742,  1933,  1064,
    1308,   614,    39,  1859,  1890,  1505,  1832,  1315,  1883,  1884,
    1885,   637,    49,    22,  1911,  1159,  1160,  1161,  1518,  2058,
    2316,  1592,  1919,     7,  1921,   638,  2065,  1191,  1172,  1369,
    1918,  2679,  2040,  2360,  1077,  2266,  1185,   675,  1897,  1898,
    1471,     3,   573,  2656,   675,  1029,  1327,  1328,  1874,  1948,
      87,   444,     3,   825,     3,     3,  1040,  1041,  2664,     3,
       3,     3,     3,  1070,  1164,  1165,  1952,  1167,     3,   499,
     107,   108,   853,   110,    16,   856,  1225,    18,    87,   851,
      32,    55,  1226,    16,   121,  1229,  1972,  1973,    18,    15,
      16,    10,   567,   865,   866,   867,    57,     3,  1485,  1425,
    2709,   132,  1202,  2712,    27,  1943,  1944,   153,  2037,  1247,
      20,  1597,   121,  1257,  1258,   112,    92,  1217,  1262,    15,
      16,    59,  2731,   112,   108,   153,   110,   144,  2737,    18,
     875,   876,   877,    48,    68,  1235,  1236,  1237,  1282,    34,
    1284,    86,   887,  1942,    54,    55,  1246,   153,   679,  1948,
     225,    48,  1951,    15,    16,  1954,    76,    57,  2938,   173,
      15,    16,    54,    55,  2773,   108,  1965,  1966,   246,  1152,
      18,    15,    16,   108,   615,  1974,   639,  2033,  1316,    15,
      16,  1319,  1320,  1321,  1322,   578,  1324,  1325,  1326,  1327,
    1328,  1329,  1330,  1331,  1332,   710,   711,   712,   201,    60,
     257,   142,   108,    57,   175,   166,    15,    16,   171,    34,
     340,    62,   142,    15,    16,    20,    32,    15,    16,   210,
     142,   126,   219,    20,  1595,    15,    16,    32,   165,   128,
     217,    15,    16,    74,   127,    32,   317,   230,   225,   334,
      45,   171,    20,  3476,   108,   110,   168,   160,    45,    54,
      55,    15,    16,   142,    32,   403,   337,    54,    55,   210,
      32,    62,  1182,   110,  2945,    15,    16,    45,   353,    15,
      16,    15,    16,   210,  2887,    58,    54,    55,   477,   433,
      93,  3388,   109,    55,   230,   247,   485,   486,    19,   281,
     247,    51,    12,   495,   142,   485,   171,   243,   247,   247,
     171,   388,  2253,   247,   199,   455,    15,    16,    15,    16,
     503,   213,   166,   171,    15,    16,  3096,   516,   389,  2259,
     476,   435,    94,   532,   237,    97,   372,  1917,    63,   535,
     171,   494,  1903,   105,    15,    16,   453,   546,   352,   536,
      15,    16,  2669,   493,   372,    94,  1266,   222,    97,    43,
    1270,    15,    16,   200,   517,   509,   562,  1052,   475,    11,
    2969,   398,   171,   350,   451,    37,   372,   225,   561,  2978,
     886,   408,   562,   487,   199,   412,   247,  3025,  1554,   371,
     417,    65,   113,  1559,  2335,   422,   585,   171,   345,  1565,
     544,   476,  1568,   213,   142,   366,   345,   224,   455,   264,
     213,   345,   122,   364,   395,  1018,   562,   444,   417,   402,
      63,   146,   232,  1026,  3521,   328,   264,   264,   344,   567,
     434,   347,   314,   264,   461,  2300,   497,  1208,  3034,  1042,
    1043,  3664,  1070,  2368,   471,  2323,   517,   567,  1064,  1070,
     477,    15,    16,   435,   395,   228,   483,   366,   485,   486,
     349,   371,   455,   490,   491,   533,  2331,   109,  2357,  1603,
     406,   353,   471,   408,   501,   281,   330,   562,   505,   515,
     345,  2042,  2371,   510,   511,  3088,   513,   514,   515,   516,
     416,  1465,   344,   682,   384,   347,   401,   562,  1019,   344,
    1990,  1129,   347,    15,    16,  1276,  1539,   435,  1129,  1870,
     344,   472,   196,   347,   401,   427,    15,    16,   344,   515,
     364,   347,   549,   530,   511,   546,   562,  2355,  2447,   380,
    3126,   426,   511,  1910,   965,   727,  1001,   420,   565,   513,
     514,   450,   380,  2033,   562,   344,   573,   574,   347,   155,
    1684,   578,   344,   504,  1688,   347,   344,   319,   585,   347,
    1876,   525,   485,   529,   344,  2041,   565,   347,  2357,   952,
     344,  3341,   485,   347,   498,   574,  1573,  1859,   328,   488,
    1859,   533,  2371,  1318,   561,  1038,  1006,  1721,   615,   516,
     344,   476,   975,   347,   533,   533,  1784,   517,  1786,   533,
      15,    16,   502,   535,   344,  2891,   485,   347,   344,   562,
     344,   347,     8,   347,   455,  3286,   568,  1082,   560,  1773,
     529,   346,  1074,  1358,   540,    15,    16,   568,   567,   568,
     568,    15,    16,   567,   568,   568,   568,   568,  1920,    15,
      16,  1920,   562,   568,   671,   344,   123,   344,   347,   565,
     347,  1779,   679,   344,   540,   682,   347,   562,   685,   686,
     504,   476,  1752,  3259,   455,  1793,  1794,    15,    16,   472,
    2600,   433,   568,   344,    15,    16,   347,   560,  2039,   344,
    3318,   564,   347,   517,   566,    15,    16,   686,   540,   427,
     463,    15,    16,  1975,   368,   540,  1975,    15,    16,   537,
    1083,  1132,   729,   346,   731,   347,   540,   502,  3307,   366,
    3309,  2272,  2273,   565,   540,   502,   561,   562,   264,   481,
      15,    16,   911,    58,   330,   283,   388,  3323,   562,  2594,
     729,   415,   731,   528,   502,   561,   562,   524,   525,   478,
     402,   540,   481,  3029,  2324,  2325,   171,   509,   540,   247,
     560,  2597,   540,  3391,    15,    16,  1666,   558,  1924,  2646,
     540,   423,   561,  2650,   160,   560,   540,  2632,  2646,   561,
     562,   175,  2650,   561,   562,   964,  3375,  2666,  3377,   337,
     344,   561,   562,   347,  2942,   974,   540,  1953,   562,  1955,
      12,  2944,  2608,   450,  1960,   455,   470,   318,    15,    16,
     540,  2072,  2073,    12,   540,  1311,   540,   561,   562,   476,
    1976,  3407,  1978,  1979,  1980,   489,    15,    16,    12,    53,
     454,   561,   562,   532,   458,  1735,   562,   561,   562,   306,
     281,   488,   344,  2986,   380,   347,   318,   546,   187,  2960,
     342,   540,  2963,   540,  1365,   344,  3449,   345,   347,   540,
     547,    15,    16,   880,   655,   882,  1490,  1460,   168,   105,
     397,  1464,   561,   562,  1467,  1468,   526,  1298,   294,   540,
     561,   562,   529,    48,  1490,   540,   435,  2666,   905,    15,
      16,   420,  1897,  1898,   911,   491,  1407,  1408,   263,  2450,
     561,   562,   420,   228,  2315,   135,   561,   562,   323,   566,
     122,   507,    12,   252,    91,   145,   905,    15,    16,   104,
    2237,  2238,  2239,   122,   336,  2761,  2765,    15,    16,   153,
    2218,   948,   156,   950,   525,   952,  1357,   528,   122,   344,
    1904,   353,   347,  2931,   168,  2964,   472,   964,   965,  1370,
    1405,  2268,  2269,  2270,    11,  1573,   256,   974,   975,  1922,
    1415,   470,  1573,   472,   344,   476,  1989,   347,   985,   210,
     344,     0,   366,   347,    15,    16,  3283,   162,   344,  3127,
    3128,   347,  2254,  2063,  1439,  2254,   540,   223,  2068,   500,
    1007,  1008,  1009,  1010,  1436,  2124,  3624,  3208,   175,   324,
    1017,   537,  1019,  2083,   476,  2123,   344,   561,  1025,   347,
    2090,    49,   560,   344,   168,   503,   347,     3,  1035,    57,
    1009,  1010,   122,   264,   344,  2105,  2106,   347,   500,   394,
     344,   560,  2112,   347,    91,   562,   344,    12,   540,   347,
    2120,  1496,   560,  1007,  1008,   547,  1035,    15,    16,   560,
     225,   540,  3163,  1017,  2374,  2923,  2924,  3364,   474,   344,
    2915,  1025,   347,  1080,   476,   109,  1083,  1792,  2212,   293,
     362,   246,   561,   562,    15,    16,   261,  2221,   472,  2159,
     142,  2044,   252,   499,    15,    16,   425,   554,   555,   556,
     557,  1080,   517,   344,    15,    16,   347,   476,   269,   270,
    1555,  1556,   472,  1558,  2655,  1560,  1561,  1562,  1563,  1564,
    3098,  1566,  1567,   343,   318,  1132,  3392,  1134,   175,  1136,
    1137,  1138,  1139,  1140,    15,    16,   318,   452,    15,    16,
     420,   372,  1149,  2591,  1151,   540,   561,   344,   463,   109,
     347,  3160,   420,    15,    16,   381,   331,   122,   372,  2229,
    1139,    15,    16,   210,   567,   344,   561,   562,   347,   329,
     540,    38,  3438,   328,    15,    16,   540,   420,  1185,   534,
     485,    66,  1136,  1137,   540,     8,  2076,  2657,  2658,  2659,
     224,   561,   562,   562,  2084,    15,    16,   561,   562,   366,
     344,    15,    16,   347,    27,  3031,   562,  3308,   213,  3310,
      15,    16,   540,  2661,    15,    16,  2686,   420,  1225,   540,
     385,    15,    16,   538,   252,   386,   387,   232,   344,    16,
     540,   347,   420,   561,   562,   461,   540,   328,    15,    16,
     561,   562,   540,  3470,  3471,  3112,   401,    15,    16,    15,
      16,   561,   562,   120,   217,   475,   344,   561,   562,   347,
     532,   560,   225,   561,   562,   540,   344,  1968,   567,   347,
      53,   426,   104,   472,   546,   283,  1283,   209,    15,    16,
     560,   166,   476,    15,    16,  1986,   561,   562,    15,    16,
    2568,  1298,   560,   560,   476,  1750,   104,  2604,   389,   540,
     567,    15,    16,    15,    16,   472,   500,   420,    15,    16,
    2478,  2479,   213,   344,    15,    16,   347,   560,   500,   366,
     561,   562,   497,    20,    15,    16,    15,    16,   213,   337,
     162,    28,    15,    16,   522,   523,    33,  3564,  3565,  2601,
      15,    16,  2601,   540,    15,    16,    75,   232,   562,   473,
    1357,    15,    16,     3,   162,  1362,  1363,   560,  1365,   209,
      89,   540,   529,  1370,   561,   562,   560,   199,    18,  1376,
     153,  1378,   560,   156,    15,    16,  1383,  1384,   560,  1386,
      15,    16,   561,   562,   549,   168,   344,   350,  3357,   347,
    3359,  1398,  2654,   340,  1401,  2654,   540,   222,    15,    16,
    1407,  1408,  1409,  1410,  1383,  1384,   171,  1386,    15,    16,
    1417,  1418,  1419,   344,   420,   410,   347,   561,  2680,  1398,
     426,  2680,  1401,   344,   540,   472,   347,   535,  1435,   261,
    1409,  1410,  1877,   344,   264,    85,   347,  1444,  1417,  1418,
    1419,   439,   440,   380,   442,   561,   562,   560,   567,    15,
      16,   564,   540,   261,  1461,   261,   393,    15,    16,  1466,
      70,    71,   540,   344,  2499,  3261,   347,   344,    15,    16,
     347,  1478,   187,  1884,   562,  1886,  1887,  1484,   473,   364,
     171,   561,   344,   561,   562,   347,   423,  1466,    15,    16,
     344,  2561,   142,   347,   142,    15,    16,   450,   108,   331,
    2215,   937,   560,   344,   940,  1484,   347,   943,    11,   540,
     293,  1956,  1957,    15,    16,   165,   522,   523,   168,   514,
     130,  1932,  1933,   331,   344,   331,  1958,   347,   325,   326,
     344,   562,  1977,   347,   529,   395,  1543,   252,   149,   344,
       3,   191,   347,   344,  1551,   337,   347,   197,   354,   517,
     344,   161,   365,   347,   560,    18,   342,  1968,  3403,   410,
     210,    15,    16,  3419,   470,   215,   472,   344,    15,    16,
     347,  1578,   222,   561,   562,  1986,   344,   470,   344,   347,
     230,   347,   540,  1590,    54,    55,  1593,   337,  3493,   372,
     562,  3314,   210,   243,    54,    55,    46,   247,  2698,  2767,
     171,  2701,  2702,    63,   562,   257,   256,   344,   514,   540,
     347,  1590,   344,   561,   562,   347,    46,   344,  2718,   540,
     347,   562,    85,   338,  2886,   561,   562,  2886,   337,   540,
     344,   562,   344,   347,   416,   347,   554,   344,   561,   562,
     347,   562,   503,   344,   257,  1506,   347,  2058,  1509,    15,
      16,   562,   147,   344,  2065,   344,   347,  1518,   347,   540,
     493,   344,   426,   540,   347,   497,  1527,   317,   560,   344,
    2838,   247,   347,   344,   561,   562,   347,   168,   540,   142,
     344,   562,  2266,   347,   455,   562,   540,   337,   455,   497,
     281,   497,   397,  2307,   399,   345,   401,   455,   403,   540,
     562,    15,    16,   344,    18,   168,   347,   470,   562,   344,
     425,  2307,   347,   257,    15,    16,   366,   139,    15,    16,
     540,   562,   188,    15,    16,    77,   540,   344,   191,   468,
     347,  2314,    15,    16,   197,   540,   562,   344,   339,   540,
     347,   108,   562,  2228,   450,   451,   540,   453,   562,   455,
    2251,  1758,   215,   419,   561,   562,   406,   562,   561,   222,
     529,   562,    51,   540,    91,   561,   562,   230,   562,   389,
    2765,   149,   540,   383,   540,   560,   426,   123,   344,   547,
     243,   347,    15,    16,   247,   562,   344,    15,    16,   347,
     566,    15,    16,   256,  2205,   561,  2297,   344,  2868,   207,
     347,    15,    16,   540,   561,   562,    15,    16,   540,   562,
     460,     3,   517,   540,     6,   561,   562,   344,   284,   285,
     347,    13,   288,   289,   344,   562,   540,   347,   540,   529,
     562,    23,    24,   540,   175,   562,  2281,    15,    16,   540,
     561,   562,   344,    15,    16,   347,   175,   174,   562,   540,
     562,   540,  1859,   503,   317,   562,   567,   540,   561,   562,
      52,   562,   123,   562,    56,   540,   516,   517,   560,   540,
    1877,  1878,   560,   562,   337,    67,   540,  1884,   561,  1886,
    1887,   560,   345,   533,    76,   535,   213,   562,   560,    81,
     344,   562,   560,   347,   561,   562,   566,   344,   562,   540,
     347,    93,   560,   366,    85,   540,   561,   562,   562,  2624,
     567,   561,   562,  1920,   561,   562,   108,   560,   568,   111,
     560,   562,   560,   540,  2369,  1932,  1933,   562,   120,   121,
     560,  2376,   560,   540,   126,  1942,   561,   562,    15,    16,
     567,  1948,   134,   406,  1951,   562,   560,  1954,   140,   561,
     562,   560,    15,    16,   560,   562,   560,  2368,  1965,  1966,
     306,  1968,   560,   426,   560,  2918,   560,  1974,  1975,    15,
      16,    15,    16,   165,   540,   561,   562,  1984,   344,  1986,
     560,   347,   540,  1990,  1991,    15,    16,   561,   562,    15,
      16,    15,    16,   540,   561,   562,   562,   460,    15,    16,
      15,    16,  2658,  2659,   562,  1984,  1267,  1268,   560,    15,
      16,    15,    16,   540,   560,   562,    15,    16,   560,   211,
     540,   213,  3133,  3134,   560,  2032,  2033,   560,   220,   560,
     344,    15,    16,   347,   215,   562,  2610,  2611,   540,   560,
     503,   560,   562,   344,   560,   306,   347,   344,   560,   230,
     347,  2058,   344,  2032,   517,   347,  2580,  2581,  2065,   560,
     562,   344,   243,   560,   347,    15,    16,    15,    16,   476,
     533,  2078,   535,  2876,  2877,  3337,   560,    15,    16,   560,
     142,   143,   560,   429,   430,   560,   540,   560,   560,    15,
      16,    15,    16,   540,   286,   560,    15,    16,   561,   562,
    3246,  3247,  3248,  3249,   560,   568,    46,   561,   300,  3223,
     562,   344,   439,   305,   347,   562,   344,  2124,   180,   347,
     344,    15,    16,   347,   560,    15,    16,    15,    16,   560,
     344,   560,   194,   347,   560,   344,   317,   560,   347,    15,
      16,   560,   560,   560,   560,   472,   473,    15,    16,    15,
      16,    15,    16,   345,   560,   560,    15,    16,   560,   351,
     560,   353,   560,   560,   226,   560,   344,  3237,   560,   347,
     560,   560,   344,   560,   540,   347,   238,   504,   560,    15,
      16,   560,   374,   375,   560,   377,  3448,   514,   560,    15,
      16,   560,   560,   535,   470,   561,   560,   560,  2205,   391,
     560,   560,  2613,   265,   550,   551,   552,   553,   554,   555,
     556,   557,   560,    15,    16,   560,   560,   560,  2629,    15,
      16,   413,   560,  2230,   560,   406,   540,  2234,   560,  2236,
    2237,  2238,  2239,   281,   560,    15,    16,   560,   560,   540,
    2247,   560,   560,   540,  2251,   560,   562,  2254,   540,    15,
      16,    15,    16,    15,    16,    15,    16,   540,   560,   321,
     561,  2268,  2269,  2270,   561,  2750,   560,   344,  2247,   561,
     347,    15,    16,   560,  2281,    15,    16,   252,   561,   460,
    2287,   344,  2289,   171,   347,   560,    15,    16,    15,    16,
    2297,   552,   553,   554,   555,   556,   557,   560,   344,   281,
     344,   347,   494,   347,    15,    16,   560,   540,   560,   560,
    2755,   503,   540,   560,   344,   560,   540,   347,   344,   560,
     344,   347,   560,   347,    15,    16,   540,   344,   561,   344,
     347,   540,   347,   561,   560,   560,   485,   561,   344,   560,
     344,   347,   560,   347,   560,   344,   485,   561,   347,   560,
    2357,  3613,   561,   560,  3613,    15,    16,    15,    16,   560,
     344,  2368,   540,   347,  2371,   560,   560,   560,   540,   560,
     562,   104,  3634,   560,    15,    16,   568,   560,   560,  3130,
    3131,  3132,  3047,   561,    15,    16,   560,  2872,  3650,   561,
     560,  3650,    15,    16,   344,   560,   344,   347,  2405,   347,
      15,    16,   560,  3549,   225,  2412,   344,   562,  2415,   347,
     562,   562,  2419,  2420,   562,   562,  2423,   562,   344,   476,
     344,   347,   554,   347,  2431,   344,    15,    16,   347,   162,
     168,  3173,  2439,   562,    15,    16,  2415,   510,    15,    16,
      15,    16,   437,   355,   171,   562,   560,   562,   561,   142,
     344,   562,   142,   347,   344,   142,   344,   347,   142,   347,
    2439,  2461,   142,   540,   142,  2465,   199,   142,   344,   142,
     142,   347,  2917,    15,    16,   142,   344,   540,   344,   347,
     344,   347,   561,   347,   561,   344,    15,    16,   347,  3154,
    2901,    15,    16,   142,   540,   142,   540,   142,   561,   142,
     142,   512,  3167,    44,   175,   337,    15,    16,   344,   171,
     540,   347,    63,    12,   540,   561,   540,   561,   344,    15,
      16,   347,   561,   540,   476,   540,    15,    16,   261,  2961,
     561,   561,    15,    16,   540,   561,   540,   561,   122,     9,
    2985,   540,   344,   561,   561,   347,   561,   561,   344,    15,
      16,   347,   532,  2964,   561,   561,   540,   561,   567,    15,
      16,   246,   561,  3305,   344,   553,   560,   347,   380,  3014,
     562,   533,   155,  2984,   214,    15,    16,   561,   344,   188,
     344,   347,   344,   347,   344,   347,   567,   347,   561,   171,
     540,   435,   540,    67,  2601,  2602,   426,  2604,   331,   562,
     344,   562,   540,   347,   344,    79,  2613,   347,    15,    16,
     168,   561,  2619,   561,   540,   344,   540,   344,   347,     7,
     347,   540,  2629,   561,  3208,    44,    15,    16,  3073,   419,
    2637,    19,   450,   344,    22,   561,   347,   561,    66,   450,
     373,    29,   561,   376,  2958,  2959,   540,  2654,   485,   450,
     540,    39,   540,   344,   119,   450,   347,   450,   231,  2666,
     231,    49,  2976,   471,   540,   471,  2673,   561,  2982,   119,
      44,   561,   540,  2680,   540,   562,   540,    16,   560,  2686,
     561,   540,   517,   567,   344,   561,   344,   347,   562,   347,
    3101,  3005,  2692,   561,  3008,   561,   561,   561,   138,    87,
     561,   561,   561,   344,   540,    16,   347,   561,  3193,  3194,
     561,  3376,   561,   344,   540,   554,   347,   567,   561,   107,
     108,   344,   110,   561,   347,   561,  2726,  2727,   171,   344,
     561,    12,   347,   121,  2734,   561,   125,   562,   540,   561,
     560,  2741,   325,   326,   540,  3410,  3411,   330,  3413,  3160,
     427,   561,  1384,   562,  1386,   344,  2763,   561,   347,   561,
     540,   235,   561,   344,   497,   561,   347,   344,   562,   344,
     347,   562,   347,   561,   540,   561,   540,   561,   540,   104,
     540,   561,   561,   108,   123,  1417,  1418,  1419,   142,  3679,
    3455,   561,  3457,  3458,   102,   561,   540,   561,   561,   561,
     540,   561,   344,   561,   561,   347,   160,   561,   561,   560,
     560,   540,   123,   540,   557,   344,   561,   561,   347,   560,
     344,   561,    57,   347,   256,   567,   180,   562,   567,   540,
     304,    66,   561,    23,  3319,   344,   537,   162,   347,   485,
     194,   122,   476,    78,   252,   560,   485,   485,   344,   540,
     561,   347,   485,   171,   328,   344,  2863,   342,   347,   171,
    3315,   344,   170,   222,   347,   171,    91,   171,   567,   227,
     561,   567,   535,    63,   199,    28,   562,    67,   344,  2886,
     540,   347,   540,   237,   238,   230,   230,   348,   344,    93,
     296,   347,    93,   567,  2901,   232,   232,   205,   476,   540,
      85,   561,  3388,   561,   344,   379,   560,   347,   491,   540,
     560,   265,   104,   403,   345,   331,    69,   540,   108,   200,
     561,     4,   554,   560,   507,   540,     9,    10,   221,   331,
     561,   166,   561,   561,   561,  2942,   261,   344,   561,   174,
     347,   561,   561,   138,    27,   331,   561,   561,   554,    32,
     175,   540,   560,    36,   567,   344,   567,  2964,   347,   540,
     567,   561,   561,   540,   561,   540,   337,   306,   210,   323,
     162,   562,   561,   561,   567,   123,   450,  2984,   213,   511,
     561,   225,   171,    34,   561,   138,   561,   295,   213,   244,
      63,   299,   269,   230,   230,   306,   337,   232,   540,   307,
     562,    85,  3009,   232,  3011,   232,   331,   199,   562,   363,
     398,   540,    18,   337,   496,  3022,   540,  3024,  3450,   561,
     408,    18,   561,    18,   412,   560,   247,   560,   562,   417,
     215,   540,   561,   116,   422,  3521,   223,   561,   560,  3524,
     223,   561,   232,  3022,   540,   230,    97,   561,   561,   561,
     561,   540,   561,   104,   561,   561,   444,   540,   243,   567,
     561,   561,   370,   561,   561,   561,  3073,   561,   561,   261,
     561,   129,   561,   461,   540,   562,   562,   225,   561,   567,
     561,   561,  3493,   471,   540,  3570,   561,    67,   420,   477,
     429,   430,   241,   562,  3101,   483,   191,   485,   486,    79,
     540,   428,   490,   491,   155,   561,   560,    85,   560,   142,
     418,   162,   561,   501,  3121,   348,   230,   505,   429,   430,
    3127,  3128,   510,   511,   230,   513,   514,   515,   516,   364,
     560,   215,   317,   540,  3141,   325,   326,   362,   118,   331,
     330,   366,   562,   108,   108,   560,   230,   337,   199,   561,
     560,   540,   337,  3160,   561,   361,   560,   560,   306,   243,
     560,   549,    85,   444,   445,   446,   447,   448,   449,   560,
     567,  3657,   497,   496,   364,   562,   561,   565,   561,   460,
      98,    99,   100,   101,   102,   573,   574,   331,    34,   331,
     578,   561,  3199,   561,   561,  3681,   422,   585,   331,    40,
     371,   561,   331,  3210,   439,   561,   561,   535,   222,   362,
     261,   550,   551,   552,   553,   554,   555,   556,   557,  3630,
     562,   406,    44,   531,   567,   197,   561,   615,   562,   382,
     380,   303,   230,   317,   424,   543,   476,   215,   123,   550,
     551,   552,   553,   554,   555,   556,   557,   517,   473,   517,
     442,    97,   230,   337,   407,   235,   476,   560,   104,   168,
     560,   560,   331,   488,   331,   243,   560,   318,   123,   504,
      32,   528,   528,   560,   331,   460,   327,   511,   108,   330,
     331,   429,   430,   671,   202,   203,   204,   205,   232,   514,
     232,   679,   215,   330,   682,   331,  3443,   685,   686,   331,
     331,   454,   331,   331,   529,   497,   560,   230,   561,   155,
     562,   535,   561,   561,   504,   561,   162,   562,   303,   151,
     243,   404,   406,   561,   304,    23,    24,   232,    65,   561,
    3337,  3338,   562,   476,    16,   476,   419,   476,   561,   317,
     225,   729,   425,   731,   561,   325,   326,   517,   328,   517,
    3357,   123,  3359,   199,  3361,  3362,    54,    55,    56,  3338,
     230,   561,   445,   561,   561,    63,   327,  3374,   523,    67,
     561,   168,   331,  3520,   562,   561,   460,   295,    76,   297,
     298,   299,   561,   561,   403,   561,   331,   535,  3535,   307,
    3537,   342,   511,   472,   317,    93,  3543,   249,   270,   379,
     560,  3408,   550,   551,   552,   553,   554,   555,   556,   557,
     108,    57,   342,   111,   337,   261,    57,   366,    44,    44,
     560,   306,   560,   135,   561,   476,   561,   478,   406,   561,
     481,   561,  3579,    44,   142,     5,  3443,   384,   342,  3586,
     491,  3448,   140,   342,   561,   131,   497,   562,    44,   500,
      44,   306,   370,    44,   561,   118,   414,   562,    16,    28,
    3467,   532,   560,  3470,  3471,  3472,   569,   274,   171,  3616,
     450,   532,   318,    28,  3621,   117,   561,   142,   222,   138,
     568,   561,   460,   406,   330,   331,  3493,   562,   209,   532,
     138,   568,   880,  3640,   882,   263,   106,  3504,   548,   417,
     418,   552,   553,   569,   210,   568,  3513,  3514,   331,   562,
     138,   560,   547,  3520,   195,   213,   562,   905,   249,   426,
    3667,  3668,   220,   911,  3671,   548,   568,   394,  3535,   168,
    3537,   168,   168,   534,   306,   547,  3543,   460,   169,   523,
     108,  1806,  1569,   677,   429,   430,  3489,  3021,  3555,  3024,
    3198,  3681,  3646,  3652,  3576,  3533,  3576,  3564,  3565,   201,
     948,  3565,   950,  3540,   952,  3572,  3541,  3030,  1129,  2759,
    1539,   392,  3579,  3125,   429,   430,   964,   965,  3585,  3586,
    2425,  2686,  2033,  1543,  1505,  1946,   974,   975,   286,  3596,
    1993,  2673,  2709,  2742,  2709,  3152,  3603,   985,  2947,  2993,
    2674,  2984,   300,  2629,  3363,   993,  3613,  3373,  3615,  3616,
    3144,  3291,  3619,   531,  3621,   257,  3623,  1144,  3210,  1007,
    1008,  1009,  1010,  3630,   542,   543,  3167,  3634,  1473,  1017,
     476,  1019,   478,  3640,  1989,   481,  1049,  1025,  1409,   281,
    1837,  1854,   686,  3650,  2247,   491,  3653,  1035,  3655,  1125,
    3657,   497,   670,   351,   500,   353,  1868,   429,   430,  3256,
    3667,  3668,   456,   603,  3671,   550,   551,   552,   553,   554,
     555,   556,   557,  2871,  3681,  1424,   374,   375,  2066,   377,
    3073,  2872,  1222,  2644,  3514,  2222,  3362,  2680,  1268,  3122,
    3101,  3570,  1080,  1172,  1873,  1083,   551,   552,   553,   554,
     555,   556,   557,   975,  1858,   952,   552,   553,  1833,  2886,
    2596,     3,  2595,  3448,  2654,   413,   446,  3634,   731,   506,
    1149,    13,    14,   365,   437,  3555,  3350,  1375,  2405,   371,
     980,  2586,    12,    13,    26,  3523,    28,  3544,  2986,  3417,
    3650,  1430,  2601,  2299,  1132,  1401,  1134,  2637,  1136,  1137,
    1138,  1139,  1140,  2912,    46,    47,  3109,   399,   429,   586,
      52,  1149,   993,  1151,    56,    57,  3596,   983,   945,  1134,
    2234,  3244,   430,  3603,  3250,   590,  1293,    69,  2199,  2552,
     552,   553,   554,   555,   556,   557,   496,   389,   389,  3619,
     473,  2031,    84,   435,  2756,  3027,   494,  1185,   495,   495,
     495,    -1,    -1,    -1,    84,   503,    -1,    -1,    -1,    -1,
      -1,   103,    -1,   455,    -1,    -1,    -1,    23,    24,    -1,
     112,   113,   114,  3653,    -1,  3655,    -1,    -1,   470,    -1,
     472,    -1,   112,   125,   126,    -1,    -1,  1225,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   126,    -1,    54,    55,
      56,    -1,    -1,    -1,    -1,    -1,   148,    63,    13,    -1,
      -1,    67,    -1,    -1,   562,    -1,    -1,    -1,   148,    -1,
      76,    -1,   164,    -1,    -1,    -1,    -1,    -1,    -1,   159,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    93,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1283,   188,    -1,    -1,    -1,
      -1,    -1,   108,   195,    -1,   111,   198,    -1,   188,    -1,
    1298,    -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   219,    -1,    84,
      -1,    -1,    -1,   213,   140,    -1,    -1,    -1,    -1,   219,
      -1,   233,    -1,   267,   268,   269,   270,   271,   272,    -1,
      -1,   275,   276,   277,   278,   279,   280,   112,   282,   251,
      -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,    -1,  1357,
      -1,   126,    -1,    -1,  1362,  1363,   256,  1365,    -1,    -1,
      -1,    -1,  1370,    -1,    -1,    -1,    -1,    -1,  1376,    -1,
    1378,    -1,    -1,   148,    -1,  1383,  1384,    -1,  1386,    -1,
      -1,    -1,    -1,    -1,   159,    -1,    -1,   213,    -1,    -1,
    1398,    -1,    -1,  1401,   220,    -1,    -1,   225,    -1,  1407,
    1408,  1409,  1410,    -1,    -1,    -1,    -1,    -1,    -1,  1417,
    1418,  1419,    -1,   188,    -1,    -1,    -1,    -1,   246,    -1,
     246,    -1,    -1,    -1,    -1,    -1,    -1,  1435,    -1,   341,
      12,    13,    -1,    -1,    -1,    -1,  1444,    -1,   213,    -1,
      -1,    -1,   386,   387,   219,    -1,    -1,    -1,    -1,    -1,
     362,    -1,    -1,  1461,    -1,    -1,    -1,   369,  1466,    -1,
     286,    -1,    -1,    -1,    -1,    -1,    -1,   367,    -1,    -1,
    1478,    -1,    -1,    -1,   300,    -1,  1484,   389,   306,   391,
     392,   256,    -1,   395,   384,    -1,   398,    -1,   400,    -1,
     390,    -1,    -1,   405,    -1,   407,   396,   325,   326,    -1,
      -1,    -1,    84,    -1,   416,    -1,    -1,    -1,   420,    -1,
      -1,    -1,    -1,    -1,   426,    -1,    -1,    -1,    -1,   431,
     420,    -1,    -1,   435,    -1,   351,    -1,   353,    -1,    -1,
     112,   431,   432,    -1,    -1,  1543,    -1,    -1,    -1,    -1,
      -1,    -1,   454,  1551,   126,    -1,   458,    -1,   374,   375,
      -1,   377,    -1,    -1,    -1,    -1,    -1,   385,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   148,   467,    -1,    -1,
    1578,    -1,    -1,    -1,    -1,    -1,    -1,   159,    -1,    -1,
     492,    -1,  1590,    -1,    -1,  1593,    -1,   413,    -1,    -1,
      -1,    -1,   367,    -1,    -1,    -1,   508,    -1,    -1,   511,
      -1,   429,   430,    -1,   516,    -1,   188,    -1,    -1,   384,
     438,   511,    -1,   513,    -1,   390,    -1,    -1,    -1,    13,
      14,   396,    -1,    -1,    -1,    -1,    -1,   539,    -1,    -1,
      -1,   213,    26,    -1,    -1,    -1,    -1,   219,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   420,    -1,    -1,   560,    -1,
      -1,    -1,    46,    47,    -1,    -1,   431,   432,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,  1495,    -1,   494,    -1,
      -1,    -1,    -1,    -1,   256,    69,    -1,   503,  1507,  1508,
      -1,  1510,  1511,  1512,    -1,    -1,  1515,    -1,    -1,    -1,
      84,  1520,   467,    -1,    -1,  1524,  1525,  1526,    -1,    -1,
    1529,  1530,  1531,  1532,  1533,    -1,  1535,  1536,  1537,   103,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   112,   113,
     114,   549,   550,   551,   552,   553,   554,   555,   556,   557,
      -1,   125,   126,    -1,   560,    -1,   511,    -1,   513,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1758,    -1,    -1,    -1,   148,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     164,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   367,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,
      -1,   195,   384,    -1,   198,    -1,    -1,    -1,   390,    -1,
      -1,    -1,    -1,    -1,   396,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   219,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   420,   233,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   431,
     432,  1859,    -1,    -1,    -1,    -1,    -1,   251,    -1,    -1,
      -1,    -1,   256,    -1,    -1,    -1,    -1,    -1,    -1,  1877,
    1878,    -1,    -1,    -1,    -1,    -1,  1884,    -1,  1886,  1887,
      -1,    -1,    -1,    -1,    -1,   467,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1920,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1932,  1933,    -1,    -1,    -1,   511,
      -1,   513,    -1,    -1,  1942,    -1,    -1,    -1,    -1,    -1,
    1948,    -1,    -1,  1951,    -1,    -1,  1954,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1965,  1966,    -1,
    1968,    -1,    -1,    -1,    -1,    -1,  1974,  1975,   362,    -1,
      -1,    -1,    -1,    -1,    -1,   369,  1984,    -1,  1986,    -1,
      -1,    -1,  1990,  1991,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   389,    -1,   391,   392,    -1,
      -1,   395,    -1,    -1,   398,    -1,   400,    -1,    -1,    -1,
      -1,   405,    -1,   407,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   416,    -1,  2032,  2033,   420,    -1,    -1,    -1,
      -1,    -1,   426,    -1,    -1,    -1,    -1,   431,    -1,    -1,
      -1,   435,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2058,    -1,    -1,    -1,    -1,    -1,    -1,  2065,    -1,    -1,
     454,    -1,    -1,    -1,   458,    -1,    -1,    -1,    -1,    -1,
    2078,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   508,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   492,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   508,    -1,  2124,   511,    -1,    -1,
      -1,    -1,   516,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1959,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     561,  1970,    -1,    -1,    -1,   539,    -1,    -1,    -1,    30,
      -1,    32,    33,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   560,    -1,    -1,    -1,
      -1,    -1,    -1,    54,    55,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    64,    -1,    66,    -1,    -1,    -1,    -1,
      31,    32,    -1,    -1,    -1,    -1,    37,  2205,    39,    40,
      41,    -1,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    55,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2230,    -1,    -1,    -1,  2234,    -1,  2236,  2237,
    2238,  2239,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2247,
      -1,    -1,    -1,  2251,    -1,    -1,  2254,    -1,    -1,    23,
      24,    -1,    -1,    94,    -1,    -1,    97,    -1,   139,   140,
    2268,  2269,  2270,   144,   105,    -1,    -1,    -1,   689,    -1,
      -1,    -1,    -1,  2281,    -1,    -1,    -1,    -1,    -1,  2287,
      -1,  2289,    56,   124,    -1,    -1,    -1,    -1,    -1,  2297,
      -1,    -1,   173,    67,   175,    -1,    -1,    -1,    -1,    -1,
     141,    -1,    76,    -1,    -1,    -1,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    93,
     161,    -1,   163,    -1,    -1,    23,    24,    -1,    -1,    -1,
      -1,   212,   213,    -1,   108,   216,    -1,   111,    -1,    -1,
      -1,   182,   183,    -1,    -1,    -1,    -1,    -1,    -1,  2357,
     231,    -1,    -1,    -1,    -1,    -1,    54,    55,    56,    -1,
    2368,    -1,    -1,  2371,    -1,    63,   140,    -1,    -1,    67,
      -1,   252,    -1,    -1,    -1,    -1,   257,   798,    76,    -1,
      -1,    -1,   223,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    -1,  2405,    -1,    -1,
     281,    -1,    -1,   824,  2412,    -1,    -1,  2415,    -1,   250,
     108,  2419,  2420,   111,    -1,  2423,    -1,    -1,   259,   260,
      -1,   262,    -1,  2431,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2439,   313,    -1,    -1,    -1,    -1,    -1,    -1,   213,
      -1,   322,   140,    -1,    -1,    -1,   220,    -1,    -1,   290,
     291,   292,    -1,   874,    -1,    -1,    -1,   878,    -1,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   310,
     311,   312,    -1,    -1,    -1,   316,    -1,    -1,   319,    -1,
      -1,    -1,    -1,    -1,   365,   366,    -1,    -1,    -1,    -1,
      -1,   332,   333,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   286,    -1,    -1,   213,   357,    -1,   359,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   300,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,    -1,    -1,    -1,   425,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   435,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   993,    -1,   455,    -1,    -1,   351,   459,   353,
      -1,  1002,    -1,   424,    -1,   426,    -1,    -1,   286,    -1,
      -1,   472,    -1,  2601,  2602,   436,  2604,    -1,    -1,    -1,
     374,   375,   300,   377,    -1,  2613,    -1,    -1,    -1,    -1,
      -1,  2619,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2629,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2637,
      -1,    -1,    -1,    -1,    -1,    -1,   477,   478,    -1,   413,
     481,   482,   483,   484,    -1,   526,  2654,    -1,    -1,   530,
      -1,    -1,    -1,   351,    -1,   353,    -1,    -1,  2666,    -1,
      -1,    -1,    -1,    -1,    -1,  2673,    -1,    -1,    -1,    -1,
      -1,    -1,  2680,    -1,    -1,    -1,   374,   375,  2686,   377,
      -1,    -1,    -1,   524,   525,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   543,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   413,    -1,    -1,    -1,    -1,
     494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   503,
      -1,    -1,  1153,  1154,  1155,    -1,    -1,    -1,    -1,    -1,
      -1,  1162,  1163,    -1,    -1,  1166,    -1,  1168,  1169,  1170,
    1171,    -1,    -1,    -1,  1175,  2763,    -1,  1178,  1179,    -1,
    1181,    -1,  1183,  1184,    -1,  1186,  1187,  1188,  1189,  1190,
      -1,  1192,    -1,  1194,  1195,  1196,    -1,  1198,  1199,  1200,
    1201,    -1,  1203,  1204,    -1,  1206,    -1,    -1,  1209,  1210,
    1211,    -1,  1213,  1214,  1215,  1216,   494,  1218,  1219,  1220,
    1221,    -1,    -1,    -1,    -1,   503,  1227,  1228,    -1,  1230,
    1231,  1232,  1233,  1234,    -1,    -1,    -1,    -1,  1239,    -1,
    1241,  1242,  1243,  1244,  1245,    -1,    -1,  1248,  1249,  1250,
    1251,  1252,  1253,    -1,  1255,  1256,    -1,    -1,  1259,  1260,
    1261,    -1,  1263,    -1,  1265,     6,    -1,    -1,  1269,    -1,
    1271,  1272,    13,    -1,    -1,  2863,  1277,    -1,    -1,    -1,
      -1,    -1,    23,    24,  1285,  1286,  1287,    -1,    -1,    -1,
      -1,    -1,  3443,  1294,    -1,    -1,  1297,    -1,  2886,    -1,
      -1,    -1,    -1,  1304,  1305,  1306,    -1,    -1,    -1,    -1,
      -1,    52,    -1,  2901,    -1,    56,    -1,    -1,    -1,  3470,
    3471,    -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    -1,  2942,    -1,    -1,    -1,  1359,    -1,
      -1,    -1,  3513,  3514,    -1,    -1,    -1,   108,    -1,  3520,
     111,    -1,    -1,    -1,    -1,    -1,  2964,    -1,    -1,   120,
      -1,    -1,    -1,    -1,  3535,   126,  3537,    -1,    -1,    -1,
      -1,    -1,  3543,   134,    -1,    -1,  2984,    -1,    -1,   140,
      -1,    -1,    -1,  1404,  3555,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3564,  3565,    -1,    -1,    -1,    -1,    -1,
      -1,  3009,    -1,  3011,   165,    -1,    -1,    -1,  3579,    -1,
      -1,    -1,    -1,    -1,  3022,  3586,  3024,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3596,    -1,    -1,    -1,    -1,
      -1,    -1,  3603,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3616,    -1,    -1,  3619,    -1,
    3621,    -1,   213,    -1,    -1,    -1,    -1,    -1,    -1,   220,
      -1,    -1,    -1,    -1,    -1,  3073,    -1,    -1,    -1,  3640,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3653,    -1,  3655,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3101,    -1,    -1,  3667,  3668,    -1,    -1,
    3671,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3121,    -1,    -1,    -1,    -1,    -1,  3127,
    3128,    -1,    -1,    -1,    -1,   286,    -1,    -1,    -1,    -1,
      -1,    -1,  1553,  3141,    -1,    -1,    -1,    -1,    -1,   300,
      -1,    -1,    -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3160,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   345,    -1,    -1,    -1,    -1,    -1,
     351,  3199,   353,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3210,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   374,   375,    -1,   377,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   413,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1730,
    1731,  1732,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1747,    -1,    -1,  3337,
    3338,    -1,    -1,   494,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   503,    -1,    -1,    -1,    -1,    -1,    -1,  3357,
      -1,  3359,  1773,  3361,  3362,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3374,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1795,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3448,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3467,
      -1,    -1,    -1,    -1,  3472,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3493,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3504,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3572,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3585,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3613,    -1,  3615,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3623,    -1,    -1,    -1,    -1,
      -1,    -1,  3630,    -1,  2045,    -1,  3634,  2048,    -1,    -1,
    2051,  2052,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3650,  2064,    -1,    -1,  2067,    -1,    -1,  3657,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2080,
      -1,  2082,    -1,    -1,    -1,  2086,    -1,  2088,  2089,    -1,
      -1,    -1,  2093,  3681,  2095,  2096,    -1,  2098,    -1,    -1,
    2101,    -1,  2103,  2104,    -1,    -1,    -1,    -1,  2109,  2110,
      -1,    -1,  2113,    -1,  2115,    -1,  2117,    -1,  2119,    -1,
    2121,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2132,  2133,    -1,    -1,  2136,    -1,  2138,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2146,  2147,    -1,  2149,    -1,
    2151,    -1,    -1,  2154,  2155,  2156,    -1,  2158,    -1,    -1,
      -1,    -1,  2163,  2164,  2165,  2166,    -1,    -1,    -1,    -1,
    2171,  2172,  2173,    -1,  2175,    -1,  2177,    -1,  2179,    -1,
    2181,    -1,  2183,    -1,    -1,    -1,    -1,    -1,    -1,  2190,
      -1,  2192,    -1,    -1,  2195,  2196,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2206,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2221,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2241,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2290,
      -1,    -1,    -1,    -1,  2295,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2338,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2454,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2527,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2537,    -1,  2539,    -1,
    2541,    -1,    -1,    -1,    -1,    -1,  2547,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2570,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2638,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2786,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2796,    -1,    -1,    -1,    -1,
      -1,  2802,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2811,  2812,    -1,    -1,    -1,    -1,  2817,    -1,    -1,    -1,
    2821,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2834,    -1,    -1,    -1,    -1,    -1,  2840,
      -1,    -1,  2843,  2844,    -1,  2846,  2847,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2860,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2927,  2928,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2938,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3096,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3219,    -1,
      -1,    -1,    -1,    -1,  3225,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3260,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3270,
      -1,  3272,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3397,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3420,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3509,  3510,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3529,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3538,    -1,    -1,
      -1,    -1,    -1,    -1,  3545,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3554,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3583,    -1,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,  3597,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    42,    43,    -1,    45,    46,    -1,
      -1,    49,    50,    51,    -1,    53,    54,    55,    56,    -1,
      58,    59,    60,    61,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    72,    73,    74,  3658,    76,    77,
      -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,
     108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,   133,   134,    -1,   136,   137,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,    -1,   151,   152,   153,   154,   155,   156,    -1,
     158,   159,   160,   161,   162,    -1,   164,    -1,    -1,   167,
      -1,   169,   170,    -1,   172,   173,    -1,   175,   176,   177,
     178,   179,    -1,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
     198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,
      -1,   239,   240,   241,    -1,   243,   244,    -1,    -1,    -1,
     248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,
     258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,    -1,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,    -1,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,   394,   395,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,    -1,   461,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,   486,   487,
      -1,   489,   490,   491,   492,   493,   494,   495,    -1,   497,
     498,   499,   500,    -1,   502,    -1,    -1,   505,   506,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
     518,   519,   520,   521,   522,   523,    -1,    -1,   526,   527,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,
     548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,
     558,    -1,   560,    -1,    -1,   563,   564,    -1,   566,   567,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    50,    51,    -1,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    79,    -1,    81,    82,    83,    -1,
      -1,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
      -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,    -1,   158,   159,   160,   161,   162,    -1,   164,
      -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,
     175,   176,   177,   178,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,    -1,    -1,   240,   241,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,
     255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,    -1,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,    -1,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
      -1,   336,   337,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,   490,   491,   492,   493,   494,
     495,    -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,
     505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,   518,   519,   520,   521,   522,   523,    -1,
      -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,
      -1,   566,   567,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,    51,
      -1,    53,    54,    55,    56,    -1,    58,    59,    60,    61,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      72,    73,    74,    -1,    76,    77,    -1,    79,    -1,    81,
      82,    83,    -1,    -1,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,
     102,   103,   104,    -1,    -1,   107,   108,   109,    -1,   111,
      -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,   133,   134,    -1,   136,   137,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,   151,
     152,   153,   154,   155,   156,    -1,   158,   159,   160,   161,
     162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,
     172,   173,    -1,   175,   176,   177,   178,   179,    -1,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,    -1,
     192,   193,    -1,   195,   196,    -1,   198,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,
      -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,
     252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,
      -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,   301,
     302,   303,    -1,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,    -1,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,   394,   395,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,    -1,   418,   419,   420,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,    -1,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,
     492,   493,   494,   495,    -1,   497,   498,   499,   500,    -1,
     502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,   518,   519,   520,   521,
     522,   523,    -1,    -1,   526,   527,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,
      -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,
      -1,   563,   564,    -1,   566,   567,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    50,    51,    -1,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    72,    73,    74,    -1,    76,    77,    -1,
      79,    -1,    81,    82,    83,    -1,    -1,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,
     109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,   133,   134,    -1,   136,   137,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,    -1,   151,   152,   153,   154,   155,   156,    -1,   158,
     159,   160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,
     169,   170,    -1,   172,   173,    -1,   175,   176,   177,   178,
     179,    -1,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,
      -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,
      -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,   258,
      -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,    -1,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,    -1,   461,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,   490,   491,   492,   493,   494,   495,    -1,   497,   498,
     499,   500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,
     519,   520,   521,   522,   523,    -1,    -1,   526,   527,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,
      -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,   563,   564,    -1,   566,   567,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    50,    51,    -1,    53,    54,    55,
      56,    -1,    58,    59,    60,    61,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    72,    73,    74,    -1,
      76,    77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,
      -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,
     136,   137,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,    -1,   151,   152,   153,   154,   155,
     156,    -1,   158,   159,   160,   161,   162,    -1,   164,    -1,
      -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,   175,
     176,   177,   178,   179,    -1,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
     236,   237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,
      -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,
      -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,    -1,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,    -1,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,   394,   395,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,    -1,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,   490,   491,   492,   493,   494,   495,
      -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,   505,
     506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,   518,   519,   520,   521,   522,   523,    -1,    -1,
     526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,
      -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,   561,    -1,   563,   564,    -1,
     566,   567,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    -1,    76,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,
     563,   564,    -1,   566,   567,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      50,    51,    -1,    53,    54,    55,    56,    -1,    58,    59,
      60,    61,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    72,    73,    74,    -1,    76,    77,    -1,    79,
      -1,    81,    82,    83,    -1,    -1,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    -1,
      -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,   109,
      -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,   133,   134,    -1,   136,   137,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
      -1,   151,   152,   153,   154,   155,   156,    -1,   158,   159,
     160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,
     170,    -1,   172,   173,    -1,   175,   176,   177,   178,   179,
      -1,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,
     220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,
     240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,
     250,    -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,
      -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,    -1,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,    -1,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,   394,   395,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
      -1,   461,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
     490,   491,   492,   493,   494,   495,    -1,   497,   498,   499,
     500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,
     520,   521,   522,   523,    -1,    -1,   526,   527,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,
      -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,
     560,   561,    -1,   563,   564,    -1,   566,   567,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    50,    51,    -1,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,
     107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,    -1,   151,   152,   153,   154,   155,   156,
      -1,   158,   159,   160,   161,   162,    -1,   164,    -1,    -1,
     167,    -1,   169,   170,   171,   172,   173,    -1,   175,   176,
     177,   178,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,
      -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,
     257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,    -1,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,    -1,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,    -1,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,   490,   491,   492,   493,   494,   495,    -1,
     497,   498,   499,   500,    -1,   502,    -1,    -1,   505,   506,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,   518,   519,   520,   521,   522,   523,    -1,    -1,   526,
     527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,
      -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,   566,
     567,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,    53,
      54,    55,    56,    -1,    58,    59,    60,    61,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    79,    -1,    81,    82,    83,
      -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,
     104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,
      -1,   115,   116,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,
     134,    -1,   136,   137,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,    -1,   151,   152,   153,
     154,   155,   156,    -1,   158,   159,   160,   161,   162,    -1,
     164,    -1,    -1,   167,    -1,   169,   170,   171,   172,   173,
      -1,   175,   176,   177,   178,   179,    -1,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,   243,
     244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,
      -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,
      -1,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,    -1,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
     394,   395,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,    -1,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,   493,
     494,   495,    -1,   497,   498,   499,   500,    -1,   502,    -1,
      -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,   518,   519,   520,   521,   522,   523,
      -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,
      -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,
     564,    -1,   566,   567,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,
      51,    -1,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    79,    -1,
      81,    82,    83,    -1,    -1,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,   107,   108,   109,    -1,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,
     151,   152,   153,   154,   155,   156,    -1,   158,   159,   160,
     161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,
     171,   172,   173,    -1,   175,   176,   177,   178,   179,    -1,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,
     241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,
      -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,
     261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,    -1,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
      -1,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,    -1,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,
     491,   492,   493,   494,   495,    -1,   497,   498,   499,   500,
      -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,   520,
     521,   522,   523,    -1,    -1,   526,   527,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
     541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,
      -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
      -1,    -1,   563,   564,    -1,   566,   567,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    50,    51,    -1,    53,    54,    55,    56,    -1,
      58,    59,    60,    61,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    72,    73,    74,    -1,    76,    77,
      -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,
     108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,   133,   134,    -1,   136,   137,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,    -1,   151,   152,   153,   154,   155,   156,    -1,
     158,   159,   160,   161,   162,    -1,   164,    -1,    -1,   167,
      -1,   169,   170,    -1,   172,   173,    -1,   175,   176,   177,
     178,   179,    -1,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
     198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,
      -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,
     248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,
     258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,    -1,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,    -1,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,   394,   395,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,    -1,   461,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,   490,   491,   492,   493,   494,   495,    -1,   497,
     498,   499,   500,    -1,   502,    -1,    -1,   505,   506,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
     518,   519,   520,   521,   522,   523,    -1,    -1,   526,   527,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,
     548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,
     558,    -1,   560,    -1,    -1,   563,   564,    -1,   566,   567,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    50,    51,    -1,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    79,    -1,    81,    82,    83,    -1,
      -1,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
      -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,    -1,   158,   159,   160,   161,   162,    -1,   164,
      -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,
     175,   176,   177,   178,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,    -1,    -1,   240,   241,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,
     255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,    -1,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,    -1,   322,   323,   324,
     325,    -1,   327,   328,    -1,   330,   331,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,   490,   491,   492,   493,   494,
     495,    -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,
     505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,   518,   519,   520,   521,   522,   523,    -1,
      -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,
      -1,   566,   567,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,    51,
      -1,    53,    54,    55,    56,    -1,    58,    59,    60,    61,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      72,    73,    74,    -1,    76,    77,    -1,    79,    -1,    81,
      82,    83,    -1,    -1,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,
     102,   103,   104,    -1,    -1,   107,   108,   109,    -1,   111,
      -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,   133,   134,    -1,   136,   137,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,   151,
     152,   153,   154,   155,   156,    -1,   158,   159,   160,   161,
     162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,
     172,   173,    -1,   175,   176,   177,   178,   179,    -1,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,    -1,
     192,   193,    -1,   195,   196,    -1,   198,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,
      -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,
     252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,
      -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,   301,
     302,   303,    -1,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,    -1,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,   394,   395,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,    -1,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,
     492,   493,   494,   495,    -1,   497,   498,   499,   500,    -1,
     502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,   518,   519,   520,   521,
     522,   523,    -1,    -1,   526,   527,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,
      -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,
      -1,   563,   564,    -1,   566,   567,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    50,    51,    -1,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    72,    73,    74,    -1,    76,    77,    -1,
      79,    -1,    81,    82,    83,    -1,    -1,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,
     109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,   133,   134,    -1,   136,   137,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,    -1,   151,   152,   153,   154,   155,   156,    -1,   158,
     159,   160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,
     169,   170,    -1,   172,   173,    -1,   175,   176,   177,   178,
     179,    -1,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,
      -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,
      -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,   258,
      -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,    -1,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,    -1,   461,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,   490,   491,   492,   493,   494,   495,    -1,   497,   498,
     499,   500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,
     519,   520,   521,   522,   523,    -1,    -1,   526,   527,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,
      -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,    -1,    -1,   563,   564,    -1,   566,   567,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    50,    51,    -1,    53,    54,    55,
      56,    -1,    58,    59,    60,    61,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    72,    73,    74,    -1,
      76,    77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,
      -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,
     136,   137,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,    -1,   151,   152,   153,   154,   155,
     156,    -1,   158,   159,   160,   161,   162,    -1,   164,    -1,
      -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,   175,
     176,   177,   178,   179,    -1,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
     236,   237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,
      -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,
      -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,    -1,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,    -1,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,   394,   395,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,    -1,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,   490,   491,   492,   493,   494,   495,
      -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,   505,
     506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,   518,   519,   520,   521,   522,   523,    -1,    -1,
     526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,
      -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,
     566,   567,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    -1,    76,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,    -1,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,
     563,   564,    -1,   566,   567,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    78,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,   174,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,   213,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,   232,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,   246,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
     420,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,   439,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,    -1,   543,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,   567,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    78,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,   174,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,   213,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,   232,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,   439,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,    -1,   543,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,   567,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
     420,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,    -1,   543,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,   561,    -1,    23,    24,    25,    26,   567,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,    -1,   543,    -1,    -1,    -1,    -1,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,   561,    17,    -1,    -1,    20,   566,   567,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,   222,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,   567,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,   554,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,   567,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,
      -1,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,   560,    -1,    17,    -1,    -1,
      20,    -1,   567,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,    -1,   543,    -1,    -1,    -1,    -1,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,   566,   567,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,   567,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,   567,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,   567,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,   567,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
     245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,   566,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,   566,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,    -1,    28,   566,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,    -1,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,
     394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,
     404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,
     414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,
     434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
      -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
     534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,
      -1,    -1,    -1,    -1,   548,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,   562,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,    -1,   543,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,   554,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,    -1,   543,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,   554,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,   554,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,
     543,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,   554,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,   130,    -1,   132,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,
     394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,
     404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,
     414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,
     434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
      -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
     534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,
      -1,    -1,   546,     5,   548,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,
      -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,   161,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
      -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
      -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,
     402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,
      -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
      -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
      -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
     532,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,
      -1,   543,    -1,    -1,   546,     5,   548,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,
      -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,
     160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,
      -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,
     410,   411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,   532,    -1,   534,    -1,   536,    -1,   538,    -1,
      -1,    -1,    -1,   543,    -1,    -1,   546,     5,   548,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,
      -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,
      68,    -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
      -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,
      -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,
      -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,
      -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,
     408,    -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,
     418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,
      -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,   534,    -1,   536,    -1,
     538,    -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,     5,
     548,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,
      -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,
      -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,
     196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,
     396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,
      -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,   415,
      -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,
      -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,    -1,
     536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,
      -1,     5,   548,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,
     394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,
     404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,
     414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,
     434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
      -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
     534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,
      -1,    -1,    -1,     5,   548,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,
      -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,   161,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
      -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
      -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,
     402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,
      -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
      -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
      -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,
      -1,   543,    -1,    -1,    -1,     5,   548,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,
      -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,
     160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,
      -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,
     410,   411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,   534,    -1,   536,    -1,   538,    -1,
      -1,    -1,    -1,   543,    -1,    -1,    -1,     5,   548,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,
      -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,
      68,    -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
      -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
      -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,
      -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,
      -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,
      -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,
     408,    -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,
     418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,
      -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,   534,    -1,   536,    -1,
     538,    -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,     5,
     548,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,
      -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,
      -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,    -1,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,
     196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,
     396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,
      -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,   415,
      -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,
      -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,    -1,
     536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,
      -1,     5,   548,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
     104,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,   162,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,   261,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,   325,   326,    -1,   328,    -1,    -1,   331,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,   441,   442,   443,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,   497,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,   142,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
     427,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    32,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    88,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    34,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
     245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    18,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,   150,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,   171,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,   364,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    -1,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,
      51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,    -1,
      -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,    -1,   393,    -1,    -1,   396,    -1,    -1,   399,    -1,
      -1,   402,   403,    -1,    -1,    -1,    -1,   408,    -1,   410,
     411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,    -1,    -1,
      -1,    -1,   543
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,     3,    13,    14,    26,    28,    46,    47,    52,    56,
      57,    69,    84,   103,   112,   113,   114,   125,   126,   148,
     164,   188,   195,   198,   219,   233,   251,   256,   341,   362,
     369,   389,   391,   392,   395,   398,   400,   405,   407,   416,
     420,   426,   431,   435,   454,   458,   492,   508,   511,   516,
     539,   560,   571,   572,   573,   574,   575,   576,   578,   583,
     585,   590,   602,   769,   787,   790,   798,   800,   802,   805,
     810,   812,   817,   820,   825,   829,   837,   838,   976,   978,
     984,   987,  1012,  1020,  1031,  1033,  1047,  1050,  1053,  1059,
    1063,  1067,  1070,  1071,  1117,  1134,  1140,  1142,  1149,  1151,
    1176,  1182,  1183,  1184,  1185,  1231,    11,    91,   175,   210,
     366,   783,  1206,  1207,   252,   329,   819,   470,   472,  1136,
    1177,   213,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      43,    45,    46,    49,    51,    53,    54,    56,    58,    59,
      60,    62,    64,    65,    67,    68,    69,    70,    71,    74,
      76,    77,    79,    86,    93,    94,    97,   102,   103,   109,
     111,   117,   119,   120,   121,   125,   128,   129,   130,   134,
     138,   139,   140,   141,   144,   146,   147,   148,   151,   153,
     156,   159,   160,   161,   164,   169,   170,   173,   175,   182,
     183,   186,   187,   189,   195,   196,   198,   201,   205,   206,
     207,   208,   211,   212,   216,   220,   224,   227,   228,   235,
     237,   241,   244,   250,   252,   255,   257,   267,   268,   269,
     270,   271,   272,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   284,   285,   286,   288,   289,   293,   294,   295,
     296,   299,   300,   303,   305,   307,   310,   311,   312,   313,
     314,   315,   316,   319,   320,   322,   323,   324,   328,   333,
     334,   336,   338,   339,   340,   351,   352,   353,   355,   357,
     359,   362,   363,   365,   367,   368,   370,   371,   372,   373,
     374,   375,   376,   377,   382,   383,   386,   387,   388,   390,
     392,   393,   396,   398,   399,   400,   402,   403,   407,   408,
     410,   411,   413,   414,   415,   416,   418,   419,   423,   424,
     425,   428,   432,   433,   434,   435,   437,   438,   445,   446,
     448,   451,   454,   455,   458,   459,   461,   462,   463,   467,
     468,   470,   471,   473,   474,   477,   478,   479,   480,   481,
     487,   489,   492,   493,   494,   495,   498,   499,   502,   507,
     510,   512,   514,   515,   523,   526,   529,   530,   531,   536,
     538,   539,   543,   596,  1107,  1111,  1115,  1116,   281,  1136,
    1136,   536,  1178,    91,   174,   439,   473,   504,   514,   594,
     687,   688,   689,   761,  1021,   977,    91,   175,   213,   366,
     473,   488,   514,   529,   983,  1111,   819,   595,   567,  1105,
    1106,  1111,   584,   985,  1068,    93,   213,   472,  1136,   819,
    1111,  1064,   416,   514,  1136,   819,   988,  1060,  1136,   595,
    1178,  1111,   840,   842,   843,   342,  1119,  1034,   454,   458,
     435,   487,   435,   472,  1032,  1141,  1013,  1111,    28,    69,
     138,   362,   382,   407,   454,  1233,   420,   560,   839,     0,
       3,   362,   153,  1051,  1105,  1111,   142,   775,  1111,   596,
     596,   472,   109,  1201,  1202,  1203,  1136,   801,  1178,   826,
     827,  1105,   603,   567,   485,   803,   813,    16,  1179,   209,
     690,   595,   347,  1198,  1202,  1203,  1204,  1205,  1206,   472,
     688,   213,   210,   264,   372,  1029,  1030,   892,   893,   209,
     982,   982,  1111,   982,   982,   595,   982,  1136,   579,  1054,
      12,    13,    84,   112,   126,   148,   159,   188,   213,   219,
     256,   367,   384,   390,   396,   420,   431,   432,   467,   511,
     513,  1152,  1154,  1156,  1157,  1111,   340,    60,   380,   567,
     245,   476,  1108,  1111,  1113,   110,   200,   264,   990,    76,
     371,  1069,  1072,   222,  1105,  1135,  1136,   171,    32,   281,
    1039,  1065,  1111,   595,   821,  1136,   110,   264,   991,  1019,
     281,   371,   435,  1061,  1062,   799,    12,  1150,  1154,   485,
    1179,   841,    12,   122,   200,   444,   445,   446,   447,   448,
     449,   460,   847,   848,   849,  1118,    30,    33,    54,    55,
      64,    66,    83,    84,    92,   140,   144,   173,   175,   187,
     189,   212,   213,   216,   231,   252,   257,   281,   313,   322,
     340,   365,   366,   425,   435,   459,   472,   530,   734,   760,
    1035,  1039,  1040,  1042,  1125,   792,   793,   792,   792,   535,
     791,   792,   981,  1105,  1136,  1019,    34,   199,   476,  1093,
    1109,  1232,  1232,  1232,  1232,  1232,   842,   839,   561,  1111,
    1049,  1048,   294,   474,   499,   771,   773,   772,  1105,   142,
     450,  1208,   811,   980,   981,   225,   562,   833,   834,   560,
     604,  1111,   586,   980,   980,    51,   328,   328,   389,  1180,
     325,   326,   864,  1111,    88,  1113,  1114,  1167,  1168,   395,
      10,   366,   488,   853,  1200,  1208,  1209,  1217,  1219,  1220,
    1226,   853,  1199,  1209,  1217,  1220,  1226,  1201,  1206,   690,
    1111,   171,  1022,  1026,  1027,  1111,  1029,     7,    20,    22,
      25,    29,    32,    34,    35,    36,    38,    50,    54,    55,
      61,    64,    72,    73,    79,    81,    82,    83,    87,    88,
      90,    91,    95,    96,    97,   102,   104,   107,   108,   115,
     116,   133,   136,   137,   149,   152,   154,   155,   158,   162,
     167,   172,   176,   177,   178,   179,   181,   182,   184,   185,
     186,   190,   192,   193,   199,   205,   209,   219,   221,   236,
     240,   243,   248,   250,   253,   258,   261,   266,   273,   283,
     287,   295,   299,   301,   302,   306,   307,   308,   309,   310,
     311,   312,   318,   325,   326,   327,   330,   331,   336,   353,
     354,   356,   357,   358,   359,   360,   370,   378,   394,   395,
     406,   409,   412,   414,   418,   456,   457,   462,   464,   465,
     466,   469,   476,   478,   479,   480,   481,   490,   491,   492,
     497,   500,   505,   506,   514,   518,   519,   520,   521,   522,
     527,   531,   541,   543,   548,   552,   553,   558,   560,   563,
     564,   566,   567,   858,   859,   860,   861,   865,   868,   869,
     871,   878,   882,   894,  1092,  1094,  1096,  1097,  1101,  1103,
    1107,  1111,   149,  1111,  1111,   337,   596,   596,  1114,  1166,
     980,   982,   517,   580,   117,   201,   257,   281,   365,   371,
     399,   435,   455,   470,  1055,  1056,  1136,   365,  1155,   410,
     410,   473,   514,   529,   342,  1159,   470,  1161,    59,   435,
    1158,    92,   529,  1160,   337,   562,    18,   142,   936,   937,
    1143,  1111,   783,   858,    74,   171,   264,  1073,  1079,    46,
     171,  1105,  1137,  1138,   818,   566,   577,  1108,   257,   822,
    1114,   823,   824,  1105,   806,   222,   981,   992,   993,    46,
     562,   980,  1155,   337,   416,  1181,  1180,   503,  1186,  1187,
     554,   851,   852,   853,   849,  1120,  1121,  1122,   257,   147,
     426,   246,   533,  1046,   493,   560,    91,   175,   366,   472,
     529,  1046,   697,  1113,   247,   955,   957,    62,   455,   168,
     455,   455,   455,   281,   470,    62,   455,   201,   455,   455,
     493,   955,  1046,   171,   225,  1043,   257,   139,    65,   368,
     470,   489,   455,   526,   789,   388,   451,   794,   795,   788,
      77,   783,   562,   339,  1235,   468,  1236,   230,   402,  1234,
     561,  1187,  1189,  1190,  1191,   837,  1052,  1093,  1111,   108,
     685,   686,   695,   696,   743,   597,   597,   770,  1114,   419,
     529,   980,   485,   562,   108,   828,  1111,   827,   213,   232,
     758,   759,   835,   605,   606,   858,   267,   268,   269,   270,
     271,   272,   275,   276,   277,   278,   279,   280,   282,   386,
     387,   587,   588,   589,   153,   372,   804,    53,   153,   156,
     168,   293,   372,   814,   815,   816,    51,   389,   149,   593,
     560,   857,   566,   207,   562,   853,   853,   853,   175,   529,
     175,  1209,  1105,   494,   517,   762,  1026,  1105,  1111,   562,
    1024,   567,  1028,   560,   560,   560,   560,   560,   869,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   857,   857,   560,   857,   560,   560,   560,
     500,   560,  1092,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   858,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   895,   896,   897,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   858,   560,
     857,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   857,   560,  1092,   560,   560,   560,
    1092,   560,   560,    34,   199,   476,   560,   560,   560,   857,
     857,   857,   560,   560,   560,   560,   560,   560,   858,   899,
     869,   869,   869,   420,   560,   858,  1195,  1111,   883,  1111,
      15,    16,   344,   347,   540,   862,   863,   142,   143,   180,
     194,   226,   238,   265,   321,   866,   123,   225,   246,   306,
     385,   429,   430,   438,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   864,   869,    98,    99,   100,   101,   102,
     202,   203,   204,   205,   295,   297,   298,   299,   307,   370,
     417,   418,   531,   542,   543,   932,   934,    63,   346,   562,
    1109,   560,   567,   567,  1105,   562,    48,   401,   784,   980,
     566,   581,   582,    46,   535,   562,  1057,   470,   560,  1169,
    1169,  1169,  1169,   175,   366,   472,  1153,  1157,  1111,   160,
     323,  1111,  1144,  1145,   992,   281,   252,  1078,   830,   281,
     937,   562,   980,  1113,    27,   485,  1066,   562,   485,   562,
     485,   980,   993,   989,  1062,   171,   562,   175,   366,  1153,
    1111,    12,   122,  1193,   562,   844,   855,   858,  1099,  1111,
     562,   187,   252,   338,   425,  1123,  1124,  1127,  1128,   225,
    1044,  1108,   858,   554,   690,   596,   596,  1105,  1105,  1036,
     261,   331,   497,   958,   959,  1094,   596,  1046,  1114,   168,
    1041,  1043,   596,  1046,  1041,  1105,  1043,  1041,  1041,  1046,
    1046,   510,   796,   562,   796,   437,   420,   560,   564,   902,
     903,   904,   905,   914,   915,   923,  1093,   355,  1237,   345,
     951,   957,  1192,   686,    63,   734,    67,    79,   235,   304,
     328,   379,   450,   599,   601,     6,    13,    23,    24,    52,
      56,    67,    76,    81,    93,   111,   120,   121,   126,   134,
     140,   165,   211,   213,   220,   286,   300,   305,   345,   351,
     353,   374,   375,   377,   391,   413,   494,   503,   692,   694,
     695,   696,   776,   777,   778,   947,   109,   224,  1105,  1108,
     981,   560,   561,   562,   142,   142,   142,   142,   142,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   562,
     512,   815,   684,   685,   561,  1113,    44,  1168,   175,   596,
     596,   596,  1111,  1105,   591,    43,   196,   415,   763,   763,
     337,  1025,  1023,   567,  1027,   171,   554,  1111,   937,   858,
     858,   858,    12,   122,   888,   938,   104,   162,   199,   261,
     331,   497,   961,   888,   888,   888,   858,   858,   892,   892,
     858,   892,   858,   858,   858,   858,   122,   888,   938,   858,
     561,   858,   858,   858,   858,   858,  1101,  1111,   858,   858,
     858,   858,   858,   560,  1195,   858,   932,   858,   858,   858,
     561,   858,   858,   858,   858,   892,   858,   858,    94,    97,
     478,   481,   935,   858,   122,   885,  1092,   858,   858,   858,
     561,   858,   858,   858,   858,   892,   858,   858,   858,   858,
     896,     9,   898,  1101,   122,   888,   858,   858,   122,   888,
     858,   858,   858,   858,   858,   892,   892,   892,   858,   858,
     858,   858,   858,   858,   892,   861,   858,   561,   858,   858,
     858,   858,   858,   561,   858,   858,   888,   888,   858,   858,
     858,   122,   888,   858,   858,   170,   933,   934,   933,   858,
      42,   239,   486,   858,   858,  1092,   561,   858,   561,   888,
    1102,  1103,  1111,   888,   858,   858,   858,   532,   901,  1196,
    1196,   561,   562,   561,   858,   566,   884,  1113,   567,   858,
     858,   858,   860,   155,   330,   491,   507,   864,    12,    17,
     860,   867,   861,   560,   869,   861,   861,   861,   861,   246,
     861,   861,   861,   861,   868,   861,   868,   861,   861,   861,
     861,   225,   246,   385,   549,   553,  1113,   869,   858,   870,
    1111,  1111,   979,  1114,   784,  1113,   562,   380,  1056,   980,
    1058,  1111,  1170,  1171,   554,  1105,  1111,  1165,  1165,  1165,
     142,   160,   180,   194,   237,   238,   265,   323,   363,  1146,
    1148,   533,   939,   986,   214,   831,   832,  1105,   264,   380,
     537,  1139,  1138,   858,  1108,  1114,  1114,   824,  1105,   153,
     372,   515,   807,   808,   809,   420,   426,   522,   523,   560,
     680,   994,   997,  1108,   188,  1165,  1165,  1165,  1188,   852,
     171,   222,   845,   846,   950,   951,   972,   854,   567,  1121,
     108,   487,  1111,  1130,   314,   353,   566,   734,  1129,  1108,
     171,  1045,   561,  1111,   257,   455,  1038,   334,   562,   435,
    1046,  1111,  1046,  1041,  1105,  1046,  1046,   589,   797,   795,
     922,  1111,    85,   215,   230,   243,   317,   406,   460,   913,
     426,   562,  1105,   922,   562,   168,  1238,    44,   955,   142,
     427,  1003,  1004,  1004,  1108,   450,   450,   450,   450,   450,
     419,    66,    78,   174,   439,   706,   709,   710,   756,   758,
     782,   782,  1004,  1004,   782,  1004,  1004,  1004,   485,   119,
    1004,   231,   471,   166,   364,   758,   782,   231,  1004,   471,
     119,  1004,  1004,  1004,   782,    44,  1004,  1004,  1004,  1004,
    1004,    18,   142,   485,   786,  1004,  1004,  1004,   692,   562,
     560,   567,   705,   711,  1104,  1111,   774,   364,   930,  1111,
     858,   961,  1108,  1108,   104,   162,   261,   331,   497,   962,
    1108,   961,  1108,  1108,  1108,  1108,  1108,   961,  1108,  1108,
     961,   588,   353,   476,  1111,  1227,     8,    27,   672,   560,
     403,  1210,   246,   560,   674,   691,   693,   694,  1105,   517,
     939,  1111,   903,   567,  1028,   562,   561,   561,   562,   888,
     561,   889,   562,   561,   561,   561,    18,   561,   517,   561,
     561,   561,   561,   562,   562,   517,   562,   562,   879,   561,
     554,   561,   562,   562,   561,   561,   562,   561,   567,   561,
     562,   561,   562,   562,   562,   561,   562,   561,   562,   171,
     562,   562,   561,   562,   561,   562,   562,   561,   562,   561,
     561,   562,   561,   562,   562,   562,   881,   562,   561,   562,
     562,   561,   562,   562,   561,   562,   561,   562,   561,   562,
     562,   562,   561,   560,   562,   888,   561,   561,   561,   888,
     561,   561,   562,   562,   561,   561,   562,   561,   562,   561,
     561,   561,   561,   561,   561,   561,   562,   562,   561,   562,
     561,   225,   561,   561,   562,   562,   562,   561,   562,   562,
     561,   561,   561,   562,   171,   562,   562,   888,   561,   561,
     561,   562,   562,   562,   561,   171,   858,   171,   858,   171,
     858,   171,   561,   562,   562,   561,   561,   561,   561,   561,
     562,   561,   562,   561,   858,   532,   546,   900,   840,   839,
     892,   565,   187,   252,   425,  1126,   427,  1111,   155,   330,
     491,   507,   560,   858,  1195,   146,   943,   861,    16,   932,
     932,   560,   869,   861,   861,   858,   873,   874,   875,   560,
     567,   582,   256,   561,   562,   567,   567,   485,   485,   485,
    1147,   940,   956,   957,   994,   476,  1110,   562,   833,   537,
     252,   485,   808,   681,   995,   560,  1000,  1005,  1000,   561,
     680,   996,  1098,  1099,  1102,  1111,   998,   342,   171,   171,
     171,   838,   127,   903,   973,   168,   256,   850,   972,   956,
     846,    18,   856,  1108,  1111,   554,  1111,   567,   227,   567,
    1003,    32,   108,   735,   736,  1003,  1113,   168,  1003,   566,
    1113,    32,   108,   738,   739,  1113,   962,  1037,   144,   530,
     959,   959,   535,   939,  1041,   562,   917,   922,   902,   230,
     230,   348,   924,   230,   243,   406,   924,   914,   902,  1015,
    1016,  1102,   902,   937,   919,   920,   961,   296,   952,   108,
     740,   742,  1113,   736,    93,    93,   109,   224,   766,  1104,
     759,   759,    57,   166,   364,   504,   708,   757,   707,   708,
     766,  1104,   962,   961,  1104,   961,  1108,  1108,   734,  1004,
     961,   232,   232,  1104,  1104,   697,  1004,   160,   237,   328,
     700,   962,   962,  1104,   948,   949,  1102,   108,   961,  1108,
     961,   961,   373,   376,   699,   961,  1105,    70,    71,   108,
     130,   161,   383,   698,   697,   560,   778,   703,   704,   705,
     706,  1111,     8,   160,   785,   384,   707,   748,   712,   567,
     560,  1211,   561,   562,   476,   403,   560,   112,   219,   511,
     673,  1221,   105,   223,   381,   461,   702,  1211,  1105,   246,
     675,   680,   703,   210,   395,   677,  1080,   562,   693,   592,
     903,   950,   939,   937,   221,   858,   858,   561,   858,   858,
      32,    55,    94,    97,   105,   319,   433,   481,   509,   890,
     735,   892,   858,   735,   890,   858,   892,   561,   868,   868,
    1109,  1111,   858,   858,   892,  1109,   858,   858,   858,   892,
     331,   858,   858,   858,   858,   858,   858,   858,   892,   892,
     331,   858,   858,   892,   858,   858,   858,   858,   892,   858,
     861,  1101,   561,   561,   858,   858,   858,   858,   858,   858,
     858,   858,   858,   858,   858,   858,   892,   221,   858,   858,
     858,   858,   561,   858,   858,   858,   858,   171,   858,   171,
     858,   171,   858,   858,   331,   858,   858,   547,   858,   858,
     138,  1194,  1194,   561,   567,   567,   567,  1113,   858,  1195,
     561,   562,   561,   869,   860,   858,  1195,   943,    16,   561,
     853,   876,   877,   891,   892,  1111,  1171,   554,   554,  1167,
    1167,  1167,   560,   858,   337,  1010,  1074,   832,   210,   836,
    1114,   847,  1001,  1002,  1102,  1006,   562,   560,   997,   561,
     561,   562,   567,  1186,   171,  1167,  1167,  1167,   939,   939,
     128,   349,   968,   969,   974,   511,   225,  1108,  1111,   567,
    1111,   244,  1111,    12,    32,   108,   337,   858,  1133,    63,
     741,   858,  1114,   336,   353,   476,  1132,  1126,  1003,   955,
     269,  1046,   589,  1189,   918,   243,   230,   914,   924,   924,
     230,   337,   337,   517,   562,  1014,  1003,   165,   210,   516,
     926,   847,   858,   953,  1100,   858,   232,   232,   759,   766,
     762,   126,   426,   779,   736,  1108,   766,   784,  1108,   780,
     562,    19,   113,   954,  1058,   561,   562,  1111,  1105,    31,
      32,    37,    39,    40,    41,    55,    94,    97,   105,   124,
     141,   161,   163,   182,   183,   223,   250,   259,   260,   262,
     290,   291,   292,   310,   311,   312,   316,   319,   332,   333,
     357,   359,   381,   424,   426,   436,   477,   478,   481,   482,
     483,   484,   524,   525,   543,   713,   716,   717,   718,   719,
     720,   721,   722,  1111,  1111,  1212,    18,  1111,   702,  1228,
     337,   607,   608,   610,  1111,   496,    18,  1105,   561,   561,
      18,   683,   693,   560,   939,   247,   960,   858,   561,   561,
     561,   560,   728,   728,   560,   723,   724,   728,   223,   223,
     561,   561,   561,   561,   561,   561,   562,   880,   932,   932,
     561,   561,   561,   561,   561,   561,   562,   561,   561,   561,
     561,   561,   562,   561,   561,   561,   561,   561,   887,   951,
     562,   562,   562,   561,   561,   561,   561,   562,   561,   561,
     561,   562,   225,   535,   872,   561,   561,   561,   561,   561,
     561,   561,   561,   561,   562,   561,   561,   561,   858,   561,
     168,   561,   561,   562,   562,   561,   562,   562,   561,   858,
     561,   858,   561,   858,   561,   561,   562,   561,   561,   858,
     547,  1197,  1197,   567,   767,   561,   892,   561,   562,   561,
     860,   858,   562,   561,   397,  1172,  1172,  1172,   108,   858,
    1008,  1009,   129,  1080,   241,   851,   562,  1003,  1007,  1008,
    1005,   999,   997,  1098,  1111,  1167,   956,   191,   944,  1110,
    1110,   566,   970,   971,  1113,   428,   554,   380,   393,   423,
    1131,   742,  1003,   560,   560,  1130,   858,   142,   561,   904,
     348,   902,   914,   230,   230,   902,   914,   907,   906,   908,
    1016,   939,  1009,   758,   927,   927,   927,   851,   562,   954,
     766,   762,   560,   108,   108,   711,   741,   713,   949,   561,
     704,   749,   560,   560,   728,   723,   361,   714,   723,   723,
      20,    32,    45,   502,   734,   744,    55,   524,   717,   719,
     744,   744,    55,   525,   525,   528,   723,   715,   728,   728,
     744,   560,   728,    23,    63,    67,   108,   330,   337,   364,
     424,   504,   730,   731,   732,   747,   864,   528,   560,   744,
      32,   560,   745,   560,   560,   728,   560,   724,   729,   567,
     561,   562,  1213,  1214,   496,   217,   225,   350,   611,   612,
     613,   614,   853,   561,   562,   609,  1108,  1213,   561,   676,
     691,   560,   680,   764,   765,  1111,   959,   932,   331,   744,
     331,   858,   561,   561,   561,   858,   858,   422,   886,   331,
     858,   858,   858,   858,    40,   371,   561,   858,   932,   858,
     858,   858,   858,   858,   561,   561,   561,   331,   858,   561,
    1111,   561,   892,   854,   877,    58,   228,   324,   452,   463,
     538,  1163,  1164,   535,  1173,  1173,  1173,   561,   562,  1011,
     222,   682,  1002,  1009,   561,  1189,    44,   197,   941,   975,
    1113,   562,   303,    68,   498,   380,  1132,   476,   476,  1003,
    1108,   937,   230,   337,   910,   914,   914,   337,   912,   858,
     858,   560,   950,   168,   925,   921,  1100,   560,   560,   764,
      97,   478,   481,   552,   553,  1095,  1096,   785,   730,   283,
     337,   560,   750,   752,   753,   754,   331,   331,   433,   509,
     544,   725,   726,   727,   560,   725,   725,   745,    20,   502,
     734,   746,   745,   735,   744,   528,   725,   560,   744,   331,
     725,   740,  1108,   327,   733,  1095,   511,   108,   232,   732,
     232,   330,   331,   331,   331,   331,   725,   331,   725,  1111,
    1111,   535,  1216,   420,   560,  1215,  1108,   561,   562,   609,
    1105,  1222,   610,   713,  1216,  1189,   677,   680,   678,   561,
     562,   954,   560,   561,   561,   561,   562,   561,   561,   562,
     561,  1093,   561,   562,   561,   562,   561,   561,   303,   151,
     561,   561,   561,   561,   561,   561,   561,   562,   561,   856,
     476,   476,   476,    16,  1162,   188,   284,   285,   288,   289,
    1174,  1175,  1009,   232,  1075,   701,   846,   956,   945,  1100,
     942,   950,    65,  1081,   971,   561,   561,  1133,    16,   902,
     909,   517,   911,   517,   931,  1111,   960,   230,   928,   701,
     954,   764,   764,   561,  1097,  1097,   781,   173,   352,   434,
     112,   511,   751,  1111,   754,   561,   561,   727,   768,  1093,
     735,   745,   768,   561,   857,   327,   523,   561,   561,   561,
     561,    49,    57,   252,   853,   853,  1229,   613,  1111,   168,
     403,   561,  1186,   765,   331,   331,   858,   888,   858,   892,
    1163,   342,   961,   961,   961,   961,  1175,   511,   472,   850,
     535,   562,   946,   954,   858,   956,   135,   145,   343,   475,
    1082,  1083,   249,  1084,   270,   337,   858,   560,   858,   560,
     561,   562,   560,   561,   561,   762,   785,    48,   328,   401,
     426,   755,   755,   561,   562,   561,   562,   561,   857,   744,
     745,   744,   745,    57,   342,    57,   840,   839,   598,   713,
     853,  1223,   679,   954,   561,   561,   561,   562,   561,   561,
     561,  1017,  1018,  1102,  1105,    86,   408,  1100,   366,   963,
      44,    44,   135,    44,  1083,   453,   475,  1085,  1086,   142,
     916,   931,   931,  1111,   929,   930,   748,   762,     5,   108,
     330,   752,  1111,   744,  1093,   744,   342,   342,   561,   118,
     599,   600,   864,  1230,   131,   713,  1189,   858,   562,  1003,
    1076,   954,  1111,  1093,  1093,    44,  1093,    44,    44,  1086,
     962,   858,   561,   561,   561,  1189,   118,    60,   157,   209,
     229,   242,   340,   404,   548,   631,   632,   635,   644,   645,
     648,   659,   662,   664,   665,  1107,  1112,  1116,   414,  1224,
     561,  1018,  1009,   734,   737,   964,  1093,  1093,  1093,    16,
     565,  1111,   171,   323,   637,   634,  1112,  1112,  1111,   633,
     646,   649,   573,   263,   394,   534,   668,    28,   666,   569,
    1218,   598,   736,  1077,   560,   274,   171,  1111,   639,   640,
     858,   858,   532,   651,   655,   616,   631,   616,   669,   667,
     660,   663,   631,  1225,  1081,   853,   965,   966,   967,   142,
     222,   138,   858,   647,   656,   546,   655,   658,   138,   631,
     568,   510,   858,   617,   668,   666,   631,  1084,   858,   561,
     562,   961,   636,   209,   547,   532,   650,   652,   858,   616,
     138,   263,   568,   671,   125,   106,   615,   618,   661,  1112,
     661,   210,  1087,   967,   638,  1111,   641,   653,   652,   658,
     657,   548,   858,   670,    80,   150,   623,   629,  1111,   138,
     631,   568,   331,   560,  1088,   562,   616,   858,   138,   547,
     138,   616,   195,   562,   619,    75,    89,   568,   249,   561,
     566,  1089,  1090,  1102,   426,  1091,  1111,   642,   654,   548,
     616,   394,   138,   168,  1111,   713,   168,   168,  1113,   561,
     562,  1017,   132,   546,   643,   547,   534,   620,   108,   630,
     442,   626,   961,   621,   622,  1090,   639,   616,   616,   441,
     443,   624,   625,   626,   628,   864,  1111,   858,   523,   627,
     573,   562,   631,   169,  1109,   625
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1207 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     MYSQL_YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1220 "sql_yacc.yy"
    {}
    break;

  case 53:
#line 1280 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= (yyvsp[(3) - (3)].lex_str);
        }
    break;

  case 56:
#line 1295 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= (yyvsp[(2) - (4)].lex_str);
        }
    break;

  case 57:
#line 1304 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[(1) - (1)].lex_str);
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 58:
#line 1311 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[(2) - (2)].lex_str);
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 59:
#line 1320 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= (yyvsp[(2) - (2)].lex_str);
        }
    break;

  case 60:
#line 1327 "sql_yacc.yy"
    {}
    break;

  case 65:
#line 1341 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[(2) - (2)].lex_str), sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 66:
#line 1353 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 67:
#line 1361 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 68:
#line 1371 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 69:
#line 1377 "sql_yacc.yy"
    {}
    break;

  case 72:
#line 1386 "sql_yacc.yy"
    {
	 Lex->mi.host = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 73:
#line 1391 "sql_yacc.yy"
    {
	 Lex->mi.user = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 74:
#line 1396 "sql_yacc.yy"
    {
	 Lex->mi.password = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 75:
#line 1401 "sql_yacc.yy"
    {
	 Lex->mi.port = (yyvsp[(3) - (3)].ulong_num);
       }
    break;

  case 76:
#line 1406 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = (yyvsp[(3) - (3)].ulong_num);
       }
    break;

  case 77:
#line 1410 "sql_yacc.yy"
    {
           Lex->mi.ssl= (yyvsp[(3) - (3)].ulong_num) ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 78:
#line 1415 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 79:
#line 1419 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 80:
#line 1423 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 81:
#line 1427 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 82:
#line 1431 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= (yyvsp[(3) - (3)].lex_str).str;
	 }
    break;

  case 84:
#line 1440 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 85:
#line 1444 "sql_yacc.yy"
    {
           Lex->mi.pos = (yyvsp[(3) - (3)].ulonglong_number);
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 86:
#line 1460 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 87:
#line 1464 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = (yyvsp[(3) - (3)].ulong_num);
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 88:
#line 1475 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[(5) - (5)].table), NULL,
						 TL_OPTION_UPDATING,
						 TL_WRITE))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=(yyvsp[(2) - (5)].num) | (yyvsp[(4) - (5)].num);
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	}
    break;

  case 89:
#line 1492 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 90:
#line 1494 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, (yyvsp[(7) - (7)].table), NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 91:
#line 1506 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[(2) - (11)].key_type), (yyvsp[(4) - (11)].lex_str).str, (yyvsp[(5) - (11)].key_alg), 0, lex->col_list);

            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();
	  }
    break;

  case 92:
#line 1514 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 93:
#line 1519 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=(yyvsp[(4) - (6)].lex_str).str;
            lex->create_info.options=(yyvsp[(3) - (6)].num);
	  }
    break;

  case 94:
#line 1526 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 95:
#line 1532 "sql_yacc.yy"
    {}
    break;

  case 96:
#line 1534 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 97:
#line 1541 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 98:
#line 1556 "sql_yacc.yy"
    {
            if (!(yyvsp[(1) - (3)].lex_str).str || check_db_name((yyvsp[(1) - (3)].lex_str).str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[(1) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name((yyvsp[(3) - (3)].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spname)= new sp_name((yyvsp[(1) - (3)].lex_str), (yyvsp[(3) - (3)].lex_str), true);
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 99:
#line 1571 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            LEX_STRING db;

	    if (check_routine_name((yyvsp[(1) - (1)].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
            if (lex->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    (yyval.spname)= new sp_name(db, (yyvsp[(1) - (1)].lex_str), false);
            if ((yyval.spname))
	      (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 100:
#line 1589 "sql_yacc.yy"
    {}
    break;

  case 101:
#line 1590 "sql_yacc.yy"
    {}
    break;

  case 102:
#line 1594 "sql_yacc.yy"
    {}
    break;

  case 103:
#line 1595 "sql_yacc.yy"
    {}
    break;

  case 104:
#line 1601 "sql_yacc.yy"
    { Lex->sp_chistics.comment= (yyvsp[(2) - (2)].lex_str); }
    break;

  case 105:
#line 1603 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 106:
#line 1605 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 107:
#line 1607 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 108:
#line 1609 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 109:
#line 1611 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 110:
#line 1613 "sql_yacc.yy"
    { }
    break;

  case 111:
#line 1618 "sql_yacc.yy"
    { }
    break;

  case 112:
#line 1619 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 113:
#line 1620 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 114:
#line 1625 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 115:
#line 1629 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 116:
#line 1636 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= (yyvsp[(2) - (2)].spname);
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, (yyvsp[(2) - (2)].spname), TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 117:
#line 1644 "sql_yacc.yy"
    {}
    break;

  case 122:
#line 1660 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[(3) - (3)].item));
	  }
    break;

  case 123:
#line 1664 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[(1) - (1)].item));
	  }
    break;

  case 128:
#line 1682 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 129:
#line 1702 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(1) - (3)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[(1) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[(1) - (3)].lex_str),
                                                     (enum enum_field_types)(yyvsp[(3) - (3)].num),
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[(3) - (3)].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 134:
#line 1739 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(3) - (4)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[(3) - (4)].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[(3) - (4)].lex_str),
                                                     (enum enum_field_types)(yyvsp[(4) - (4)].num),
                                                     (sp_param_mode_t)(yyvsp[(1) - (4)].num));

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[(4) - (4)].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 135:
#line 1764 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 136:
#line 1765 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 137:
#line 1766 "sql_yacc.yy"
    { (yyval.num)= sp_param_out; }
    break;

  case 138:
#line 1767 "sql_yacc.yy"
    { (yyval.num)= sp_param_inout; }
    break;

  case 139:
#line 1771 "sql_yacc.yy"
    {}
    break;

  case 141:
#line 1776 "sql_yacc.yy"
    {}
    break;

  case 143:
#line 1782 "sql_yacc.yy"
    {
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	  }
    break;

  case 144:
#line 1786 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if (((yyvsp[(2) - (3)].spblock).vars || (yyvsp[(2) - (3)].spblock).conds) && ((yyvsp[(1) - (3)].spblock).curs || (yyvsp[(1) - (3)].spblock).hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if ((yyvsp[(2) - (3)].spblock).curs && (yyvsp[(1) - (3)].spblock).hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    (yyval.spblock).vars= (yyvsp[(1) - (3)].spblock).vars + (yyvsp[(2) - (3)].spblock).vars;
	    (yyval.spblock).conds= (yyvsp[(1) - (3)].spblock).conds + (yyvsp[(2) - (3)].spblock).conds;
	    (yyval.spblock).hndlrs= (yyvsp[(1) - (3)].spblock).hndlrs + (yyvsp[(2) - (3)].spblock).hndlrs;
	    (yyval.spblock).curs= (yyvsp[(1) - (3)].spblock).curs + (yyvsp[(2) - (3)].spblock).curs;
	  }
    break;

  case 145:
#line 1812 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            if (lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
            lex->spcont->declare_var_boundary((yyvsp[(2) - (2)].num));
          }
    break;

  case 146:
#line 1821 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            if (pctx == 0)
            {
              MYSQL_YYABORT;
            }
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) (yyvsp[(4) - (5)].num);
            Item *dflt_value_item= (yyvsp[(5) - (5)].item);
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-(yyvsp[(2) - (5)].num) ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            (yyval.spblock).vars= (yyvsp[(2) - (5)].num);
            (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
          }
    break;

  case 147:
#line 1873 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&(yyvsp[(2) - (5)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), (yyvsp[(2) - (5)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&(yyvsp[(2) - (5)].lex_str), (yyvsp[(5) - (5)].spcondtype));
	    (yyval.spblock).vars= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	    (yyval.spblock).conds= 1;
	  }
    break;

  case 148:
#line 1887 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            lex->spcont= lex->spcont->push_context(LABEL_HANDLER_SCOPE);

	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, (yyvsp[(2) - (4)].num),
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 149:
#line 1902 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if ((yyvsp[(2) - (7)].num) == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
              if (i == NULL )
                MYSQL_YYABORT;
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);

            lex->spcont= ctx->pop_context();

	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).curs= 0;
	    (yyval.spblock).hndlrs= (yyvsp[(6) - (7)].num);
	    lex->spcont->add_handlers((yyvsp[(6) - (7)].num));
	  }
    break;

  case 150:
#line 1934 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&(yyvsp[(2) - (5)].lex_str), &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), (yyvsp[(2) - (5)].lex_str).str);
	      delete (yyvsp[(5) - (5)].lex);
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, (yyvsp[(5) - (5)].lex),
                                  ctx->current_cursor_count());
	    if ( i==NULL )
              MYSQL_YYABORT;
            sp->add_instr(i);
	    ctx->push_cursor(&(yyvsp[(2) - (5)].lex_str));
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= 0;
	    (yyval.spblock).curs= 1;
	  }
    break;

  case 151:
#line 1959 "sql_yacc.yy"
    {
	    if(Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 152:
#line 1969 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    (yyval.lex)= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 153:
#line 1991 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_EXIT; }
    break;

  case 154:
#line 1992 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_CONTINUE; }
    break;

  case 155:
#line 1998 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 156:
#line 2000 "sql_yacc.yy"
    { (yyval.num)+= 1; }
    break;

  case 157:
#line 2005 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont->parent_context();

	    if (ctx->find_handler((yyvsp[(1) - (1)].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[(1) - (1)].spcondtype));
	      ctx->push_handler((yyvsp[(1) - (1)].spcondtype));
	    }
	  }
    break;

  case 158:
#line 2028 "sql_yacc.yy"
    {			/* mysql errno */
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::number;
	    (yyval.spcondtype)->mysqlerr= (yyvsp[(1) - (1)].ulong_num);
	  }
    break;

  case 159:
#line 2034 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&(yyvsp[(3) - (3)].lex_str)))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::state;
	    memcpy((yyval.spcondtype)->sqlstate, (yyvsp[(3) - (3)].lex_str).str, 5);
	    (yyval.spcondtype)->sqlstate[5]= '\0';
	  }
    break;

  case 160:
#line 2048 "sql_yacc.yy"
    {}
    break;

  case 161:
#line 2049 "sql_yacc.yy"
    {}
    break;

  case 162:
#line 2054 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (yyvsp[(1) - (1)].spcondtype);
	  }
    break;

  case 163:
#line 2058 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= Lex->spcont->find_cond(&(yyvsp[(1) - (1)].lex_str));
	    if ((yyval.spcondtype) == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 164:
#line 2067 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::warning;
	  }
    break;

  case 165:
#line 2072 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::notfound;
	  }
    break;

  case 166:
#line 2077 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::exception;
	  }
    break;

  case 167:
#line 2085 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(1) - (1)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[(1) - (1)].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= 1;
	  }
    break;

  case 168:
#line 2100 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(3) - (3)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[(3) - (3)].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= (yyvsp[(1) - (3)].num) + 1;
	  }
    break;

  case 169:
#line 2117 "sql_yacc.yy"
    { (yyval.item) = NULL; }
    break;

  case 170:
#line 2118 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(2) - (2)].item); }
    break;

  case 171:
#line 2122 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    if (lex->sphead->reset_lex(thd))
              MYSQL_YYABORT;
	    lex->sphead->m_tmp_query= lip->tok_start;
	  }
    break;

  case 172:
#line 2132 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i= new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);
              if (i == NULL)
                MYSQL_YYABORT;
              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lip->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lip->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(thd->mem_root,
                                           sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(thd);
          }
    break;

  case 173:
#line 2174 "sql_yacc.yy"
    {
            if(Lex->sphead->reset_lex(YYTHD))
               MYSQL_YYABORT;
          }
    break;

  case 174:
#line 2179 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, (yyvsp[(3) - (3)].item),
                                      sp->m_return_field_def.sql_type, lex);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 175:
#line 2202 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 176:
#line 2204 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 178:
#line 2207 "sql_yacc.yy"
    {}
    break;

  case 179:
#line 2208 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 180:
#line 2214 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 181:
#line 2220 "sql_yacc.yy"
    {}
    break;

  case 182:
#line 2222 "sql_yacc.yy"
    {}
    break;

  case 183:
#line 2224 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[(2) - (2)].lex_str).str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;
              /*
                When jumping to a BEGIN-END block end, the target jump
                points to the block hpop/cpop cleanup instructions,
                so we should exclude the block context here.
                When jumping to something else (i.e., SP_LAB_ITER),
                there are no hpop/cpop at the jump destination,
                so we should include the block context here for cleanup.
              */
              bool exclusive= (lab->type == SP_LAB_BEGIN);

	      n= ctx->diff_handlers(lab->ctx, exclusive);
	      if (n)
              {
                sp_instr_hpop *hpop= new sp_instr_hpop(ip++, ctx, n);
                if (hpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(hpop);
              }
	      n= ctx->diff_cursors(lab->ctx, exclusive);
	      if (n)
              {
                sp_instr_cpop *cpop= new sp_instr_cpop(ip++, ctx, n);
                if (cpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(cpop);
              }
	      i= new sp_instr_jump(ip, ctx);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 184:
#line 2274 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[(2) - (2)].lex_str).str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
              {
                sp_instr_hpop *hpop= new sp_instr_hpop(ip++, ctx, n);
                if (hpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(hpop);
              }
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
              {
                sp_instr_cpop *cpop= new sp_instr_cpop(ip++, ctx, n);
                if (cpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(cpop);
              }
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              if (i == NULL)
                MYSQL_YYABORT;
              sp->add_instr(i);
	    }
	  }
    break;

  case 185:
#line 2314 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[(2) - (2)].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 186:
#line 2331 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[(3) - (4)].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[(3) - (4)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 187:
#line 2348 "sql_yacc.yy"
    { }
    break;

  case 188:
#line 2350 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[(2) - (2)].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 192:
#line 2376 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[(1) - (1)].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 193:
#line 2397 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[(3) - (3)].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 194:
#line 2419 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 195:
#line 2424 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               (yyvsp[(2) - (3)].item), lex);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 196:
#line 2439 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 197:
#line 2451 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 203:
#line 2471 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            if (lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 204:
#line 2478 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, (yyvsp[(3) - (3)].item)))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 205:
#line 2489 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 206:
#line 2497 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 207:
#line 2505 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 212:
#line 2523 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 213:
#line 2528 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[(3) - (3)].item), true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 214:
#line 2537 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 215:
#line 2545 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 216:
#line 2550 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[(3) - (3)].item), false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 217:
#line 2557 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 218:
#line 2565 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            if (i == NULL)
              MYSQL_YYABORT;
            sp->add_instr(i);
          }
    break;

  case 220:
#line 2580 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[(1) - (2)].lex_str).str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[(1) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label((yyvsp[(1) - (2)].lex_str).str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 221:
#line 2598 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
            sp_label_t *lab= lex->spcont->pop_label();

	    if ((yyvsp[(5) - (5)].lex_str).str)
	    {
	      if (my_strcasecmp(system_charset_info, (yyvsp[(5) - (5)].lex_str).str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[(5) - (5)].lex_str).str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lab);
	  }
    break;

  case 222:
#line 2615 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 223:
#line 2616 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str); }
    break;

  case 224:
#line 2621 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *ctx= lex->spcont;
            sp_label_t *lab= ctx->find_label((yyvsp[(1) - (2)].lex_str).str);

            if (lab)
            {
              my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[(1) - (2)].lex_str).str);
              MYSQL_YYABORT;
            }

            lab= lex->spcont->push_label((yyvsp[(1) - (2)].lex_str).str,
                                         lex->sphead->instructions());
            lab->type= SP_LAB_BEGIN;
          }
    break;

  case 225:
#line 2637 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_label_t *lab= lex->spcont->pop_label();

            if ((yyvsp[(5) - (5)].lex_str).str)
            {
              if (my_strcasecmp(system_charset_info, (yyvsp[(5) - (5)].lex_str).str, lab->name) != 0)
              {
                my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[(5) - (5)].lex_str).str);
                MYSQL_YYABORT;
              }
            }
          }
    break;

  case 226:
#line 2653 "sql_yacc.yy"
    { /* Unlabeled blocks get a secret label. */
            LEX *lex= Lex;
            uint ip= lex->sphead->instructions();
            sp_label_t *lab= lex->spcont->push_label((char *)"", ip);
            lab->type= SP_LAB_BEGIN;
          }
    break;

  case 227:
#line 2660 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->spcont->pop_label();
          }
    break;

  case 228:
#line 2668 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    lex->spcont= lex->spcont->push_context(LABEL_DEFAULT_SCOPE);
	  }
    break;

  case 229:
#line 2677 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if ((yyvsp[(3) - (5)].spblock).hndlrs)
            {
              sp_instr_hpop *hpop= new sp_instr_hpop(sp->instructions(), ctx,
                                                     (yyvsp[(3) - (5)].spblock).hndlrs);
              if (hpop == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(hpop);
            }
	    if ((yyvsp[(3) - (5)].spblock).curs)
            {
              sp_instr_cpop *cpop= new sp_instr_cpop(sp->instructions(), ctx,
                                                     (yyvsp[(3) - (5)].spblock).curs);
              if (cpop == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(cpop);
            }
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 230:
#line 2706 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);
            if (i == NULL)
              MYSQL_YYABORT;
	    lex->sphead->add_instr(i);
	  }
    break;

  case 231:
#line 2716 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 232:
#line 2721 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       (yyvsp[(3) - (4)].item), lex);
            if (i == NULL)
              MYSQL_YYABORT;
	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 233:
#line 2736 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);
            if (i == NULL)
              MYSQL_YYABORT;
	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 234:
#line 2747 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 235:
#line 2752 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               (yyvsp[(5) - (7)].item), lab->ip,
                                                               lex);
            if (i == NULL)
              MYSQL_YYABORT;
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 236:
#line 2770 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 237:
#line 2772 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 238:
#line 2777 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 239:
#line 2779 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 240:
#line 2781 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 241:
#line 2785 "sql_yacc.yy"
    {}
    break;

  case 242:
#line 2786 "sql_yacc.yy"
    {}
    break;

  case 243:
#line 2788 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[(2) - (2)].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 244:
#line 2794 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[(3) - (4)].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 245:
#line 2802 "sql_yacc.yy"
    {}
    break;

  case 246:
#line 2803 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 247:
#line 2803 "sql_yacc.yy"
    {}
    break;

  case 248:
#line 2807 "sql_yacc.yy"
    {}
    break;

  case 249:
#line 2809 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 250:
#line 2809 "sql_yacc.yy"
    {}
    break;

  case 251:
#line 2811 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 252:
#line 2811 "sql_yacc.yy"
    {}
    break;

  case 253:
#line 2816 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 254:
#line 2832 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 255:
#line 2836 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 256:
#line 2846 "sql_yacc.yy"
    {}
    break;

  case 257:
#line 2847 "sql_yacc.yy"
    {}
    break;

  case 258:
#line 2850 "sql_yacc.yy"
    {}
    break;

  case 259:
#line 2851 "sql_yacc.yy"
    {}
    break;

  case 260:
#line 2854 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2855 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2858 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2859 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2862 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 265:
#line 2863 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[(1) - (1)].num);}
    break;

  case 266:
#line 2866 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[(1) - (1)].num); }
    break;

  case 267:
#line 2867 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[(1) - (2)].num) | (yyvsp[(2) - (2)].num); }
    break;

  case 268:
#line 2870 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 269:
#line 2873 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 270:
#line 2874 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 278:
#line 2890 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[(3) - (3)].db_type); Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 279:
#line 2891 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[(3) - (3)].db_type); WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 280:
#line 2892 "sql_yacc.yy"
    { Lex->create_info.max_rows= (yyvsp[(3) - (3)].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 281:
#line 2893 "sql_yacc.yy"
    { Lex->create_info.min_rows= (yyvsp[(3) - (3)].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 282:
#line 2894 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=(yyvsp[(3) - (3)].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 283:
#line 2895 "sql_yacc.yy"
    { Lex->create_info.password=(yyvsp[(3) - (3)].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 284:
#line 2896 "sql_yacc.yy"
    { Lex->create_info.comment=(yyvsp[(3) - (3)].lex_str); Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 285:
#line 2897 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=(yyvsp[(3) - (3)].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 286:
#line 2899 "sql_yacc.yy"
    {
            switch((yyvsp[(3) - (3)].ulong_num)) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 287:
#line 2914 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 288:
#line 2919 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[(3) - (3)].ulong_num) ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 289:
#line 2920 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[(3) - (3)].ulong_num) ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 290:
#line 2921 "sql_yacc.yy"
    { Lex->create_info.row_type= (yyvsp[(3) - (3)].row_type);  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 291:
#line 2923 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 292:
#line 2928 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 293:
#line 2933 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 294:
#line 2938 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 297:
#line 2954 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= (yyvsp[(3) - (3)].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 298:
#line 2955 "sql_yacc.yy"
    { Lex->create_info.data_file_name= (yyvsp[(4) - (4)].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 299:
#line 2956 "sql_yacc.yy"
    { Lex->create_info.index_file_name= (yyvsp[(4) - (4)].lex_str).str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 300:
#line 2957 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= (yyvsp[(3) - (3)].lex_str).str; Lex->create_info.connect_string.length= (yyvsp[(3) - (3)].lex_str).length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 301:
#line 2962 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[(4) - (4)].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[(4) - (4)].charset)))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", (yyvsp[(4) - (4)].charset)->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= (yyvsp[(4) - (4)].charset);
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 302:
#line 2979 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[(4) - (4)].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[(4) - (4)].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[(4) - (4)].charset)->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= (yyvsp[(4) - (4)].charset);
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 303:
#line 2995 "sql_yacc.yy"
    {
	  (yyval.db_type) = ha_resolve_by_name((yyvsp[(1) - (1)].lex_str).str,(yyvsp[(1) - (1)].lex_str).length);
	  if ((yyval.db_type) == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 304:
#line 3004 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DEFAULT; }
    break;

  case 305:
#line 3005 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_FIXED; }
    break;

  case 306:
#line 3006 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DYNAMIC; }
    break;

  case 307:
#line 3007 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPRESSED; }
    break;

  case 308:
#line 3008 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_REDUNDANT; }
    break;

  case 309:
#line 3009 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPACT; }
    break;

  case 310:
#line 3012 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 311:
#line 3013 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 312:
#line 3014 "sql_yacc.yy"
    { (yyval.ulong_num)=(yyvsp[(1) - (1)].ulong_num);}
    break;

  case 313:
#line 3017 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_DISABLED; }
    break;

  case 314:
#line 3018 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_FIRST; }
    break;

  case 315:
#line 3019 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_LAST; }
    break;

  case 316:
#line 3022 "sql_yacc.yy"
    {}
    break;

  case 318:
#line 3026 "sql_yacc.yy"
    {(yyval.num) = (int) STRING_RESULT; }
    break;

  case 319:
#line 3027 "sql_yacc.yy"
    {(yyval.num) = (int) REAL_RESULT; }
    break;

  case 320:
#line 3028 "sql_yacc.yy"
    {(yyval.num) = (int) DECIMAL_RESULT; }
    break;

  case 321:
#line 3029 "sql_yacc.yy"
    {(yyval.num) = (int) INT_RESULT; }
    break;

  case 327:
#line 3044 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 328:
#line 3051 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[(1) - (7)].key_type), (yyvsp[(2) - (7)].simple_string), (yyvsp[(7) - (7)].key_alg) ? (yyvsp[(7) - (7)].key_alg) : (yyvsp[(3) - (7)].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);

	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 329:
#line 3059 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    const char *key_name= (yyvsp[(3) - (8)].simple_string) ? (yyvsp[(3) - (8)].simple_string):(yyvsp[(1) - (8)].simple_string);
            Key *key= new Key((yyvsp[(2) - (8)].key_type), key_name, (yyvsp[(4) - (8)].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 330:
#line 3067 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            const char *key_name= (yyvsp[(4) - (8)].simple_string) ? (yyvsp[(4) - (8)].simple_string) : (yyvsp[(1) - (8)].simple_string);
            Key *key= new foreign_key(key_name, lex->col_list,
                                      (yyvsp[(8) - (8)].table),
                                      lex->ref_list,
                                      lex->fk_delete_opt,
                                      lex->fk_update_opt,
                                      lex->fk_match_option);
            lex->alter_info.key_list.push_back(key);
            key= new Key(Key::MULTIPLE, key_name,
                         HA_KEY_ALG_UNDEF, 1,
                         lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 331:
#line 3084 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 332:
#line 3088 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 336:
#line 3103 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 337:
#line 3104 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[(1) - (1)].simple_string); }
    break;

  case 338:
#line 3108 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[(2) - (2)].simple_string); }
    break;

  case 339:
#line 3113 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->length=lex->dec=0; lex->type=0;
	   lex->default_value= lex->on_update_value= 0;
           lex->comment=null_lex_str;
	   lex->charset=NULL;
	 }
    break;

  case 340:
#line 3121 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  if (add_field_to_list(lex->thd, (yyvsp[(1) - (4)].lex_str).str,
				(enum enum_field_types) (yyvsp[(3) - (4)].num),
				lex->length,lex->dec,lex->type,
				lex->default_value, lex->on_update_value, 
                                &lex->comment,
				lex->change,&lex->interval_list,lex->charset,
				lex->uint_geom_type))
	    MYSQL_YYABORT;
	}
    break;

  case 341:
#line 3134 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[(1) - (3)].num); }
    break;

  case 342:
#line 3135 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[(1) - (3)].num); }
    break;

  case 343:
#line 3136 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_FLOAT; }
    break;

  case 344:
#line 3137 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 345:
#line 3139 "sql_yacc.yy"
    { Lex->length= (yyvsp[(3) - (4)].lex_str).str;
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 346:
#line 3141 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 347:
#line 3143 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 348:
#line 3145 "sql_yacc.yy"
    { Lex->length=(yyvsp[(3) - (5)].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 349:
#line 3147 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 350:
#line 3149 "sql_yacc.yy"
    { Lex->length=(yyvsp[(3) - (5)].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 351:
#line 3152 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 352:
#line 3155 "sql_yacc.yy"
    { Lex->length=(yyvsp[(3) - (4)].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 353:
#line 3158 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 354:
#line 3161 "sql_yacc.yy"
    { Lex->length=(yyvsp[(3) - (5)].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 355:
#line 3163 "sql_yacc.yy"
    { Lex->length=(yyvsp[(3) - (5)].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR;
					  Lex->charset=national_charset_info; }
    break;

  case 356:
#line 3166 "sql_yacc.yy"
    { Lex->length=(yyvsp[(3) - (4)].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 357:
#line 3169 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_YEAR; }
    break;

  case 358:
#line 3170 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATE; }
    break;

  case 359:
#line 3171 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TIME; }
    break;

  case 360:
#line 3173 "sql_yacc.yy"
    {
	    if (YYTHD->variables.sql_mode & MODE_MAXDB)
	      (yyval.num)=FIELD_TYPE_DATETIME;
	    else
            {
              /* 
                Unlike other types TIMESTAMP fields are NOT NULL by default.
              */
              Lex->type|= NOT_NULL_FLAG;
	      (yyval.num)=FIELD_TYPE_TIMESTAMP;
            }
	   }
    break;

  case 361:
#line 3185 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATETIME; }
    break;

  case 362:
#line 3186 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 363:
#line 3188 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 364:
#line 3191 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
            Lex->charset=&my_charset_bin;
            Lex->uint_geom_type= (uint)(yyvsp[(1) - (1)].num);
            (yyval.num)=FIELD_TYPE_GEOMETRY;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
            MYSQL_YYABORT;
#endif
          }
    break;

  case 365:
#line 3202 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 366:
#line 3204 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 367:
#line 3206 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 368:
#line 3208 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 369:
#line 3209 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 370:
#line 3210 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 371:
#line 3211 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 372:
#line 3212 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 373:
#line 3214 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 374:
#line 3216 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 375:
#line 3218 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 376:
#line 3219 "sql_yacc.yy"
    {Lex->interval_list.empty();}
    break;

  case 377:
#line 3220 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_ENUM; }
    break;

  case 378:
#line 3221 "sql_yacc.yy"
    { Lex->interval_list.empty();}
    break;

  case 379:
#line 3222 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SET; }
    break;

  case 380:
#line 3223 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 381:
#line 3225 "sql_yacc.yy"
    {
	    (yyval.num)=FIELD_TYPE_LONGLONG;
	    Lex->type|= (AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNSIGNED_FLAG |
		         UNIQUE_FLAG);
	  }
    break;

  case 382:
#line 3233 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRY; }
    break;

  case 383:
#line 3234 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRYCOLLECTION; }
    break;

  case 384:
#line 3235 "sql_yacc.yy"
    { Lex->length= (char*)"25";
                                (yyval.num)= Field::GEOM_POINT;
                              }
    break;

  case 385:
#line 3238 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOINT; }
    break;

  case 386:
#line 3239 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_LINESTRING; }
    break;

  case 387:
#line 3240 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTILINESTRING; }
    break;

  case 388:
#line 3241 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_POLYGON; }
    break;

  case 389:
#line 3242 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOLYGON; }
    break;

  case 390:
#line 3246 "sql_yacc.yy"
    {}
    break;

  case 391:
#line 3250 "sql_yacc.yy"
    {}
    break;

  case 392:
#line 3251 "sql_yacc.yy"
    {}
    break;

  case 393:
#line 3255 "sql_yacc.yy"
    {}
    break;

  case 394:
#line 3256 "sql_yacc.yy"
    {}
    break;

  case 395:
#line 3260 "sql_yacc.yy"
    {}
    break;

  case 396:
#line 3261 "sql_yacc.yy"
    {}
    break;

  case 397:
#line 3262 "sql_yacc.yy"
    {}
    break;

  case 398:
#line 3263 "sql_yacc.yy"
    {}
    break;

  case 399:
#line 3264 "sql_yacc.yy"
    {}
    break;

  case 400:
#line 3268 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG; }
    break;

  case 401:
#line 3269 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 402:
#line 3270 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SHORT; }
    break;

  case 403:
#line 3271 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_INT24; }
    break;

  case 404:
#line 3272 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONGLONG; }
    break;

  case 405:
#line 3275 "sql_yacc.yy"
    { (yyval.num)= YYTHD->variables.sql_mode & MODE_REAL_AS_FLOAT ?
			      FIELD_TYPE_FLOAT : FIELD_TYPE_DOUBLE; }
    break;

  case 406:
#line 3277 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 407:
#line 3278 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 408:
#line 3282 "sql_yacc.yy"
    { Lex->dec=Lex->length= (char*)0; }
    break;

  case 409:
#line 3283 "sql_yacc.yy"
    { Lex->length=(yyvsp[(2) - (3)].lex_str).str; Lex->dec= (char*)0; }
    break;

  case 410:
#line 3284 "sql_yacc.yy"
    {}
    break;

  case 411:
#line 3288 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->length=(yyvsp[(2) - (5)].lex_str).str; lex->dec=(yyvsp[(4) - (5)].lex_str).str;
	}
    break;

  case 412:
#line 3294 "sql_yacc.yy"
    {}
    break;

  case 413:
#line 3295 "sql_yacc.yy"
    {}
    break;

  case 414:
#line 3298 "sql_yacc.yy"
    {}
    break;

  case 415:
#line 3299 "sql_yacc.yy"
    {}
    break;

  case 416:
#line 3302 "sql_yacc.yy"
    {}
    break;

  case 417:
#line 3303 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG;}
    break;

  case 418:
#line 3304 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG | ZEROFILL_FLAG; }
    break;

  case 419:
#line 3307 "sql_yacc.yy"
    { Lex->length=(char*) 0; }
    break;

  case 420:
#line 3308 "sql_yacc.yy"
    { Lex->length= (yyvsp[(2) - (3)].lex_str).str; }
    break;

  case 421:
#line 3311 "sql_yacc.yy"
    {}
    break;

  case 422:
#line 3312 "sql_yacc.yy"
    {}
    break;

  case 423:
#line 3315 "sql_yacc.yy"
    {}
    break;

  case 424:
#line 3316 "sql_yacc.yy"
    {}
    break;

  case 425:
#line 3319 "sql_yacc.yy"
    {}
    break;

  case 427:
#line 3323 "sql_yacc.yy"
    { Lex->type&= ~ NOT_NULL_FLAG; }
    break;

  case 428:
#line 3324 "sql_yacc.yy"
    { Lex->type|= NOT_NULL_FLAG; }
    break;

  case 429:
#line 3325 "sql_yacc.yy"
    { Lex->default_value=(yyvsp[(2) - (2)].item); }
    break;

  case 430:
#line 3327 "sql_yacc.yy"
    { Lex->on_update_value= new Item_func_now_local(); }
    break;

  case 431:
#line 3328 "sql_yacc.yy"
    { Lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG; }
    break;

  case 432:
#line 3330 "sql_yacc.yy"
    { 
	    LEX *lex=Lex;
	    lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 433:
#line 3336 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= PRI_KEY_FLAG | NOT_NULL_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 434:
#line 3342 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 435:
#line 3348 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_KEY_FLAG; 
	    lex->alter_info.flags|= A