## 4.1 서비스프로토콜 개요

+ **멀티프로토콜 지원**

  AnyStor-E은 기본적으로 멀티프로토콜 억세스가 가능합니다.   
  다만 멀티프로토콜간에 lock 및 ACL 정책은 공유되지 않습니다.   

> AnyStor-E의 모든 노드에는 /export/볼륨이름 폴더가 생성되며 모든 노드에서 동일 파일시스템 이미지에 접근이 가능합니다.  
> 해당 폴더는 NFS 및 CIFS/SMB 프로토콜로 공유 및 export 설정이 가능합니다.   
> AnyStor-E 매니저는 테스트 및 튜닝이 완료된 설정만 지원하며, 기타 설정이 필요한 경우는 기술지원을 통해 가능합니다.  

### 4.1.1 프로토콜 기술 요소 설명
> 본 챕터는 NFS/CIFS 서비스 프로토콜의 기본적인 내용을 설명합니다.

#### 4.1.1.1 CIFS / SMB (Common Internet File System)
> AnyStor-E 는 SMB 1,2,3 을 지원합니다. 세부내용은 다음과 같습니다.

| SMB version | Supported Operating System    |
|-----		|------|
| 1           | Windows 2000 or later <br> Windows XP or later <br> Mac OS X 10.5 or later |
| 2           | Windows Vista or later <br> Windows Server 2008 or later       |
| 2.1         | Window 7 or later <br> Windows Server 2008 R2 or later         |
| 3           | Window 8 or later <br> Windows Server 2012 or later <br> Mac OS X 10.11 or later  |

* **CIFS/SMB 프로토콜 개요**
  * CIFS/SMB 프로토콜은 네트워크를 통해 원격지 컴퓨터의 파일이나 데이터에 접근할 수 있게 하는 프로토콜입니다.
  * CIFS/SMB 프로토콜을 사용하면 유저나 도메인, IP 대역에 따라 접근 제어가 다양하게 가능합니다.
  * AnyStor-E는 윈도우즈 환경 및 Linux 및 MacOS 환경 모두 지원합니다.

* **NetBIOS Name**
  * NetBIOS(Network Base Input/Output System): 소프트웨어와 원격지 컴퓨터가 네트워크로 통신할 때 사용하는 통신 프로토콜 입니다.
  * NetBIOS Name은 NetBIOS 프로토콜이 통신 주체가 되는 소프트웨어를 구분하는 기준으로 사용하는 16자 이내의 문자열입니다.

* **WINS (Windows Internet Naming Service)**
  * 윈도우즈 클라이언트에서 사용하는 서비스의 일종입니다.
  * NetBIOS Name과 네트워크 주소(IP)를 연관지어 기억하고 있다가 윈도우즈 클라이언트가 NetBIOS name으로 연결을 해야 할 때 알맞은 네트워크 주소를 알려주는 역할을 합니다.

* **CIFS security mode**
  * CIFS 프로토콜은 파일 시스템에 대한 접근 제어 방식을 여러 종류 지원하는데 이러한 접근 제어 방식 각각을 security mode라고 합니다.

| security mode | security mode 설명           |
|-----		|------|
| **user**      | 사용자가 security mode를 지정하지 않으면 자동으로 설정되는 기본값입니다. <br> 클라이언트의 요청에 포함된 사옹자 이름과 비밀번호를 확인하여 요청을 허용하거나 거부하는 형태로 동작합니다. |
| **ads**       | CIFS 프로토콜의 인증 모듈로 Microsoft ADS(Active Directory Service)를 사용합니다. <br> ADS에 관한 자세한 내용은 **[3.4 외부 인증](34-외부-인증)** 항목을 참조하여 확인할 수 있습니다. |
| **domain**   | CIFS 프로토콜의 사용자나 그룹 계정을 하나의 공유 공간에 집중하여 읽고 쓰는 방법입니다. <br> 클라언트가 보낸 요청을 대상 도메인(workgroup) 내부의 한 서버가 모든 클라이언트의 인증을 수행합니다. <br> 같은 도메인 내의 클라이언트 인증을 도맡아 수행하는 서버를 도메인 컨트롤러라고 하며 도메인 컨트롤 사용자가 지정 할 수도 있고 도메인 내부의 서버중 하나를 도메인 내부 판단에 의해 자동 지정 하기도 합니다. |

#### 4.1.1.2 NFS (Network File System)

* **NFS 개요**
  * NFS는 Unix/Linux 환경에서 주로 사용되는 네트워크 공유 파일시스템입니다.
  * NFS 프로토콜을 사용하면 IP 대역에 따라 공유 접근 제어가 가능합니다.
  * NFS vs CIFS  vs FUSE (전용 프로토콜)

* **프로토콜 비교**

| 특성   |  NFS                   | CIFS             | Fuse (전용 프로토콜)        |
|-----		|------| -----		|------|
| 성능   |  파일 사이즈에 관련없이 일정함   | 큰파일 적합      | 큰 파일 및 병렬 읽기 적합   |
| 안정성 | 세션 연결이 끊어져도 다시 재연결시도    | Failover/Failback 발생시 I/O 중인 파일 끟김 | 좋음 |
| 호환성 | UNIX, Linix, VMware    | Windows, MacOS   | Linux                  |

+ **NFS 호환성**

  AnyStor-E 는 TCP 기반의 **NFS v3 프로토콜이 기본** 설정되어 있습니다.
  **MTU 설정 및 네트워크 환경**이 문제가 있는 공유접근이 원할치 않습니다.

-----

## 4.2 프로토콜 설정

> 클러스터 볼륨을 클라이언트에 공유할 때 사용할 스토리지 공유 서버(Daemon)를 설정하는 기능입니다.  
> 지원하는 프로토콜 서비스는 CIFS, NFS 두 가지입니다.  
> 해당 기능으로 설정한 내용은 같은 프로토콜을 사용하는 모든 공유에도 반영됩니다.  


### 4.2.1 CIFS 설정
> 왼쪽 메뉴트리의 **서비스 프로토콜 >> 프로토콜 설정** 을 클릭하여 CIFS 설정창을 확인할 수 있습니다.  
> CIFS 서비스 **활성/비활성/재시작**을 설정할 수 있습니다.  
> 재시작시 클라이언트에서 **전송중 완료가 되지 않은 파일은 재전송**되지 않습니다.  

* **[서비스 활성화]**
  * 체크 박스가 선택되어 있으면 클러스터의 모든 노드들에 CIFS 서버를 활성화합니다.
* **[서비스 상태]**
  * 클러스터의 CIFS 서버의 on/off를 나타냅니다.
* **[서비서 재시작]**
  * 버튼을 누르면 클러스터의 CIFS 서버를 껐다가 다시 켭니다.
 **[NetBIOS Name]**
  * 클러스터 전체의 CIFS 서버에 할당된 NetBIOS Name을 표기합니다.
  * 클러스터 관리 소프트웨어가 클러스터 노드 중 하나의 호스트명으로 자동 지정합니다.
* **[모드]**
  * 현재 CIFS 프로토콜이 사용중인 security mode를 표기합니다.
  * CIFS 설정 페이지에서 직접 지정할 수 없고 "[3.4 외부 인증](34-외부-인증)"의 설정에 따라 결정됩니다.
* **[작업 그룹]**
  * 클러스터 CIFS 서버들의 작업 그룹을 지정할 수 있습니다.
* **[WINS 서버]**
  * 클러스터 CIFS 서버들이 참조할 WINS 서버를 지정할 수 있습니다.


### 4.2.2 NFS 설정
> 왼쪽 메뉴트리의 **서비스 프로토콜 >> 프로토콜 설정** 을 클릭한 후 NFS 설정 탭을 클릭합니다.  
> NFS 서비스 **활성/비활성/재시작**을 설정할 수 있습니다.    

+ **NFS 설정시 유의사항**  
  
  NFS 서비스는 기본으로 on 입니다.
  서비스 재시작 클라이언트 연결이 잠시 지연될 수 있습니다.

-----

* **[서비스 활성화]**
  * 체크 박스가 선택되어 있으면 클러스터의 모든 노드들에 NFS 서버를 활성화합니다.
* **[서비스 상태]**
  * 클러스터의 NFS 서버의 on/off를 나타냅니다.
* **[서비서 재시작]**
  * 버튼을 누르면 클러스터의 NFS 서버를 껐다가 다시 켭니다.
* **[공통 옵션]**
  * 모든 nfs 서버에 적용되는 옵션들을 지정할 수 있습니다.
