<?php
use \Michelf\MarkdownExtra;
require_once '../markdown/MarkdownExtra.inc.php';
// Read file and pass content through the Markdown parser

function replaceLink($text)
{
	$text = str_replace("(#1", "(#cluster.xhtml#1",$text);
	$text = str_replace("(#2", "(#clusterVolume.xhtml#2",$text);
	$text = str_replace("(#3", "(#account.xhtml#3",$text);
	$text = str_replace("(#4", "(#share.xhtml#4",$text);
	$text = str_replace("(#5", "(#node.xhtml#5",$text);
	$text = str_replace("(#6", "(#support.xhtml#6",$text);
	$text = str_replace("(#7", "(#troubleshoot.xhtml#7",$text);

	return $text;
}

//클러스터
if($_POST['type'] == 'intro')
{
	$clusterMd = '/var/www/html/public/_manual/doc/eng/intro';
	$clusterImg = '/_manual/doc/eng/intro';

	$intro = file_get_contents($clusterMd.'/intro.md');
	$intro = str_replace("./images/", $clusterImg."/images/",$intro);
	$intro = replaceLink($intro);

	$markDownData = $intro;
}

//클러스터
if($_POST['type'] == 'cluster')
{
	$clusterMd = '/var/www/html/public/_manual/doc/eng/cluster';
	$clusterImg = '/_manual/doc/eng/cluster';

	$intro = file_get_contents($clusterMd.'/intro.md');
	$intro = str_replace("./images/", $clusterImg."/images/",$intro);
	$intro = replaceLink($intro);

	$overview = file_get_contents($clusterMd.'/overview.md');
	$overview = str_replace("./images/", $clusterImg."/images/",$overview);
	$overview = replaceLink($overview);

	$clusterNode = file_get_contents($clusterMd.'/clusterNode.md');
	$clusterNode = str_replace("./images/", $clusterImg."/images/",$clusterNode);
	$clusterNode = replaceLink($clusterNode);

	$event = file_get_contents($clusterMd.'/event.md');
	$event = str_replace("./images/", $clusterImg."/images/",$event);
	$event = replaceLink($event);

	$network = file_get_contents($clusterMd.'/network.md');
	$network = str_replace("./images/", $clusterImg."/images/",$network);
	$network = replaceLink($network);

	$mail = file_get_contents($clusterMd.'/mail.md');
	$mail = str_replace("./images/", $clusterImg."/images/",$mail);
	$mail = replaceLink($mail);

	$time = file_get_contents($clusterMd.'/time.md');
	$time = str_replace("./images/", $clusterImg."/images/",$time);
	$time = replaceLink($time);

	$power = file_get_contents($clusterMd.'/power.md');
	$power = str_replace("./images/", $clusterImg."/images/",$power);
	$power = replaceLink($power);

	$log = file_get_contents($clusterMd.'/log.md');
	$log = str_replace("./images/", $clusterImg."/images/",$log);
	$log = replaceLink($log);
	$license = file_get_contents($clusterMd.'/license.md');
	$license = str_replace("./images/", $clusterImg."/images/",$license);
	$license = replaceLink($license);

	$markDownData = $intro."\n\n\n".$overview."\n\n\n".$clusterNode."\n\n\n".$event."\n\n\n".$network."\n\n\n".$mail."\n\n\n".$time."\n\n\n".$power."\n\n\n".$log."\n\n\n".$license;
}
//클러스터 볼륨
if($_POST['type'] == 'clusterVolume')
{
	$clusterVolumeMd = '/var/www/html/public/_manual/doc/eng/clusterVolume';
	$clusterVolumeImg = '/_manual/doc/eng/clusterVolume';

	$intro = file_get_contents($clusterVolumeMd.'/intro.md');
	$intro = str_replace("./images/", $clusterVolumeImg."/images/",$intro);
	$intro = replaceLink($intro);

	$volume = file_get_contents($clusterVolumeMd.'/volume.md');
	$volume = str_replace("./images/", $clusterVolumeImg."/images/",$volume);
	$volume = replaceLink($volume);

	$volumePool = file_get_contents($clusterVolumeMd.'/volumePool.md');
	$volumePool = str_replace("./images/", $clusterVolumeImg."/images/",$volumePool);
	$volumePool = replaceLink($volumePool);

	$snapshot = file_get_contents($clusterVolumeMd.'/snapshot.md');
	$snapshot = str_replace("./images/", $clusterVolumeImg."/images/",$snapshot);
	$snapshot = replaceLink($snapshot);

	$markDownData = $intro."\n\n\n".$volumePool."\n\n\n".$volume."\n\n\n".$snapshot;
	//echo $markDownData;
}
//계정
if($_POST['type'] == 'account')
{
	$accountMd = '/var/www/html/public/_manual/doc/eng/account';
	$accountImg = '/_manual/doc/eng/account';

	$intro = file_get_contents($accountMd.'/intro.md');
	$intro = str_replace("./images/", $accountImg."/images/",$intro);
	$intro = replaceLink($intro);

	$user = file_get_contents($accountMd.'/user.md');
	$user = str_replace("./images/", $accountImg."/images/",$user);
	$user = replaceLink($user);

	$group = file_get_contents($accountMd.'/group.md');
	$group = str_replace("./images/", $accountImg."/images/",$group);
	$group = replaceLink($group);

	$external = file_get_contents($accountMd.'/external.md');
	$external = str_replace("./images/", $accountImg."/images/",$external);
	$external = replaceLink($external);

	$admin = file_get_contents($accountMd.'/admin.md');
	$admin = str_replace("./images/", $accountImg."/images/",$admin);
	$admin = replaceLink($admin);

	$markDownData = $intro."\n\n\n".$user."\n\n\n".$group."\n\n\n".$external."\n\n\n".$admin;
}
//서비스 프로토콜
if($_POST['type'] == 'share')
{
	$shareMd = '/var/www/html/public/_manual/doc/eng/share';
	$shareImg = '/_manual/doc/eng/share';

	$intro = file_get_contents($shareMd.'/intro.md');
	$intro = str_replace("./images/", $shareImg."/images/",$intro);
	$intro = replaceLink($intro);

	$protocol = file_get_contents($shareMd.'/protocol.md');
	$protocol = str_replace("./images/", $shareImg."/images/",$protocol);
	$protocol = replaceLink($protocol);

	$share = file_get_contents($shareMd.'/share.md');
	$share = str_replace("./images/", $shareImg."/images/",$share);
	$share = replaceLink($share);

	$markDownData = $intro."\n\n\n".$protocol."\n\n\n".$share;
}
//노드 관리
if($_POST['type'] == 'node')
{
	$nodeMd = '/var/www/html/public/_manual/doc/eng/node';
	$nodeImg = '/_manual/doc/eng/node';

	$intro = file_get_contents($nodeMd.'/intro.md');
	$intro = str_replace("./images/", $nodeImg."/images/",$intro);
	$intro = replaceLink($intro);

	$condition = file_get_contents($nodeMd.'/condition.md');
	$condition = str_replace("./images/", $nodeImg."/images/",$condition);
	$condition = replaceLink($condition);

	$disk = file_get_contents($nodeMd.'/disk.md');
	$disk = str_replace("./images/", $nodeImg."/images/",$disk);
	$disk = replaceLink($disk);

	$volume = file_get_contents($nodeMd.'/volume.md');
	$volume = str_replace("./images/", $nodeImg."/images/",$volume);
	$volume = replaceLink($volume);

	$process = file_get_contents($nodeMd.'/process.md');
	$process = str_replace("./images/", $nodeImg."/images/",$process);
	$process = replaceLink($process);

	$raid = file_get_contents($nodeMd.'/raid.md');
	$raid = str_replace("./images/", $nodeImg."/images/",$raid);
	$raid = replaceLink($raid);

	$bond = file_get_contents($nodeMd.'/bond.md');
	$bond = str_replace("./images/", $nodeImg."/images/",$bond);
	$bond = replaceLink($bond);

	$device = file_get_contents($nodeMd.'/device.md');
	$device = str_replace("./images/", $nodeImg."/images/",$device);
	$device = replaceLink($device);

	$address = file_get_contents($nodeMd.'/address.md');
	$address = str_replace("./images/", $nodeImg."/images/",$address);
	$address = replaceLink($address);

	$power = file_get_contents($nodeMd.'/power.md');
	$power = str_replace("./images/", $nodeImg."/images/",$power);
	$power = replaceLink($power);

	$markDownData = $intro."\n\n\n".$condition."\n\n\n".$disk."\n\n\n".$volume."\n\n\n".$process."\n\n\n".$raid."\n\n\n".$bond."\n\n\n".$device."\n\n\n".$address."\n\n\n".$power;
}

//장애 대응: 공통 사항
if($_POST['type'] == 'troubleshoot_common')
{
	$troubleshootMd = '/var/www/html/public/_manual/doc/eng/troubleshoot';
	$troubleshootImg = '/_manual/doc/eng/troubleshoot';

	$common = file_get_contents($troubleshootMd.'/common.md');
	$common = str_replace("./images/", $troubleshootImg."/images/",$common);
	$common = replaceLink($common);

	$markDownData = $common;
}

//장애 대응: 이벤트에 대항 장애
if($_POST['type'] == 'troubleshoot_event')
{
	$troubleshootMd = '/var/www/html/public/_manual/doc/eng/troubleshoot';
	$troubleshootImg = '/_manual/doc/eng/troubleshoot';

	$event = file_get_contents($troubleshootMd.'/events.md');
	$event = str_replace("./images/", $troubleshootImg."/images/",$event);
	$event = replaceLink($event);

	$markDownData = $event;
}

//장애 대응: 상태 및 스테이지에 따른 장애
if($_POST['type'] == 'troubleshoot_status')
{
	$troubleshootMd = '/var/www/html/public/_manual/doc/eng/troubleshoot';
	$troubleshootImg = '/_manual/doc/eng/troubleshoot';

	$status = file_get_contents($troubleshootMd.'/status.md');
	$status = str_replace("./images/", $troubleshootImg."/images/",$status);
	$status = replaceLink($status);

	$markDownData = $status;
}

//장애 대응: I/O 장애
if($_POST['type'] == 'troubleshoot_ioservice')
{
	$troubleshootMd = '/var/www/html/public/_manual/doc/eng/troubleshoot';
	$troubleshootImg = '/_manual/doc/eng/troubleshoot';

	$ioservice = file_get_contents($troubleshootMd.'/ioservice.md');
	$ioservice = str_replace("./images/", $troubleshootImg."/images/",$ioservice);
	$ioservice = replaceLink($ioservice);

	$markDownData = $ioservice;
}

$html = MarkdownExtra::defaultTransform($markDownData);
echo $html;
?>
