/*
 * Decompiled with CFR 0.152.
 */
package COM.legato.remagents.fsra;

import COM.legato.gst.GtAttr;
import COM.legato.gst.GtAttrList;
import COM.legato.gst.GtObject;
import COM.legato.gst.GtObjectList;
import COM.legato.gst.GtPath;
import COM.legato.gst.GtValue;
import COM.legato.gst.GtValueList;
import COM.legato.gwt.api.GwtDialog;
import COM.legato.gwt.api.GwtWizard;
import COM.legato.gwt.api.ServiceProvider;
import COM.legato.gwt.components.Util;
import COM.legato.gwt.gtpanel.GtActionEvent;
import COM.legato.networker.NetWorkerConstants;
import COM.legato.networker.remote.RemoteAgentConfigApi;
import COM.legato.networker.remote.RemoteAgentConfigWizardInteractionApi;
import COM.legato.networker.remote.RemoteAgentWizard;
import COM.legato.networker.remote.RemoteAgentWizardInteractionApi;
import COM.legato.remagents.fsra.FSPluginConstants;
import COM.legato.util.I18N;
import COM.legato.util.Sort;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileSystemConfigWizardPlugin
implements RemoteAgentConfigApi {
    private static final String CLIENT_SAVEOP_VSS_DR = "VSS:DISASTER_RECOVERY=";
    private static final String CLIENT_SAVEOP_VSS_DR_OFF = "VSS:DISASTER_RECOVERY=off";
    private static final String GTP_SS_DR_SUPPORT = "/display_desc/attribute_display/components/page_browse/components/win_disaster_recovery_panel/visible";
    RemoteAgentConfigWizardInteractionApi interaction;
    String filesystem;
    GwtWizard wizard;
    GtValueList treeRootValues;
    boolean isWindowDR = false;
    boolean hasDROffFlag = false;

    public void setInteractionApi(RemoteAgentWizardInteractionApi interaction) {
        this.interaction = (RemoteAgentConfigWizardInteractionApi)interaction;
        this.isWindowDR = this.isDRSupported();
    }

    public int[] modifyWizardAttributeDisplay(GtAttrList attributeDisplay) throws Exception {
        int[] pageMap = new int[]{-1};
        return pageMap;
    }

    public GtAttrList getWizardInstance() throws Exception {
        GtAttrList al = new GtAttrList();
        al.addAttr(new GtAttr("name", new GtValue(this.interaction.getRemoteAgentHost())));
        al.addAttr(new GtAttr("object_type", new GtValue("client")));
        GtAttrList fsAl = new GtAttrList();
        fsAl.addAttr(new GtAttr("file_browser", new GtValue(al)));
        if (this.isWindowDR) {
            GtAttrList cal = this.interaction.getClientInitialValues();
            GtAttr saveop = cal.getAttr("Save operations");
            GtValue val = GtPath.newInstance().selectFirstValue(saveop, "Save operations");
            if (val != null && FileSystemConfigWizardPlugin.hasDRFlag(val.getStringValue())) {
                this.hasDROffFlag = true;
            }
            fsAl.addAttr(new GtAttr("win_disaster_recovery", new GtValue(!this.hasDROffFlag)));
        }
        GtAttrList alfs = new GtAttrList();
        alfs.addAttr(new GtAttr("fs_wiz", new GtValue(fsAl)));
        return alfs;
    }

    public GtObject getWizardMeta() throws Exception {
        GtValue val;
        GtObject meta = Util.getGuiMetaObject(this.getClass(), (String)"/oily/fsra/meta", (String)"filesystem_wizard_plugin");
        if (this.isWindowDR && (val = GtPath.newInstance().selectFirstValue(meta, GTP_SS_DR_SUPPORT)) != null) {
            val.setBooleanValue(true);
        }
        return meta;
    }

    public GtAttrList getClientCreateAttrs() {
        GtAttrList al = new GtAttrList();
        GtAttr ss = new GtAttr("save set", 6);
        ss.addValueList(this.buildSaveSetValueList());
        al.addAttr(ss);
        if (this.isWindowDR) {
            String saveop = null;
            GtAttrList cal = this.interaction.getClientInitialValues();
            GtAttr attr = cal.getAttr("Save operations");
            GtValue val = GtPath.newInstance().selectFirstValue(attr, "Save operations");
            if (val != null) {
                saveop = val.getStringValue();
            }
            if ((saveop = this.hasDROffFlag ? FileSystemConfigWizardPlugin.insertDRFlag(saveop) : FileSystemConfigWizardPlugin.removeDRFlag(saveop)) != null) {
                attr = new GtAttr("Save operations", 6);
                attr.addValue(new GtValue(saveop));
                al.addAttr(attr);
            }
        }
        return al;
    }

    public GtAttrList getClientCreateReviewContents() {
        GtAttrList results = new GtAttrList();
        GtAttr attr = new GtAttr(I18N.JI18N((int)77585, (String)"Save set"), 6);
        attr.addValueList(this.buildSaveSetValueList());
        results.addAttr(attr);
        if (this.isWindowDR) {
            attr = new GtAttr(I18N.JI18N((int)83533, (String)"Enable Disaster Recovery"), 6);
            attr.addValue(new GtValue(this.hasDROffFlag ? "false" : "true"));
            results.addAttr(attr);
        }
        return results;
    }

    protected boolean isDRSupported() {
        try {
            GtValue val;
            GtObject query = new GtObject();
            query.addAttr(new GtAttr("message type", new GtValue("is dr supported")));
            GtObjectList res = null;
            try {
                Vector<String> types = new Vector<String>();
                types.addElement("is dr supported");
                res = this.interaction.sendRemoteAgentMessage(query, types);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (res != null && res.size() > 0 && (val = GtPath.newInstance().selectFirstValue((GtObject)res.get(0), "is dr supported")) != null) {
                return val.getBooleanValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isDedupSupported() {
        return true;
    }

    public boolean isDataDomainPoolSupported() {
        return true;
    }

    public boolean isMediaPoolSupported() {
        return true;
    }

    public void gtActionPerformed(GtActionEvent e) {
        if (e.getCommand().equals(GwtWizard.NEXT_BUTTON)) {
            if (this.interaction.getWizard().getPageName(this.interaction.getWizard().getNextPage()).equals("page_browse")) {
                this.processBrowsePage(e);
            }
        } else if (e.getCommand().equals(GwtWizard.BACK_BUTTON)) {
            if (this.interaction.getWizard().getPageName(this.interaction.getWizard().getPreviousPage()).equals("page_browse")) {
                this.processBrowsePage(e);
            }
        } else if (e.getCommand().equals("click") && e.getName().equals("Sidebar") && e.getData().equals(FSPluginConstants.GTA_NWFSRAWIZ_PAGE_BROWSE_SIDEBAR)) {
            this.processBrowsePage(e);
        } else if (e.getCommand().equals("selectionChanged") && e.getName().equals("fs_wiz.win_disaster_recovery")) {
            GtAttr drattr = this.interaction.getWizard().getPanel().getAttr("fs_wiz.win_disaster_recovery");
            GtValue val = GtPath.newInstance().selectFirstValue(drattr, "/fs_wiz/win_disaster_recovery");
            this.hasDROffFlag = val != null && !val.getBooleanValue();
            GtAttr ss = this.interaction.getWizard().getPanel().getSelection("fs_wiz.file_browser");
            GtAttrList bral = GtPath.newInstance().selectAttrs(ss, "/fs_wiz/file_browser");
            GtAttrList al = new GtAttrList();
            al.addAttr(new GtAttr("name", new GtValue(this.interaction.getRemoteAgentHost())));
            al.addAttr(new GtAttr("object_type", new GtValue("client")));
            al.addAttr(new GtAttr("string_value", new GtValue("All")));
            GtAttr attr = new GtAttr("file_browser", new GtValue(al));
            al = new GtAttrList();
            al.addAttr(attr);
            attr = new GtAttr("fs_wiz", new GtValue(al));
            this.interaction.getWizard().getPanel().setAttr("fs_wiz.file_browser", attr);
            if (bral != null && bral.size() > 0) {
                this.interaction.getWizard().getPanel().setSelection("fs_wiz.file_browser", (GtAttr)bral.get(0));
            }
        } else if (e.getCommand().equals("treePathChecked") && e.getName().equals("fs_wiz.file_browser")) {
            this.processBrowsePage(e);
        } else if (e.getCommand().equals("treeExpanded") && e.getName().equals("fs_wiz.file_browser")) {
            Vector vec = (Vector)e.getData();
            if (vec.size() < 1) {
                return;
            }
            vec.removeElementAt(0);
            GtValueList vl = null;
            vl = vec.size() == 0 && this.treeRootValues != null ? this.treeRootValues : this.listDirectory(vec.size() == 0 ? null : vec);
            vec.removeAllElements();
            if (vl != null) {
                vec.addElement(vl);
            }
            if (this.isWindowDR) {
                if (this.hasDROffFlag) {
                    this.hideSystemVolume(vec, "DISASTER_RECOVERY");
                } else {
                    this.hideSystemVolume(vec, "VSS");
                }
            }
        }
    }

    private void processBrowsePage(GtActionEvent e) {
        this.fetchTreeRootValues();
        this.interaction.getWizard().setNextButtonName(GwtWizard.NEXT_BUTTON);
        GtValueList vl = RemoteAgentWizard.getValueListForAttr((GwtWizard)this.interaction.getWizard(), (String)"fs_wiz.file_browser", (String)"file_browser");
        if (vl == null || vl.size() == 0) {
            this.interaction.getWizard().disableWizardButton(GwtWizard.NEXT_BUTTON);
            if (e != null && e.getName().equals("Sidebar")) {
                this.interaction.getWizard().setCurrentPage(e.getData().toString());
            }
            this.interaction.getWizard().clearSidebar();
        } else {
            this.interaction.getWizard().enableWizardButton(GwtWizard.NEXT_BUTTON);
        }
    }

    private void fetchTreeRootValues() {
        GtAttrList top;
        if (this.treeRootValues != null) {
            return;
        }
        this.treeRootValues = this.listDirectory(null);
        Object[] oa = new Object[this.treeRootValues.size()];
        this.treeRootValues.copyInto(oa);
        Sort.sort((Object[])oa, (int)1, (Sort.Comparator)new Sort.Comparator(){

            public int compare(Object obj1, Object obj2) {
                String str1 = ((GtValue)obj1).getAttrListValue().getSingleValueForAttr("name").getStringValue();
                String str2 = ((GtValue)obj2).getAttrListValue().getSingleValueForAttr("name").getStringValue();
                if (str1.length() - str2.length() < 0) {
                    return 1;
                }
                if (str1.length() - str2.length() > 0) {
                    return -1;
                }
                return 0;
            }

            public int compare(int index1, int index2) {
                return 0;
            }
        });
        this.treeRootValues.removeAllElements();
        for (Object obj : oa) {
            this.treeRootValues.addElement((Object)((GtValue)obj));
        }
        GtValueList savesets = this.interaction.getClientInitialValues().getValueListForAttr("save set");
        GtAttr treeSelection = new GtAttr("file_browser", 9);
        GtAttrList current = top = new GtAttrList();
        current.addAttr(new GtAttr("name", new GtValue(this.interaction.getRemoteAgentHost())));
        if (savesets.size() == 1 && savesets.valueAt(0).getStringValue().equalsIgnoreCase("All")) {
            treeSelection.addValue(new GtValue(top));
        } else {
            GtAttr attr = new GtAttr("children", new GtValue(new GtAttrList()));
            current.addAttr(attr);
            GtAttrList client = current = attr.getValueList().valueAt(0).getAttrListValue();
            for (int i = 0; i < savesets.size(); ++i) {
                GtValue val = savesets.valueAt(i);
                String saveSet = val.getStringValue();
                saveSet = this.stripTrailingPathSep(saveSet);
                String matchingRoot = null;
                for (GtValue value : this.treeRootValues) {
                    String tmp = value.getAttrListValue().getSingleValueForAttr("name").getStringValue();
                    if (saveSet.startsWith(tmp, 0)) {
                        matchingRoot = tmp;
                    }
                    if (matchingRoot == null) continue;
                    String ss = saveSet.substring(matchingRoot.length());
                    current.addAttr(new GtAttr("name", new GtValue(matchingRoot)));
                    if (ss != null && ss.length() != 0) {
                        attr = new GtAttr("children", new GtValue(new GtAttrList()));
                        current.addAttr(attr);
                        current = attr.getValueList().valueAt(0).getAttrListValue();
                    } else {
                        GtAttr childrenAttr = current.getAttr("children");
                        if (childrenAttr != null) {
                            current.remove((Object)childrenAttr);
                        }
                    }
                    StringTokenizer st = new StringTokenizer(ss, this.getPathSep());
                    while (st.hasMoreTokens()) {
                        String tok = st.nextToken();
                        current.addAttr(new GtAttr("name", new GtValue(tok)));
                        if (!st.hasMoreTokens()) continue;
                        attr = new GtAttr("children", new GtValue(new GtAttrList()));
                        current.addAttr(attr);
                        current = attr.getValueList().valueAt(0).getAttrListValue();
                    }
                    treeSelection.addValue(new GtValue(top));
                    current = client;
                }
            }
        }
        this.interaction.getWizard().getPanel().setSelection("fs_wiz.file_browser", treeSelection);
    }

    public GtValueList listDirectory(Vector pathComponents) {
        GtObject query = new GtObject();
        query.addAttr(new GtAttr("message type", new GtValue("list files")));
        if (pathComponents != null) {
            String path = "";
            for (int i = 0; i < pathComponents.size(); ++i) {
                if (i != 0 || this.filesystem.equals("unix")) {
                    path = path + this.getPathSep();
                }
                GtValue val = (GtValue)pathComponents.elementAt(i);
                path = path + val.getAttrListValue().getSingleValueForAttr("name");
            }
            query.addAttr(new GtAttr("dir", new GtValue(path)));
        } else {
            query.addAttr(new GtAttr("list fstab", 6));
        }
        GtObjectList res = null;
        try {
            Vector<String> types = new Vector<String>();
            types.addElement("client");
            types.addElement("disk");
            types.addElement("system volume");
            types.addElement("dir");
            types.addElement("file");
            res = this.interaction.sendRemoteAgentMessage(query, types);
        }
        catch (Exception e) {
            GwtDialog.exceptionDialog((ServiceProvider)this.interaction.getServiceProvider(), (Throwable)e);
        }
        if (this.filesystem == null && res != null && res.size() > 0) {
            this.filesystem = res.objectAt(0).getAttrList().getSingleValueForAttr("filesystem type").getStringValue();
        }
        GtValueList vl = null;
        if (res != null) {
            vl = new GtValueList();
            for (int i = 0; i < res.size(); ++i) {
                GtValue matchCase = new GtValue(!"windows".equalsIgnoreCase(this.filesystem));
                res.objectAt(i).getAttrList().add((Object)new GtAttr("match_case", matchCase));
                vl.addValue(new GtValue(res.objectAt(i).getAttrList()));
            }
        }
        return vl;
    }

    private String getPathSep() {
        if (this.filesystem.equals("unix")) {
            return "/";
        }
        return "\\";
    }

    private GtValueList buildSaveSetValueList() {
        GtValueList vl = new GtValueList();
        GtValue val = RemoteAgentWizard.getValueForAttr((GwtWizard)this.interaction.getWizard(), (String)"fs_wiz.file_browser", (String)"file_browser");
        if (val == null) {
            this.processBrowsePage(null);
            this.interaction.getWizard().setNextButtonName(NetWorkerConstants.GTV_MODIFY_BUTTON);
            val = RemoteAgentWizard.getValueForAttr((GwtWizard)this.interaction.getWizard(), (String)"fs_wiz.file_browser", (String)"file_browser");
        }
        if (val != null) {
            GtAttrList al = val.getAttrListValue();
            GtValueList base = al.getValueListForAttr("children");
            if (base == null) {
                vl.addValue(new GtValue("All"));
                return vl;
            }
            this.traverseChildren(vl, base, null);
        }
        return vl;
    }

    private void traverseChildren(GtValueList results, GtValueList nodes, String path) {
        for (int i = 0; i < nodes.size(); ++i) {
            GtAttrList al = nodes.valueAt(i).getAttrListValue();
            GtValueList children = al.getValueListForAttr("children");
            String newPath = null;
            newPath = path == null ? al.getSingleValueForAttr("name").getStringValue() : path + (path.endsWith(this.getPathSep()) ? "" : this.getPathSep()) + al.getSingleValueForAttr("name").getStringValue();
            if (children != null && children.size() > 0) {
                this.traverseChildren(results, children, newPath);
                continue;
            }
            if (this.filesystem.equals("windows") && newPath.endsWith(":")) {
                newPath = newPath + "\\";
            }
            if (results.contains((Object)new GtValue(newPath))) continue;
            results.addValue(new GtValue(newPath));
        }
    }

    private String stripTrailingPathSep(String s) {
        if (s != null && s.endsWith(this.getPathSep())) {
            s = s.substring(0, s.length() - 1);
            return this.stripTrailingPathSep(s);
        }
        return s;
    }

    protected void hideSystemVolume(Object obj, String volname) {
        if (!(obj instanceof Vector)) {
            return;
        }
        Vector v = (Vector)obj;
        if (v.size() == 0 || !(v.get(0) instanceof GtValueList)) {
            return;
        }
        GtValueList vl = (GtValueList)v.get(0);
        GtValueList vallist = new GtValueList();
        for (GtValue val : vl) {
            GtValue name = val.getAttrListValue().getSingleValueForAttr("name");
            GtValue type = val.getAttrListValue().getSingleValueForAttr("object_type");
            if (type != null && type.getStringValue().equalsIgnoreCase("system volume") && name != null && name.getStringValue().toUpperCase().startsWith(volname)) continue;
            vallist.add((Object)val);
        }
        v.set(0, vallist);
    }

    public static String insertDRFlag(String saveop) {
        if (saveop == null) {
            return CLIENT_SAVEOP_VSS_DR_OFF;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer tz = new StringTokenizer(saveop, ";");
        boolean found = false;
        while (tz.hasMoreTokens()) {
            String token = tz.nextToken();
            if (token.startsWith(CLIENT_SAVEOP_VSS_DR)) {
                found = true;
                token = CLIENT_SAVEOP_VSS_DR_OFF;
            }
            sb.append(token).append(";");
        }
        if (!found) {
            sb.append(CLIENT_SAVEOP_VSS_DR_OFF);
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ';') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String removeDRFlag(String saveop) {
        if (saveop == null) {
            return saveop;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer tz = new StringTokenizer(saveop, ";");
        while (tz.hasMoreTokens()) {
            String token = tz.nextToken();
            if (token.startsWith(CLIENT_SAVEOP_VSS_DR)) continue;
            sb.append(token).append(";");
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ';') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean hasDRFlag(String saveop) {
        if (saveop == null) {
            return false;
        }
        StringTokenizer tz = new StringTokenizer(saveop, ";");
        while (tz.hasMoreTokens()) {
            String token = tz.nextToken();
            if (!token.equalsIgnoreCase(CLIENT_SAVEOP_VSS_DR_OFF)) continue;
            return true;
        }
        return false;
    }
}

