#!/bin/bash
#This file is module.upgrade.sh template by kpkim@gluesys.com
#history :
# Wed May  6 14:16:14 KST 2009 : upgradectl v1.0 compatible
# From gbkwon gbkwon@gluesys.com 2009/05/13

# Strict Field
MODE="online"    #reboot/service-off/online
MOD_NAME="gbs"
MOD_VERSION="4.2.2.16"
BUILD_NUMBER="(build 15198)"
VERBOSE_LOG=/dev/shm/upgrade_verbose.log

CMD="$1"
REP="$2"
QUIET="$3"

return_result ()
{
    RET=$?
    DATE=$(date +%x" "%X)
    CONTENT=$1
    ERROR=$2
    [ "$ERROR" = "t" ] && RET=0
    [ "$ERROR" = "f" ] && RET=1

    if [ $RET = 0 ]; then
        echo "$DATE >> $MOD_NAME >> $CONTENT ok" >> $VERBOSE_LOG
        [ "$QUIET" = "" ] && echo "$DATE >> $MOD_NAME >> $CONTENT ok"
    else
        echo "$DATE >> $MOD_NAME >> $CONTENT fail" >> $VERBOSE_LOG
        [ "$QUIET" = "" ] && echo "$DATE >> $MOD_NAME >> $CONTENT failed"
        exit 1
    fi
}

mode_cmd ()
{
    echo $MODE
    return 0
}

version_cmd ()
{
    echo $MOD_VERSION
    return 0
}

install_cmd ()
{
    
    # remove old file

    # file install
    tar xfz $REP/$MOD_NAME.dat -C / >&/dev/null
    return_result "Unpacking upgrade files version $MOD_NAME.dat on $REP"

    return_result "$MOD_NAME patch script complete" "t"
    return 0
}

rollback_cmd ()
{
    return 0
}

pre_cmd ()
{
    return 0
}

post_cmd ()
{

    # update version
    echo "$MOD_VERSION $BUILD_NUMBER" > /etc/gluestor/version
    return 0
}

case "$CMD" in
mode)
    mode_cmd
    RETVAL=$?
    ;;
pre)
    pre_cmd
    RETVAL=$?
    ;;
install)
    install_cmd
    RETVAL=$?
    ;;
rollback)
    rollback_cmd
    RETVAL=$?
    ;;
post)
    post_cmd
    RETVAL=$?
    ;;
version)
    version_cmd
    RETVAL=$?
    ;;
*)
    exit 1;
esac

exit $RETVAL

# vim:set et:
