#!/bin/bash
#This file is module.upgrade.sh template by kpkim@gluesys.com
#history :
# Wed May  6 14:16:14 KST 2009 : upgradectl v1.0 compatible
# kpkim@gluesys.com 2009. 06. 08. () 10:42:52 KST

# Strict Field
MODE="service-off"    #reboot/service-off/online
MOD_NAME="gms"
MOD_VERSION="4.2.2.16"
VERBOSE_LOG=/dev/shm/upgrade_verbose.log

CMD="$1"
REP="$2"
QUIET="$3"

# Private Field

return_result ()
{
    RET=$?
    DATE=$(date +%x" "%X)
    CONTENT=$1
    ERROR=$2
    [ "$ERROR" = "t" ] && RET=0
    [ "$ERROR" = "f" ] && RET=1

    if [ $RET = 0 ]; then
        echo "$DATE >> $MOD_NAME >> $CONTENT ok" >> $VERBOSE_LOG
        [ "$QUIET" = "" ] && echo "$DATE >> $MOD_NAME >> $CONTENT ok"
    else
        echo "$DATE >> $MOD_NAME >> $CONTENT fail" >> $VERBOSE_LOG
        [ "$QUIET" = "" ] && echo "$DATE >> $MOD_NAME >> $CONTENT failed"
        [ "$ERROR" != "p" ] && exit 1
    fi
}

mode_cmd ()
{
    echo $MODE
    return 0
}

version_cmd ()
{
    echo $MOD_VERSION
    return 0
}

install_cmd ()
{
    # file install
    tar xfz $REP/$MOD_NAME.dat -C /
    return_result "Unpacking upgrade files version $MOD_NAME.dat on $REP"

    /anystor/bin/GMS_ln GMS

    ha_status=$( /anystor/bin/GSoption -ev HA | cut -d= -f2 )
    if [ "$ha_status" = "yes" ]; then
        /anystor/bin/svc_lock LOCK CIFS
        return_result "locking cifs service" "p"
    fi

    /etc/init.d/smb restart
    return_result "restart cifs service"

    if [ "$ha_status" = "yes" ]; then
        /anystor/bin/svc_lock UNLOCK CIFS
        return_result "unlocking cifs service" "p"
    fi

    return_result "$MOD_NAME patch script complete" "t"
    return 0
}

rollback_cmd ()
{ 
    # rollback dummy file
    return 0
}

pre_cmd ()
{
    # backup
    return 0
}

post_cmd ()
{
    /etc/init.d/syslog-ng restart
    return_result "syslog restart"

    return 0
}

case "$CMD" in
mode)
    mode_cmd
    RETVAL=$?
    ;;
pre)
    pre_cmd
    RETVAL=$?
    ;;
install)
    install_cmd
    RETVAL=$?
    ;;
rollback)
    rollback_cmd
    RETVAL=$?
    ;;
post)
    post_cmd
    RETVAL=$?
    ;;
version)
    version_cmd
    RETVAL=$?
    ;;
*)
    exit 1;
esac

exit $RETVAL

# vim:set et:
