#!/bin/bash

echo 
echo "glibc vulnerability update for gluesys nas" 
echo 

#check glibc version and env
echo -n "check gluesys nas version..."
machin=`uname -m`

if [ $machin == "x86_64" -a -e "/lib64/libc-2.6.1.so" -a -x /bin/busybox ] ; then

    echo ok
    echo
    echo -n "check ghost vulnerability... "
    echo -n "this system "
    ./GHOST

    if [ $? -eq 1 ]; then
        # glibc update

        echo
        echo "update glibc ..."

        cp -a /lib64/libc-2.6.1.so libc-2.6.1.so.old
        cp -a /lib32/libc-2.6.1.so libc-2.6.1.so.32.old
        busybox cp -a libc-2.6.1.so /lib64/
        busybox cp -a libc-2.6.1.so.32 /lib32/libc-2.6.1.so 

        echo
        echo -n "recheck ghost vulnerability... "
        echo -n "this system "
        ./GHOST 

        if [ $? -eq 0 ]; then

            echo
            echo glibc vulnerability update success ... 
            echo

        fi

    else
        # not glibc update

        echo "this system not require glibc update..."
        echo

    fi
else
    # version mismatch

    echo not ok 
    echo
    echo nas version mismatch or found another problem
    echo glibc vulnerability update fail...
    echo

fi
