/*
 * Open the named file with O_TRUNC and write some stuff
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

char buf[1000];

int main(int argc, char *argv[])
{
	int fd;
	char *filename;

	if (argc != 2) {
		fprintf(stderr, "Usage; %s filename\n", argv[0]);
		exit(1);
	}

	filename = argv[1];
	fd = open(filename, O_RDWR|O_TRUNC);
	if (fd < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			argv[0], filename, strerror(errno));
		exit(1);
	}

	if (write(fd, buf, sizeof(buf)) != sizeof(buf)) {
		fprintf(stderr, "%s: error writing to `%s': %s\n",
			argv[0], filename, strerror(errno));
		exit(1);
	}
	exit(0);
}

