/*
 * Read stuff from all over a file.
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <limits.h>
#include <sys/stat.h>
#include "slacker.h"

#include "fadvise.h"

char *progname;
size_t chunk;
loff_t maxoff;
int nr_operations;
loff_t file_size;

ssize_t pread(int fd, void *buf, size_t count, off_t offset);

void usage(void)
{
	fprintf(stderr, "Usage: %s chunk nr_operations filename\n",
			progname);
	exit(1);
}

int main(int argc, char *argv[])
{
	int c;
	int fd;
	char *filename;
	struct stat statbuf;
	int i;
	void *p;
	loff_t off;

	progname = argv[0];
	while ((c = getopt(argc, argv, "")) != -1) {
		switch (c) {
		default:
			usage();
			break;
		}
	}

	if (optind == argc)
		usage();
	chunk = strtoull(argv[optind++], NULL, 10);
	if (optind == argc)
		usage();

	nr_operations = strtoull(argv[optind++], NULL, 10);
	if (optind == argc)
		usage();

	filename = argv[optind++];
	if (optind != argc)
		usage();

	fd = open(filename, O_RDONLY);
	if (fd < 0) {
		perror("open");
		exit(1);
	}

	fstat(fd, &statbuf);
	if (S_ISBLK(statbuf.st_mode)) {
		file_size = INT_MAX;
	} else {
		file_size = statbuf.st_size;
	}

	maxoff = file_size;

	fsync(fd);
	off = 0;
	while (off < file_size) {
		loff_t amt = file_size - off;

		if (amt > 0xffff0000)
			amt = 0xffff0000;
		__posix_fadvise64(fd, off, amt, POSIX_FADV_DONTNEED);
		off += amt;
	}

	srand(0);

	posix_memalign(&p, getpagesize(), chunk);
	for (i = 0; i < nr_operations; i++) {
		loff_t offset;
		int ret;

		offset = rand();
		offset <<= 32;
		offset += rand();
		offset %= maxoff;
		offset -= offset % chunk;

		ret = pread64(fd, p, chunk, offset);
		if (ret != chunk) {
			perror("pread");
			fprintf(stderr, "pread at %lld returned %d\n",
					(long long)offset, ret);
			exit(1);
		}
	}
			
	exit(0);
}
