/*
 * sys_readahead() demo
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <linux/unistd.h>

#ifndef __NR_readahead
#define __NR_readahead	225		/* x86-specific */
#endif

_syscall3(	ssize_t, readahead,
		int, fd,
		loff_t, offset,
		size_t, count)

#define N (1024 * 1024)

int main(int argc, char *argv[])
{
	struct stat statbuf;
	int fd;
	loff_t offset;

	fd = open(argv[1], O_RDONLY);
	fstat(fd, &statbuf);
	for (offset = 0; offset < statbuf.st_size; offset += N) {
		printf("%lld\n", (unsigned long long)offset);
		fflush(stdout);
		readahead(fd, offset, N);
	}
	close(fd);
	exit(0);
}
