#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/time.h>

static int delay = 1;
static int nr_fields;
static char **fields;
static FILE *f;

static void acquire(long *values)
{
	char buf[1024];

	rewind(f);
	memset(values, 0, nr_fields * sizeof(*values));
	while (fgets(buf, sizeof(buf), f)) {
		int i;

		for (i = 0; i < nr_fields; i++) {
			char *p;

			if (strncmp(buf, fields[i], strlen(fields[i])))
				continue;
			p = strchr(buf, ' ');
			if (p == NULL) {
				fprintf(stderr, "vmmon: error parsing /proc\n");
				exit(1);
			}
			values[i] += strtoul(p, NULL, 10);
			break;
		}
	}
}

static void display(long *new_values, long *prev_values,
			unsigned long long usecs)
{
	int i;

	for (i = 0; i < nr_fields; i++) {
		long long diff;
		double ddiff;

		ddiff = new_values[i] - prev_values[i];
		ddiff *= 1000000;
		ddiff /= usecs;
		diff = ddiff;
		printf(" %10lld", diff);
	}
	printf("\n");
}

static void do1(long *prev_values)
{
	struct timeval start;
	struct timeval end;
	long long usecs;
	long new_values[nr_fields];

	gettimeofday(&start, NULL);
	sleep(delay);
	gettimeofday(&end, NULL);
	acquire(new_values);
	usecs = end.tv_sec - start.tv_sec;
	usecs *= 1000000;
	usecs += end.tv_usec - start.tv_usec;
	display(new_values, prev_values, usecs);
	memcpy(prev_values, new_values, nr_fields * sizeof(*prev_values));
}

static void heading(void)
{
	int i;

	printf("\n");
	for (i = 0; i < nr_fields; i++)
		printf(" %10s", fields[i]);
	printf("\n");
}

static void doit(void)
{
	int line = 0;
	long prev_values[nr_fields];

	acquire(prev_values);
	for ( ; ; ) {
		if (line == 0)
			heading();
		do1(prev_values);
		line++;
		if (line == 24)
			line = 0;
	}
}

static void usage(void)
{
	fprintf(stderr, "usage: vmmon [-d N] field [field ...]\n");
	fprintf(stderr, "   -d N             : delay N seconds\n");
	exit(1);
}

int main(int argc, char *argv[])
{
	int c;

	while ((c = getopt(argc, argv, "d:")) != -1) {
		switch (c) {
		case 'd':
			delay = strtol(optarg, NULL, 10);
			break;
		default:
			usage();
		}
	}

	if (optind == argc)
		usage();

	nr_fields = argc - optind;
	fields = argv + optind;
	f = fopen("/proc/vmstat", "r");
	doit();
	exit(0);
}
