"""
kvm_stat prints statistics generated by the kvm module.
It depends on debugfs. If no debugfs is mounted, the profiler
will try to mount it so it's possible to proceed.

@copyright: Red Hat 2010
@author: Lucas Meneghel Rodrigues (lmr@redhat.com)
"""
import time, os, subprocess, commands
from autotest_lib.client.bin import utils, profiler, os_dep
from autotest_lib.client.common_lib import error


class kvm_stat(profiler.profiler):
    """
    kvm_stat based profiler. Consists on executing kvm_stat -l during a given
    test execution, redirecting its output to a file on the profile dir.
    """
    version = 1
    def initialize(self):
        """
        Gets path of kvm_stat and verifies if debugfs needs to be mounted.
        """
        self.stat_path = os_dep.command('kvm_stat')
        try:
            utils.system_output("%s --batch" % self.stat_path)
        except error.CmdError, e:
            if 'debugfs' in str(e):
                utils.system('mount -t debugfs debugfs /sys/kernel/debug')
            else:
                raise error.AutotestError('kvm_stat failed due to an '
                                          'unknown reason: %s' % str(e))


    def start(self, test):
        """
        Starts kvm_stat subprocess.

        @param test: Autotest test on which this profiler will operate on.
        """
        cmd = "%s -l" % self.stat_path
        logfile = open(os.path.join(test.profdir, "kvm_stat"), 'w')
        p = subprocess.Popen(cmd, shell=True, stdout=logfile,
                             stderr=subprocess.STDOUT)
        self.pid = p.pid


    def stop(self, test):
        """
        Stops profiler execution by sending a SIGTERM to kvm_stat process.

        @param test: Autotest test on which this profiler will operate on.
        """
        try:
            os.kill(self.pid, 15)
        except OSError:
            pass


    def report(self, test):
        """
        Report function. Does nothing as there's no postprocesing needed.

        @param test: Autotest test on which this profiler will operate on.
        """
        return None
