/*
 * check-hacked-dbench-file
 *
 * Need I describe this?
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <string.h>
#include <time.h>
#include "write-struct.h"

char *progname;

#define CHUNK	8192
#define SUL	(sizeof(unsigned long))

int do_check(char *filename)
{
	int ret = 0;
	int fd;
	int nbytes;
	struct stat statbuf;
	unsigned char buf[CHUNK];
	unsigned long ino;
	unsigned long file_offset = 0;

	fd = open(filename, O_RDONLY);
	if (fd < 0) {
		fprintf(stderr, "%s: cannot open `%s': %s\n",
			progname, filename, strerror(errno));
		ret = -1;
		goto out;
	}

	if (fstat(fd, &statbuf)) {
		fprintf(stderr, "%s: cannot stat `%s': %s\n",
			progname, filename, strerror(errno));
		ret = -1;
		goto out;
	}

	ino = statbuf.st_ino;

	while ((nbytes = read(fd, buf, CHUNK))) {
		unsigned long offset = 0;
		static unsigned long val;
		unsigned char *valp = (unsigned char *)&val;

		for (offset = 0; offset < nbytes; offset++, file_offset++) {
			if (file_offset & (sizeof(struct write_struct) - 1)
					& ~(sizeof(unsigned long) - 1))
				continue;
			if (file_offset % SUL == 0)
				val = ino + file_offset;
			if (buf[offset] != valp[offset % SUL]) {
				struct write_struct *ws;

				ws = (void *)(buf +
					(offset & ~(sizeof(*ws) - 1)));
				fprintf(stderr,
					"%s: file `%s' has bad contents at "
						"offset %lu: is %u (0x%x), "
						"should be %u (0x%x)\n",
					progname, filename, file_offset,
					buf[offset], buf[offset],
					valp[offset % SUL],
					valp[offset % SUL]);
				fprintf(stderr, "line_count:%lu time:%s "
						"name:%s ino:%lu offset:%lu\n",
						ws->line_count,
						ctime(&ws->now),
						ws->filename,
						ws->ino,
						ws->offset);
				ret = -1;
				goto out_close;
			}
		}
	}
out_close:
	close(fd);
out:
	return ret;
}

int main(int argc, char *argv[])
{
	int arg;
	int ret = 0;

	progname = argv[0];

	for (arg = 1; arg < argc; arg++) {
		int r = do_check(argv[arg]);
		if (r && !ret)
			ret = r;
	}
	if (ret) {
		time_t now = time(0);
		fprintf(stderr, "time now: %s\n", ctime(&now));
	}
	exit(ret);
}
