/*
 * Write many files, slowly
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <assert.h>

int main(int argc, char *argv[])
{
	char **filenames;
	unsigned long chunksize;
	int nr_files;
	int i;
	int *fds;
	char *buf;

	if (argc < 3) {
		fprintf(stderr,
			"Usage: %s chunksize_bytes file1 file2 ...\n",
			argv[0]);
		exit(1);
	}

	chunksize = atoi(argv[1]);
	filenames = argv + 2;
	nr_files = argc - 2;
	fds = malloc(nr_files * sizeof(*fds));
	buf = malloc(chunksize);
	assert(buf);

	for (i = 0; i < nr_files; i++) {
		fds[i] = open(filenames[i],
			O_RDWR|O_CREAT|O_TRUNC, 0666);
		if (fds[i] < 0) {
			fprintf(stderr, "%s: failed to open `%s': %s\n",
				argv[0], filenames[i], strerror(errno));
			exit(1);
		}
	}

	for ( ; ; ) {
		for (i = 0; i < nr_files; i++) {
			if (write(fds[i], buf, chunksize) != chunksize) {
				fprintf(stderr,
					"%s: failed to write `%s': %s\n",
					argv[0], filenames[i],
					strerror(errno));
				exit(1);
			}
		}
	}
}
