/*
 * Force -ENOSPC on writepage().
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>

int main(int argc, char *argv[])
{
	int fd;
	char *filename;
	int size;
	void *mem;
	int ret;

	if (argc != 3) {
		fprintf(stderr,
			"Usage: %s filename file_size_in_bytes\n", argv[0]);
		exit(1);
	}

	filename = argv[1];
	size = atoi(argv[2]);

	fd = open(filename, O_RDWR|O_CREAT|O_TRUNC, 0666);
	if (fd < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			argv[0], filename, strerror(errno));
		exit(1);
	}

	if (ftruncate(fd, size) < 0) {
		fprintf(stderr, "%s: error truncating `%s': %s\n",
			argv[0], filename, strerror(errno));
		exit(1);
	}

	mem = mmap(0, size, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
	if (mem == MAP_FAILED) {
		perror("mmap");
		exit(1);
	}

	memset(mem, 0, size);
	getchar();
	ret = msync(mem, size, MS_SYNC);
	if (ret < 0)
		printf("msync() returns `%s'\n", strerror(errno));
	else
		printf("msync() succeeded\n");

	ret = munmap(mem, size);
	if (ret < 0)
		perror("munmap");
	ret = close(fd);
	if (ret < 0)
		perror("close");
	exit(0);
}
