#!/bin/sh
#
# scripts/restore-kernel.sh
#
# Blows away all the ext3 files and restires a pristine kernel from local CVS
#
# Usage: restore-kernel.sh name_of_patched_kernel_tree
#
# Uses scripts/file-manifest
#
# Must be run from the root of the ext3 CVS tree.
#
# Assumes that the kernel tree and the ext3 CVS tree both live
# in the same directory (eg: /usr/src)

usage()
{
	echo Usage: restore-kernel.sh name_of_patched_kernel_tree
	exit 1
}

wantdir()
{
	if [ ! -d $1 ]
	then
		echo $1: no directory by that name in $(/bin/pwd)
		exit 1
	fi
}

#
# Initialise and check stuff
#
if [ $# != 1 ]
then
	usage
fi

EXT3_CVS_DIR=$(/bin/pwd)
PATCHED_KERNEL_TREE=$1
cd ..
wantdir $PATCHED_KERNEL_TREE
cd $EXT3_CVS_DIR
FILES_TO_KILL=$(cat scripts/file-manifest)

cd ../$PATCHED_KERNEL_TREE
echo Removing $FILES_TO_KILL
rm -rf $FILES_TO_KILL fs/ext3 fs/jbd

#
# Now work out which files were originally in the kernel
#
cd $EXT3_CVS_DIR
FILES_TO_RESTORE=$(cat scripts/non-ext3-file-manifest)
echo "Restoring $FILES_TO_RESTORE from local CVS"
cd ../$PATCHED_KERNEL_TREE
cvs update $FILES_TO_RESTORE

echo
echo Successfully restored kernel tree ../$PATCHED_KERNEL_TREE from local CVS
