#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <fcntl.h>
#include <string.h>
#include <limits.h>
#include <signal.h>
#include <fcntl.h>
#include <time.h>
#include <stdarg.h>

#define SYNC_FILE_RANGE_WAIT_BEFORE     1
#define SYNC_FILE_RANGE_WRITE           2
#define SYNC_FILE_RANGE_WAIT_AFTER      4

#ifdef __i386__
#define __NR_sync_file_range 314

#define __syscall_return(type, res) \
do { \
	if ((unsigned long)(res) >= (unsigned long)(-(128 + 1))) { \
		errno = -(res); \
		res = -1; \
	} \
	return (type) (res); \
} while (0)

#define _syscall6(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4, \
	  type5,arg5,type6,arg6) \
type name (type1 arg1,type2 arg2,type3 arg3,type4 arg4,type5 arg5,type6 arg6) \
{ \
long __res; \
  struct { long __a1; long __a6; } __s = { (long)arg1, (long)arg6 }; \
__asm__ volatile ("push %%ebp ; push %%ebx ; movl 4(%2),%%ebp ; " \
                  "movl 0(%2),%%ebx ; movl %1,%%eax ; int $0x80 ; " \
                  "pop %%ebx ;  pop %%ebp" \
	: "=a" (__res) \
	: "i" (__NR_##name),"0" ((long)(&__s)),"c" ((long)(arg2)), \
	  "d" ((long)(arg3)),"S" ((long)(arg4)),"D" ((long)(arg5)) \
	: "memory"); \
__syscall_return(type,__res); \
}

_syscall6(int, sync_file_range,
		int, fd, 
		long, offset_lo,
		long, offset_hi,
		long, nbytes_lo,
		long, nbytes_hi,
		int, flags);

int do_sync_file_range(int fd, loff_t offset, loff_t nbytes, int flags)
{
	return sync_file_range(fd,
				offset, offset >> 32,
				nbytes, nbytes >> 32,
				flags);
}
#endif

char *progname;
int flags;
char *filename;
loff_t offset;
loff_t nbytes;

static void doit(void)
{
	int fd;
	int ret;

	fd = open(filename, O_RDONLY);
	if (fd < 0) {
		perror("open");
		exit(1);
	}
	ret = do_sync_file_range(fd, offset, nbytes, flags);
	if (ret) {
		perror("sync_file_range");
		exit(1);
	}
	close(fd);
}

void usage(void)
{
	fprintf(stderr, "Usage: %s [-bwa] filename start offset\n", progname);
	fprintf(stderr, "      -b:         SYNC_FILE_RANGE_WAIT_BEFORE\n"); 
	fprintf(stderr, "      -w:         SYNC_FILE_RANGE_WRITE\n"); 
	fprintf(stderr, "      -a:         SYNC_FILE_RANGE_WAIT_AFTER\n"); 
	exit(1);
}

int main(int argc, char *argv[])
{
	int c;

	progname = argv[0];
	while ((c = getopt(argc, argv, "bwa")) != -1) {
		switch (c) {
		case 'b':
			flags |= SYNC_FILE_RANGE_WAIT_BEFORE;
			break;
		case 'w':
			flags |= SYNC_FILE_RANGE_WRITE;
			break;
		case 'a':
			flags |= SYNC_FILE_RANGE_WAIT_AFTER;
			break;
		default:
			usage();
		}
	}

	if (optind == argc)
		usage();
	filename = argv[optind++];
	if (optind == argc)
		usage();
	if (strncmp(argv[optind], "0x", 2) == 0)
		sscanf(argv[optind++], "0x%Lx", &offset);
	else
		sscanf(argv[optind++], "%Ld", &offset);
	if (optind == argc)
		usage();
	if (strncmp(argv[optind], "0x", 2) == 0)
		sscanf(argv[optind++], "0x%Lx", &nbytes);
	else
		sscanf(argv[optind++], "%Ld", &nbytes);
	if (optind != argc)
		usage();

	doit();
	exit(0);
}
