/*
 * Cause the maximum amount of mmap writeback activity with the minimum
 * amount of CPU cost.
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>

int main(int argc, char *argv[])
{
	int fd;
	loff_t size = 1024*1024;
	char *filename;
	char *mapped_mem;
	int nr_loops = 100;
	int i;

	if (argc != 2 && argc != 3) {
		fprintf(stderr, "Usage; %s filename [nr_loops]\n", argv[0]);
		exit(1);
	}

	filename = argv[1];
	if (argc == 3)
		nr_loops = atoi(argv[2]);

	fd = open(filename, O_RDWR|O_TRUNC|O_CREAT, 0666);
	if (fd < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			argv[0], filename, strerror(errno));
		exit(1);
	}

	printf("%s: expanding `%s' to size %Ld\n", argv[0], filename, size);
	if (ftruncate(fd, size) < 0) {
		perror("ftruncate");
		exit(1);
	}
	mapped_mem = mmap(0, size, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
	if (mapped_mem == MAP_FAILED) {
		perror("mmap");
		exit(1);
	}

	memset(mapped_mem, 0, size);
	for (i = 0; i < nr_loops; i++) {
		int off;

		for (off = 0; off < size; off += 4096) {
			mapped_mem[off] = 1;
		}
		msync(mapped_mem, size, MS_ASYNC);
	}

	return 0;
}
